/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.api.wands.WandTriggerRegistry;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.items.armor.RecipesRobeArmorDyes;
import thaumcraft.common.items.armor.RecipesVoidRobeArmorDyes;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;
import thaumcraft.common.lib.crafting.InfusionRunicAugmentRecipe;
import thaumcraft.common.lib.crafting.ShapelessNBTOreRecipe;

public class ConfigRecipes {
    static ItemStack basicWand = new ItemStack(ConfigItems.itemWandCasting);

    public static void init() {
        ((ItemWandCasting)basicWand.getItem()).setCap(basicWand, ConfigItems.WAND_CAP_IRON);
        ((ItemWandCasting)basicWand.getItem()).setRod(basicWand, ConfigItems.WAND_ROD_WOOD);
        ConfigRecipes.initializeSmelting();
        ConfigRecipes.initializeNormalRecipes();
        ConfigRecipes.initializeArcaneRecipes();
        ConfigRecipes.initializeInfusionRecipes();
        ConfigRecipes.initializeInfusionEnchantmentRecipes();
        ConfigRecipes.initializeAlchemyRecipes();
        ConfigRecipes.initializeCompoundRecipes();
        RecipeSorter.register((String)"forge:shapelessorenbt", ShapelessNBTOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"forge:robearmordye", RecipesRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessorenbt");
        RecipeSorter.register((String)"forge:voidrobearmordye", RecipesVoidRobeArmorDyes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:robearmordye");
    }

    private static void initializeCompoundRecipes() {
        ItemStack empty = new ItemStack(ConfigBlocks.blockHole, 1, 15);
        ConfigResearch.recipes.put("Thaumonomicon", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Blocks.bookshelf))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 0, Blocks.bookshelf, 0, "Thaumcraft");
        ConfigResearch.recipes.put("ArcTable", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(ConfigBlocks.blockTable))));
        ConfigResearch.recipes.put("ResTable", Arrays.asList(new AspectList(), 1, 2, 2, Arrays.asList(null, new ItemStack(ConfigItems.itemInkwell), new ItemStack(ConfigBlocks.blockTable), new ItemStack(ConfigBlocks.blockTable))));
        ConfigResearch.recipes.put("Crucible", Arrays.asList(new AspectList(), 1, 2, 1, Arrays.asList(basicWand, new ItemStack(Items.cauldron))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 1, (Block)Blocks.cauldron, -1, "Thaumcraft");
        ConfigResearch.recipes.put("InfernalFurnace", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.EARTH, 50), 3, 3, 3, Arrays.asList(new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), empty, new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.lava), new ItemStack(Blocks.iron_bars), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick), new ItemStack(Blocks.obsidian), new ItemStack(Blocks.nether_brick))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.obsidian, -1, "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.nether_brick, -1, "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 2, Blocks.iron_bars, -1, "Thaumcraft");
        ConfigResearch.recipes.put("InfusionAltar", Arrays.asList(new AspectList().add(Aspect.FIRE, 25).add(Aspect.EARTH, 25).add(Aspect.ORDER, 25).add(Aspect.AIR, 25).add(Aspect.ENTROPY, 25).add(Aspect.WATER, 25), 3, 3, 3, Arrays.asList(empty, null, empty, null, new ItemStack(ConfigBlocks.blockStoneDevice, 1, 2), null, empty, null, empty, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, null, null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockStoneDevice, 1, 1), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), null, new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 3, ConfigBlocks.blockStoneDevice, 2, "Thaumcraft");
        ConfigResearch.recipes.put("NodeJar", Arrays.asList(new AspectList().add(Aspect.FIRE, 70).add(Aspect.EARTH, 70).add(Aspect.AIR, 70).add(Aspect.WATER, 70).add(Aspect.ORDER, 70).add(Aspect.ENTROPY, 70), 3, 4, 3, Arrays.asList("slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", "slabWood", new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(ConfigBlocks.blockAiry, 1, 5), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass), new ItemStack(Blocks.glass))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 4, Blocks.glass, -1, "Thaumcraft");
        ConfigResearch.recipes.put("Thaumatorium", Arrays.asList(new AspectList().add(Aspect.FIRE, 15).add(Aspect.ORDER, 30).add(Aspect.WATER, 30), 1, 3, 1, Arrays.asList(new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 0))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 5, ConfigBlocks.blockMetalDevice, 9, "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 6, ConfigBlocks.blockEldritch, 0, "Thaumcraft");
        ConfigResearch.recipes.put("AdvAlchemyFurnace", Arrays.asList(new AspectList().add(Aspect.FIRE, 50).add(Aspect.WATER, 50).add(Aspect.ORDER, 50), 3, 2, 3, Arrays.asList(new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), empty, new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 0), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 3))));
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 7, ConfigBlocks.blockMetalDevice, 3, "Thaumcraft");
        WandTriggerRegistry.registerWandBlockTrigger(Thaumcraft.proxy.wandManager, 7, ConfigBlocks.blockMetalDevice, 9, "Thaumcraft_2");
    }

    private static void initializeAlchemyRecipes() {
        Aspect[] aspect = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY};
        for (int a = 0; a < 6; ++a) {
            AspectList al = new AspectList();
            for (int b = 0; b < 6; ++b) {
                if (b == a) continue;
                al.add(aspect[b], 2);
            }
            ConfigResearch.recipes.put("BalancedShard_" + a, ThaumcraftApi.addCrucibleRecipe("CRUCIBLE", new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, a), al));
        }
        ConfigResearch.recipes.put("Alumentum", ThaumcraftApi.addCrucibleRecipe("ALUMENTUM", new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Items.coal, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.ENTROPY, 3)));
        ConfigResearch.recipes.put("Nitor", ThaumcraftApi.addCrucibleRecipe("NITOR", new ItemStack(ConfigItems.itemResource, 1, 1), "dustGlowstone", new AspectList().merge(Aspect.ENERGY, 3).merge(Aspect.FIRE, 3).merge(Aspect.LIGHT, 3)));
        ConfigResearch.recipes.put("Thaumium", ThaumcraftApi.addCrucibleRecipe("THAUMIUM", new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(Items.iron_ingot), new AspectList().merge(Aspect.MAGIC, 4)));
        ConfigResearch.recipes.put("VoidMetal", ThaumcraftApi.addCrucibleRecipe("VOIDMETAL", new ItemStack(ConfigItems.itemResource, 1, 16), new ItemStack(ConfigItems.itemResource, 1, 17), new AspectList().merge(Aspect.METAL, 8)));
        ConfigResearch.recipes.put("VoidSeed", ThaumcraftApi.addCrucibleRecipe("VOIDMETAL", new ItemStack(ConfigItems.itemResource, 1, 17), new ItemStack(Items.wheat_seeds), new AspectList().merge(Aspect.DARKNESS, 8).merge(Aspect.VOID, 8).merge(Aspect.ELDRITCH, 2)));
        ConfigResearch.recipes.put("Tallow", ThaumcraftApi.addCrucibleRecipe("TALLOW", new ItemStack(ConfigItems.itemResource, 1, 4), new ItemStack(Items.rotten_flesh), new AspectList().merge(Aspect.MAGIC, 2)));
        ConfigResearch.recipes.put("AltGunpowder", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.gunpowder, 2, 0), new ItemStack(Items.gunpowder), new AspectList().merge(Aspect.FIRE, 4).merge(Aspect.ENTROPY, 4)));
        ConfigResearch.recipes.put("AltSlime", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.slime_ball, 2, 0), new ItemStack(Items.slime_ball), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.LIFE, 2)));
        ConfigResearch.recipes.put("AltClay", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.clay_ball, 2, 0), new ItemStack(Items.clay_ball), new AspectList().merge(Aspect.WATER, 1).merge(Aspect.EARTH, 2)));
        ConfigResearch.recipes.put("AltGlowstone", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.glowstone_dust, 2, 0), "dustGlowstone", new AspectList().merge(Aspect.LIGHT, 3).merge(Aspect.SENSES, 1)));
        ConfigResearch.recipes.put("AltInk", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALDUPLICATION", new ItemStack(Items.dye, 2, 0), new ItemStack(Items.dye, 1, 0), new AspectList().merge(Aspect.WATER, 2).merge(Aspect.SENSES, 2)));
        ConfigResearch.recipes.put("AltWeb", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.web), new ItemStack(Items.string), new AspectList().merge(Aspect.TRAP, 2).merge(Aspect.CLOTH, 2)));
        ConfigResearch.recipes.put("AltMossyCobble", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.mossy_cobblestone), new ItemStack(Blocks.cobblestone), new AspectList().merge(Aspect.PLANT, 2).merge(Aspect.MAGIC, 1)));
        ConfigResearch.recipes.put("AltIce", ThaumcraftApi.addCrucibleRecipe("ALCHEMICALMANUFACTURE", new ItemStack(Blocks.ice), new ItemStack(Blocks.snow), new AspectList().merge(Aspect.ORDER, 1).merge(Aspect.COLD, 1)));
        ConfigResearch.recipes.put("AltCrackedBrick", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Blocks.stonebrick, 1, 2), new ItemStack(Blocks.stonebrick), new AspectList().merge(Aspect.ENTROPY, 2)));
        ConfigResearch.recipes.put("AltBonemeal", ThaumcraftApi.addCrucibleRecipe("ENTROPICPROCESSING", new ItemStack(Items.dye, 4, 15), new ItemStack(Items.bone), new AspectList().merge(Aspect.ENTROPY, 1)));
        ConfigResearch.recipes.put("PureIron", ThaumcraftApi.addCrucibleRecipe("PUREIRON", new ItemStack(ConfigItems.itemNugget, 1, 16), "oreIron", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        ConfigResearch.recipes.put("PureGold", ThaumcraftApi.addCrucibleRecipe("PUREGOLD", new ItemStack(ConfigItems.itemNugget, 1, 31), "oreGold", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("PureCopper", ThaumcraftApi.addCrucibleRecipe("PURECOPPER", new ItemStack(ConfigItems.itemNugget, 1, 17), "oreCopper", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("PureTin", ThaumcraftApi.addCrucibleRecipe("PURETIN", new ItemStack(ConfigItems.itemNugget, 1, 18), "oreTin", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("PureSilver", ThaumcraftApi.addCrucibleRecipe("PURESILVER", new ItemStack(ConfigItems.itemNugget, 1, 19), "oreSilver", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("PureLead", ThaumcraftApi.addCrucibleRecipe("PURELEAD", new ItemStack(ConfigItems.itemNugget, 1, 20), "oreLead", new AspectList().merge(Aspect.METAL, 1).merge(Aspect.ORDER, 1)));
        }
        ConfigResearch.recipes.put("TransIron", ThaumcraftApi.addCrucibleRecipe("TRANSIRON", new ItemStack(ConfigItems.itemNugget, 3, 0), "nuggetIron", new AspectList().merge(Aspect.METAL, 2)));
        ConfigResearch.recipes.put("TransGold", ThaumcraftApi.addCrucibleRecipe("TRANSGOLD", new ItemStack(Items.gold_nugget, 3, 0), new ItemStack(Items.gold_nugget), new AspectList().merge(Aspect.METAL, 2).merge(Aspect.GREED, 1)));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("TransCopper", ThaumcraftApi.addCrucibleRecipe("TRANSCOPPER", new ItemStack(ConfigItems.itemNugget, 3, 1), "nuggetCopper", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.EXCHANGE, 1)));
        }
        if (Config.foundTinIngot) {
            ConfigResearch.recipes.put("TransTin", ThaumcraftApi.addCrucibleRecipe("TRANSTIN", new ItemStack(ConfigItems.itemNugget, 3, 2), "nuggetTin", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.CRYSTAL, 1)));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("TransSilver", ThaumcraftApi.addCrucibleRecipe("TRANSSILVER", new ItemStack(ConfigItems.itemNugget, 3, 3), "nuggetSilver", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.GREED, 1)));
        }
        if (Config.foundLeadIngot) {
            ConfigResearch.recipes.put("TransLead", ThaumcraftApi.addCrucibleRecipe("TRANSLEAD", new ItemStack(ConfigItems.itemNugget, 3, 4), "nuggetLead", new AspectList().merge(Aspect.METAL, 2).merge(Aspect.ORDER, 1)));
        }
        ConfigResearch.recipes.put("EtherealBloom", ThaumcraftApi.addCrucibleRecipe("ETHEREALBLOOM", new ItemStack(ConfigBlocks.blockCustomPlant, 1, 4), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2), new AspectList().add(Aspect.MAGIC, 16).add(Aspect.PLANT, 16).add(Aspect.HEAL, 16).add(Aspect.TAINT, 8)));
        ConfigResearch.recipes.put("LiquidDeath", ThaumcraftApi.addCrucibleRecipe("LIQUIDDEATH", new ItemStack(ConfigItems.itemBucketDeath), new ItemStack(Items.bucket), new AspectList().add(Aspect.DEATH, 32).add(Aspect.POISON, 32).add(Aspect.ENTROPY, 32)));
        ItemStack bt = new ItemStack(ConfigItems.itemEssence, 1, 1);
        ((IEssentiaContainerItem)bt.getItem()).setAspects(bt, new AspectList().add(Aspect.TAINT, 8));
        ConfigResearch.recipes.put("BottleTaint", ThaumcraftApi.addCrucibleRecipe("BOTTLETAINT", new ItemStack(ConfigItems.itemBottleTaint), bt, new AspectList().add(Aspect.TAINT, 8).add(Aspect.MAGIC, 8)));
        ConfigResearch.recipes.put("GolemStraw", ThaumcraftApi.addCrucibleRecipe("GOLEMSTRAW", new ItemStack(ConfigItems.itemGolemPlacer, 1, 0), new ItemStack(Blocks.hay_block), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemWood", ThaumcraftApi.addCrucibleRecipe("GOLEMWOOD", new ItemStack(ConfigItems.itemGolemPlacer, 1, 1), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemTallow", ThaumcraftApi.addCrucibleRecipe("GOLEMTALLOW", new ItemStack(ConfigItems.itemGolemPlacer, 1, 2), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("GolemClay", ThaumcraftApi.addCrucibleRecipe("GOLEMCLAY", new ItemStack(ConfigItems.itemGolemPlacer, 1, 3), new ItemStack(Blocks.brick_block), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemFlesh", ThaumcraftApi.addCrucibleRecipe("GOLEMFLESH", new ItemStack(ConfigItems.itemGolemPlacer, 1, 4), new ItemStack(ConfigBlocks.blockTaint, 1, 2), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("GolemStone", ThaumcraftApi.addCrucibleRecipe("GOLEMSTONE", new ItemStack(ConfigItems.itemGolemPlacer, 1, 5), new ItemStack(Blocks.stonebrick), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemIron", ThaumcraftApi.addCrucibleRecipe("GOLEMIRON", new ItemStack(ConfigItems.itemGolemPlacer, 1, 6), new ItemStack(Blocks.iron_block), new AspectList().add(Aspect.MAN, 4).add(Aspect.MOTION, 4).add(Aspect.SOUL, 4)));
        ConfigResearch.recipes.put("GolemThaumium", ThaumcraftApi.addCrucibleRecipe("GOLEMTHAUMIUM", new ItemStack(ConfigItems.itemGolemPlacer, 1, 7), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4), new AspectList().add(Aspect.MAN, 8).add(Aspect.MOTION, 8).add(Aspect.SOUL, 8)));
        ConfigResearch.recipes.put("CoreGather", ThaumcraftApi.addCrucibleRecipe("COREGATHER", new ItemStack(ConfigItems.itemGolemCore, 1, 2), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.GREED, 5).add(Aspect.EARTH, 5)));
        ConfigResearch.recipes.put("CoreFill", ThaumcraftApi.addCrucibleRecipe("COREFILL", new ItemStack(ConfigItems.itemGolemCore, 1, 0), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.HUNGER, 5).add(Aspect.VOID, 5)));
        ConfigResearch.recipes.put("CoreEmpty", ThaumcraftApi.addCrucibleRecipe("COREEMPTY", new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.GREED, 5).add(Aspect.VOID, 5)));
        ConfigResearch.recipes.put("CoreHarvest", ThaumcraftApi.addCrucibleRecipe("COREHARVEST", new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.HARVEST, 5).add(Aspect.CROP, 5)));
        ConfigResearch.recipes.put("CoreGuard", ThaumcraftApi.addCrucibleRecipe("COREGUARD", new ItemStack(ConfigItems.itemGolemCore, 1, 4), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.WEAPON, 5).add(Aspect.TRAP, 5)));
        ConfigResearch.recipes.put("CoreButcher", ThaumcraftApi.addCrucibleRecipe("COREBUTCHER", new ItemStack(ConfigItems.itemGolemCore, 1, 9), new ItemStack(ConfigItems.itemGolemCore, 1, 4), new AspectList().add(Aspect.FLESH, 5).add(Aspect.BEAST, 5)));
        ConfigResearch.recipes.put("CoreLiquid", ThaumcraftApi.addCrucibleRecipe("CORELIQUID", new ItemStack(ConfigItems.itemGolemCore, 1, 5), new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.WATER, 5).add(Aspect.VOID, 5)));
        ConfigResearch.recipes.put("BathSalts", ThaumcraftApi.addCrucibleRecipe("BATHSALTS", new ItemStack(ConfigItems.itemBathSalts), new ItemStack(ConfigItems.itemResource, 1, 14), new AspectList().add(Aspect.MIND, 6).add(Aspect.AURA, 6).add(Aspect.ORDER, 6).add(Aspect.HEAL, 6)));
        ConfigResearch.recipes.put("SaneSoap", ThaumcraftApi.addCrucibleRecipe("SANESOAP", new ItemStack(ConfigItems.itemSanitySoap), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5), new AspectList().add(Aspect.MIND, 16).add(Aspect.ELDRITCH, 16).add(Aspect.ORDER, 16).add(Aspect.HEAL, 16)));
    }

    private static void initializeArcaneRecipes() {
        for (int a = 0; a < 16; ++a) {
            ItemStack banner = new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 8);
            banner.setTagCompound(new NBTTagCompound());
            banner.stackTagCompound.setByte("color", (byte)a);
            ConfigResearch.recipes.put("Banner_" + a, ThaumcraftApi.addArcaneCraftingRecipe("BANNERS", banner, new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 5), "WS", "WS", "WB", Character.valueOf('W'), new ItemStack(Blocks.wool, 1, a), Character.valueOf('S'), "stickWood", Character.valueOf('B'), "slabWood"));
        }
        ConfigResearch.recipes.put("PrimalCharm", ThaumcraftApi.addArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ConfigItems.itemResource, 1, 15), new AspectList().add(Aspect.EARTH, 25).add(Aspect.FIRE, 25).add(Aspect.AIR, 25).add(Aspect.WATER, 25).add(Aspect.ORDER, 25).add(Aspect.ENTROPY, 25), "123", "ISI", "456", Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, 6), Character.valueOf('I'), Items.gold_ingot, Character.valueOf('1'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('2'), new ItemStack(ConfigItems.itemShard, 1, 1), Character.valueOf('3'), new ItemStack(ConfigItems.itemShard, 1, 2), Character.valueOf('4'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('5'), new ItemStack(ConfigItems.itemShard, 1, 4), Character.valueOf('6'), new ItemStack(ConfigItems.itemShard, 1, 5)));
        ConfigResearch.recipes.put("ArcaneDoor", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemArcaneDoor), new AspectList().add(Aspect.WATER, 20).add(Aspect.ORDER, 10).add(Aspect.EARTH, 10).add(Aspect.FIRE, 5), "TDT", "DBD", "TDT", Character.valueOf('T'), "ingotThaumium", Character.valueOf('B'), new ItemStack(ConfigItems.itemZombieBrain), Character.valueOf('D'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        ConfigResearch.recipes.put("WardedGlass", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigBlocks.blockCosmeticOpaque, 8, 2), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 10).add(Aspect.EARTH, 5).add(Aspect.FIRE, 5), "GGG", "WBW", "GGG", Character.valueOf('B'), new ItemStack(ConfigItems.itemZombieBrain), Character.valueOf('G'), new ItemStack(Blocks.glass), Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        ConfigResearch.recipes.put("IronKey", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemKey, 2, 0), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "NNI", "N  ", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('N'), "nuggetIron"));
        ConfigResearch.recipes.put("FluxScrubber", ThaumcraftApi.addArcaneCraftingRecipe("FLUXSCRUB", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 14), new AspectList().add(Aspect.WATER, 16).add(Aspect.ORDER, 16).add(Aspect.AIR, 8), " B ", "GOG", "STS", Character.valueOf('B'), new ItemStack(ConfigBlocks.blockWoodenDevice), Character.valueOf('G'), new ItemStack(Blocks.iron_bars), Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube), Character.valueOf('O'), new ItemStack(ConfigItems.itemResource, 1, 8), Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7)));
        if (Config.wardedStone) {
            ConfigResearch.recipes.put("GoldKey", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigItems.itemKey, 2, 1), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "NNI", "N  ", Character.valueOf('I'), Items.gold_ingot, Character.valueOf('N'), Items.gold_nugget));
            ConfigResearch.recipes.put("ArcanePressurePlate", ThaumcraftApi.addArcaneCraftingRecipe("WARDEDARCANA", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 2), new AspectList().add(Aspect.WATER, 20).add(Aspect.ORDER, 10).add(Aspect.FIRE, 5).add(Aspect.EARTH, 10), " B ", "TDT", Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 2), Character.valueOf('B'), new ItemStack(ConfigItems.itemZombieBrain), Character.valueOf('D'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)));
        }
        ConfigResearch.recipes.put("NodeStabilizer", ThaumcraftApi.addArcaneCraftingRecipe("NODESTABILIZER", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 9), new AspectList().add(Aspect.WATER, 32).add(Aspect.EARTH, 32).add(Aspect.ORDER, 32), " G ", "QPQ", "SNS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('G'), new ItemStack(Items.gold_ingot), Character.valueOf('P'), new ItemStack((Block)Blocks.piston), Character.valueOf('Q'), new ItemStack(Blocks.quartz_block), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1)));
        ConfigResearch.recipes.put("NodeTransducer", ThaumcraftApi.addArcaneCraftingRecipe("VISPOWER", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 11), new AspectList().add(Aspect.FIRE, 32).add(Aspect.AIR, 32).add(Aspect.ENTROPY, 32), "RCR", "ISI", "RAR", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 9), Character.valueOf('C'), new ItemStack(Items.comparator), Character.valueOf('I'), new ItemStack(Items.iron_ingot), Character.valueOf('R'), new ItemStack(Blocks.redstone_block), Character.valueOf('A'), new ItemStack(ConfigItems.itemResource, 1, 1)));
        ConfigResearch.recipes.put("NodeRelay", ThaumcraftApi.addArcaneCraftingRecipe("VISPOWER", new ItemStack(ConfigBlocks.blockMetalDevice, 2, 14), new AspectList().add(Aspect.FIRE, 8).add(Aspect.ORDER, 8), " I ", "ISI", " I ", Character.valueOf('I'), new ItemStack(Items.iron_ingot), Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, 6)));
        ConfigResearch.recipes.put("NodeChargeRelay", ThaumcraftApi.addArcaneCraftingRecipe("VISCHARGERELAY", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 2), new AspectList().add(Aspect.FIRE, 16).add(Aspect.ORDER, 16).add(Aspect.AIR, 16), " R ", "W W", "I I", Character.valueOf('I'), new ItemStack(Items.iron_ingot), Character.valueOf('R'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 14), Character.valueOf('W'), new ItemStack(ConfigItems.itemWandRod, 1, 0)));
        ConfigResearch.recipes.put("FocalManipulator", ThaumcraftApi.addArcaneCraftingRecipe("FOCALMANIPULATION", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 13), new AspectList().add(Aspect.FIRE, 32).add(Aspect.AIR, 32).add(Aspect.ENTROPY, 32).add(Aspect.EARTH, 32).add(Aspect.WATER, 32).add(Aspect.ORDER, 32), "IQI", "SPS", "GTG", Character.valueOf('Q'), new ItemStack(ConfigBlocks.blockSlabStone, 1, 0), Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTable), Character.valueOf('I'), new ItemStack(Items.iron_ingot), Character.valueOf('G'), new ItemStack(Items.gold_ingot), Character.valueOf('P'), new ItemStack(ConfigItems.itemResource, 1, 15)));
        ConfigResearch.recipes.put("GolemFetter", ThaumcraftApi.addArcaneCraftingRecipe("GOLEMFETTER", new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 9), new AspectList().add(Aspect.EARTH, 5).add(Aspect.ORDER, 5), "SSS", "IRI", "BBB", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('I'), new ItemStack(Items.iron_ingot), Character.valueOf('B'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('R'), new ItemStack(Blocks.redstone_block)));
        ConfigResearch.recipes.put("ArcaneStone1", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESTONE", new ItemStack(ConfigBlocks.blockCosmeticSolid, 9, 6), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1), "SSS", "SCS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("ArcaneStone2", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 7), (Object[])new Object[]{"SS", "SS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)}));
        ConfigResearch.recipes.put("ArcaneStone3", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockStairsArcaneStone, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7)}));
        ConfigResearch.recipes.put("ArcaneStone4", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockSlabStone, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7)}));
        ConfigResearch.recipes.put("PaveTravel", ThaumcraftApi.addArcaneCraftingRecipe("PAVETRAVEL", new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 2), new AspectList().add(Aspect.EARTH, 10).add(Aspect.AIR, 10), "SAS", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("ArcaneLamp", ThaumcraftApi.addArcaneCraftingRecipe("ARCANELAMP", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new AspectList().add(Aspect.FIRE, 8).add(Aspect.AIR, 8).add(Aspect.WATER, 4).add(Aspect.ENTROPY, 4), " S ", "IAI", " N ", Character.valueOf('A'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0), Character.valueOf('S'), new ItemStack((Block)Blocks.daylight_detector), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1), Character.valueOf('I'), new ItemStack(Items.iron_ingot)));
        ConfigResearch.recipes.put("ArcaneSpa", ThaumcraftApi.addArcaneCraftingRecipe("ARCANESPA", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 12), new AspectList().add(Aspect.WATER, 16).add(Aspect.ORDER, 8).add(Aspect.EARTH, 4), "QIQ", "SJS", "SPS", Character.valueOf('P'), new ItemStack((Block)Blocks.piston), Character.valueOf('J'), new ItemStack(ConfigBlocks.blockJar), Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('Q'), new ItemStack(Blocks.quartz_block), Character.valueOf('I'), new ItemStack(Blocks.iron_bars)));
        ConfigResearch.recipes.put("PaveWard", ThaumcraftApi.addArcaneCraftingRecipe("PAVEWARD", new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 3), new AspectList().add(Aspect.FIRE, 10).add(Aspect.ORDER, 10), "SAS", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 7), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 1), Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, 4)));
        ConfigResearch.recipes.put("Levitator", ThaumcraftApi.addArcaneCraftingRecipe("LEVITATOR", new ItemStack(ConfigBlocks.blockLifter), new AspectList().add(Aspect.AIR, 10).add(Aspect.EARTH, 5), "WEW", "BNB", "WAW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 3), Character.valueOf('A'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1), Character.valueOf('B'), Items.iron_ingot));
        ConfigResearch.recipes.put("ArcaneEar", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEEAR", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 1), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10), "GIG", "GBG", "WRW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('R'), Items.redstone, Character.valueOf('I'), Items.iron_ingot, Character.valueOf('G'), Items.gold_ingot, Character.valueOf('B'), new ItemStack(ConfigItems.itemZombieBrain)));
        ConfigResearch.recipes.put("MirrorGlass", ThaumcraftApi.addShapelessArcaneCraftingRecipe("BASICARTIFACE", new ItemStack(ConfigItems.itemResource, 1, 10), new AspectList().add(Aspect.FIRE, 10).add(Aspect.EARTH, 10), new ItemStack(ConfigItems.itemResource, 1, 3), Blocks.glass_pane));
        ConfigResearch.recipes.put("BoneBow", ThaumcraftApi.addArcaneCraftingRecipe("BONEBOW", new ItemStack(ConfigItems.itemBowBone), new AspectList().add(Aspect.AIR, 16).add(Aspect.ENTROPY, 32), "SB ", "SEB", "SB ", Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 5), Character.valueOf('B'), Items.bone, Character.valueOf('S'), Items.string));
        Aspect[] pa = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.WATER, Aspect.EARTH, Aspect.ORDER, Aspect.ENTROPY};
        for (int a = 0; a < 6; ++a) {
            ConfigResearch.recipes.put("PrimalArrow_" + a, ThaumcraftApi.addArcaneCraftingRecipe("PRIMALARROW", new ItemStack(ConfigItems.itemPrimalArrow, 8, a), new AspectList().add(pa[a], 8), "AAA", "ASA", "AAA", Character.valueOf('A'), Items.arrow, Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, a)));
        }
        ConfigResearch.recipes.put("InfusionMatrix", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 2), new AspectList().add(Aspect.ORDER, 40), "SBS", "BEB", "SBS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6), Character.valueOf('E'), Items.ender_pearl, Character.valueOf('B'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("ArcanePedestal", ThaumcraftApi.addArcaneCraftingRecipe("INFUSION", new ItemStack(ConfigBlocks.blockStoneDevice, 2, 1), new AspectList().add(Aspect.AIR, 5), "SSS", " S ", "SSS", Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)));
        ConfigResearch.recipes.put("WardedJar", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockJar, 1, 0), new AspectList().add(Aspect.WATER, 1), "GWG", "G G", "GGG", Character.valueOf('W'), "slabWood", Character.valueOf('G'), Blocks.glass_pane));
        ConfigResearch.recipes.put("JarVoid", ThaumcraftApi.addArcaneCraftingRecipe("JARVOID", new ItemStack(ConfigBlocks.blockJar, 1, 3), new AspectList().add(Aspect.WATER, 5).add(Aspect.ENTROPY, 15), "O", "J", "P", Character.valueOf('O'), Blocks.obsidian, Character.valueOf('P'), Items.blaze_powder, Character.valueOf('J'), new ItemStack(ConfigBlocks.blockJar, 1, 0)));
        ArcaneWandRecipe wr = new ArcaneWandRecipe();
        ThaumcraftApi.getCraftingRecipes().add(wr);
        ArcaneSceptreRecipe sr = new ArcaneSceptreRecipe();
        ThaumcraftApi.getCraftingRecipes().add(sr);
        ConfigResearch.recipes.put("WandCapGold", ThaumcraftApi.addArcaneCraftingRecipe("CAP_gold", new ItemStack(ConfigItems.itemWandCap, 1, 1), new AspectList().add(Aspect.ORDER, WandCap.caps.get("gold").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("gold").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("gold").getCraftCost()), "NNN", "N N", Character.valueOf('N'), Items.gold_nugget));
        if (Config.foundCopperIngot) {
            ConfigResearch.recipes.put("WandCapCopper", ThaumcraftApi.addArcaneCraftingRecipe("CAP_copper", new ItemStack(ConfigItems.itemWandCap, 1, 3), new AspectList().add(Aspect.ORDER, WandCap.caps.get("copper").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("copper").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("copper").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetCopper"));
        }
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("WandCapSilverInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_silver", new ItemStack(ConfigItems.itemWandCap, 1, 5), new AspectList().add(Aspect.ORDER, WandCap.caps.get("silver").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("silver").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("silver").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetSilver"));
        }
        ConfigResearch.recipes.put("WandCapThaumiumInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_thaumium", new ItemStack(ConfigItems.itemWandCap, 1, 6), new AspectList().add(Aspect.ORDER, WandCap.caps.get("thaumium").getCraftCost()).add(Aspect.FIRE, WandCap.caps.get("thaumium").getCraftCost()).add(Aspect.AIR, WandCap.caps.get("thaumium").getCraftCost()), "NNN", "N N", Character.valueOf('N'), "nuggetThaumium"));
        ConfigResearch.recipes.put("WandCapVoidInert", ThaumcraftApi.addArcaneCraftingRecipe("CAP_void", new ItemStack(ConfigItems.itemWandCap, 1, 8), new AspectList().add(Aspect.ENTROPY, WandCap.caps.get("void").getCraftCost() * 3).add(Aspect.ORDER, WandCap.caps.get("void").getCraftCost() * 3).add(Aspect.FIRE, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.AIR, WandCap.caps.get("void").getCraftCost() * 2), "NNN", "N N", Character.valueOf('N'), "nuggetVoid"));
        ConfigResearch.recipes.put("WandRodGreatwood", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood", new ItemStack(ConfigItems.itemWandRod, 1, 0), new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("greatwood").getCraftCost()), " G", "G ", Character.valueOf('G'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)));
        ConfigResearch.recipes.put("WandRodGreatwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_greatwood_staff", new ItemStack(ConfigItems.itemWandRod, 1, 50), new AspectList().add(Aspect.ORDER, WandRod.rods.get("greatwood_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 0)));
        ConfigResearch.recipes.put("WandRodObsidianStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_obsidian_staff", new ItemStack(ConfigItems.itemWandRod, 1, 51), new AspectList().add(Aspect.ORDER, WandRod.rods.get("obsidian_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 1)));
        ConfigResearch.recipes.put("WandRodSilverwoodStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_silverwood_staff", new ItemStack(ConfigItems.itemWandRod, 1, 52), new AspectList().add(Aspect.ORDER, WandRod.rods.get("silverwood_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 2)));
        ConfigResearch.recipes.put("WandRodIceStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_ice_staff", new ItemStack(ConfigItems.itemWandRod, 1, 53), new AspectList().add(Aspect.ORDER, WandRod.rods.get("ice_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 3)));
        ConfigResearch.recipes.put("WandRodQuartzStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_quartz_staff", new ItemStack(ConfigItems.itemWandRod, 1, 54), new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 4)));
        ConfigResearch.recipes.put("WandRodReedStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_reed_staff", new ItemStack(ConfigItems.itemWandRod, 1, 55), new AspectList().add(Aspect.ORDER, WandRod.rods.get("reed_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 5)));
        ConfigResearch.recipes.put("WandRodBlazeStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_blaze_staff", new ItemStack(ConfigItems.itemWandRod, 1, 56), new AspectList().add(Aspect.ORDER, WandRod.rods.get("blaze_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 6)));
        ConfigResearch.recipes.put("WandRodBoneStaff", ThaumcraftApi.addArcaneCraftingRecipe("ROD_bone_staff", new ItemStack(ConfigItems.itemWandRod, 1, 57), new AspectList().add(Aspect.ORDER, WandRod.rods.get("bone_staff").getCraftCost()), "  S", " G ", "G  ", Character.valueOf('S'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('G'), new ItemStack(ConfigItems.itemWandRod, 1, 7)));
        ConfigResearch.recipes.put("FocusFire", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFIRE", new ItemStack(ConfigItems.itemFocusFire), new AspectList().add(Aspect.FIRE, 20).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.fire_charge, Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 1)));
        ConfigResearch.recipes.put("FocusFrost", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSFROST", new ItemStack(ConfigItems.itemFocusFrost), new AspectList().add(Aspect.WATER, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.diamond, Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 2)));
        ConfigResearch.recipes.put("FocusShock", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSSHOCK", new ItemStack(ConfigItems.itemFocusShock), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "CQC", "Q#Q", "CQC", Character.valueOf('#'), Items.potato, Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0)));
        ConfigResearch.recipes.put("FocusTrade", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSTRADE", new ItemStack(ConfigItems.itemFocusTrade), new AspectList().add(Aspect.ORDER, 15).add(Aspect.ENTROPY, 15).add(Aspect.EARTH, 10), "CQE", "Q#Q", "CQE", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 3), Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 6), Character.valueOf('E'), new ItemStack(ConfigItems.itemShard, 1, 6)));
        ConfigResearch.recipes.put("FocusExcavation", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSEXCAVATION", new ItemStack(ConfigItems.itemFocusExcavation), new AspectList().add(Aspect.EARTH, 20).add(Aspect.ENTROPY, 5).add(Aspect.ORDER, 5), "CQC", "Q#Q", "CQC", Character.valueOf('#'), "gemEmerald", Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("FocusPrimal", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPRIMAL", new ItemStack(ConfigItems.itemFocusPrimal), new AspectList().add(Aspect.EARTH, 25).add(Aspect.ENTROPY, 25).add(Aspect.ORDER, 25).add(Aspect.AIR, 25).add(Aspect.FIRE, 25).add(Aspect.WATER, 25), "CQC", "Q#Q", "CQC", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 15), Character.valueOf('Q'), Items.quartz, Character.valueOf('C'), Items.diamond));
        ConfigResearch.recipes.put("FocusPouch", ThaumcraftApi.addArcaneCraftingRecipe("FOCUSPOUCH", new ItemStack(ConfigItems.itemFocusPouch), new AspectList().add(Aspect.EARTH, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), "LGL", "LBL", "LLL", Character.valueOf('B'), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), Character.valueOf('L'), Items.leather, Character.valueOf('G'), Items.gold_ingot));
        ConfigResearch.recipes.put("Deconstructor", ThaumcraftApi.addArcaneCraftingRecipe("DECONSTRUCTOR", new ItemStack(ConfigBlocks.blockTable, 1, 14), new AspectList().add(Aspect.ENTROPY, 20), " S ", "ATP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTable, 1, 0), Character.valueOf('S'), new ItemStack(ConfigItems.itemThaumometer), Character.valueOf('P'), new ItemStack(Items.golden_pickaxe), Character.valueOf('A'), new ItemStack(Items.golden_axe)));
        ConfigResearch.recipes.put("ArcaneBoreBase", ThaumcraftApi.addArcaneCraftingRecipe("ARCANEBORE", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 4), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 10), "WIW", "IDI", "WIW", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('I'), Items.iron_ingot, Character.valueOf('D'), Blocks.dispenser));
        ConfigResearch.recipes.put("EnchantedFabric", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemResource, 1, 7), new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), " S ", "SCS", " S ", Character.valueOf('S'), new ItemStack(Items.string, 1, Short.MAX_VALUE), Character.valueOf('C'), new ItemStack(Blocks.wool, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("RobeChest", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemChestRobe, 1), new AspectList().add(Aspect.AIR, 5), "I I", "III", "III", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        ConfigResearch.recipes.put("RobeLegs", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemLegsRobe, 1), new AspectList().add(Aspect.WATER, 5), "III", "I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        ConfigResearch.recipes.put("RobeBoots", ThaumcraftApi.addArcaneCraftingRecipe("ENCHFABRIC", new ItemStack(ConfigItems.itemBootsRobe, 1), new AspectList().add(Aspect.EARTH, 3), "I I", "I I", Character.valueOf('I'), new ItemStack(ConfigItems.itemResource, 1, 7)));
        GameRegistry.addRecipe((IRecipe)new RecipesRobeArmorDyes());
        ConfigResearch.recipes.put("Goggles", ThaumcraftApi.addArcaneCraftingRecipe("GOGGLES", new ItemStack(ConfigItems.itemGoggles), new AspectList().add(Aspect.AIR, 5).add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 3).add(Aspect.ORDER, 3), "LGL", "L L", "TGT", Character.valueOf('T'), ConfigItems.itemThaumometer, Character.valueOf('G'), Items.gold_ingot, Character.valueOf('L'), Items.leather));
        ConfigResearch.recipes.put("HungryChest", ThaumcraftApi.addArcaneCraftingRecipe("HUNGRYCHEST", new ItemStack(ConfigBlocks.blockChestHungry), new AspectList().add(Aspect.AIR, 5).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3), "WTW", "W W", "WWW", Character.valueOf('W'), "plankWood", Character.valueOf('T'), Blocks.trapdoor));
        ConfigResearch.recipes.put("GolemBell", ThaumcraftApi.addArcaneCraftingRecipe("GOLEMBELL", new ItemStack(ConfigItems.itemGolemBell), new AspectList().add(Aspect.ORDER, 5), " QQ", " QQ", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('Q'), Items.quartz));
        ConfigResearch.recipes.put("CoreBlank", ThaumcraftApi.addArcaneCraftingRecipe("COREGATHER", new ItemStack(ConfigItems.itemGolemCore, 1, 100), new AspectList().add(Aspect.ORDER, 5).add(Aspect.FIRE, 5), " C ", "CNC", " C ", Character.valueOf('C'), Items.brick, Character.valueOf('N'), new ItemStack(ConfigItems.itemResource, 1, 1)));
        ConfigResearch.recipes.put("UpgradeAir", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEAIR", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 0), new AspectList().add(Aspect.AIR, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0)));
        ConfigResearch.recipes.put("UpgradeEarth", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEEARTH", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 1), new AspectList().add(Aspect.EARTH, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 3)));
        ConfigResearch.recipes.put("UpgradeFire", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEFIRE", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 2), new AspectList().add(Aspect.FIRE, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 1)));
        ConfigResearch.recipes.put("UpgradeWater", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEWATER", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 3), new AspectList().add(Aspect.WATER, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 2)));
        ConfigResearch.recipes.put("UpgradeOrder", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEORDER", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 4), new AspectList().add(Aspect.ORDER, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 4)));
        ConfigResearch.recipes.put("UpgradeEntropy", ThaumcraftApi.addArcaneCraftingRecipe("UPGRADEENTROPY", new ItemStack(ConfigItems.itemGolemUpgrade, 1, 5), new AspectList().add(Aspect.ENTROPY, 10), "NNN", "NCN", "NNN", Character.valueOf('N'), Items.gold_nugget, Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 5)));
        ConfigResearch.recipes.put("TinyHat", ThaumcraftApi.addArcaneCraftingRecipe("TINYHAT", new ItemStack(ConfigItems.itemGolemDecoration, 1, 0), new AspectList().add(Aspect.ORDER, 8).add(Aspect.FIRE, 8), " C ", " G ", "CCC", Character.valueOf('C'), new ItemStack(Blocks.wool, 1, 15), Character.valueOf('G'), Items.gold_ingot));
        ConfigResearch.recipes.put("TinyFez", ThaumcraftApi.addArcaneCraftingRecipe("TINYFEZ", new ItemStack(ConfigItems.itemGolemDecoration, 1, 3), new AspectList().add(Aspect.WATER, 4).add(Aspect.EARTH, 4), "CCS", "CCS", "  S", Character.valueOf('C'), new ItemStack(Blocks.wool, 1, 14), Character.valueOf('S'), Items.string));
        ConfigResearch.recipes.put("TinyBowtie", ThaumcraftApi.addArcaneCraftingRecipe("TINYBOWTIE", new ItemStack(ConfigItems.itemGolemDecoration, 1, 2), new AspectList().add(Aspect.AIR, 4).add(Aspect.ORDER, 4), "CSC", "C C", Character.valueOf('C'), new ItemStack(Blocks.wool, 1, 15), Character.valueOf('S'), Items.string));
        ConfigResearch.recipes.put("TinyGlasses", ThaumcraftApi.addArcaneCraftingRecipe("TINYGLASSES", new ItemStack(ConfigItems.itemGolemDecoration, 1, 1), new AspectList().add(Aspect.AIR, 4).add(Aspect.WATER, 4), "GIG", Character.valueOf('G'), Blocks.glass, Character.valueOf('I'), Items.iron_ingot));
        ConfigResearch.recipes.put("TinyDart", ThaumcraftApi.addArcaneCraftingRecipe("TINYDART", new ItemStack(ConfigItems.itemGolemDecoration, 1, 4), new AspectList().add(Aspect.AIR, 4).add(Aspect.FIRE, 4), "AIA", "ADA", "AIA", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('D'), Blocks.dispenser, Character.valueOf('A'), Items.arrow));
        ConfigResearch.recipes.put("TinyVisor", ThaumcraftApi.addArcaneCraftingRecipe("TINYVISOR", new ItemStack(ConfigItems.itemGolemDecoration, 1, 5), new AspectList().add(Aspect.EARTH, 4).add(Aspect.WATER, 4), "IHI", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('H'), new ItemStack((Item)Items.iron_helmet, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("TinyArmor", ThaumcraftApi.addArcaneCraftingRecipe("TINYARMOR", new ItemStack(ConfigItems.itemGolemDecoration, 1, 6), new AspectList().add(Aspect.EARTH, 8), "I I", "IAI", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('A'), new ItemStack((Item)Items.iron_chestplate, 1, Short.MAX_VALUE)));
        ConfigResearch.recipes.put("TinyHammer", ThaumcraftApi.addArcaneCraftingRecipe("TINYHAMMER", new ItemStack(ConfigItems.itemGolemDecoration, 1, 7), new AspectList().add(Aspect.EARTH, 4).add(Aspect.FIRE, 4), "III", "III", " I ", Character.valueOf('I'), Items.iron_ingot));
        ConfigResearch.recipes.put("Filter", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigItems.itemResource, 2, 8), new AspectList().add(Aspect.ORDER, 5).add(Aspect.WATER, 5), "GWG", Character.valueOf('G'), Items.gold_ingot, Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 7)));
        ConfigResearch.recipes.put("AlchemyFurnace", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 0), new AspectList().add(Aspect.FIRE, 5).add(Aspect.WATER, 5), "SCS", "SFS", "SSS", Character.valueOf('C'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 0), Character.valueOf('F'), Blocks.furnace, Character.valueOf('S'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 6)));
        ConfigResearch.recipes.put("Alembic", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), new AspectList().add(Aspect.AIR, 5).add(Aspect.WATER, 5), "FIG", "IBI", "I I", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('B'), Items.bucket, Character.valueOf('G'), Items.gold_ingot, Character.valueOf('F'), new ItemStack(ConfigItems.itemResource, 1, 8), Character.valueOf('L'), new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 1)));
        ConfigResearch.recipes.put("Bellows", ThaumcraftApi.addArcaneCraftingRecipe("BELLOWS", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 0), new AspectList().add(Aspect.AIR, 10).add(Aspect.ORDER, 5), "WW ", "LCI", "WW ", Character.valueOf('W'), "plankWood", Character.valueOf('C'), new ItemStack(ConfigItems.itemShard, 1, 0), Character.valueOf('I'), Items.iron_ingot, Character.valueOf('L'), Items.leather));
        ConfigResearch.recipes.put("Tube", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ConfigBlocks.blockTube, 8, 0), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), " Q ", "IGI", " B ", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('B'), Items.gold_nugget, Character.valueOf('G'), Blocks.glass, Character.valueOf('Q'), new ItemStack(ConfigItems.itemNugget, 1, 5)));
        ConfigResearch.recipes.put("Resonator", ThaumcraftApi.addArcaneCraftingRecipe("TUBES", new ItemStack(ConfigItems.itemResonator), new AspectList().add(Aspect.WATER, 5).add(Aspect.AIR, 5), "I I", "INI", " S ", Character.valueOf('I'), Items.iron_ingot, Character.valueOf('N'), Items.quartz, Character.valueOf('S'), "stickWood"));
        ConfigResearch.recipes.put("TubeValve", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBES", new ItemStack(ConfigBlocks.blockTube, 1, 1), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), new ItemStack(ConfigBlocks.blockTube, 1, 0), new ItemStack(Blocks.lever)));
        ConfigResearch.recipes.put("TubeFilter", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 3), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 16), new ItemStack(ConfigBlocks.blockTube, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 8)));
        ConfigResearch.recipes.put("TubeRestrict", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 5), new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 16), new ItemStack(ConfigBlocks.blockTube, 1, 0), "stone"));
        ConfigResearch.recipes.put("TubeOneway", ThaumcraftApi.addShapelessArcaneCraftingRecipe("TUBEFILTER", new ItemStack(ConfigBlocks.blockTube, 1, 6), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 8).add(Aspect.ENTROPY, 8), new ItemStack(ConfigBlocks.blockTube, 1, 0), "dyeBlue"));
        ConfigResearch.recipes.put("TubeBuffer", ThaumcraftApi.addArcaneCraftingRecipe("CENTRIFUGE", new ItemStack(ConfigBlocks.blockTube, 1, 4), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "PVP", "T T", "PRP", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('V'), new ItemStack(ConfigBlocks.blockTube, 1, 1), Character.valueOf('R'), new ItemStack(ConfigBlocks.blockTube, 1, 5), Character.valueOf('P'), new ItemStack(ConfigItems.itemEssence, 1, 0)));
        ConfigResearch.recipes.put("AlchemicalConstruct", ThaumcraftApi.addArcaneCraftingRecipe("DISTILESSENTIA", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "VTF", "TWT", "FTV", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), Character.valueOf('V'), new ItemStack(ConfigBlocks.blockTube, 1, 1), Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('F'), new ItemStack(ConfigItems.itemResource, 1, 8)));
        ConfigResearch.recipes.put("AdvAlchemyConstruct", ThaumcraftApi.addArcaneCraftingRecipe("ADVALCHEMYFURNACE", new ItemStack(ConfigBlocks.blockMetalDevice, 4, 3), new AspectList().add(Aspect.WATER, 10).add(Aspect.ORDER, 30).add(Aspect.EARTH, 10), "VAV", "APA", "VAV", Character.valueOf('A'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9), Character.valueOf('V'), new ItemStack(ConfigItems.itemResource, 1, 16), Character.valueOf('P'), new ItemStack(ConfigItems.itemEldritchObject, 1, 3)));
        ConfigResearch.recipes.put("Centrifuge", ThaumcraftApi.addArcaneCraftingRecipe("CENTRIFUGE", new ItemStack(ConfigBlocks.blockTube, 1, 2), new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 5), " T ", "ACP", " T ", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('P'), new ItemStack((Block)Blocks.piston), Character.valueOf('A'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 1), Character.valueOf('C'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9)));
        ConfigResearch.recipes.put("EssentiaCrystalizer", ThaumcraftApi.addArcaneCraftingRecipe("ESSENTIACRYSTAL", new ItemStack(ConfigBlocks.blockTube, 1, 7), new AspectList().add(Aspect.WATER, 5).add(Aspect.EARTH, 15).add(Aspect.ORDER, 5), "IDI", "QCQ", "WTW", Character.valueOf('T'), new ItemStack(ConfigBlocks.blockTube, 1, 0), Character.valueOf('D'), new ItemStack(Blocks.dispenser), Character.valueOf('Q'), new ItemStack(ConfigItems.itemShard, 1, 6), Character.valueOf('I'), "ingotIron", Character.valueOf('W'), "plankWood", Character.valueOf('C'), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 9)));
        ConfigResearch.recipes.put("MnemonicMatrix", ThaumcraftApi.addArcaneCraftingRecipe("THAUMATORIUM", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 12), new AspectList().add(Aspect.FIRE, 5).add(Aspect.WATER, 5).add(Aspect.ORDER, 5), "IAI", "ABA", "IAI", Character.valueOf('B'), new ItemStack(ConfigItems.itemZombieBrain), Character.valueOf('A'), new ItemStack(ConfigItems.itemResource, 1, 6), Character.valueOf('I'), new ItemStack(Items.iron_ingot)));
    }

    private static void initializeInfusionEnchantmentRecipes() {
        ConfigResearch.recipes.put("InfEnchRepair", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.enchantmentsList[ThaumcraftApi.enchantRepair], 4, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.CRAFT, 10).add(Aspect.ORDER, 10), new ItemStack[]{new ItemStack(Blocks.anvil), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnchHaste", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.enchantmentsList[ThaumcraftApi.enchantHaste], 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TRAVEL, 8).add(Aspect.FLIGHT, 8), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch0", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.protection, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 8), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch1", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.fireProtection, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.FIRE, 4), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(Items.magma_cream), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch2", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.blastProtection, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.ENTROPY, 4), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(Items.gunpowder), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch3", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.projectileProtection, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.ARMOR, 4).add(Aspect.FLIGHT, 4), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(Items.arrow), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch4", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.featherFalling, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.AIR, 4).add(Aspect.FLIGHT, 4), new ItemStack[]{new ItemStack(Items.feather), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch5", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.respiration, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.AIR, 8).add(Aspect.WATER, 8), new ItemStack[]{new ItemStack(Items.reeds), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch6", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.aquaAffinity, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.MOTION, 8).add(Aspect.WATER, 8), new ItemStack[]{new ItemStack(Items.reeds), new ItemStack(Items.slime_ball), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch7", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.thorns, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8).add(Aspect.PLANT, 8), new ItemStack[]{new ItemStack((Block)Blocks.deadbush), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch8", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.sharpness, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8), new ItemStack[]{new ItemStack(Items.iron_sword), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch9", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.smite, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.UNDEAD, 4), new ItemStack[]{new ItemStack(Items.iron_sword), new ItemStack(Items.glowstone_dust), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch10", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.baneOfArthropods, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.BEAST, 4), new ItemStack[]{new ItemStack(Items.iron_sword), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch11", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.knockback, 1, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 3).add(Aspect.MOTION, 3), new ItemStack[]{new ItemStack((Block)Blocks.piston), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch12", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.fireAspect, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.FIRE, 8), new ItemStack[]{new ItemStack(Items.iron_sword), new ItemStack(Items.blaze_powder), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch13", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.looting, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.GREED, 8), new ItemStack[]{new ItemStack(Items.iron_sword), new ItemStack(Items.diamond), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch14", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.efficiency, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.ORDER, 4), new ItemStack[]{new ItemStack(Items.iron_pickaxe), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch15", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.silkTouch, 5, new AspectList().add(Aspect.MAGIC, 16).add(Aspect.TOOL, 16).add(Aspect.ORDER, 16).add(Aspect.HARVEST, 16).add(Aspect.MINE, 16), new ItemStack[]{new ItemStack(Items.iron_pickaxe), new ItemStack(Blocks.web), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch16", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.unbreaking, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.ORDER, 8), new ItemStack[]{new ItemStack(Items.iron_pickaxe), new ItemStack(Blocks.obsidian), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch17", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.fortune, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.TOOL, 4).add(Aspect.GREED, 8), new ItemStack[]{new ItemStack(Items.iron_pickaxe), new ItemStack(Items.diamond), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch18", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.power, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 8), new ItemStack[]{new ItemStack((Item)Items.bow), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch19", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.punch, 2, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 3).add(Aspect.MOTION, 3), new ItemStack[]{new ItemStack((Block)Blocks.piston), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch20", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.flame, 3, new AspectList().add(Aspect.MAGIC, 4).add(Aspect.WEAPON, 4).add(Aspect.FIRE, 8), new ItemStack[]{new ItemStack((Item)Items.bow), new ItemStack(Items.blaze_powder), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("InfEnch21", ThaumcraftApi.addInfusionEnchantmentRecipe("INFUSIONENCHANTMENT", Enchantment.infinity, 5, new AspectList().add(Aspect.MAGIC, 8).add(Aspect.WEAPON, 16).add(Aspect.VOID, 16).add(Aspect.EXCHANGE, 16), new ItemStack[]{new ItemStack((Item)Items.bow), new ItemStack(Items.arrow), new ItemStack(ConfigItems.itemResource, 1, 14)}));
    }

    private static void initializeInfusionRecipes() {
        if (Config.foundSilverIngot) {
            ConfigResearch.recipes.put("WandCapSilver", ThaumcraftApi.addInfusionCraftingRecipe("CAP_silver", new ItemStack(ConfigItems.itemWandCap, 1, 4), 4, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("silver").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("silver").getCraftCost()), new ItemStack(ConfigItems.itemWandCap, 1, 5), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        }
        ConfigResearch.recipes.put("WandCapThaumium", ThaumcraftApi.addInfusionCraftingRecipe("CAP_thaumium", new ItemStack(ConfigItems.itemWandCap, 1, 2), 5, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("thaumium").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("thaumium").getCraftCost()), new ItemStack(ConfigItems.itemWandCap, 1, 6), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("WandCapVoid", ThaumcraftApi.addInfusionCraftingRecipe("CAP_void", new ItemStack(ConfigItems.itemWandCap, 1, 7), 8, new AspectList().add(Aspect.ENERGY, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.VOID, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.ELDRITCH, WandCap.caps.get("void").getCraftCost() * 2).add(Aspect.AURA, WandCap.caps.get("void").getCraftCost() * 2), new ItemStack(ConfigItems.itemWandCap, 1, 8), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 14)}));
        ConfigResearch.recipes.put("WandRodObsidian", ThaumcraftApi.addInfusionCraftingRecipe("ROD_obsidian", new ItemStack(ConfigItems.itemWandRod, 1, 1), 3, new AspectList().add(Aspect.EARTH, WandRod.rods.get("obsidian").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("obsidian").getCraftCost()).add(Aspect.DARKNESS, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.obsidian), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("WandRodIce", ThaumcraftApi.addInfusionCraftingRecipe("ROD_ice", new ItemStack(ConfigItems.itemWandRod, 1, 3), 3, new AspectList().add(Aspect.WATER, WandRod.rods.get("ice").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("ice").getCraftCost()).add(Aspect.COLD, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.ice), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 2)}));
        ConfigResearch.recipes.put("WandRodQuartz", ThaumcraftApi.addInfusionCraftingRecipe("ROD_quartz", new ItemStack(ConfigItems.itemWandRod, 1, 4), 3, new AspectList().add(Aspect.ORDER, WandRod.rods.get("quartz").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("quartz").getCraftCost()).add(Aspect.CRYSTAL, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Blocks.quartz_block), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 4)}));
        ConfigResearch.recipes.put("WandRodReed", ThaumcraftApi.addInfusionCraftingRecipe("ROD_reed", new ItemStack(ConfigItems.itemWandRod, 1, 5), 3, new AspectList().add(Aspect.AIR, WandRod.rods.get("reed").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("reed").getCraftCost()).add(Aspect.MOTION, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.reeds), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 0)}));
        ConfigResearch.recipes.put("WandRodBlaze", ThaumcraftApi.addInfusionCraftingRecipe("ROD_blaze", new ItemStack(ConfigItems.itemWandRod, 1, 6), 3, new AspectList().add(Aspect.FIRE, WandRod.rods.get("blaze").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("blaze").getCraftCost()).add(Aspect.BEAST, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.blaze_rod), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 1)}));
        ConfigResearch.recipes.put("WandRodBone", ThaumcraftApi.addInfusionCraftingRecipe("ROD_bone", new ItemStack(ConfigItems.itemWandRod, 1, 7), 3, new AspectList().add(Aspect.ENTROPY, WandRod.rods.get("bone").getCraftCost() * 2).add(Aspect.MAGIC, WandRod.rods.get("bone").getCraftCost()).add(Aspect.UNDEAD, WandRod.rods.get("blaze").getCraftCost()), new ItemStack(Items.bone), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("WandRodSilverwood", ThaumcraftApi.addInfusionCraftingRecipe("ROD_silverwood", new ItemStack(ConfigItems.itemWandRod, 1, 2), 5, new AspectList().add(Aspect.AIR, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("silverwood").getCraftCost()).add(Aspect.MAGIC, WandRod.rods.get("silverwood").getCraftCost()), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("WandRodPrimalStaff", ThaumcraftApi.addInfusionCraftingRecipe("ROD_primal_staff", new ItemStack(ConfigItems.itemWandRod, 1, 100), 8, new AspectList().add(Aspect.AIR, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.FIRE, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.WATER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.EARTH, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ORDER, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.ENTROPY, WandRod.rods.get("primal_staff").getCraftCost()).add(Aspect.MAGIC, WandRod.rods.get("primal_staff").getCraftCost() * 2), new ItemStack(ConfigItems.itemWandRod, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemWandRod, 1, 1), new ItemStack(ConfigItems.itemWandRod, 1, 3), new ItemStack(ConfigItems.itemWandRod, 1, 4), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemWandRod, 1, 5), new ItemStack(ConfigItems.itemWandRod, 1, 6), new ItemStack(ConfigItems.itemWandRod, 1, 7)}));
        ConfigResearch.recipes.put("FocusHellbat", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSHELLBAT", new ItemStack(ConfigItems.itemFocusHellbat), 3, new AspectList().add(Aspect.FIRE, 25).add(Aspect.AIR, 15).add(Aspect.BEAST, 15).add(Aspect.ENTROPY, 25), new ItemStack(Items.magma_cream), new ItemStack[]{new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("FocusPortableHole", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSPORTABLEHOLE", new ItemStack(ConfigItems.itemFocusPortableHole), 3, new AspectList().add(Aspect.TRAVEL, 25).add(Aspect.ELDRITCH, 10).add(Aspect.EXCHANGE, 10).add(Aspect.ENTROPY, 25), new ItemStack(Items.ender_pearl), new ItemStack[]{new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("FocusWarding", ThaumcraftApi.addInfusionCraftingRecipe("FOCUSWARDING", new ItemStack(ConfigItems.itemFocusWarding), 4, new AspectList().add(Aspect.EARTH, 25).add(Aspect.ARMOR, 25).add(Aspect.ORDER, 25).add(Aspect.MIND, 10), new ItemStack(Items.nether_star), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemResource, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.quartz), new ItemStack(ConfigItems.itemShard, 1, 4)}));
        ConfigResearch.recipes.put("WandPed", ThaumcraftApi.addInfusionCraftingRecipe("WANDPED", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 5), 3, new AspectList().add(Aspect.AURA, 10).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 15), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 1), new ItemStack[]{new ItemStack(Items.gold_ingot), new ItemStack(Items.diamond), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(Items.diamond)}));
        ConfigResearch.recipes.put("WandPedFocus", ThaumcraftApi.addInfusionCraftingRecipe("WANDPEDFOC", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 8), 4, new AspectList().add(Aspect.ORDER, 10).add(Aspect.MAGIC, 15).add(Aspect.EXCHANGE, 10), new ItemStack(Items.comparator), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemResource, 1, 8)}));
        ConfigResearch.recipes.put("NodeStabilizerAdv", ThaumcraftApi.addInfusionCraftingRecipe("NODESTABILIZERADV", new ItemStack(ConfigBlocks.blockStoneDevice, 1, 10), 10, new AspectList().add(Aspect.AURA, 32).add(Aspect.MAGIC, 16).add(Aspect.ORDER, 16).add(Aspect.ENERGY, 16), new ItemStack(ConfigBlocks.blockStoneDevice, 1, 9), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(Blocks.redstone_block), new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Blocks.redstone_block), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(Blocks.redstone_block), new ItemStack(ConfigItems.itemResource, 1, 0), new ItemStack(Blocks.redstone_block)}));
        ConfigResearch.recipes.put("JarBrain", ThaumcraftApi.addInfusionCraftingRecipe("JARBRAIN", new ItemStack(ConfigBlocks.blockJar, 1, 1), 4, new AspectList().add(Aspect.MIND, 10).add(Aspect.SENSES, 10).add(Aspect.UNDEAD, 20), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemZombieBrain), new ItemStack(Items.spider_eye), new ItemStack(Items.water_bucket), new ItemStack(Items.spider_eye)}));
        ConfigResearch.recipes.put("AdvancedGolem", ThaumcraftApi.addInfusionCraftingRecipe("ADVANCEDGOLEM", new Object[]{"advanced", new NBTTagByte(1)}, 3, new AspectList().add(Aspect.MIND, 8).add(Aspect.SENSES, 8).add(Aspect.LIFE, 8), new ItemStack(ConfigItems.itemGolemPlacer, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.redstone), new ItemStack(Items.glowstone_dust), new ItemStack(Items.gunpowder), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack(ConfigItems.itemZombieBrain)}));
        ConfigResearch.recipes.put("HoverHarness", ThaumcraftApi.addInfusionCraftingRecipe("HOVERHARNESS", new ItemStack(ConfigItems.itemHoverHarness), 6, new AspectList().add(Aspect.FLIGHT, 32).add(Aspect.ENERGY, 32).add(Aspect.MECHANISM, 32).add(Aspect.TRAVEL, 16), new ItemStack((Item)Items.leather_chestplate), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(Items.comparator), new ItemStack(Items.gold_ingot), new ItemStack(Items.gold_ingot), new ItemStack(Items.iron_ingot), new ItemStack(Items.iron_ingot)}));
        ConfigResearch.recipes.put("HoverGirdle", ThaumcraftApi.addInfusionCraftingRecipe("HOVERGIRDLE", new ItemStack(ConfigItems.itemGirdleHover), 8, new AspectList().add(Aspect.FLIGHT, 16).add(Aspect.ENERGY, 32).add(Aspect.AIR, 32).add(Aspect.TRAVEL, 16), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.feather), new ItemStack(Items.gold_ingot), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.feather), new ItemStack(Items.gold_ingot)}));
        ConfigResearch.recipes.put("VisAmulet", ThaumcraftApi.addInfusionCraftingRecipe("VISAMULET", new ItemStack(ConfigItems.itemAmuletVis, 1, 1), 6, new AspectList().add(Aspect.AURA, 24).add(Aspect.ENERGY, 64).add(Aspect.MAGIC, 64).add(Aspect.VOID, 24), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new ItemStack(ConfigBlocks.blockCrystal, 1, 6)}));
        ConfigResearch.recipes.put("RunicAmulet", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemAmuletRunic, 1, 0), 4, new AspectList().add(Aspect.ARMOR, 20).add(Aspect.MAGIC, 35).add(Aspect.ENERGY, 35), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicAmuletEmergency", ThaumcraftApi.addInfusionCraftingRecipe("RUNICEMERGENCY", new ItemStack(ConfigItems.itemAmuletRunic, 1, 1), 7, new AspectList().add(Aspect.ARMOR, 20).add(Aspect.MAGIC, 35).add(Aspect.EARTH, 32).add(Aspect.VOID, 32), new ItemStack(ConfigItems.itemAmuletRunic, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack((Item)Items.potionitem, 1, 8233), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("RunicRing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemRingRunic, 1, 1), 3, new AspectList().add(Aspect.ARMOR, 10).add(Aspect.MAGIC, 25).add(Aspect.ENERGY, 25), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicRingCharged", ThaumcraftApi.addInfusionCraftingRecipe("RUNICCHARGED", new ItemStack(ConfigItems.itemRingRunic, 1, 2), 6, new AspectList().add(Aspect.ARMOR, 16).add(Aspect.MAGIC, 16).add(Aspect.ENERGY, 64), new ItemStack(ConfigItems.itemRingRunic, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack((Item)Items.potionitem, 1, 8226), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1)}));
        ConfigResearch.recipes.put("RunicRingHealing", ThaumcraftApi.addInfusionCraftingRecipe("RUNICHEALING", new ItemStack(ConfigItems.itemRingRunic, 1, 3), 6, new AspectList().add(Aspect.ARMOR, 16).add(Aspect.MAGIC, 16).add(Aspect.WATER, 32).add(Aspect.HEAL, 32), new ItemStack(ConfigItems.itemRingRunic, 1, 1), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack((Item)Items.potionitem, 1, 8257), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2)}));
        ConfigResearch.recipes.put("RunicGirdle", ThaumcraftApi.addInfusionCraftingRecipe("RUNICARMOR", new ItemStack(ConfigItems.itemGirdleRunic, 1, 0), 4, new AspectList().add(Aspect.ARMOR, 30).add(Aspect.MAGIC, 50).add(Aspect.ENERGY, 50), new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemResource, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemInkwell)}));
        ConfigResearch.recipes.put("RunicGirdleKinetic", ThaumcraftApi.addInfusionCraftingRecipe("RUNICKINETIC", new ItemStack(ConfigItems.itemGirdleRunic, 1, 1), 7, new AspectList().add(Aspect.ARMOR, 33).add(Aspect.MAGIC, 55).add(Aspect.AIR, 64), new ItemStack(ConfigItems.itemGirdleRunic, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack((Item)Items.potionitem, 1, 16428), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0)}));
        ConfigResearch.recipes.put("RunicGirdleKinetic_2", ThaumcraftApi.addInfusionCraftingRecipe("RUNICKINETIC", new ItemStack(ConfigItems.itemGirdleRunic, 1, 1), 7, new AspectList().add(Aspect.ARMOR, 33).add(Aspect.MAGIC, 55).add(Aspect.AIR, 64), new ItemStack(ConfigItems.itemGirdleRunic, 1, 0), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack((Item)Items.potionitem, 1, 24620), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0)}));
        InfusionRunicAugmentRecipe ra = new InfusionRunicAugmentRecipe();
        ThaumcraftApi.getCraftingRecipes().add(ra);
        if (Config.allowMirrors) {
            ConfigResearch.recipes.put("Mirror", ThaumcraftApi.addInfusionCraftingRecipe("MIRROR", new ItemStack(ConfigBlocks.blockMirror, 1, 0), 1, new AspectList().add(Aspect.TRAVEL, 8).add(Aspect.DARKNESS, 8).add(Aspect.EXCHANGE, 8), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack[]{new ItemStack(Items.gold_ingot), new ItemStack(Items.gold_ingot), new ItemStack(Items.gold_ingot), new ItemStack(Items.ender_pearl)}));
            ConfigResearch.recipes.put("MirrorHand", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORHAND", new ItemStack(ConfigItems.itemHandMirror), 5, new AspectList().add(Aspect.TOOL, 16).add(Aspect.TRAVEL, 16), new ItemStack(ConfigBlocks.blockMirror, 1, 0), new ItemStack[]{new ItemStack(Items.stick), new ItemStack(Items.compass), new ItemStack((Item)Items.map)}));
            ConfigResearch.recipes.put("MirrorEssentia", ThaumcraftApi.addInfusionCraftingRecipe("MIRRORESSENTIA", new ItemStack(ConfigBlocks.blockMirror, 1, 6), 2, new AspectList().add(Aspect.TRAVEL, 8).add(Aspect.WATER, 8).add(Aspect.EXCHANGE, 8), new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(Items.iron_ingot), new ItemStack(Items.iron_ingot), new ItemStack(Items.ender_pearl)}));
        }
        ConfigResearch.recipes.put("ElementalAxe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALAXE", new ItemStack(ConfigItems.itemAxeElemental), 1, new AspectList().add(Aspect.WATER, 16).add(Aspect.TREE, 8), new ItemStack(ConfigItems.itemAxeThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(Items.diamond), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalPick", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALPICK", new ItemStack(ConfigItems.itemPickElemental), 1, new AspectList().add(Aspect.FIRE, 8).add(Aspect.MINE, 8).add(Aspect.SENSES, 8), new ItemStack(ConfigItems.itemPickThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.diamond), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalSword", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALSWORD", new ItemStack(ConfigItems.itemSwordElemental), 1, new AspectList().add(Aspect.AIR, 8).add(Aspect.MOTION, 8).add(Aspect.ENERGY, 8), new ItemStack(ConfigItems.itemSwordThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(Items.diamond), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalShovel", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALSHOVEL", new ItemStack(ConfigItems.itemShovelElemental), 1, new AspectList().add(Aspect.EARTH, 16).add(Aspect.CRAFT, 8), new ItemStack(ConfigItems.itemShovelThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.diamond), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("ElementalHoe", ThaumcraftApi.addInfusionCraftingRecipe("ELEMENTALHOE", new ItemStack(ConfigItems.itemHoeElemental), 1, new AspectList().add(Aspect.HARVEST, 8).add(Aspect.PLANT, 8).add(Aspect.EARTH, 8), new ItemStack(ConfigItems.itemHoeThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5), new ItemStack(Items.diamond), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("BootsTraveller", ThaumcraftApi.addInfusionCraftingRecipe("BOOTSTRAVELLER", new ItemStack(ConfigItems.itemBootsTraveller), 1, new AspectList().add(Aspect.FLIGHT, 25).add(Aspect.TRAVEL, 25), new ItemStack((Item)Items.leather_boots), new ItemStack[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(Items.feather), new ItemStack(Items.fish, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("CoreAlchemy", ThaumcraftApi.addInfusionCraftingRecipe("COREALCHEMY", new ItemStack(ConfigItems.itemGolemCore, 1, 6), 2, new AspectList().add(Aspect.MAGIC, 15).add(Aspect.WATER, 15).add(Aspect.MOTION, 15), new ItemStack(ConfigItems.itemGolemCore, 1, 5), new ItemStack[]{new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack((Item)Items.potionitem), new ItemStack((Item)Items.potionitem), new ItemStack((Item)Items.potionitem)}));
        ConfigResearch.recipes.put("CoreSorting", ThaumcraftApi.addInfusionCraftingRecipe("CORESORTING", new ItemStack(ConfigItems.itemGolemCore, 1, 10), 3, new AspectList().add(Aspect.VOID, 16).add(Aspect.EXCHANGE, 16).add(Aspect.HUNGER, 16).add(Aspect.GREED, 16), new ItemStack(ConfigItems.itemZombieBrain), new ItemStack[]{new ItemStack(ConfigItems.itemGolemCore, 1, 0), new ItemStack(Items.comparator), new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack(Items.paper)}));
        ConfigResearch.recipes.put("CoreLumber", ThaumcraftApi.addInfusionCraftingRecipe("CORELUMBER", new ItemStack(ConfigItems.itemGolemCore, 1, 7), 2, new AspectList().add(Aspect.TOOL, 16).add(Aspect.TREE, 16).add(Aspect.HARVEST, 16), new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack[]{new ItemStack(ConfigItems.itemAxeElemental), new ItemStack(Items.iron_axe), new ItemStack(Items.iron_axe), new ItemStack(Items.iron_axe)}));
        ConfigResearch.recipes.put("CoreFishing", ThaumcraftApi.addInfusionCraftingRecipe("COREFISHING", new ItemStack(ConfigItems.itemGolemCore, 1, 11), 3, new AspectList().add(Aspect.WATER, 16).add(Aspect.HARVEST, 16).add(Aspect.BEAST, 16), new ItemStack(ConfigItems.itemGolemCore, 1, 3), new ItemStack[]{new ItemStack((Item)Items.fishing_rod), new ItemStack(Items.fish, 1, 0), new ItemStack(Items.fish, 1, 3), new ItemStack(Items.fish, 1, 1)}));
        ConfigResearch.recipes.put("CoreUse", ThaumcraftApi.addInfusionCraftingRecipe("COREUSE", new ItemStack(ConfigItems.itemGolemCore, 1, 8), 3, new AspectList().add(Aspect.TOOL, 20).add(Aspect.MECHANISM, 20).add(Aspect.MAN, 20), new ItemStack(ConfigItems.itemGolemCore, 1, 1), new ItemStack[]{new ItemStack(Items.comparator), new ItemStack(Items.flint_and_steel), new ItemStack((Item)Items.shears), new ItemStack(Blocks.lever)}));
        ConfigResearch.recipes.put("ArcaneBore", ThaumcraftApi.addInfusionCraftingRecipe("ARCANEBORE", new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 5), 4, new AspectList().add(Aspect.ENERGY, 16).add(Aspect.MINE, 32).add(Aspect.MECHANISM, 32).add(Aspect.VOID, 16).add(Aspect.MOTION, 16), new ItemStack((Block)Blocks.piston), new ItemStack[]{new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(Items.gold_ingot), new ItemStack(Items.gold_ingot), new ItemStack(Items.diamond_pickaxe), new ItemStack(Items.diamond_shovel), new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("TravelTrunk", ThaumcraftApi.addInfusionCraftingRecipe("TRAVELTRUNK", new ItemStack(ConfigItems.itemTrunkSpawner), 3, new AspectList().add(Aspect.MOTION, 4).add(Aspect.SOUL, 4).add(Aspect.TRAVEL, 4).add(Aspect.VOID, 16), new ItemStack(ConfigBlocks.blockChestHungry), new ItemStack[]{new ItemStack(Items.iron_ingot), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6), new ItemStack(ConfigItems.itemGolemPlacer, 1, 1), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)}));
        ConfigResearch.recipes.put("LampGrowth", ThaumcraftApi.addInfusionCraftingRecipe("LAMPGROWTH", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 8), 4, new AspectList().add(Aspect.PLANT, 16).add(Aspect.LIGHT, 8).add(Aspect.LIFE, 16), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new ItemStack[]{new ItemStack(Items.gold_ingot), new ItemStack(Items.dye, 1, 15), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(Items.gold_ingot), new ItemStack(Items.dye, 1, 15), new ItemStack(ConfigItems.itemShard, 1, 3)}));
        ConfigResearch.recipes.put("LampFertility", ThaumcraftApi.addInfusionCraftingRecipe("LAMPFERTILITY", new ItemStack(ConfigBlocks.blockMetalDevice, 1, 13), 4, new AspectList().add(Aspect.BEAST, 16).add(Aspect.LIFE, 16).add(Aspect.LIGHT, 8), new ItemStack(ConfigBlocks.blockMetalDevice, 1, 7), new ItemStack[]{new ItemStack(Items.gold_ingot), new ItemStack(Items.wheat), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(Items.gold_ingot), new ItemStack(Items.carrot), new ItemStack(ConfigItems.itemShard, 1, 1)}));
        ConfigResearch.recipes.put("ThaumiumFortressHelm", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", new ItemStack(ConfigItems.itemHelmetFortress), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.ARMOR, 16).add(Aspect.MAGIC, 16), new ItemStack(ConfigItems.itemHelmetThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(Items.gold_ingot), new ItemStack(Items.gold_ingot), new ItemStack(Items.emerald)}));
        ConfigResearch.recipes.put("ThaumiumFortressChest", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", new ItemStack(ConfigItems.itemChestFortress), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.ARMOR, 24).add(Aspect.MAGIC, 16), new ItemStack(ConfigItems.itemChestThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(Items.gold_ingot), new ItemStack(Items.leather)}));
        ConfigResearch.recipes.put("ThaumiumFortressLegs", ThaumcraftApi.addInfusionCraftingRecipe("ARMORFORTRESS", new ItemStack(ConfigItems.itemLegsFortress), 3, new AspectList().add(Aspect.METAL, 24).add(Aspect.ARMOR, 20).add(Aspect.MAGIC, 16), new ItemStack(ConfigItems.itemLegsThaumium), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(Items.gold_ingot), new ItemStack(Items.leather)}));
        ConfigResearch.recipes.put("VoidRobeHelm", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", new ItemStack(ConfigItems.itemHelmetVoidRobe), 6, new AspectList().add(Aspect.METAL, 16).add(Aspect.SENSES, 16).add(Aspect.ARMOR, 16).add(Aspect.CLOTH, 16).add(Aspect.MAGIC, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 16), new ItemStack(ConfigItems.itemHelmetVoid), new ItemStack[]{new ItemStack(ConfigItems.itemGoggles), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 7)}));
        ConfigResearch.recipes.put("VoidRobeChest", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", new ItemStack(ConfigItems.itemChestVoidRobe), 6, new AspectList().add(Aspect.METAL, 24).add(Aspect.ARMOR, 24).add(Aspect.CLOTH, 24).add(Aspect.MAGIC, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 24), new ItemStack(ConfigItems.itemChestVoid), new ItemStack[]{new ItemStack(ConfigItems.itemChestRobe), new ItemStack(ConfigItems.itemResource, 1, 16), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(Items.leather)}));
        ConfigResearch.recipes.put("VoidRobeLegs", ThaumcraftApi.addInfusionCraftingRecipe("ARMORVOIDFORTRESS", new ItemStack(ConfigItems.itemLegsVoidRobe), 6, new AspectList().add(Aspect.METAL, 20).add(Aspect.ARMOR, 20).add(Aspect.CLOTH, 20).add(Aspect.MAGIC, 16).add(Aspect.ELDRITCH, 16).add(Aspect.VOID, 20), new ItemStack(ConfigItems.itemLegsVoid), new ItemStack[]{new ItemStack(ConfigItems.itemLegsRobe), new ItemStack(ConfigItems.itemResource, 1, 16), new ItemStack(ConfigItems.itemResource, 1, 2), new ItemStack(ConfigItems.itemResource, 1, 14), new ItemStack(ConfigItems.itemResource, 1, 7), new ItemStack(Items.leather)}));
        GameRegistry.addRecipe((IRecipe)new RecipesVoidRobeArmorDyes());
        ConfigResearch.recipes.put("HelmGoggles", ThaumcraftApi.addInfusionCraftingRecipe("HELMGOGGLES", new Object[]{"goggles", new NBTTagByte(1)}, 5, new AspectList().add(Aspect.SENSES, 32).add(Aspect.AURA, 16).add(Aspect.ARMOR, 16), new ItemStack(ConfigItems.itemHelmetFortress, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.slime_ball), new ItemStack(ConfigItems.itemGoggles, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("MaskGrinningDevil", ThaumcraftApi.addInfusionCraftingRecipe("MASKGRINNINGDEVIL", new Object[]{"mask", new NBTTagInt(0)}, 8, new AspectList().add(Aspect.MIND, 64).add(Aspect.HEAL, 64).add(Aspect.ARMOR, 16), new ItemStack(ConfigItems.itemHelmetFortress, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.dye, 1, 0), new ItemStack(Items.iron_ingot), new ItemStack(Items.leather), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2), new ItemStack(ConfigItems.itemZombieBrain), new ItemStack(Items.iron_ingot)}));
        ConfigResearch.recipes.put("MaskAngryGhost", ThaumcraftApi.addInfusionCraftingRecipe("MASKANGRYGHOST", new Object[]{"mask", new NBTTagInt(1)}, 8, new AspectList().add(Aspect.ENTROPY, 64).add(Aspect.DEATH, 64).add(Aspect.ARMOR, 16), new ItemStack(ConfigItems.itemHelmetFortress, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.dye, 1, 15), new ItemStack(Items.iron_ingot), new ItemStack(Items.leather), new ItemStack(Items.poisonous_potato), new ItemStack(Items.skull, 1, 1), new ItemStack(Items.iron_ingot)}));
        ConfigResearch.recipes.put("MaskSippingFiend", ThaumcraftApi.addInfusionCraftingRecipe("MASKSIPPINGFIEND", new Object[]{"mask", new NBTTagInt(2)}, 8, new AspectList().add(Aspect.UNDEAD, 64).add(Aspect.LIFE, 64).add(Aspect.ARMOR, 16), new ItemStack(ConfigItems.itemHelmetFortress, 1, Short.MAX_VALUE), new ItemStack[]{new ItemStack(Items.dye, 1, 1), new ItemStack(Items.iron_ingot), new ItemStack(Items.leather), new ItemStack(Items.ghast_tear), new ItemStack(Items.milk_bucket), new ItemStack(Items.iron_ingot)}));
        ConfigResearch.recipes.put("SanityCheck", ThaumcraftApi.addInfusionCraftingRecipe("SANITYCHECK", new ItemStack(ConfigItems.itemSanityChecker), 4, new AspectList().add(Aspect.MIND, 24).add(Aspect.SENSES, 24).add(Aspect.ELDRITCH, 8), new ItemStack(ConfigItems.itemThaumometer), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 10), new ItemStack(ConfigItems.itemZombieBrain), new ItemStack(Items.diamond)}));
        ConfigResearch.recipes.put("EssentiaReservoir", ThaumcraftApi.addInfusionCraftingRecipe("ESSENTIARESERVOIR", new ItemStack(ConfigBlocks.blockEssentiaReservoir), 6, new AspectList().add(Aspect.WATER, 8).add(Aspect.VOID, 8).add(Aspect.MAGIC, 8).add(Aspect.EXCHANGE, 8), new ItemStack(ConfigBlocks.blockTube, 1, 4), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 16), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 16), new ItemStack(ConfigBlocks.blockJar, 1, 0), new ItemStack(ConfigBlocks.blockJar, 1, 0)}));
        ConfigResearch.recipes.put("SinStone", ThaumcraftApi.addInfusionCraftingRecipe("SINSTONE", new ItemStack(ConfigItems.itemCompassStone), 5, new AspectList().add(Aspect.SENSES, 8).add(Aspect.DARKNESS, 8).add(Aspect.ELDRITCH, 8).add(Aspect.AURA, 8), new ItemStack(Items.flint), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemResource, 1, 9), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        ConfigResearch.recipes.put("PrimalCrusher", ThaumcraftApi.addInfusionCraftingRecipe("PRIMALCRUSHER", new ItemStack(ConfigItems.itemPrimalCrusher), 6, new AspectList().add(Aspect.MINE, 24).add(Aspect.TOOL, 24).add(Aspect.ENTROPY, 16).add(Aspect.VOID, 16).add(Aspect.WEAPON, 16).add(Aspect.ELDRITCH, 16).add(Aspect.GREED, 16), new ItemStack(ConfigItems.itemEldritchObject, 1, 3), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemPickVoid, 1, Short.MAX_VALUE), new ItemStack(ConfigItems.itemShovelVoid, 1, Short.MAX_VALUE), new ItemStack(ConfigItems.itemResource, 1, 15), new ItemStack(ConfigItems.itemPickElemental, 1, Short.MAX_VALUE), new ItemStack(ConfigItems.itemShovelElemental, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("EldritchEye", ThaumcraftApi.addInfusionCraftingRecipe("OCULUS", new ItemStack(ConfigItems.itemEldritchObject), 5, new AspectList().add(Aspect.ELDRITCH, 64).add(Aspect.VOID, 16).add(Aspect.DARKNESS, 16).add(Aspect.TRAVEL, 16), new ItemStack(Items.ender_eye), new ItemStack[]{new ItemStack(ConfigItems.itemResource, 1, 17), new ItemStack(Items.gold_ingot)}));
    }

    private static void initializeNormalRecipes() {
        int a;
        CraftingManager.getInstance().addRecipe(new ItemStack(ConfigItems.itemNugget, 9, 0), new Object[]{"#", Character.valueOf('#'), Items.iron_ingot});
        CraftingManager.getInstance().addRecipe(new ItemStack(ConfigItems.itemNugget, 9, 6), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 2)});
        CraftingManager.getInstance().addRecipe(new ItemStack(ConfigItems.itemNugget, 9, 7), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 16)});
        ConfigRecipes.oreDictRecipe(new ItemStack(Items.iron_ingot), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 0)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 2), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 6)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 3), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 5)});
        CraftingManager.getInstance().addRecipe(new ItemStack(ConfigItems.itemNugget, 9, 5), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 3)});
        ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 16), new Object[]{"###", "###", "###", Character.valueOf('#'), new ItemStack(ConfigItems.itemNugget, 1, 7)});
        ConfigResearch.recipes.put("MundaneAmulet", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 0), new Object[]{" S ", "S S", " I ", Character.valueOf('S'), new ItemStack(Items.string), Character.valueOf('I'), new ItemStack(Items.gold_ingot)}));
        ConfigResearch.recipes.put("MundaneRing", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 1), new Object[]{" N ", "N N", " N ", Character.valueOf('N'), new ItemStack(Items.gold_nugget)}));
        ConfigResearch.recipes.put("MundaneBelt", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBaubleBlanks, 1, 2), new Object[]{" L ", "L L", " I ", Character.valueOf('L'), new ItemStack(Items.leather), Character.valueOf('I'), new ItemStack(Items.gold_ingot)}));
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.sugar, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetPork});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.sugar, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetFish});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.sugar, ConfigItems.itemNuggetBeef, ConfigItems.itemNuggetFish, ConfigItems.itemNuggetPork});
        ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemTripleMeatTreat), new Object[]{Items.sugar, ConfigItems.itemNuggetFish, ConfigItems.itemNuggetChicken, ConfigItems.itemNuggetPork});
        CraftingManager.getInstance().addRecipe(new ItemStack(ConfigItems.itemResource, 1, 3), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2)});
        CraftingManager.getInstance().addRecipe(new ItemStack(Items.blaze_powder), new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCustomPlant, 1, 3)});
        ConfigResearch.recipes.put("JarLabel", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemResource, 4, 13), new Object[]{"dyeBlack", Items.slime_ball, Items.paper, Items.paper, Items.paper, Items.paper}));
        int count = 0;
        for (Aspect aspect : Aspect.aspects.values()) {
            ItemStack essence = new ItemStack(ConfigItems.itemEssence, 1, 1);
            ((IEssentiaContainerItem)essence.getItem()).setAspects(essence, new AspectList().add(aspect, 8));
            ItemStack output = new ItemStack(ConfigItems.itemResource, 1, 13);
            ((IEssentiaContainerItem)output.getItem()).setAspects(output, new AspectList().add(aspect, 0));
            ConfigResearch.recipes.put("JarLabel" + count, ConfigRecipes.shapelessNBTOreRecipe(output, new Object[]{new ItemStack(ConfigItems.itemResource, 1, 13), essence}));
            ++count;
        }
        ItemStack input = new ItemStack(ConfigItems.itemResource, 1, 13);
        ((IEssentiaContainerItem)input.getItem()).setAspects(input, new AspectList().add(Aspect.WATER, 1));
        ConfigResearch.recipes.put("JarLabelNull", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemResource, 1, 13), new Object[]{input}));
        ConfigResearch.recipes.put("WandBasic", ConfigRecipes.oreDictRecipe(basicWand, new Object[]{"  I", " S ", "I  ", Character.valueOf('I'), new ItemStack(ConfigItems.itemWandCap, 1, 0), Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("WandCapIron", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemWandCap, 1, 0), new Object[]{"NNN", "N N", Character.valueOf('N'), "nuggetIron"}));
        ConfigResearch.recipes.put("KnowFrag", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResearchNotes, 1, 42), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), new ItemStack(ConfigItems.itemResource, 1, 9)}));
        ConfigResearch.recipes.put("PlankGreatwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockWoodenDevice, 4, 6), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0)}));
        ConfigResearch.recipes.put("PlankSilverwood", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockWoodenDevice, 4, 7), (Object[])new Object[]{"W", Character.valueOf('W'), new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockStairsGreatwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockStairsSilverwood, 4, 0), (Object[])new Object[]{"K  ", "KK ", "KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 7)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockSlabWood, 6, 0), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6)});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockSlabWood, 6, 1), (Object[])new Object[]{"KKK", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 7)});
        ConfigResearch.recipes.put("BlockFlesh", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockTaint, 1, 2), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), Items.rotten_flesh}));
        ConfigResearch.recipes.put("BlockThaumium", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4), new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), "ingotThaumium"}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 9, 2), (Object[])new Object[]{"K", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 4)});
        ConfigResearch.recipes.put("BlockTallow", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5), (Object[])new Object[]{"KKK", "KKK", "KKK", Character.valueOf('K'), new ItemStack(ConfigItems.itemResource, 1, 4)}));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 9, 4), (Object[])new Object[]{"K", Character.valueOf('K'), new ItemStack(ConfigBlocks.blockCosmeticSolid, 1, 5)});
        for (a = 0; a < 6; ++a) {
            ConfigResearch.recipes.put("Clusters" + a, ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCrystal, 1, a), new Object[]{new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a), new ItemStack(ConfigItems.itemShard, 1, a)}));
        }
        ConfigResearch.recipes.put("Clusters6", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCrystal, 1, 6), new Object[]{new ItemStack(ConfigItems.itemShard, 1, 0), new ItemStack(ConfigItems.itemShard, 1, 1), new ItemStack(ConfigItems.itemShard, 1, 2), new ItemStack(ConfigItems.itemShard, 1, 3), new ItemStack(ConfigItems.itemShard, 1, 4), new ItemStack(ConfigItems.itemShard, 1, 5)}));
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(ConfigItems.itemResource, 1, 6)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticOpaque, 4, 1), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCosmeticSolid, 4, 1), (Object[])new Object[]{"##", "##", Character.valueOf('#'), Blocks.obsidian});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 4, 6), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(ConfigItems.itemResource, 4, 6), (Object[])new Object[]{"#", Character.valueOf('#'), new ItemStack(ConfigBlocks.blockCosmeticOpaque, 1, 1)});
        ConfigResearch.recipes.put("Grate", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockMetalDevice, 1, 5), (Object[])new Object[]{"#", "T", Character.valueOf('#'), new ItemStack(Blocks.iron_bars), Character.valueOf('T'), new ItemStack(Blocks.trapdoor)}));
        ConfigResearch.recipes.put("Phial", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigItems.itemEssence, 8, 0), (Object[])new Object[]{" C ", "G G", " G ", Character.valueOf('G'), Blocks.glass, Character.valueOf('C'), Items.clay_ball}));
        ConfigResearch.recipes.put("Table", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigBlocks.blockTable, 1, 0), new Object[]{"SSS", "W W", Character.valueOf('S'), "slabWood", Character.valueOf('W'), "plankWood"}));
        ConfigResearch.recipes.put("Scribe1", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{new ItemStack(ConfigItems.itemEssence, 1, 0), Items.feather, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe2", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{Items.glass_bottle, Items.feather, "dyeBlack"}));
        ConfigResearch.recipes.put("Scribe3", ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigItems.itemInkwell), new Object[]{new ItemStack(ConfigItems.itemInkwell, 1, Short.MAX_VALUE), "dyeBlack"}));
        ConfigResearch.recipes.put("Thaumometer", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemThaumometer), new Object[]{" 1 ", "IGI", " 1 ", Character.valueOf('I'), Items.gold_ingot, Character.valueOf('G'), Blocks.glass, Character.valueOf('1'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)}));
        ConfigResearch.recipes.put("ThaumiumHelm", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemHelmetThaumium, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumChest", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemChestThaumium, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumLegs", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemLegsThaumium, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumBoots", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBootsThaumium, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotThaumium"}));
        ConfigResearch.recipes.put("ThaumiumShovel", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemShovelThaumium, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumPick", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemPickThaumium, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumAxe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemAxeThaumium, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumHoe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemHoeThaumium, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("ThaumiumSword", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemSwordThaumium, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotThaumium", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidHelm", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemHelmetVoid, 1), new Object[]{"III", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidChest", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemChestVoid, 1), new Object[]{"I I", "III", "III", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidLegs", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemLegsVoid, 1), new Object[]{"III", "I I", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidBoots", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemBootsVoid, 1), new Object[]{"I I", "I I", Character.valueOf('I'), "ingotVoid"}));
        ConfigResearch.recipes.put("VoidShovel", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemShovelVoid, 1), new Object[]{"I", "S", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidPick", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemPickVoid, 1), new Object[]{"III", " S ", " S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidAxe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemAxeVoid, 1), new Object[]{"II", "SI", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidHoe", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemHoeVoid, 1), new Object[]{"II", "S ", "S ", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("VoidSword", ConfigRecipes.oreDictRecipe(new ItemStack(ConfigItems.itemSwordVoid, 1), new Object[]{"I", "I", "S", Character.valueOf('I'), "ingotVoid", Character.valueOf('S'), "stickWood"}));
        ConfigResearch.recipes.put("TallowCandle", GameRegistry.addShapedRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCandle, 3, 0), (Object[])new Object[]{" S ", " T ", " T ", Character.valueOf('S'), Items.string, Character.valueOf('T'), new ItemStack(ConfigItems.itemResource, 1, 4)}));
        for (a = 1; a < 16; ++a) {
            ConfigRecipes.shapelessOreDictRecipe(new ItemStack(ConfigBlocks.blockCandle, 1, a), new Object[]{ConfigAspects.dyes[15 - a], new ItemStack(ConfigBlocks.blockCandle, 1, 0)});
        }
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ConfigBlocks.blockCandle, 1, 0), (Object[])new Object[]{new ItemStack(Items.dye, 1, 15), new ItemStack(ConfigBlocks.blockCandle, 1, Short.MAX_VALUE)});
    }

    private static void initializeSmelting() {
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigBlocks.blockCustomOre, 1, 0), new ItemStack(ConfigItems.itemResource, 1, 3), 1.0f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigBlocks.blockCustomOre, 1, 7), new ItemStack(ConfigItems.itemResource, 1, 6), 1.0f);
        GameRegistry.addSmelting((Block)ConfigBlocks.blockMagicalLog, (ItemStack)new ItemStack(Items.coal, 1, 1), (float)0.5f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(Items.iron_ingot, 2, 0), 1.0f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemResource, 2, 3), 1.0f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.gold_ingot, 2, 0), 1.0f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigItems.itemShard, 1, 6), new ItemStack(ConfigItems.itemResource, 1, 14), 1.0f);
        FurnaceRecipes.smelting().func_151394_a(new ItemStack(ConfigItems.itemResource, 1, 18), new ItemStack(Items.gold_nugget), 0.0f);
        ThaumcraftApi.addSmeltingBonus("oreGold", new ItemStack(Items.gold_nugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreIron", new ItemStack(ConfigItems.itemNugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus("oreCinnabar", new ItemStack(ConfigItems.itemNugget, 0, 5));
        ThaumcraftApi.addSmeltingBonus("oreCopper", new ItemStack(ConfigItems.itemNugget, 0, 1));
        ThaumcraftApi.addSmeltingBonus("oreTin", new ItemStack(ConfigItems.itemNugget, 0, 2));
        ThaumcraftApi.addSmeltingBonus("oreSilver", new ItemStack(ConfigItems.itemNugget, 0, 3));
        ThaumcraftApi.addSmeltingBonus("oreLead", new ItemStack(ConfigItems.itemNugget, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 31), new ItemStack(Items.gold_nugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 16), new ItemStack(ConfigItems.itemNugget, 0, 0));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 21), new ItemStack(ConfigItems.itemNugget, 0, 5));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 17), new ItemStack(ConfigItems.itemNugget, 0, 1));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 18), new ItemStack(ConfigItems.itemNugget, 0, 2));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 19), new ItemStack(ConfigItems.itemNugget, 0, 3));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(ConfigItems.itemNugget, 1, 20), new ItemStack(ConfigItems.itemNugget, 0, 4));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.chicken), new ItemStack(ConfigItems.itemNuggetChicken));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.beef), new ItemStack(ConfigItems.itemNuggetBeef));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.porkchop), new ItemStack(ConfigItems.itemNuggetPork));
        ThaumcraftApi.addSmeltingBonus(new ItemStack(Items.fish, 1, Short.MAX_VALUE), new ItemStack(ConfigItems.itemNuggetFish));
    }

    static IRecipe oreDictRecipe(ItemStack res, Object[] params) {
        ShapedOreRecipe rec = new ShapedOreRecipe(res, params);
        CraftingManager.getInstance().getRecipeList().add(rec);
        return rec;
    }

    static IRecipe shapelessOreDictRecipe(ItemStack res, Object[] params) {
        ShapelessOreRecipe rec = new ShapelessOreRecipe(res, params);
        CraftingManager.getInstance().getRecipeList().add(rec);
        return rec;
    }

    static IRecipe shapelessNBTOreRecipe(ItemStack res, Object[] params) {
        ShapelessNBTOreRecipe rec = new ShapelessNBTOreRecipe(res, params);
        CraftingManager.getInstance().getRecipeList().add(rec);
        return rec;
    }
}

