/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.InventoryUtils;

public class EntityAspectOrb
extends Entity
implements IEntityAdditionalSpawnData {
    public int orbAge = 0;
    public int orbMaxAge = 150;
    public int orbCooldown;
    private int orbHealth = 5;
    private Aspect aspect;
    private int aspectValue;
    private EntityPlayer closestPlayer;

    public boolean isInRangeToRenderDist(double par1) {
        double d1 = 0.5;
        return par1 < (d1 *= 64.0 * this.renderDistanceWeight) * d1;
    }

    public EntityAspectOrb(World par1World, double par2, double par4, double par6, Aspect aspect, int par8) {
        super(par1World);
        this.setSize(0.125f, 0.125f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(par2, par4, par6);
        this.rotationYaw = (float)(Math.random() * 360.0);
        this.motionX = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.motionY = (float)(Math.random() * 0.2) * 2.0f;
        this.motionZ = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.aspectValue = par8;
        this.setAspect(aspect);
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public EntityAspectOrb(World par1World) {
        super(par1World);
        this.setSize(0.125f, 0.125f);
        this.yOffset = this.height / 2.0f;
    }

    protected void entityInit() {
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrightnessForRender(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.getBrightnessForRender(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public void onUpdate() {
        double d3;
        double d2;
        double d1;
        double d4;
        double d5;
        List targets;
        super.onUpdate();
        if (this.orbCooldown > 0) {
            --this.orbCooldown;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)0.03f;
        if (this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY), MathHelper.floor_double((double)this.posZ)).getMaterial() == Material.lava) {
            this.motionY = 0.2f;
            this.motionX = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.motionZ = (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f;
            this.playSound("random.fizz", 0.4f, 2.0f + this.rand.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.posX, (this.boundingBox.minY + this.boundingBox.maxY) / 2.0, this.posZ);
        double d0 = 8.0;
        if (this.ticksExisted % 5 == 0 && this.closestPlayer == null && (targets = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)this.posX, (double)this.posY, (double)this.posZ, (double)this.posX, (double)this.posY, (double)this.posZ).expand(d0, d0, d0))).size() > 0) {
            double distance = Double.MAX_VALUE;
            for (Entity t : targets) {
                double d = ((EntityPlayer)t).getDistanceSqToEntity((Entity)this);
                if (!(d < distance) || InventoryUtils.isWandInHotbarWithRoom(this.getAspect(), this.aspectValue, (EntityPlayer)t) < 0) continue;
                distance = d;
                this.closestPlayer = (EntityPlayer)t;
            }
        }
        if (this.closestPlayer != null && (d5 = 1.0 - (d4 = Math.sqrt((d1 = (this.closestPlayer.posX - this.posX) / d0) * d1 + (d2 = (this.closestPlayer.posY + (double)this.closestPlayer.getEyeHeight() - this.posY) / d0) * d2 + (d3 = (this.closestPlayer.posZ - this.posZ) / d0) * d3))) > 0.0) {
            d5 *= d5;
            this.motionX += d1 / d4 * d5 * 0.1;
            this.motionY += d2 / d4 * d5 * 0.1;
            this.motionZ += d3 / d4 * d5 * 0.1;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        float f = 0.98f;
        if (this.onGround) {
            f = 0.58800006f;
            Block i = this.worldObj.getBlock(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ));
            if (!i.isAir((IBlockAccess)this.worldObj, MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.boundingBox.minY) - 1, MathHelper.floor_double((double)this.posZ))) {
                f = i.slipperiness * 0.98f;
            }
        }
        this.motionX *= (double)f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)f;
        if (this.onGround) {
            this.motionY *= (double)-0.9f;
        }
        ++this.orbAge;
        if (this.orbAge >= this.orbMaxAge) {
            this.setDead();
        }
    }

    public boolean handleWaterMovement() {
        return this.worldObj.handleMaterialAcceleration(this.boundingBox, Material.water, (Entity)this);
    }

    protected void dealFireDamage(int par1) {
        this.attackEntityFrom(DamageSource.inFire, par1);
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, float par2) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        this.setBeenAttacked();
        this.orbHealth = (int)((float)this.orbHealth - par2);
        if (this.orbHealth <= 0) {
            this.setDead();
        }
        return false;
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("Health", (short)((byte)this.orbHealth));
        par1NBTTagCompound.setShort("Age", (short)this.orbAge);
        par1NBTTagCompound.setShort("Value", (short)this.aspectValue);
        par1NBTTagCompound.setString("Aspect", this.getAspect().getTag());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.orbHealth = par1NBTTagCompound.getShort("Health") & 0xFF;
        this.orbAge = par1NBTTagCompound.getShort("Age");
        this.aspectValue = par1NBTTagCompound.getShort("Value");
        this.setAspect(Aspect.getAspect(par1NBTTagCompound.getString("Aspect")));
    }

    public void onCollideWithPlayer(EntityPlayer par1EntityPlayer) {
        if (!this.worldObj.isRemote) {
            int slot = InventoryUtils.isWandInHotbarWithRoom(this.getAspect(), this.aspectValue, par1EntityPlayer);
            if (this.orbCooldown == 0 && par1EntityPlayer.xpCooldown == 0 && this.getAspect().isPrimal() && slot >= 0) {
                ItemWandCasting wand = (ItemWandCasting)par1EntityPlayer.inventory.mainInventory[slot].getItem();
                wand.addVis(par1EntityPlayer.inventory.mainInventory[slot], this.getAspect(), this.aspectValue, true);
                par1EntityPlayer.xpCooldown = 2;
                this.playSound("random.orb", 0.1f, 0.5f * ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.8f));
                this.setDead();
            }
        }
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.getAspect() != null) {
            data.writeShort(this.getAspect().getTag().length());
            for (char c : this.getAspect().getTag().toCharArray()) {
                data.writeChar((int)c);
            }
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            int l = data.readShort();
            StringBuilder s = new StringBuilder();
            for (int var4 = 0; var4 < l; ++var4) {
                s.append(data.readChar());
            }
            this.setAspect(Aspect.getAspect(s.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAspectValue() {
        return this.aspectValue;
    }

    public boolean canAttackWithItem() {
        return false;
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
    }
}

