/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTaint;
import thaumcraft.common.config.ConfigBlocks;

public class EntityFallingTaint
extends Entity
implements IEntityAdditionalSpawnData {
    public Block block;
    public int metadata;
    public int oldX;
    public int oldY;
    public int oldZ;
    public int fallTime = 0;
    private int fallHurtMax = 40;
    private float fallHurtAmount = 2.0f;

    public EntityFallingTaint(World par1World) {
        super(par1World);
    }

    public EntityFallingTaint(World par1World, double par2, double par4, double par6, Block par8, int par9, int ox, int oy, int oz) {
        super(par1World);
        this.block = par8;
        this.metadata = par9;
        this.preventEntitySpawning = true;
        this.setSize(0.98f, 0.98f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(par2, par4, par6);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = par2;
        this.prevPosY = par4;
        this.prevPosZ = par6;
        this.oldX = ox;
        this.oldY = oy;
        this.oldZ = oz;
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    protected void entityInit() {
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(Block.getIdFromBlock((Block)this.block));
        data.writeByte(this.metadata);
    }

    public void readSpawnData(ByteBuf data) {
        try {
            this.block = Block.getBlockById((int)data.readInt());
            this.metadata = data.readByte();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canBeCollidedWith() {
        return !this.isDead;
    }

    public void onUpdate() {
        block5: {
            block6: {
                int j;
                block7: {
                    block4: {
                        if (this.block != null && this.block != Blocks.air) break block4;
                        this.setDead();
                        break block5;
                    }
                    this.prevPosX = this.posX;
                    this.prevPosY = this.posY;
                    this.prevPosZ = this.posZ;
                    ++this.fallTime;
                    this.motionY -= (double)0.04f;
                    this.moveEntity(this.motionX, this.motionY, this.motionZ);
                    this.motionX *= (double)0.98f;
                    this.motionY *= (double)0.98f;
                    this.motionZ *= (double)0.98f;
                    if (this.worldObj.isRemote) break block6;
                    int i = MathHelper.floor_double((double)this.posX);
                    j = MathHelper.floor_double((double)this.posY);
                    int k = MathHelper.floor_double((double)this.posZ);
                    if (this.fallTime == 1) {
                        if (this.worldObj.getBlock(this.oldX, this.oldY, this.oldZ) != this.block) {
                            this.setDead();
                            return;
                        }
                        this.worldObj.setBlockToAir(this.oldX, this.oldY, this.oldZ);
                    }
                    if (!this.onGround && (this.worldObj.getBlock(i, j - 1, k) != ConfigBlocks.blockFluxGoo || this.worldObj.getBlockMetadata(i, j - 1, k) < 4)) break block7;
                    this.motionX *= (double)0.7f;
                    this.motionZ *= (double)0.7f;
                    this.motionY *= -0.5;
                    if (this.worldObj.getBlock(i, j, k) == Blocks.piston || this.worldObj.getBlock(i, j, k) == Blocks.piston_extension || this.worldObj.getBlock(i, j, k) == Blocks.piston_head) break block5;
                    this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:gore", 0.5f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                    this.setDead();
                    if (!this.canPlace(i, j, k) || BlockTaint.canFallBelow(this.worldObj, i, j - 1, k) || !this.worldObj.setBlock(i, j, k, this.block, this.metadata, 3) || !(this.block instanceof BlockTaint)) break block5;
                    ((BlockTaint)this.block).onFinishFalling(this.worldObj, i, j, k, this.metadata);
                    break block5;
                }
                if ((this.fallTime <= 100 || this.worldObj.isRemote || j >= 1 && j <= 256) && this.fallTime <= 600) break block5;
                this.setDead();
                break block5;
            }
            if (this.onGround || this.fallTime == 1) {
                for (int j = 0; j < 10; ++j) {
                    Thaumcraft.proxy.taintLandFX(this);
                }
            }
        }
    }

    private boolean canPlace(int i, int j, int k) {
        return this.worldObj.getBlock(i, j, k) == ConfigBlocks.blockTaintFibres || this.worldObj.getBlock(i, j, k) == ConfigBlocks.blockFluxGoo || this.worldObj.canPlaceEntityOnSide(this.block, i, j, k, true, 1, (Entity)null, (ItemStack)null);
    }

    protected void fall(float par1) {
    }

    protected void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setInteger("TileID", Block.getIdFromBlock((Block)this.block));
        par1NBTTagCompound.setByte("Data", (byte)this.metadata);
        par1NBTTagCompound.setByte("Time", (byte)this.fallTime);
        par1NBTTagCompound.setFloat("FallHurtAmount", this.fallHurtAmount);
        par1NBTTagCompound.setInteger("FallHurtMax", this.fallHurtMax);
        par1NBTTagCompound.setInteger("OldX", this.oldX);
        par1NBTTagCompound.setInteger("OldY", this.oldY);
        par1NBTTagCompound.setInteger("OldZ", this.oldZ);
    }

    protected void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        if (par1NBTTagCompound.hasKey("TileID")) {
            this.block = Block.getBlockById((int)par1NBTTagCompound.getInteger("TileID"));
        }
        this.metadata = par1NBTTagCompound.getByte("Data") & 0xFF;
        this.fallTime = par1NBTTagCompound.getByte("Time") & 0xFF;
        this.oldX = par1NBTTagCompound.getInteger("OldX");
        this.oldY = par1NBTTagCompound.getInteger("OldY");
        this.oldZ = par1NBTTagCompound.getInteger("OldZ");
        if (par1NBTTagCompound.hasKey("HurtEntities")) {
            this.fallHurtAmount = par1NBTTagCompound.getFloat("FallHurtAmount");
            this.fallHurtMax = par1NBTTagCompound.getInteger("FallHurtMax");
        }
        if (this.block == null) {
            this.block = Blocks.sand;
        }
    }

    public void addEntityCrashInfo(CrashReportCategory par1CrashReportCategory) {
        super.addEntityCrashInfo(par1CrashReportCategory);
        par1CrashReportCategory.addCrashSection("Immitating block ID", (Object)Block.getIdFromBlock((Block)this.block));
        par1CrashReportCategory.addCrashSection("Immitating block data", (Object)this.metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public World getWorld() {
        return this.worldObj;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderOnFire() {
        return false;
    }
}

