/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.EntitySpecialItem;

public class EntityFollowingItem
extends EntitySpecialItem
implements IEntityAdditionalSpawnData {
    double targetX = 0.0;
    double targetY = 0.0;
    double targetZ = 0.0;
    int type = 3;
    public Entity target = null;
    int age = 20;
    public double gravity = 0.04f;

    public EntityFollowingItem(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
        this.setPosition(par2, par4, par6);
        this.setEntityItemStack(par8ItemStack);
        this.rotationYaw = (float)(Math.random() * 360.0);
    }

    public EntityFollowingItem(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack, Entity target, int t) {
        this(par1World, par2, par4, par6, par8ItemStack);
        this.target = target;
        this.targetX = target.posX;
        this.targetY = target.boundingBox.minY + (double)(target.height / 2.0f);
        this.targetZ = target.posZ;
        this.type = t;
        this.noClip = true;
    }

    public EntityFollowingItem(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack, double tx, double ty, double tz) {
        this(par1World, par2, par4, par6, par8ItemStack);
        this.targetX = tx;
        this.targetY = ty;
        this.targetZ = tz;
    }

    public EntityFollowingItem(World par1World) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.yOffset = this.height / 2.0f;
    }

    @Override
    public void onUpdate() {
        if (this.target != null) {
            this.targetX = this.target.posX;
            this.targetY = this.target.boundingBox.minY + (double)(this.target.height / 2.0f);
            this.targetZ = this.target.posZ;
        }
        if (this.targetX != 0.0 || this.targetY != 0.0 || this.targetZ != 0.0) {
            double distance;
            float xd = (float)(this.targetX - this.posX);
            float yd = (float)(this.targetY - this.posY);
            float zd = (float)(this.targetZ - this.posZ);
            if (this.age > 1) {
                --this.age;
            }
            if ((distance = (double)MathHelper.sqrt_float((float)(xd * xd + yd * yd + zd * zd))) > 0.5) {
                this.motionX = (double)xd / (distance *= (double)this.age);
                this.motionY = (double)yd / distance;
                this.motionZ = (double)zd / distance;
            } else {
                this.motionX *= (double)0.1f;
                this.motionY *= (double)0.1f;
                this.motionZ *= (double)0.1f;
                this.targetX = 0.0;
                this.targetY = 0.0;
                this.targetZ = 0.0;
                this.target = null;
                this.noClip = false;
            }
            if (this.worldObj.isRemote) {
                if (this.type != 10) {
                    Thaumcraft.proxy.sparkle((float)this.prevPosX + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, (float)this.prevPosY + this.yOffset + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, (float)this.prevPosZ + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, this.type);
                } else {
                    Thaumcraft.proxy.crucibleBubble(this.worldObj, (float)this.prevPosX + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, (float)this.prevPosY + this.yOffset + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, (float)this.prevPosZ + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.125f, 0.33f, 0.33f, 1.0f);
                }
            }
        } else {
            this.motionY -= this.gravity;
        }
        super.onUpdate();
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setShort("type", (short)this.type);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.type = par1NBTTagCompound.getShort("type");
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.target != null) {
            data.writeInt(this.target == null ? -1 : this.target.getEntityId());
            data.writeDouble(this.targetX);
            data.writeDouble(this.targetY);
            data.writeDouble(this.targetZ);
            data.writeByte(this.type);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            int ent = data.readInt();
            if (ent > -1) {
                this.target = this.worldObj.getEntityByID(ent);
            }
            this.targetX = data.readDouble();
            this.targetY = data.readDouble();
            this.targetZ = data.readDouble();
            this.type = data.readByte();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

