/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.fluid;

import java.util.Iterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileJarFillable;

public class AIEssentiaEmpty
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int jarX;
    private int jarY;
    private int jarZ;
    private ForgeDirection markerOrientation;
    private World theWorld;

    public AIEssentiaEmpty(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        ChunkCoordinates home = this.theGolem.getHomePosition();
        if (!this.theGolem.getNavigator().noPath() || this.theGolem.essentia == null || this.theGolem.essentiaAmount == 0) {
            return false;
        }
        ChunkCoordinates jarloc = GolemHelper.findJarWithRoom(this.theGolem);
        if (jarloc == null) {
            return false;
        }
        if (this.theGolem.getDistanceSq((double)jarloc.posX + 0.5, (double)jarloc.posY + 0.5, (double)jarloc.posZ + 0.5) > 4.0) {
            return false;
        }
        this.jarX = jarloc.posX;
        this.jarY = jarloc.posY;
        this.jarZ = jarloc.posZ;
        return true;
    }

    public boolean continueExecuting() {
        return false;
    }

    public void startExecuting() {
        block6: {
            TileEntity tile;
            block7: {
                int added;
                block5: {
                    tile = this.theWorld.getTileEntity(this.jarX, this.jarY, this.jarZ);
                    if (tile == null || !(tile instanceof TileJarFillable)) break block5;
                    TileJarFillable jar = (TileJarFillable)tile;
                    this.theGolem.essentiaAmount = jar.addToContainer(this.theGolem.essentia, this.theGolem.essentiaAmount);
                    if (this.theGolem.essentiaAmount == 0) {
                        this.theGolem.essentia = null;
                    }
                    this.theWorld.playSoundAtEntity((Entity)this.theGolem, "game.neutral.swim", 0.2f, 1.0f + (this.theWorld.rand.nextFloat() - this.theWorld.rand.nextFloat()) * 0.3f);
                    this.theGolem.updateCarried();
                    this.theWorld.markBlockForUpdate(this.jarX, this.jarY, this.jarZ);
                    break block6;
                }
                if (tile == null || !(tile instanceof TileEssentiaReservoir)) break block7;
                TileEssentiaReservoir trans = (TileEssentiaReservoir)tile;
                if (trans.getSuctionAmount(trans.facing) <= 0 || trans.getSuctionType(trans.facing) != null && trans.getSuctionType(trans.facing) != this.theGolem.essentia || (added = trans.addEssentia(this.theGolem.essentia, this.theGolem.essentiaAmount, trans.facing)) <= 0) break block6;
                this.theGolem.essentiaAmount -= added;
                if (this.theGolem.essentiaAmount == 0) {
                    this.theGolem.essentia = null;
                }
                this.theWorld.playSoundAtEntity((Entity)this.theGolem, "game.neutral.swim", 0.2f, 1.0f + (this.theWorld.rand.nextFloat() - this.theWorld.rand.nextFloat()) * 0.3f);
                this.theGolem.updateCarried();
                this.theWorld.markBlockForUpdate(this.jarX, this.jarY, this.jarZ);
                break block6;
            }
            if (tile != null && tile instanceof IEssentiaTransport) {
                Iterator<Integer> i$ = GolemHelper.getMarkedSides(this.theGolem, tile, (byte)-1).iterator();
                while (i$.hasNext()) {
                    int added;
                    IEssentiaTransport trans = (IEssentiaTransport)tile;
                    Integer side = i$.next();
                    if (!trans.canInputFrom(ForgeDirection.getOrientation((int)side)) || trans.getSuctionAmount(ForgeDirection.getOrientation((int)side)) <= 0 || trans.getSuctionType(ForgeDirection.getOrientation((int)side)) != null && trans.getSuctionType(ForgeDirection.getOrientation((int)side)) != this.theGolem.essentia || (added = trans.addEssentia(this.theGolem.essentia, this.theGolem.essentiaAmount, ForgeDirection.getOrientation((int)side))) <= 0) continue;
                    this.theGolem.essentiaAmount -= added;
                    if (this.theGolem.essentiaAmount == 0) {
                        this.theGolem.essentia = null;
                    }
                    this.theWorld.playSoundAtEntity((Entity)this.theGolem, "game.neutral.swim", 0.2f, 1.0f + (this.theWorld.rand.nextFloat() - this.theWorld.rand.nextFloat()) * 0.3f);
                    this.theGolem.updateCarried();
                    this.theWorld.markBlockForUpdate(this.jarX, this.jarY, this.jarZ);
                    break;
                }
            }
        }
    }
}

