/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.interact;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.Utils;

public class AIHarvestLogs
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int xx;
    private int yy;
    private int zz;
    private float movementSpeed;
    private float distance;
    private World theWorld;
    private Block block = Blocks.air;
    private int blockMd = 0;
    private int delay = -1;
    private int maxDelay = 1;
    private int mod = 1;
    FakePlayer player;
    private int count = 0;

    public AIHarvestLogs(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.worldObj;
        this.setMutexBits(3);
        this.distance = MathHelper.ceiling_float_int((float)(this.theGolem.getRange() / 3.0f));
        if (this.theWorld instanceof WorldServer) {
            this.player = FakePlayerFactory.get((WorldServer)((WorldServer)this.theWorld), (GameProfile)new GameProfile((UUID)null, "FakeThaumcraftGolem"));
        }
    }

    public boolean shouldExecute() {
        if (this.delay >= 0 || this.theGolem.ticksExisted % Config.golemDelay > 0 || !this.theGolem.getNavigator().noPath()) {
            return false;
        }
        Vec3 var1 = this.findLog();
        if (var1 == null) {
            return false;
        }
        this.xx = (int)var1.xCoord;
        this.yy = (int)var1.yCoord;
        this.zz = (int)var1.zCoord;
        this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
        this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
        return true;
    }

    public boolean continueExecuting() {
        return this.theWorld.getBlock(this.xx, this.yy, this.zz) == this.block && this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz) == this.blockMd && this.count-- > 0 && (this.delay > 0 || Utils.isWoodLog((IBlockAccess)this.theWorld, this.xx, this.yy, this.zz) || !this.theGolem.getNavigator().noPath());
    }

    public void updateTask() {
        double dist = this.theGolem.getDistanceSq((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5);
        this.theGolem.getLookHelper().setLookPosition((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, 30.0f, 30.0f);
        if (dist <= 4.0) {
            if (this.delay < 0) {
                this.maxDelay = this.delay = (int)Math.max(5.0f, (20.0f - (float)this.theGolem.getGolemStrength() * 3.0f) * this.block.getBlockHardness(this.theWorld, this.xx, this.yy, this.zz));
                this.mod = this.delay / Math.round((float)this.delay / 6.0f);
            }
            if (this.delay > 0) {
                if (--this.delay > 0 && this.delay % this.mod == 0 && this.theGolem.getNavigator().noPath()) {
                    this.theGolem.startActionTimer();
                    this.theWorld.playSoundEffect((double)((float)this.xx + 0.5f), (double)((float)this.yy + 0.5f), (double)((float)this.zz + 0.5f), this.block.stepSound.getBreakSound(), (this.block.stepSound.getVolume() + 0.7f) / 8.0f, this.block.stepSound.getPitch() * 0.5f);
                    BlockUtils.destroyBlockPartially(this.theWorld, this.theGolem.getEntityId(), this.xx, this.yy, this.zz, (int)(9.0f * (1.0f - (float)this.delay / (float)this.maxDelay)));
                }
                if (this.delay == 0) {
                    this.harvest();
                    if (Utils.isWoodLog((IBlockAccess)this.theWorld, this.xx, this.yy, this.zz)) {
                        this.delay = -1;
                        this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
                        this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
                        this.startExecuting();
                    } else {
                        this.checkAdjacent();
                    }
                }
            }
        }
    }

    private void checkAdjacent() {
        for (int x2 = -1; x2 <= 1; ++x2) {
            for (int z2 = -1; z2 <= 1; ++z2) {
                for (int y2 = -1; y2 <= 1; ++y2) {
                    Vec3 var1;
                    int x = this.xx + x2;
                    int y = this.yy + y2;
                    int z = this.zz + z2;
                    if ((float)Math.abs(this.theGolem.getHomePosition().posX - x) > this.distance || (float)Math.abs(this.theGolem.getHomePosition().posY - y) > this.distance || (float)Math.abs(this.theGolem.getHomePosition().posZ - z) > this.distance || !Utils.isWoodLog((IBlockAccess)this.theWorld, x, y, z) || (var1 = Vec3.createVectorHelper((double)x, (double)y, (double)z)) == null) continue;
                    this.xx = (int)var1.xCoord;
                    this.yy = (int)var1.yCoord;
                    this.zz = (int)var1.zCoord;
                    this.block = this.theWorld.getBlock(this.xx, this.yy, this.zz);
                    this.blockMd = this.theWorld.getBlockMetadata(this.xx, this.yy, this.zz);
                    this.delay = -1;
                    this.startExecuting();
                    return;
                }
            }
        }
    }

    public void resetTask() {
        BlockUtils.destroyBlockPartially(this.theWorld, this.theGolem.getEntityId(), this.xx, this.yy, this.zz, -1);
        this.delay = -1;
    }

    public void startExecuting() {
        this.count = 200;
        this.theGolem.getNavigator().tryMoveToXYZ((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, (double)this.theGolem.getAIMoveSpeed());
    }

    void harvest() {
        this.count = 200;
        this.theWorld.playAuxSFX(2001, this.xx, this.yy, this.zz, Block.getIdFromBlock((Block)this.block) + (this.blockMd << 12));
        BlockUtils.breakFurthestBlock(this.theWorld, this.xx, this.yy, this.zz, this.block, (EntityPlayer)this.player);
        this.theGolem.startActionTimer();
    }

    private Vec3 findLog() {
        Random rand = this.theGolem.getRNG();
        int var2 = 0;
        while ((float)var2 < this.distance * 4.0f) {
            int z;
            int y;
            int x = (int)((float)(this.theGolem.getHomePosition().posX + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance);
            if (Utils.isWoodLog((IBlockAccess)this.theWorld, x, y = (int)((float)(this.theGolem.getHomePosition().posY + rand.nextInt((int)(1.0f + this.distance))) - this.distance / 2.0f), z = (int)((float)(this.theGolem.getHomePosition().posZ + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance))) {
                Vec3 v = Vec3.createVectorHelper((double)x, (double)y, (double)z);
                double dist = this.theGolem.getDistanceSq((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                int yy = 1;
                while (Utils.isWoodLog((IBlockAccess)this.theWorld, x, y - yy, z) && this.theGolem.getDistanceSq((double)x + 0.5, (double)(y - yy) + 0.5, (double)z + 0.5) < dist) {
                    v = Vec3.createVectorHelper((double)x, (double)(y - yy), (double)z);
                    dist = this.theGolem.getDistanceSq((double)x + 0.5, (double)(y - yy) + 0.5, (double)z + 0.5);
                    ++yy;
                }
                return v;
            }
            ++var2;
        }
        return null;
    }
}

