/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.ChunkCoordinates;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;

public class AIEmptyDrop
extends EntityAIBase {
    private EntityGolemBase theGolem;
    int count = 0;

    public AIEmptyDrop(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.theGolem.itemCarried == null || !this.theGolem.getNavigator().noPath()) {
            return false;
        }
        ChunkCoordinates home = this.theGolem.getHomePosition();
        ArrayList<Byte> matchingColors = this.theGolem.getColorsMatching(this.theGolem.itemCarried);
        for (byte color : matchingColors) {
            ArrayList<ChunkCoordinates> mc = GolemHelper.getMarkedBlocksAdjacentToGolem(this.theGolem.worldObj, this.theGolem, color);
            for (ChunkCoordinates cc : mc) {
                if (cc == home) continue;
                return true;
            }
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.count > 0 && this.shouldExecute();
    }

    public void resetTask() {
    }

    public void updateTask() {
        --this.count;
        super.updateTask();
    }

    public void startExecuting() {
        this.count = 200;
        ChunkCoordinates home = this.theGolem.getHomePosition();
        ArrayList<Byte> matchingColors = this.theGolem.getColorsMatching(this.theGolem.itemCarried);
        block0: for (byte color : matchingColors) {
            ArrayList<ChunkCoordinates> mc = GolemHelper.getMarkedBlocksAdjacentToGolem(this.theGolem.worldObj, this.theGolem, color);
            for (ChunkCoordinates cc : mc) {
                EntityItem item;
                if (cc == home || (item = new EntityItem(this.theGolem.worldObj, this.theGolem.posX, this.theGolem.posY + (double)(this.theGolem.height / 2.0f), this.theGolem.posZ, this.theGolem.itemCarried.copy())) == null) continue;
                double distance = this.theGolem.getDistance((double)cc.posX + 0.5, (double)cc.posY + 0.5, (double)cc.posZ + 0.5);
                item.motionX = ((double)cc.posX + 0.5 - this.theGolem.posX) * (distance / 3.0);
                item.motionY = 0.1 + ((double)cc.posY + 0.5 - (this.theGolem.posY + (double)(this.theGolem.height / 2.0f))) * (distance / 3.0);
                item.motionZ = ((double)cc.posZ + 0.5 - this.theGolem.posZ) * (distance / 3.0);
                item.delayBeforeCanPickup = 10;
                this.theGolem.worldObj.spawnEntityInWorld((Entity)item);
                this.theGolem.itemCarried = null;
                this.theGolem.startActionTimer();
                break block0;
            }
        }
        this.theGolem.updateCarried();
    }
}

