/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.inventory;

import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;
import thaumcraft.common.entities.golems.Marker;

public class AIEmptyGoto
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private double movePosX;
    private double movePosY;
    private double movePosZ;
    private ChunkCoordinates dest = null;
    int count = 0;
    int prevX = 0;
    int prevY = 0;
    int prevZ = 0;

    public AIEmptyGoto(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.theGolem.itemCarried == null || this.theGolem.ticksExisted % Config.golemDelay > 0) {
            return false;
        }
        ArrayList<Byte> matchingColors = this.theGolem.getColorsMatching(this.theGolem.itemCarried);
        for (byte color : matchingColors) {
            ArrayList<IInventory> results = GolemHelper.getContainersWithRoom(this.theGolem.worldObj, this.theGolem, color);
            if (results.size() == 0) continue;
            ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
            ChunkCoordinates home = this.theGolem.getHomePosition();
            int cX = home.posX - facing.offsetX;
            int cY = home.posY - facing.offsetY;
            int cZ = home.posZ - facing.offsetZ;
            int tX = 0;
            int tY = 0;
            int tZ = 0;
            double range = Double.MAX_VALUE;
            float dmod = this.theGolem.getRange();
            for (IInventory te : results) {
                double distance = this.theGolem.getDistanceSq((double)((TileEntity)te).xCoord + 0.5, (double)((TileEntity)te).yCoord + 0.5, (double)((TileEntity)te).zCoord + 0.5);
                if (!(distance < range) || !(distance <= (double)(dmod * dmod)) || ((TileEntity)te).xCoord == cX && ((TileEntity)te).yCoord == cY && ((TileEntity)te).zCoord == cZ) continue;
                range = distance;
                tX = ((TileEntity)te).xCoord;
                tY = ((TileEntity)te).yCoord;
                tZ = ((TileEntity)te).zCoord;
                this.dest = new ChunkCoordinates(tX, tY, tZ);
            }
            if (this.dest == null) continue;
            this.movePosX = tX;
            this.movePosY = tY;
            this.movePosZ = tZ;
            return true;
        }
        for (byte color : matchingColors) {
            ArrayList<Marker> markers = this.theGolem.getMarkers();
            for (Marker marker : markers) {
                if (marker.color != color && color != -1 || this.theGolem.worldObj.getTileEntity(marker.x, marker.y, marker.z) != null && this.theGolem.worldObj.getTileEntity(marker.x, marker.y, marker.z) instanceof IInventory) continue;
                this.movePosX = marker.x;
                this.movePosY = marker.y;
                this.movePosZ = marker.z;
                return true;
            }
        }
        return false;
    }

    public boolean continueExecuting() {
        return this.count > 0 && !this.theGolem.getNavigator().noPath();
    }

    public void updateTask() {
        Vec3 var2;
        --this.count;
        if (this.count == 0 && this.prevX == MathHelper.floor_double((double)this.theGolem.posX) && this.prevY == MathHelper.floor_double((double)this.theGolem.posY) && this.prevZ == MathHelper.floor_double((double)this.theGolem.posZ) && (var2 = RandomPositionGenerator.findRandomTarget((EntityCreature)this.theGolem, (int)2, (int)1)) != null) {
            this.count = 20;
            this.theGolem.getNavigator().tryMoveToXYZ(var2.xCoord, var2.yCoord, var2.zCoord, (double)this.theGolem.getAIMoveSpeed());
        }
        super.updateTask();
    }

    public void resetTask() {
        this.count = 0;
        this.dest = null;
    }

    public void startExecuting() {
        this.count = 200;
        this.prevX = MathHelper.floor_double((double)this.theGolem.posX);
        this.prevY = MathHelper.floor_double((double)this.theGolem.posY);
        this.prevZ = MathHelper.floor_double((double)this.theGolem.posZ);
        this.theGolem.getNavigator().tryMoveToXYZ(this.movePosX, this.movePosY, this.movePosZ, (double)this.theGolem.getAIMoveSpeed());
    }
}

