/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.pech;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathPoint;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.monster.EntityPech;

public class AIPechItemEntityGoto
extends EntityAIBase {
    private EntityPech pech;
    private Entity targetEntity;
    float maxTargetDistance = 16.0f;
    private int count;
    private int failedPathFindingPenalty;

    public AIPechItemEntityGoto(EntityPech par1EntityCreature) {
        this.pech = par1EntityCreature;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        if (this.pech.ticksExisted % Config.golemDelay > 0) {
            return false;
        }
        if (--this.count > 0) {
            return false;
        }
        double range = Double.MAX_VALUE;
        List targets = this.pech.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.pech, this.pech.boundingBox.expand((double)this.maxTargetDistance, (double)this.maxTargetDistance, (double)this.maxTargetDistance));
        if (targets.size() == 0) {
            return false;
        }
        for (Entity e : targets) {
            double distance;
            if (!(e instanceof EntityItem) || !this.pech.canPickup(((EntityItem)e).getEntityItem())) continue;
            NBTTagCompound itemData = ((EntityItem)e).getEntityData();
            String username = ((EntityItem)e).func_145800_j();
            if (username != null && username.equals("PechDrop") || !((distance = e.getDistanceSq(this.pech.posX, this.pech.posY, this.pech.posZ)) < range) || !(distance <= (double)(this.maxTargetDistance * this.maxTargetDistance))) continue;
            range = distance;
            this.targetEntity = e;
        }
        return this.targetEntity != null;
    }

    public boolean continueExecuting() {
        return this.targetEntity == null ? false : (!this.targetEntity.isEntityAlive() ? false : !this.pech.getNavigator().noPath() && this.targetEntity.getDistanceSqToEntity((Entity)this.pech) < (double)(this.maxTargetDistance * this.maxTargetDistance));
    }

    public void resetTask() {
        this.targetEntity = null;
    }

    public void startExecuting() {
        this.pech.getNavigator().setPath(this.pech.getNavigator().getPathToEntityLiving(this.targetEntity), this.pech.getEntityAttribute(SharedMonsterAttributes.movementSpeed).getAttributeValue() * 1.5);
        this.count = 0;
    }

    public void updateTask() {
        double distance;
        this.pech.getLookHelper().setLookPositionWithEntity(this.targetEntity, 30.0f, 30.0f);
        if (this.pech.getEntitySenses().canSee(this.targetEntity) && --this.count <= 0) {
            PathPoint finalPathPoint;
            this.count = this.failedPathFindingPenalty + 4 + this.pech.getRNG().nextInt(4);
            this.pech.getNavigator().tryMoveToEntityLiving(this.targetEntity, this.pech.getEntityAttribute(SharedMonsterAttributes.movementSpeed).getAttributeValue() * 1.5);
            this.failedPathFindingPenalty = this.pech.getNavigator().getPath() != null ? ((finalPathPoint = this.pech.getNavigator().getPath().getFinalPathPoint()) != null && this.targetEntity.getDistanceSq((double)finalPathPoint.xCoord, (double)finalPathPoint.yCoord, (double)finalPathPoint.zCoord) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
        }
        if ((distance = this.pech.getDistanceSq(this.targetEntity.posX, this.targetEntity.boundingBox.minY, this.targetEntity.posZ)) <= 1.5) {
            this.count = 0;
            int am = ((EntityItem)this.targetEntity).getEntityItem().stackSize;
            ItemStack is = this.pech.pickupItem(((EntityItem)this.targetEntity).getEntityItem());
            if (is != null && is.stackSize > 0) {
                ((EntityItem)this.targetEntity).setEntityItemStack(is);
            } else {
                this.targetEntity.setDead();
            }
            if (is == null || is.stackSize != am) {
                this.targetEntity.worldObj.playSoundAtEntity(this.targetEntity, "random.pop", 0.2f, ((this.targetEntity.worldObj.rand.nextFloat() - this.targetEntity.worldObj.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }
}

