/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.golems;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.Level;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.InventoryMob;
import thaumcraft.common.entities.ai.combat.AIAvoidCreeperSwell;
import thaumcraft.common.entities.ai.combat.AIDartAttack;
import thaumcraft.common.entities.ai.combat.AIGolemAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AIHurtByTarget;
import thaumcraft.common.entities.ai.combat.AINearestAttackableTarget;
import thaumcraft.common.entities.ai.combat.AINearestButcherTarget;
import thaumcraft.common.entities.ai.fluid.AIEssentiaEmpty;
import thaumcraft.common.entities.ai.fluid.AIEssentiaGather;
import thaumcraft.common.entities.ai.fluid.AIEssentiaGoto;
import thaumcraft.common.entities.ai.fluid.AILiquidEmpty;
import thaumcraft.common.entities.ai.fluid.AILiquidGather;
import thaumcraft.common.entities.ai.fluid.AILiquidGoto;
import thaumcraft.common.entities.ai.interact.AIFish;
import thaumcraft.common.entities.ai.interact.AIHarvestCrops;
import thaumcraft.common.entities.ai.interact.AIHarvestLogs;
import thaumcraft.common.entities.ai.interact.AIUseItem;
import thaumcraft.common.entities.ai.inventory.AIEmptyDrop;
import thaumcraft.common.entities.ai.inventory.AIEmptyGoto;
import thaumcraft.common.entities.ai.inventory.AIEmptyPlace;
import thaumcraft.common.entities.ai.inventory.AIFillGoto;
import thaumcraft.common.entities.ai.inventory.AIFillTake;
import thaumcraft.common.entities.ai.inventory.AIHomeDrop;
import thaumcraft.common.entities.ai.inventory.AIHomePlace;
import thaumcraft.common.entities.ai.inventory.AIHomeReplace;
import thaumcraft.common.entities.ai.inventory.AIHomeTake;
import thaumcraft.common.entities.ai.inventory.AIHomeTakeSorting;
import thaumcraft.common.entities.ai.inventory.AIItemPickup;
import thaumcraft.common.entities.ai.inventory.AISortingGoto;
import thaumcraft.common.entities.ai.inventory.AISortingPlace;
import thaumcraft.common.entities.ai.misc.AIOpenDoor;
import thaumcraft.common.entities.ai.misc.AIReturnHome;
import thaumcraft.common.entities.golems.EnumGolemType;
import thaumcraft.common.entities.golems.ItemGolemCore;
import thaumcraft.common.entities.golems.ItemGolemDecoration;
import thaumcraft.common.entities.golems.Marker;
import thaumcraft.common.entities.projectile.EntityDart;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.utils.Utils;

public class EntityGolemBase
extends EntityGolem
implements IEntityAdditionalSpawnData {
    public InventoryMob inventory = new InventoryMob((Entity)this, 1);
    public ItemStack itemCarried;
    public FluidStack fluidCarried;
    public ItemStack itemWatched = null;
    public Aspect essentia;
    public int essentiaAmount;
    public boolean advanced = false;
    public int homeFacing = 0;
    public boolean paused = false;
    public boolean inactive = false;
    public boolean flag = false;
    public byte[] colors = null;
    public byte[] upgrades = null;
    public String decoration = "";
    public float bootup = -1.0f;
    public EnumGolemType golemType = EnumGolemType.WOOD;
    public int regenTimer = 0;
    protected ArrayList<Marker> markers = new ArrayList();
    boolean pdw = false;
    public int action = 0;
    public int leftArm = 0;
    public int rightArm = 0;
    public int healing = 0;

    public EntityGolemBase(World par1World) {
        super(par1World);
        this.dataWatcher.addObject(30, (Object)((byte)this.getMaxHealth()));
        this.stepHeight = 1.0f;
        this.colors = new byte[]{-1};
        this.upgrades = new byte[]{-1};
        this.setSize(0.4f, 0.95f);
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setEnterDoors(true);
        this.getNavigator().setCanSwim(true);
        this.func_110163_bv();
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getAttributeMap().registerAttribute(SharedMonsterAttributes.attackDamage);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(1.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.6);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(32.0);
    }

    public EntityGolemBase(World par0World, EnumGolemType type, boolean adv) {
        this(par0World);
        this.golemType = type;
        this.advanced = adv;
        this.upgrades = new byte[this.golemType.upgrades + (this.advanced ? 1 : 0)];
        for (int a = 0; a < this.upgrades.length; ++a) {
            this.upgrades[a] = -1;
        }
    }

    public boolean setupGolemInventory() {
        Object core = null;
        if (!ItemGolemCore.hasInventory(this.getCore())) {
            return false;
        }
        if (this.getCore() > -1) {
            int invSize = 0;
            switch (this.getCore()) {
                default: {
                    invSize = 6;
                    invSize += this.getUpgradeAmount(2) * 6;
                    break;
                }
                case 5: {
                    invSize = 1;
                    invSize += this.getUpgradeAmount(2);
                }
                case 3: 
                case 4: 
                case 6: 
            }
            InventoryMob inventory2 = new InventoryMob((Entity)this, invSize);
            for (int a = 0; a < this.inventory.inventory.length; ++a) {
                inventory2.inventory[a] = this.inventory.inventory[a];
            }
            this.inventory = inventory2;
        }
        byte[] oldcolors = this.colors;
        this.colors = new byte[this.inventory.slotCount];
        for (int a = 0; a < this.inventory.slotCount; ++a) {
            this.colors[a] = -1;
            if (a >= oldcolors.length) continue;
            this.colors[a] = oldcolors[a];
        }
        return true;
    }

    public boolean setupGolem() {
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(19, (Object)((byte)this.golemType.ordinal()));
        }
        if (this.getGolemType() == EnumGolemType.STONE || this.getGolemType() == EnumGolemType.IRON || this.getGolemType() == EnumGolemType.THAUMIUM) {
            this.getNavigator().setAvoidsWater(false);
        } else {
            this.getNavigator().setAvoidsWater(true);
        }
        if (this.getGolemType().fireResist) {
            this.isImmuneToFire = true;
        }
        int bonus = 0;
        try {
            bonus = this.getGolemDecoration().contains("H") ? 5 : 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)(this.getGolemType().health + bonus));
        int damage = 2 + this.getGolemStrength() + this.getUpgradeAmount(1);
        try {
            if (this.getGolemDecoration().contains("M")) {
                damage += 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue((double)damage);
        this.tasks.taskEntries.clear();
        if (this.getCore() > -1) {
            this.tasks.addTask(0, (EntityAIBase)new AIAvoidCreeperSwell(this));
        }
        switch (this.getCore()) {
            case 0: {
                this.tasks.addTask(0, (EntityAIBase)new AIHomeReplace(this));
                this.tasks.addTask(1, (EntityAIBase)new AIHomePlace(this));
                this.tasks.addTask(2, (EntityAIBase)new AIHomeDrop(this));
                this.tasks.addTask(3, (EntityAIBase)new AIFillTake(this));
                this.tasks.addTask(4, (EntityAIBase)new AIFillGoto(this));
                break;
            }
            case 1: {
                this.tasks.addTask(0, (EntityAIBase)new AIHomeReplace(this));
                this.tasks.addTask(1, (EntityAIBase)new AIEmptyPlace(this));
                this.tasks.addTask(2, (EntityAIBase)new AIEmptyDrop(this));
                this.tasks.addTask(3, (EntityAIBase)new AIEmptyGoto(this));
                this.tasks.addTask(4, (EntityAIBase)new AIHomeTake(this));
                break;
            }
            case 2: {
                this.tasks.addTask(0, (EntityAIBase)new AIHomeReplace(this));
                this.tasks.addTask(1, (EntityAIBase)new AIHomePlace(this));
                this.tasks.addTask(2, (EntityAIBase)new AIItemPickup(this));
                break;
            }
            case 3: {
                this.tasks.addTask(2, (EntityAIBase)new AIHarvestCrops(this));
                break;
            }
            case 4: {
                if (this.decoration.contains("R")) {
                    this.tasks.addTask(2, (EntityAIBase)new AIDartAttack(this));
                }
                this.tasks.addTask(3, (EntityAIBase)new AIGolemAttackOnCollide(this));
                this.targetTasks.addTask(1, (EntityAIBase)new AIHurtByTarget((EntityCreature)this, false));
                this.targetTasks.addTask(2, (EntityAIBase)new AINearestAttackableTarget(this, 0, true));
                break;
            }
            case 5: {
                this.tasks.addTask(1, (EntityAIBase)new AILiquidEmpty(this));
                this.tasks.addTask(2, (EntityAIBase)new AILiquidGather(this));
                this.tasks.addTask(3, (EntityAIBase)new AILiquidGoto(this));
                break;
            }
            case 6: {
                this.tasks.addTask(1, (EntityAIBase)new AIEssentiaEmpty(this));
                this.tasks.addTask(2, (EntityAIBase)new AIEssentiaGather(this));
                this.tasks.addTask(3, (EntityAIBase)new AIEssentiaGoto(this));
                break;
            }
            case 7: {
                this.tasks.addTask(2, (EntityAIBase)new AIHarvestLogs(this));
                break;
            }
            case 8: {
                this.tasks.addTask(0, (EntityAIBase)new AIHomeReplace(this));
                this.tasks.addTask(0, (EntityAIBase)new AIUseItem(this));
                this.tasks.addTask(4, (EntityAIBase)new AIHomeTake(this));
                break;
            }
            case 9: {
                if (this.decoration.contains("R")) {
                    this.tasks.addTask(2, (EntityAIBase)new AIDartAttack(this));
                }
                this.tasks.addTask(3, (EntityAIBase)new AIGolemAttackOnCollide(this));
                this.targetTasks.addTask(1, (EntityAIBase)new AINearestButcherTarget(this, 0, true));
                break;
            }
            case 10: {
                this.tasks.addTask(0, (EntityAIBase)new AIHomeReplace(this));
                this.tasks.addTask(1, (EntityAIBase)new AISortingPlace(this));
                this.tasks.addTask(3, (EntityAIBase)new AISortingGoto(this));
                this.tasks.addTask(4, (EntityAIBase)new AIHomeTakeSorting(this));
                break;
            }
            case 11: {
                this.tasks.addTask(2, (EntityAIBase)new AIFish(this));
            }
        }
        if (this.getCore() > -1) {
            this.tasks.addTask(5, (EntityAIBase)new AIOpenDoor(this, true));
            this.tasks.addTask(6, (EntityAIBase)new AIReturnHome(this));
            this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
            this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        }
        return true;
    }

    public int getCarryLimit() {
        int base = this.golemType.carry;
        if (this.worldObj.isRemote) {
            base = this.getGolemType().carry;
        }
        base += Math.min(16, Math.max(4, base)) * this.getUpgradeAmount(1);
        return base;
    }

    public int getFluidCarryLimit() {
        return MathHelper.floor_double((double)Math.sqrt(this.getCarryLimit())) * 1000;
    }

    public float getAIMoveSpeed() {
        if (this.paused || this.inactive) {
            return 0.0f;
        }
        float speed = this.golemType.speed * (this.decoration.contains("B") ? 1.1f : 1.0f);
        if (this.decoration.contains("P")) {
            speed *= 0.88f;
        }
        speed *= 1.0f + (float)this.getUpgradeAmount(0) * 0.15f;
        if (this.advanced) {
            speed *= 1.1f;
        }
        if (this.isInWater() && (this.getGolemType() == EnumGolemType.STONE || this.getGolemType() == EnumGolemType.IRON || this.getGolemType() == EnumGolemType.THAUMIUM)) {
            speed *= 2.0f;
        }
        return speed;
    }

    public void setup(int side) {
        this.homeFacing = side;
        this.setupGolem();
        this.setupGolemInventory();
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObjectByDataType(16, 5);
        this.dataWatcher.addObject(17, (Object)"");
        this.dataWatcher.addObject(18, (Object)0);
        this.dataWatcher.addObject(19, (Object)0);
        this.dataWatcher.addObject(20, (Object)String.valueOf(""));
        this.dataWatcher.addObject(21, (Object)-1);
        this.dataWatcher.addObject(22, (Object)String.valueOf(""));
        this.dataWatcher.addObject(23, (Object)String.valueOf(""));
    }

    public boolean isAIEnabled() {
        return !this.paused && !this.inactive;
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        if (this.action > 0) {
            --this.action;
        }
        if (this.leftArm > 0) {
            --this.leftArm;
        }
        if (this.rightArm > 0) {
            --this.rightArm;
        }
        if (this.healing > 0) {
            --this.healing;
        }
        int xx = MathHelper.floor_double((double)this.posX);
        int yy = MathHelper.floor_double((double)this.posY);
        int zz = MathHelper.floor_double((double)this.posZ);
        this.inactive = yy > 0 && this.worldObj.getBlock(xx, yy - 1, zz) == ConfigBlocks.blockCosmeticSolid && this.worldObj.getBlockMetadata(xx, yy - 1, zz) == 10;
        if (!this.worldObj.isRemote) {
            if (this.regenTimer > 0) {
                --this.regenTimer;
            } else {
                this.regenTimer = this.golemType.regenDelay;
                if (this.decoration.contains("F")) {
                    this.regenTimer = (int)((float)this.regenTimer * 0.66f);
                }
                if (!this.worldObj.isRemote && this.getHealth() < this.getMaxHealth()) {
                    this.worldObj.setEntityState((Entity)this, (byte)5);
                    this.heal(1.0f);
                }
            }
            if (this.getDistanceSq(this.getHomePosition().posX, this.getHomePosition().posY, this.getHomePosition().posZ) >= 2304.0 || this.isEntityInsideOpaqueBlock()) {
                int var1 = MathHelper.floor_double((double)this.getHomePosition().posX);
                int var2 = MathHelper.floor_double((double)this.getHomePosition().posZ);
                int var3 = MathHelper.floor_double((double)this.getHomePosition().posY);
                for (int var0 = 1; var0 >= -1; --var0) {
                    for (int var4 = -1; var4 <= 1; ++var4) {
                        for (int var5 = -1; var5 <= 1; ++var5) {
                            if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)this.worldObj, (int)(var1 + var4), (int)(var3 - 1 + var0), (int)(var2 + var5)) || this.worldObj.isBlockNormalCubeDefault(var1 + var4, var3 + var0, var2 + var5, false)) continue;
                            this.setLocationAndAngles((float)(var1 + var4) + 0.5f, (double)var3 + (double)var0, (float)(var2 + var5) + 0.5f, this.rotationYaw, this.rotationPitch);
                            this.getNavigator().clearPathEntity();
                            return;
                        }
                    }
                }
            }
        } else if (this.bootup > 0.0f && this.getCore() > -1) {
            this.bootup *= this.bootup / 33.1f;
            this.worldObj.playSound(this.posX, this.posY, this.posZ, "thaumcraft:cameraticks", this.bootup * 0.2f, 1.0f * this.bootup, false);
        }
    }

    public float getRange() {
        float dmod = 16 + this.getUpgradeAmount(3) * 4;
        if (this.decoration.contains("G")) {
            dmod += Math.max(dmod * 0.1f, 1.0f);
        }
        if (this.advanced) {
            dmod += Math.max(dmod * 0.2f, 2.0f);
        }
        return dmod;
    }

    public boolean isWithinHomeDistance(int par1, int par2, int par3) {
        float dmod = this.getRange();
        return this.getHomePosition().getDistanceSquared(par1, par2, par3) < dmod * dmod;
    }

    protected void updateEntityActionState() {
        ++this.entityAge;
        this.despawnEntity();
        boolean vara = this.isInWater();
        boolean varb = this.handleLavaMovement();
        if (vara || varb) {
            this.isJumping = this.rand.nextFloat() < 0.8f;
        }
    }

    public void onDeath(DamageSource ds) {
        if (!this.worldObj.isRemote) {
            FMLCommonHandler.instance().getFMLLogger().log(Level.INFO, "[Thaumcraft] " + (Object)((Object)this) + " was killed by " + ds.getSourceOfDamage() + " (" + ds.getDamageType() + ")");
        }
        super.onDeath(ds);
    }

    public void setFire(int par1) {
        if (!this.golemType.fireResist) {
            super.setFire(par1);
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void despawnEntity() {
    }

    public int decreaseAirSupply(int par1) {
        return par1;
    }

    public short getColors(int slot) {
        char[] chars = this.dataWatcher.getWatchableObjectString(22).toCharArray();
        if (slot < chars.length) {
            if (("" + chars[slot]).equals("h")) {
                return -1;
            }
            return Short.parseShort("" + chars[slot], 16);
        }
        return -1;
    }

    public void setColors(int slot, int color) {
        this.colors[slot] = (byte)color;
        String s = "";
        for (byte c : this.colors) {
            s = c == -1 ? s + "h" : s + Integer.toHexString(c);
        }
        this.dataWatcher.updateObject(22, (Object)String.valueOf(s));
    }

    public byte getUpgrade(int slot) {
        char[] chars = this.dataWatcher.getWatchableObjectString(23).toCharArray();
        if (slot < chars.length) {
            byte t = Byte.parseByte("" + chars[slot], 16);
            if (t == 15) {
                return -1;
            }
            return t;
        }
        return -1;
    }

    public int getUpgradeAmount(int type) {
        int a = 0;
        for (byte b : this.upgrades) {
            if (type != b) continue;
            ++a;
        }
        return a;
    }

    public void setUpgrade(int slot, byte upgrade) {
        this.upgrades[slot] = upgrade;
        String s = "";
        for (byte c : this.upgrades) {
            s = s + Integer.toHexString(c);
        }
        this.dataWatcher.updateObject(23, (Object)String.valueOf(s));
    }

    public ArrayList<Byte> getColorsMatching(ItemStack match) {
        ArrayList<Byte> l = new ArrayList<Byte>();
        if (this.inventory.inventory != null && this.inventory.inventory.length > 0) {
            int a;
            boolean allNull = true;
            for (a = 0; a < this.inventory.inventory.length; ++a) {
                if (this.inventory.getStackInSlot(a) != null) {
                    allNull = false;
                }
                if (!InventoryUtils.areItemStacksEqual(this.inventory.getStackInSlot(a), match, this.checkOreDict(), this.ignoreDamage(), this.ignoreNBT())) continue;
                l.add(this.colors[a]);
            }
            if (allNull) {
                for (a = 0; a < this.inventory.inventory.length; ++a) {
                    l.add(this.colors[a]);
                }
            }
        }
        return l;
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setInteger("HomeX", this.getHomePosition().posX);
        nbt.setInteger("HomeY", this.getHomePosition().posY);
        nbt.setInteger("HomeZ", this.getHomePosition().posZ);
        nbt.setByte("HomeFacing", (byte)this.homeFacing);
        nbt.setByte("GolemType", (byte)this.golemType.ordinal());
        nbt.setByte("Core", this.getCore());
        nbt.setString("Decoration", this.decoration);
        nbt.setByte("toggles", this.getTogglesValue());
        nbt.setBoolean("advanced", this.advanced);
        nbt.setByteArray("colors", this.colors);
        nbt.setByteArray("upgrades", this.upgrades);
        if (this.getCore() == 5 && this.fluidCarried != null) {
            this.fluidCarried.writeToNBT(nbt);
        }
        if (this.getCore() == 6 && this.essentia != null && this.essentiaAmount > 0) {
            nbt.setString("essentia", this.essentia.getTag());
            nbt.setByte("essentiaAmount", (byte)this.essentiaAmount);
        }
        NBTTagCompound var4 = new NBTTagCompound();
        if (this.itemCarried != null) {
            this.itemCarried.writeToNBT(var4);
        }
        nbt.setTag("ItemCarried", (NBTBase)var4);
        if (this.getOwnerName() == null) {
            nbt.setString("Owner", "");
        } else {
            nbt.setString("Owner", this.getOwnerName());
        }
        NBTTagList tl = new NBTTagList();
        for (Marker l : this.markers) {
            NBTTagCompound nbtc = new NBTTagCompound();
            nbtc.setInteger("x", l.x);
            nbtc.setInteger("y", l.y);
            nbtc.setInteger("z", l.z);
            nbtc.setInteger("dim", l.dim);
            nbtc.setByte("side", l.side);
            nbtc.setByte("color", l.color);
            tl.appendTag((NBTBase)nbtc);
        }
        nbt.setTag("Markers", (NBTBase)tl);
        nbt.setTag("Inventory", (NBTBase)this.inventory.writeToNBT(new NBTTagList()));
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        String s;
        super.readEntityFromNBT(nbt);
        int hx = nbt.getInteger("HomeX");
        int hy = nbt.getInteger("HomeY");
        int hz = nbt.getInteger("HomeZ");
        this.homeFacing = nbt.getByte("HomeFacing");
        this.setHomeArea(hx, hy, hz, 32);
        this.advanced = nbt.getBoolean("advanced");
        this.golemType = EnumGolemType.getType(nbt.getByte("GolemType"));
        this.setCore(nbt.getByte("Core"));
        if (this.getCore() == 5) {
            this.fluidCarried = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        }
        if (this.getCore() == 6 && (s = nbt.getString("essentia")) != null) {
            this.essentia = Aspect.getAspect(s);
            if (this.essentia != null) {
                this.essentiaAmount = nbt.getByte("essentiaAmount");
            }
        }
        this.setTogglesValue(nbt.getByte("toggles"));
        NBTTagCompound var4 = nbt.getCompoundTag("ItemCarried");
        this.itemCarried = ItemStack.loadItemStackFromNBT((NBTTagCompound)var4);
        this.updateCarried();
        this.decoration = nbt.getString("Decoration");
        this.setGolemDecoration(this.decoration);
        String var2 = nbt.getString("Owner");
        if (var2.length() > 0) {
            this.setOwner(var2);
        }
        this.dataWatcher.updateObject(30, (Object)((byte)this.getHealth()));
        NBTTagList nbttaglist = nbt.getTagList("Markers", 10);
        for (int i = 0; i < nbttaglist.tagCount(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.getCompoundTagAt(i);
            int x = nbttagcompound1.getInteger("x");
            int y = nbttagcompound1.getInteger("y");
            int z = nbttagcompound1.getInteger("z");
            int dim = nbttagcompound1.getInteger("dim");
            byte s2 = nbttagcompound1.getByte("side");
            byte c = nbttagcompound1.getByte("color");
            this.markers.add(new Marker(x, y, z, (byte)dim, s2, c));
        }
        this.upgrades = new byte[this.golemType.upgrades + (this.advanced ? 1 : 0)];
        int ul = this.upgrades.length;
        this.upgrades = nbt.getByteArray("upgrades");
        if (ul != this.upgrades.length) {
            int a;
            byte[] tt = new byte[ul];
            for (a = 0; a < ul; ++a) {
                tt[a] = -1;
            }
            for (a = 0; a < this.upgrades.length; ++a) {
                if (a >= ul) continue;
                tt[a] = this.upgrades[a];
            }
            this.upgrades = tt;
        }
        String st = "";
        for (byte c : this.upgrades) {
            st = st + Integer.toHexString(c);
        }
        this.dataWatcher.updateObject(23, (Object)String.valueOf(st));
        this.setupGolem();
        this.setupGolemInventory();
        NBTTagList nbttaglist2 = nbt.getTagList("Inventory", 10);
        this.inventory.readFromNBT(nbttaglist2);
        byte[] oldcolors = this.colors = nbt.getByteArray("colors");
        this.colors = new byte[this.inventory.slotCount];
        for (int a = 0; a < this.inventory.slotCount; ++a) {
            this.colors[a] = -1;
            if (a >= oldcolors.length) continue;
            this.colors[a] = oldcolors[a];
        }
        st = "";
        for (byte c : this.colors) {
            st = c == -1 ? st + "h" : st + Integer.toHexString(c);
        }
        this.dataWatcher.updateObject(22, (Object)String.valueOf(st));
    }

    public String getOwnerName() {
        return this.dataWatcher.getWatchableObjectString(17);
    }

    public void setOwner(String par1Str) {
        this.dataWatcher.updateObject(17, (Object)par1Str);
    }

    public void setMarkers(ArrayList<Marker> markers) {
        this.markers = markers;
    }

    public ArrayList<Marker> getMarkers() {
        this.validateMarkers();
        return this.markers;
    }

    protected void validateMarkers() {
        ArrayList<Marker> newMarkers = new ArrayList<Marker>();
        for (Marker marker : this.markers) {
            if (marker.dim != this.worldObj.provider.dimensionId) continue;
            newMarkers.add(marker);
        }
        this.markers = newMarkers;
    }

    public EntityLivingBase getOwner() {
        return this.worldObj.getPlayerEntityByName(this.getOwnerName());
    }

    protected void damageEntity(DamageSource ds, float par2) {
        if (ds.isFireDamage() && this.golemType.fireResist) {
            return;
        }
        if (ds == DamageSource.inWall || ds == DamageSource.outOfWorld) {
            this.setLocationAndAngles((double)this.getHomePosition().posX + 0.5, (double)this.getHomePosition().posY + 0.5, (double)this.getHomePosition().posZ + 0.5, 0.0f, 0.0f);
        }
        super.damageEntity(ds, par2);
        if (!this.worldObj.isRemote) {
            this.dataWatcher.updateObject(30, (Object)((byte)this.getHealth()));
        }
    }

    public void heal(float par1) {
        super.heal(par1);
        try {
            if (!this.worldObj.isRemote) {
                this.dataWatcher.updateObject(30, (Object)((byte)this.getHealth()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setHealth(float par1) {
        super.setHealth(par1);
        try {
            if (!this.worldObj.isRemote) {
                this.dataWatcher.updateObject(30, (Object)((byte)this.getHealth()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getHealthPercentage() {
        return (float)this.dataWatcher.getWatchableObjectByte(30) / this.getMaxHealth();
    }

    public void setCarried(ItemStack stack) {
        this.itemCarried = stack;
        this.updateCarried();
    }

    public boolean hasSomething() {
        return this.inventory.hasSomething();
    }

    public ItemStack getCarried() {
        if (this.itemCarried != null && this.itemCarried.stackSize <= 0) {
            this.setCarried(null);
        }
        return this.itemCarried;
    }

    public int getCarrySpace() {
        if (this.itemCarried == null) {
            return this.getCarryLimit();
        }
        return Math.min(this.getCarryLimit() - this.itemCarried.stackSize, this.itemCarried.getMaxStackSize() - this.itemCarried.stackSize);
    }

    public boolean[] getToggles() {
        return Utils.unpack(this.dataWatcher.getWatchableObjectByte(18));
    }

    public byte getTogglesValue() {
        return this.dataWatcher.getWatchableObjectByte(18);
    }

    public void setToggle(int index, boolean tog) {
        boolean[] fz = this.getToggles();
        fz[index] = tog;
        this.dataWatcher.updateObject(18, (Object)Utils.pack(fz));
    }

    public void setTogglesValue(byte tog) {
        this.dataWatcher.updateObject(18, (Object)tog);
    }

    public boolean canAttackHostiles() {
        return !this.getToggles()[1];
    }

    public boolean canAttackAnimals() {
        return !this.getToggles()[2];
    }

    public boolean canAttackPlayers() {
        return !this.getToggles()[3];
    }

    public boolean canAttackCreepers() {
        return !this.getToggles()[4];
    }

    public boolean checkOreDict() {
        return this.getToggles()[5];
    }

    public boolean ignoreDamage() {
        return this.getToggles()[6];
    }

    public boolean ignoreNBT() {
        return this.getToggles()[7];
    }

    public EnumGolemType getGolemType() {
        return EnumGolemType.getType(this.dataWatcher.getWatchableObjectByte(19));
    }

    public int getGolemStrength() {
        return this.getGolemType().strength + this.getUpgradeAmount(1);
    }

    public void setCore(byte core) {
        this.dataWatcher.updateObject(21, (Object)core);
    }

    public byte getCore() {
        return this.dataWatcher.getWatchableObjectByte(21);
    }

    public String getGolemDecoration() {
        return this.dataWatcher.getWatchableObjectString(20);
    }

    public void setGolemDecoration(String string) {
        this.dataWatcher.updateObject(20, (Object)String.valueOf(this.decoration));
    }

    public ItemStack getCarriedForDisplay() {
        if (this.dataWatcher.getWatchableObjectItemStack(16) != null) {
            return this.dataWatcher.getWatchableObjectItemStack(16);
        }
        return null;
    }

    public void updateCarried() {
        if (this.itemCarried != null) {
            this.getDataWatcher().updateObject(16, (Object)this.itemCarried.copy());
            this.getDataWatcher().setObjectWatched(16);
        } else if (this.getCore() == 5 && this.fluidCarried != null) {
            this.getDataWatcher().updateObject(16, (Object)new ItemStack(Item.getItemById((int)this.fluidCarried.fluidID), 1, this.fluidCarried.amount));
            this.getDataWatcher().setObjectWatched(16);
        } else if (this.getCore() == 6) {
            ItemStack disp = new ItemStack(ConfigItems.itemJarFilled);
            int amt = (int)(64.0f * ((float)this.essentiaAmount / (float)this.getCarryLimit()));
            if (this.essentia != null && this.essentiaAmount > 0) {
                ((IEssentiaContainerItem)disp.getItem()).setAspects(disp, new AspectList().add(this.essentia, amt));
            }
            this.getDataWatcher().updateObject(16, (Object)disp);
            this.getDataWatcher().setObjectWatched(16);
        } else {
            this.getDataWatcher().addObjectByDataType(16, 5);
            this.getDataWatcher().setObjectWatched(16);
        }
    }

    protected float getSoundVolume() {
        return 0.1f;
    }

    protected void dropFewItems(boolean par1, int par2) {
        this.dropStuff();
    }

    public void dropStuff() {
        if (!this.worldObj.isRemote && this.itemCarried != null) {
            this.entityDropItem(this.itemCarried, 0.5f);
        }
    }

    protected boolean addDecoration(String type, ItemStack itemStack) {
        if (this.decoration.contains(type)) {
            return false;
        }
        if ((type.equals("F") || type.equals("H")) && (this.decoration.contains("F") || this.decoration.contains("H"))) {
            return false;
        }
        if ((type.equals("G") || type.equals("V")) && (this.decoration.contains("G") || this.decoration.contains("V"))) {
            return false;
        }
        if ((type.equals("B") || type.equals("P")) && (this.decoration.contains("P") || this.decoration.contains("B"))) {
            return false;
        }
        this.decoration = this.decoration + type;
        if (!this.worldObj.isRemote) {
            this.setGolemDecoration(this.decoration);
            --itemStack.stackSize;
            this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:cameraclack", 1.0f, 1.0f);
        }
        this.setupGolem();
        return true;
    }

    public boolean customInteraction(EntityPlayer player) {
        if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() == ConfigItems.itemGolemBell) {
            return false;
        }
        if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() == ConfigItems.itemGolemDecoration) {
            this.addDecoration(ItemGolemDecoration.getDecoChar(player.inventory.getCurrentItem().getItemDamage()), player.inventory.getCurrentItem());
            player.swingItem();
            return false;
        }
        if (player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() == Items.cookie) {
            player.inventory.consumeInventoryItem(Items.cookie);
            player.swingItem();
            for (int var3 = 0; var3 < 3; ++var3) {
                double var4 = this.rand.nextGaussian() * 0.02;
                double var6 = this.rand.nextGaussian() * 0.02;
                double var8 = this.rand.nextGaussian() * 0.02;
                this.worldObj.spawnParticle("heart", this.posX + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, this.posY + 0.5 + (double)(this.rand.nextFloat() * this.height), this.posZ + (double)(this.rand.nextFloat() * this.width * 2.0f) - (double)this.width, var4, var6, var8);
                this.worldObj.playSoundAtEntity((Entity)this, "random.eat", 0.3f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                int duration = 600;
                if (!this.worldObj.isRemote) continue;
                if (this.getActivePotionEffect(Potion.moveSpeed) != null && this.getActivePotionEffect(Potion.moveSpeed).getDuration() < 2400) {
                    duration += this.getActivePotionEffect(Potion.moveSpeed).getDuration();
                }
                this.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, duration, 0));
            }
            this.heal(5.0f);
            return false;
        }
        if (!(this.getCore() <= -1 || !ItemGolemCore.hasGUI(this.getCore()) || player.inventory.getCurrentItem() != null && player.inventory.getCurrentItem().getItem() instanceof ItemWandCasting || this.worldObj.isRemote)) {
            player.openGui((Object)Thaumcraft.instance, 0, this.worldObj, this.getEntityId(), 0, 0);
            return false;
        }
        return false;
    }

    public boolean interact(EntityPlayer player) {
        if (player.isSneaking()) {
            return false;
        }
        ItemStack itemstack = player.inventory.getCurrentItem();
        if (this.getCore() > -1 && itemstack != null && itemstack.getItem() == ConfigItems.itemGolemBell) {
            return false;
        }
        if (this.getCore() == -1 && itemstack != null && itemstack.getItem() == ConfigItems.itemGolemCore && itemstack.getItemDamage() != 100) {
            this.setCore((byte)itemstack.getItemDamage());
            this.setupGolem();
            this.setupGolemInventory();
            --itemstack.stackSize;
            if (itemstack.stackSize <= 0) {
                player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
            }
            this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:upgrade", 0.5f, 1.0f);
            player.swingItem();
            this.worldObj.setEntityState((Entity)this, (byte)7);
            return true;
        }
        if (itemstack != null && itemstack.getItem() == ConfigItems.itemGolemUpgrade) {
            for (int a = 0; a < this.upgrades.length; ++a) {
                if (this.getUpgrade(a) != -1 || this.getUpgradeAmount(itemstack.getItemDamage()) >= 2) continue;
                this.setUpgrade(a, (byte)itemstack.getItemDamage());
                this.setupGolem();
                this.setupGolemInventory();
                --itemstack.stackSize;
                if (itemstack.stackSize <= 0) {
                    player.inventory.setInventorySlotContents(player.inventory.currentItem, (ItemStack)null);
                }
                this.worldObj.playSoundAtEntity((Entity)this, "thaumcraft:upgrade", 0.5f, 1.0f);
                player.swingItem();
                return true;
            }
            return false;
        }
        return this.customInteraction(player);
    }

    public int getActionTimer() {
        return 3 - Math.abs(this.action - 3);
    }

    public void startActionTimer() {
        if (this.action == 0) {
            this.action = 6;
            this.worldObj.setEntityState((Entity)this, (byte)4);
        }
    }

    public void startLeftArmTimer() {
        if (this.leftArm == 0) {
            this.leftArm = 5;
            this.worldObj.setEntityState((Entity)this, (byte)6);
        }
    }

    public void startRightArmTimer() {
        if (this.rightArm == 0) {
            this.rightArm = 5;
            this.worldObj.setEntityState((Entity)this, (byte)8);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte par1) {
        if (par1 == 4) {
            this.action = 6;
        } else if (par1 == 5) {
            this.healing = 5;
            int bonus = 0;
            try {
                bonus = this.getGolemDecoration().contains("H") ? 5 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)(this.getGolemType().health + bonus));
        } else if (par1 == 6) {
            this.leftArm = 5;
        } else if (par1 == 8) {
            this.rightArm = 5;
        } else if (par1 == 7) {
            this.bootup = 33.0f;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    protected void updateFallState(double par1, boolean par3) {
        if (par3 && this.fallDistance > 0.0f) {
            int var4 = MathHelper.floor_double((double)this.posX);
            int var5 = MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset));
            int var6 = MathHelper.floor_double((double)this.posZ);
            Block var7 = this.worldObj.getBlock(var4, var5, var6);
            if (this.worldObj.isAirBlock(var4, var5, var6) && this.worldObj.getBlock(var4, var5 - 1, var6) == Blocks.fence) {
                var7 = this.worldObj.getBlock(var4, var5 - 1, var6);
            }
        }
        if (par3) {
            if (this.fallDistance > 0.0f) {
                this.fall(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (par1 < 0.0) {
            this.fallDistance = (float)((double)this.fallDistance - par1);
        }
    }

    public EntityLivingBase getAttackTarget() {
        EntityLivingBase e = super.getAttackTarget();
        if (e != null && !e.isEntityAlive()) {
            e = null;
        }
        return e;
    }

    public int getTotalArmorValue() {
        int var1 = super.getTotalArmorValue() + this.golemType.armor;
        if (this.decoration.contains("V")) {
            ++var1;
        }
        if (this.decoration.contains("P")) {
            var1 += 4;
        }
        if (var1 > 20) {
            var1 = 20;
        }
        return var1;
    }

    public boolean attackEntityAsMob(Entity par1Entity) {
        boolean flag;
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        int i = 0;
        if (par1Entity instanceof EntityLivingBase) {
            f += EnchantmentHelper.getEnchantmentModifierLiving((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
            i += EnchantmentHelper.getKnockbackModifier((EntityLivingBase)this, (EntityLivingBase)((EntityLivingBase)par1Entity));
        }
        if (flag = par1Entity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), f)) {
            int j;
            if (this.decoration.contains("V")) {
                EntityUtils.setRecentlyHit((EntityLivingBase)par1Entity, 100);
            }
            if (i > 0) {
                par1Entity.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.motionX *= 0.6;
                this.motionZ *= 0.6;
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((EntityLivingBase)this) + this.getUpgradeAmount(2)) > 0) {
                par1Entity.setFire(j * 4);
            }
            if (par1Entity instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)this);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)this, (Entity)par1Entity);
        }
        return flag;
    }

    public boolean attackEntityFrom(DamageSource ds, float par2) {
        this.paused = false;
        if (ds == DamageSource.cactus) {
            return false;
        }
        if (this.getGolemType() == EnumGolemType.THAUMIUM && ds == DamageSource.magic) {
            par2 *= 0.5f;
        }
        if (ds.getSourceOfDamage() != null && this.getUpgradeAmount(5) > 0 && ds.getSourceOfDamage().getEntityId() != this.getEntityId()) {
            ds.getSourceOfDamage().attackEntityFrom(DamageSource.causeThornsDamage((Entity)this), (float)(this.getUpgradeAmount(5) * 2 + this.rand.nextInt(2 * this.getUpgradeAmount(5))));
            ds.getSourceOfDamage().playSound("damage.thorns", 0.5f, 1.0f);
        }
        return super.attackEntityFrom(ds, par2);
    }

    public boolean canAttackClass(Class par1Class) {
        return EntityVillager.class != par1Class && EntityGolemBase.class != par1Class && EntityBat.class != par1Class;
    }

    public boolean isValidTarget(Entity target) {
        if (!target.isEntityAlive()) {
            return false;
        }
        if (target instanceof EntityPlayer && ((EntityPlayer)target).getCommandSenderName().equals(this.getOwnerName())) {
            return false;
        }
        if (!this.isWithinHomeDistance(MathHelper.floor_double((double)target.posX), MathHelper.floor_double((double)target.posY), MathHelper.floor_double((double)target.posZ))) {
            return false;
        }
        if (this.getCore() == 9) {
            if (!(!(target instanceof EntityAnimal) && !(target instanceof IAnimals) || target instanceof IMob || target instanceof EntityTameable && ((EntityTameable)target).isTamed() || target instanceof EntityGolem)) {
                return !(target instanceof EntityAnimal) || !((EntityAnimal)target).isChild();
            }
        } else {
            if (this.canAttackCreepers() && this.getUpgradeAmount(4) > 0 && target instanceof EntityCreeper) {
                return true;
            }
            if (this.canAttackHostiles() && (target instanceof EntityMob || target instanceof IMob) && !(target instanceof EntityCreeper)) {
                return true;
            }
            if (!(!this.canAttackAnimals() || this.getUpgradeAmount(4) <= 0 || !(target instanceof EntityAnimal) && !(target instanceof IAnimals) || target instanceof IMob || target instanceof EntityTameable && ((EntityTameable)target).isTamed() || target instanceof EntityGolem)) {
                return true;
            }
            if (this.canAttackPlayers() && this.getUpgradeAmount(4) > 0 && target instanceof EntityPlayer) {
                return true;
            }
        }
        return false;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase par1EntityLiving) {
        EntityDart var2 = new EntityDart(this.worldObj, (EntityLivingBase)this, par1EntityLiving, 1.6f, 7.0f - (float)this.getUpgradeAmount(3) * 1.75f);
        float f = (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue();
        var2.setDamage(f * 0.4f);
        this.playSound("thaumcraft:golemironshoot", 0.5f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.6f));
        this.worldObj.spawnEntityInWorld((Entity)var2);
        this.startLeftArmTimer();
    }

    public int getAttackSpeed() {
        return 20 - (this.advanced ? 2 : 0);
    }

    protected String getLivingSound() {
        return "thaumcraft:cameraclack";
    }

    protected String getHurtSound() {
        return "thaumcraft:cameraclack";
    }

    protected String getDeathSound() {
        return "thaumcraft:cameraclack";
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte((int)this.getCore());
        data.writeBoolean(this.advanced);
        data.writeByte(this.inventory.slotCount);
        data.writeByte(this.upgrades.length);
        for (byte b : this.upgrades) {
            data.writeByte((int)b);
        }
    }

    public void readSpawnData(ByteBuf data) {
        try {
            int a;
            this.setCore(data.readByte());
            this.advanced = data.readBoolean();
            if (this.getCore() >= 0) {
                this.bootup = 0.0f;
            }
            this.inventory = new InventoryMob((Entity)this, data.readByte());
            this.colors = new byte[this.inventory.slotCount];
            for (a = 0; a < this.inventory.slotCount; ++a) {
                this.colors[a] = -1;
            }
            this.upgrades = new byte[data.readByte()];
            for (a = 0; a < this.upgrades.length; ++a) {
                this.upgrades[a] = data.readByte();
            }
            int bonus = 0;
            try {
                bonus = this.getGolemDecoration().contains("H") ? 5 : 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue((double)(this.getGolemType().health + bonus));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCommandSenderName() {
        if (this.hasCustomNameTag()) {
            return this.getCustomNameTag();
        }
        return StatCollector.translateToLocal((String)("item.ItemGolemPlacer." + this.getGolemType().ordinal() + ".name"));
    }
}

