/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.golems;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class EntityGolemBobber
extends Entity
implements IEntityAdditionalSpawnData {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int inData = 0;
    private boolean inGround = false;
    private boolean inBlock = false;
    public EntityGolemBase fisher = null;
    private int field_146045_ax;
    private int field_146040_ay;
    private float field_146054_aA;

    public void writeSpawnData(ByteBuf data) {
        data.writeDouble(this.motionX);
        data.writeDouble(this.motionY);
        data.writeDouble(this.motionZ);
        data.writeInt(this.fisher != null ? this.fisher.getEntityId() : -1);
    }

    public void readSpawnData(ByteBuf data) {
        this.motionX = data.readDouble();
        this.motionY = data.readDouble();
        this.motionZ = data.readDouble();
        int fid = data.readInt();
        if (fid >= 0) {
            this.fisher = (EntityGolemBase)this.worldObj.getEntityByID(fid);
        }
    }

    public EntityGolemBobber(World par1World) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.ignoreFrustumCheck = true;
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
    }

    public EntityGolemBobber(World par1World, EntityGolemBase par2EntityLiving, int x, int y, int z) {
        super(par1World);
        this.setSize(0.25f, 0.25f);
        this.fisher = par2EntityLiving;
        this.ignoreFrustumCheck = true;
        double d1 = (double)x + 0.5 - this.fisher.posX;
        double d3 = (double)(y + 1) - this.fisher.posY;
        double d5 = (double)z + 0.5 - this.fisher.posZ;
        double d7 = MathHelper.sqrt_double((double)(d1 * d1 + d3 * d3 + d5 * d5));
        double d9 = 0.1;
        this.motionX = d1 * d9;
        this.motionY = d3 * d9 + (double)MathHelper.sqrt_double((double)d7) * 0.08;
        this.motionZ = d5 * d9;
        this.setPosition(this.fisher.posX, this.fisher.posY, this.fisher.posZ);
        this.yOffset = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isInRangeToRenderDist(double par1) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote) {
            if (this.fisher == null || !this.fisher.isEntityAlive()) {
                this.setDead();
                return;
            }
            if (this.rand.nextFloat() < 0.02f) {
                ((WorldServer)this.worldObj).func_147487_a("splash", this.posX + (double)this.rand.nextFloat() - (double)this.rand.nextFloat(), this.posY + (double)this.rand.nextFloat(), this.posZ + (double)this.rand.nextFloat() - (double)this.rand.nextFloat(), 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
            }
        }
        if (this.ticksExisted++ > 4000) {
            this.setDead();
            return;
        }
        if (this.inBlock) {
            this.inBlock = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
        }
        Vec3 vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        Vec3 vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        MovingObjectPosition movingobjectposition = this.worldObj.rayTraceBlocks(vec31, vec3);
        vec31 = Vec3.createVectorHelper((double)this.posX, (double)this.posY, (double)this.posZ);
        vec3 = Vec3.createVectorHelper((double)(this.posX + this.motionX), (double)(this.posY + this.motionY), (double)(this.posZ + this.motionZ));
        if (movingobjectposition != null) {
            vec3 = Vec3.createVectorHelper((double)movingobjectposition.hitVec.xCoord, (double)movingobjectposition.hitVec.yCoord, (double)movingobjectposition.hitVec.zCoord);
            if (movingobjectposition.entityHit == null) {
                this.inBlock = true;
                if (this.worldObj.getBlock(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ).getMaterial() != Material.water) {
                    this.setDead();
                }
            }
        }
        if (!this.inBlock) {
            this.moveEntity(this.motionX, this.motionY, this.motionZ);
            float f5 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.rotationPitch = (float)(Math.atan2(this.motionY, f5) * 180.0 / Math.PI);
            while (this.rotationPitch - this.prevRotationPitch < -180.0f) {
                this.prevRotationPitch -= 360.0f;
            }
            while (this.rotationPitch - this.prevRotationPitch >= 180.0f) {
                this.prevRotationPitch += 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw < -180.0f) {
                this.prevRotationYaw -= 360.0f;
            }
            while (this.rotationYaw - this.prevRotationYaw >= 180.0f) {
                this.prevRotationYaw += 360.0f;
            }
            this.rotationPitch = this.prevRotationPitch + (this.rotationPitch - this.prevRotationPitch) * 0.2f;
            this.rotationYaw = this.prevRotationYaw + (this.rotationYaw - this.prevRotationYaw) * 0.2f;
            float f6 = 0.92f;
            if (this.onGround || this.isCollidedHorizontally) {
                f6 = 0.5f;
            }
            int b0 = 5;
            double d10 = 0.0;
            for (int j = 0; j < b0; ++j) {
                double d3 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 0) / (double)b0 - 0.125 + 0.125;
                double d4 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(j + 1) / (double)b0 - 0.125 + 0.125;
                AxisAlignedBB axisalignedbb1 = AxisAlignedBB.getBoundingBox((double)this.boundingBox.minX, (double)d3, (double)this.boundingBox.minZ, (double)this.boundingBox.maxX, (double)d4, (double)this.boundingBox.maxZ);
                if (!this.worldObj.isAABBInMaterial(axisalignedbb1, Material.water)) continue;
                d10 += 1.0 / (double)b0;
            }
            if (!this.worldObj.isRemote && d10 > 0.0) {
                WorldServer worldserver = (WorldServer)this.worldObj;
                int k = 1;
                if (this.rand.nextFloat() < 0.25f && this.worldObj.canLightningStrikeAt(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 1, MathHelper.floor_double((double)this.posZ))) {
                    k = 2;
                }
                if (this.rand.nextFloat() < 0.5f && !this.worldObj.canBlockSeeTheSky(MathHelper.floor_double((double)this.posX), MathHelper.floor_double((double)this.posY) + 1, MathHelper.floor_double((double)this.posZ))) {
                    --k;
                }
                if (this.field_146045_ax > 0) {
                    --this.field_146045_ax;
                    if (this.field_146045_ax <= 0) {
                        this.field_146040_ay = 0;
                    }
                } else if (this.field_146040_ay > 0) {
                    this.field_146040_ay -= k;
                    float f1 = 0.15f;
                    if (this.field_146040_ay < 20) {
                        f1 = (float)((double)f1 + (double)(20 - this.field_146040_ay) * 0.05);
                    } else if (this.field_146040_ay < 40) {
                        f1 = (float)((double)f1 + (double)(40 - this.field_146040_ay) * 0.02);
                    } else if (this.field_146040_ay < 60) {
                        f1 = (float)((double)f1 + (double)(60 - this.field_146040_ay) * 0.01);
                    }
                    if (this.rand.nextFloat() < f1) {
                        float f7 = MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                        float f2 = MathHelper.randomFloatClamp((Random)this.rand, (float)25.0f, (float)60.0f);
                        double d11 = this.posX + (double)(MathHelper.sin((float)f7) * f2 * 0.1f);
                        double d5 = (float)MathHelper.floor_double((double)this.boundingBox.minY) + 1.0f;
                        double d6 = this.posZ + (double)(MathHelper.cos((float)f7) * f2 * 0.1f);
                        worldserver.func_147487_a("splash", d11, d5, d6, 2 + this.rand.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    }
                    if (this.field_146040_ay <= 0) {
                        this.field_146054_aA = MathHelper.randomFloatClamp((Random)this.rand, (float)0.0f, (float)360.0f);
                    }
                }
                if (this.field_146045_ax > 0) {
                    this.motionY -= (double)(this.rand.nextFloat() * this.rand.nextFloat() * this.rand.nextFloat()) * 0.2;
                }
            }
            double d2 = d10 * 2.0 - 1.0;
            this.motionY += (double)0.04f * d2;
            if (d10 > 0.0) {
                f6 = (float)((double)f6 * 0.9);
                this.motionY *= 0.8;
            }
            this.motionX *= (double)f6;
            this.motionY *= (double)f6;
            this.motionZ *= (double)f6;
            this.setPosition(this.posX, this.posY, this.posZ);
        }
    }

    protected void entityInit() {
    }

    protected void readEntityFromNBT(NBTTagCompound var1) {
    }

    protected void writeEntityToNBT(NBTTagCompound var1) {
    }
}

