/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AICultistHurtByTarget;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.ai.misc.AIAltarFocus;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.projectile.EntityGolemOrb;

public class EntityCultistCleric
extends EntityCultist
implements IRangedAttackMob,
IEntityAdditionalSpawnData {
    public EntityCultistCleric(World p_i1745_1_) {
        super(p_i1745_1_);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(1, (EntityAIBase)new AIAltarFocus(this));
        this.tasks.addTask(2, (EntityAIBase)new AILongRangeAttack(this, 2.0, 1.0, 20, 40, 24.0f));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new AICultistHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    @Override
    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(4, new ItemStack(ConfigItems.itemHelmetCultistRobe));
        this.setCurrentItemOrArmor(3, new ItemStack(ConfigItems.itemChestCultistRobe));
        this.setCurrentItemOrArmor(2, new ItemStack(ConfigItems.itemLegsCultistRobe));
        float f = this.rand.nextFloat();
        float f2 = this.worldObj.difficultySetting == EnumDifficulty.HARD ? 0.3f : 0.1f;
        if (f < f2) {
            this.setCurrentItemOrArmor(1, new ItemStack(ConfigItems.itemBootsCultist));
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float f) {
        double d0 = entitylivingbase.posX - this.posX;
        double d1 = entitylivingbase.boundingBox.minY + (double)(entitylivingbase.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
        double d2 = entitylivingbase.posZ - this.posZ;
        this.swingItem();
        if (this.rand.nextFloat() > 0.66f) {
            EntityGolemOrb blast = new EntityGolemOrb(this.worldObj, (EntityLivingBase)this, entitylivingbase, true);
            blast.posX += blast.motionX / 2.0;
            blast.posZ += blast.motionZ / 2.0;
            blast.setPosition(blast.posX, blast.posY, blast.posZ);
            blast.setThrowableHeading(d0, d1 + 2.0, d2, 0.66f, 3.0f);
            this.playSound("thaumcraft:egattack", 1.0f, 1.0f + this.rand.nextFloat() * 0.1f);
            this.worldObj.spawnEntityInWorld((Entity)blast);
        } else {
            float f1 = MathHelper.sqrt_float((float)f) * 0.5f;
            this.worldObj.playAuxSFXAtEntity((EntityPlayer)null, 1009, (int)this.posX, (int)this.posY, (int)this.posZ, 0);
            for (int i = 0; i < 3; ++i) {
                EntitySmallFireball entitysmallfireball = new EntitySmallFireball(this.worldObj, (EntityLivingBase)this, d0 + this.rand.nextGaussian() * (double)f1, d1, d2 + this.rand.nextGaussian() * (double)f1);
                entitysmallfireball.posY = this.posY + (double)(this.height / 2.0f) + 0.5;
                this.worldObj.spawnEntityInWorld((Entity)entitysmallfireball);
            }
        }
    }

    @Override
    protected boolean canDespawn() {
        return !this.getIsRitualist();
    }

    @Override
    public void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)new Byte(0));
    }

    public boolean getIsRitualist() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 1) != 0;
    }

    public void setIsRitualist(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public boolean attackEntityFrom(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.isEntityInvulnerable()) {
            return false;
        }
        this.setIsRitualist(false);
        return super.attackEntityFrom(p_70097_1_, p_70097_2_);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.dataWatcher.updateObject(16, (Object)par1NBTTagCompound.getByte("Flags"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setByte("Flags", this.dataWatcher.getWatchableObjectByte(16));
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.getHomePosition().posX);
        data.writeInt(this.getHomePosition().posY);
        data.writeInt(this.getHomePosition().posZ);
    }

    public void readSpawnData(ByteBuf data) {
        this.setHomeArea(data.readInt(), data.readInt(), data.readInt(), 8);
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.worldObj.isRemote && this.getIsRitualist()) {
            double d0 = (double)this.getHomePosition().posX + 0.5 - this.posX;
            double d1 = (double)this.getHomePosition().posY + 1.5 - (this.posY + (double)this.getEyeHeight());
            double d2 = (double)this.getHomePosition().posZ + 0.5 - this.posZ;
            double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
            float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            this.rotationPitch = this.updateRotation(this.rotationPitch, f1, 10.0f);
            this.rotationYawHead = this.updateRotation(this.rotationYawHead, f, this.getVerticalFaceSpeed());
        }
    }

    private float updateRotation(float p_75652_1_, float p_75652_2_, float p_75652_3_) {
        float f3 = MathHelper.wrapAngleTo180_float((float)(p_75652_2_ - p_75652_1_));
        if (f3 > p_75652_3_) {
            f3 = p_75652_3_;
        }
        if (f3 < -p_75652_3_) {
            f3 = -p_75652_3_;
        }
        return p_75652_1_ + f3;
    }

    protected String getLivingSound() {
        return "thaumcraft:chant";
    }

    public int getTalkInterval() {
        return 500;
    }
}

