/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AICultistHurtByTarget;
import thaumcraft.common.entities.monster.EntityCultist;

public class EntityCultistKnight
extends EntityCultist {
    public EntityCultistKnight(World p_i1745_1_) {
        super(p_i1745_1_);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.tasks.addTask(4, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new AICultistHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(36.0);
    }

    @Override
    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(4, new ItemStack(ConfigItems.itemHelmetCultistPlate));
        this.setCurrentItemOrArmor(3, new ItemStack(ConfigItems.itemChestCultistPlate));
        this.setCurrentItemOrArmor(2, new ItemStack(ConfigItems.itemLegsCultistPlate));
        this.setCurrentItemOrArmor(1, new ItemStack(ConfigItems.itemBootsCultist));
        float f = this.rand.nextFloat();
        float f2 = this.worldObj.difficultySetting == EnumDifficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.rand.nextInt(5);
            if (i == 0) {
                this.setCurrentItemOrArmor(0, new ItemStack(ConfigItems.itemSwordVoid));
                this.setCurrentItemOrArmor(4, new ItemStack(ConfigItems.itemHelmetCultistRobe));
            } else {
                this.setCurrentItemOrArmor(0, new ItemStack(ConfigItems.itemSwordThaumium));
                if (this.rand.nextBoolean()) {
                    this.setCurrentItemOrArmor(4, null);
                }
            }
        } else {
            this.setCurrentItemOrArmor(0, new ItemStack(Items.iron_sword));
        }
    }

    @Override
    protected void enchantEquipment() {
        float f = this.worldObj.func_147462_b(this.posX, this.posY, this.posZ);
        if (this.getHeldItem() != null && this.rand.nextFloat() < 0.25f * f) {
            EnchantmentHelper.addRandomEnchantment((Random)this.rand, (ItemStack)this.getHeldItem(), (int)((int)(5.0f + f * (float)this.rand.nextInt(18))));
        }
    }
}

