/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.monster.EntityCultist;

public class EntityEldritchCrab
extends EntityMob {
    public EntityEldritchCrab(World par1World) {
        super(par1World);
        this.setSize(0.8f, 0.6f);
        this.experienceValue = 6;
        this.getNavigator().setBreakDoors(true);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.63f));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.0, false));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, 0, true));
    }

    public double getYOffset() {
        return this.isRiding() ? 0.5 : 0.0;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(4.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(this.hasHelm() ? 0.275 : 0.3);
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(22, (Object)new Byte(0));
    }

    public boolean canPickUpLoot() {
        return false;
    }

    public int getTotalArmorValue() {
        return this.hasHelm() ? 5 : 0;
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData livingData) {
        int i;
        if (this.worldObj.difficultySetting == EnumDifficulty.HARD) {
            this.setHelm(true);
        } else {
            this.setHelm(this.rand.nextFloat() < 0.33f);
        }
        if (livingData == null) {
            livingData = new EntitySpider.GroupData();
            if (this.worldObj.difficultySetting == EnumDifficulty.HARD && this.worldObj.rand.nextFloat() < 0.1f * this.worldObj.func_147462_b(this.posX, this.posY, this.posZ)) {
                ((EntitySpider.GroupData)livingData).func_111104_a(this.worldObj.rand);
            }
        }
        if (livingData instanceof EntitySpider.GroupData && (i = ((EntitySpider.GroupData)livingData).field_111105_a) > 0 && Potion.potionTypes[i] != null) {
            this.addPotionEffect(new PotionEffect(i, Integer.MAX_VALUE));
        }
        return super.onSpawnWithEgg(livingData);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    public boolean hasHelm() {
        return (this.dataWatcher.getWatchableObjectByte(22) & 1) != 0;
    }

    public void setHelm(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(22);
        if (par1) {
            this.dataWatcher.updateObject(22, (Object)((byte)(var2 | 1)));
        } else {
            this.dataWatcher.updateObject(22, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.ticksExisted < 20) {
            this.fallDistance = 0.0f;
        }
        if (this.ridingEntity == null && this.getAITarget() != null && this.getAITarget().riddenByEntity == null && !this.onGround && !this.hasHelm() && !this.getAITarget().isDead && this.posY - this.getAITarget().posY >= (double)(this.getAITarget().height / 2.0f) && this.getDistanceSqToEntity((Entity)this.getAITarget()) < 4.0) {
            this.mountEntity((Entity)this.getAITarget());
        }
        if (!this.worldObj.isRemote && this.ridingEntity != null && this.attackTime <= 0) {
            this.attackTime = 10 + this.rand.nextInt(10);
            this.attackEntityAsMob(this.ridingEntity);
            if (this.ridingEntity != null && (double)this.rand.nextFloat() < 0.2) {
                this.dismountEntity(this.ridingEntity);
            }
        }
    }

    protected Item getDropItem() {
        return Item.getItemById((int)0);
    }

    protected void dropFewItems(boolean p_70628_1_, int p_70628_2_) {
        super.dropFewItems(p_70628_1_, p_70628_2_);
        if (p_70628_1_ && (this.rand.nextInt(3) == 0 || this.rand.nextInt(1 + p_70628_2_) > 0)) {
            this.dropItem(Items.ender_pearl, 1);
        }
    }

    public boolean attackEntityAsMob(Entity p_70652_1_) {
        if (super.attackEntityAsMob(p_70652_1_)) {
            this.playSound("thaumcraft:crabclaw", 1.0f, 0.9f + this.worldObj.rand.nextFloat() * 0.2f);
            return true;
        }
        return false;
    }

    public boolean attackEntityFrom(DamageSource source, float damage) {
        boolean b = super.attackEntityFrom(source, damage);
        if (this.hasHelm() && this.getHealth() / this.getMaxHealth() <= 0.5f) {
            this.setHelm(false);
            this.renderBrokenItemStack(new ItemStack(ConfigItems.itemChestCultistPlate));
            this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        }
        return b;
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.dataWatcher.updateObject(22, (Object)par1NBTTagCompound.getByte("Flags"));
        if (!this.hasHelm()) {
            this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        }
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setByte("Flags", this.dataWatcher.getWatchableObjectByte(22));
    }

    public int getTalkInterval() {
        return 160;
    }

    protected String getLivingSound() {
        return "thaumcraft:crabtalk";
    }

    protected String getHurtSound() {
        return "game.hostile.hurt";
    }

    protected String getDeathSound() {
        return "thaumcraft:crabdeath";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.playSound("mob.spider.step", 0.15f, 1.0f);
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean isPotionApplicable(PotionEffect p_70687_1_) {
        return p_70687_1_.getPotionID() == Potion.poison.id ? false : super.isPotionApplicable(p_70687_1_);
    }

    public boolean isOnSameTeam(EntityLivingBase el) {
        return el instanceof EntityEldritchCrab;
    }
}

