/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.misc.AIConvertGrass;

public class EntityTaintSheep
extends EntityMob
implements IShearable,
ITaintedMob {
    private int sheepTimer;
    private AIConvertGrass field_48137_c = new AIConvertGrass((EntityLiving)this);

    public EntityTaintSheep(World par1World) {
        super(par1World);
        this.setSize(0.9f, 1.3f);
        this.getNavigator().setAvoidsWater(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)this.field_48137_c);
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityPlayer.class, 1.0, false));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityVillager.class, 1.0, true));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, 0, false));
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(20.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(3.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.25);
    }

    protected boolean isAIEnabled() {
        return true;
    }

    protected boolean canDespawn() {
        return false;
    }

    public int getTotalArmorValue() {
        return 1;
    }

    protected void updateAITasks() {
        this.sheepTimer = this.field_48137_c.func_48396_h();
        super.updateAITasks();
    }

    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.onLivingUpdate();
        if (this.worldObj.isRemote && this.ticksExisted < 5) {
            for (int a = 0; a < Thaumcraft.proxy.particleCount(10); ++a) {
                Thaumcraft.proxy.splooshFX((Entity)this);
            }
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)new Byte(0));
    }

    protected Item getDropItem() {
        return ConfigItems.itemResource;
    }

    protected void dropFewItems(boolean flag, int i) {
        if (this.worldObj.rand.nextInt(3) == 0) {
            if (this.worldObj.rand.nextBoolean()) {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 11), this.height / 2.0f);
            } else {
                this.entityDropItem(new ItemStack(ConfigItems.itemResource, 1, 12), this.height / 2.0f);
            }
        }
    }

    public void handleHealthUpdate(byte par1) {
        if (par1 == 10) {
            this.sheepTimer = 40;
        } else {
            super.handleHealthUpdate(par1);
        }
    }

    public float func_44003_c(float par1) {
        return this.sheepTimer <= 0 ? 0.0f : (this.sheepTimer >= 4 && this.sheepTimer <= 36 ? 1.0f : (this.sheepTimer < 4 ? ((float)this.sheepTimer - par1) / 4.0f : -((float)(this.sheepTimer - 40) - par1) / 4.0f));
    }

    public float func_44002_d(float par1) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float var2 = ((float)(this.sheepTimer - 4) - par1) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.sin((float)(var2 * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.rotationPitch / 57.295776f;
    }

    public boolean interact(EntityPlayer par1EntityPlayer) {
        return super.interact(par1EntityPlayer);
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("Sheared", this.getSheared());
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.setSheared(par1NBTTagCompound.getBoolean("Sheared"));
    }

    protected String getLivingSound() {
        return "mob.sheep.say";
    }

    protected String getHurtSound() {
        return "mob.sheep.say";
    }

    protected String getDeathSound() {
        return "mob.sheep.say";
    }

    protected void playStepSound(int par1, int par2, int par3, int par4) {
        this.playSound("mob.sheep.step", 0.15f, 1.0f);
    }

    protected float getSoundPitch() {
        return 0.7f;
    }

    public boolean getSheared() {
        return (this.dataWatcher.getWatchableObjectByte(16) & 0x10) != 0;
    }

    public void setSheared(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 | 0x10)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int X, int Y, int Z) {
        return !this.getSheared();
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int X, int Y, int Z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        this.setSheared(true);
        int i = 1 + this.rand.nextInt(3);
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Blocks.wool, 1, 10));
        }
        return ret;
    }
}

