/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.common.entities.ai.misc.AIWander;

public class EntityWatcher
extends EntityMob {
    private float field_175482_b;
    private float field_175484_c;
    private float field_175483_bk;
    private float field_175485_bl;
    private float field_175486_bm;
    private EntityLivingBase field_175478_bn;
    private int field_175479_bo;
    private boolean field_175480_bp;
    private AIWander wander;
    private EntityMoveHelper moveHelper;
    private GuardianLookHelper lookHelper;
    IEntitySelector mobSelector = new IEntitySelector(){

        public boolean isEntityApplicable(Entity ent) {
            return true;
        }
    };

    public EntityWatcher(World worldIn) {
        super(worldIn);
        this.experienceValue = 10;
        this.setSize(0.85f, 0.85f);
        this.tasks.addTask(4, (EntityAIBase)new AIGuardianAttack());
        EntityAIMoveTowardsRestriction entityaimovetowardsrestriction = new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0);
        this.tasks.addTask(5, (EntityAIBase)entityaimovetowardsrestriction);
        this.wander = new AIWander((EntityCreature)this, 1.0);
        this.tasks.addTask(7, (EntityAIBase)this.wander);
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityWatcher.class, 12.0f, 0.01f));
        this.tasks.addTask(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.wander.setMutexBits(3);
        entityaimovetowardsrestriction.setMutexBits(3);
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, true, false));
        this.lookHelper = new GuardianLookHelper((EntityLiving)this);
        this.moveHelper = new GuardianMoveHelper();
        this.field_175484_c = this.field_175482_b = this.rand.nextFloat();
        this.isImmuneToFire = true;
    }

    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(6.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.5);
        this.getEntityAttribute(SharedMonsterAttributes.followRange).setBaseValue(16.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(30.0);
    }

    public void readEntityFromNBT(NBTTagCompound tagCompund) {
        super.readEntityFromNBT(tagCompund);
    }

    public void writeEntityToNBT(NBTTagCompound tagCompound) {
        super.writeEntityToNBT(tagCompound);
    }

    public GuardianLookHelper getLookHelper() {
        return this.lookHelper;
    }

    protected void entityInit() {
        super.entityInit();
        this.dataWatcher.addObject(16, (Object)0);
        this.dataWatcher.addObject(17, (Object)0);
    }

    private boolean getFlags(int p_175468_1_) {
        return (this.dataWatcher.getWatchableObjectInt(16) & p_175468_1_) != 0;
    }

    private void setFlags(int p_175473_1_, boolean p_175473_2_) {
        int j = this.dataWatcher.getWatchableObjectInt(16);
        if (p_175473_2_) {
            this.dataWatcher.updateObject(16, (Object)(j | p_175473_1_));
        } else {
            this.dataWatcher.updateObject(16, (Object)(j & ~p_175473_1_));
        }
    }

    public boolean isGazing() {
        return this.getFlags(2);
    }

    private void setGazing(boolean p_175476_1_) {
        this.setFlags(2, p_175476_1_);
    }

    public int func_175464_ck() {
        return this.func_175461_cl() ? 60 : 80;
    }

    public boolean func_175461_cl() {
        return this.getFlags(4);
    }

    private void func_175463_b(int p_175463_1_) {
        this.dataWatcher.updateObject(17, (Object)p_175463_1_);
    }

    public boolean func_175474_cn() {
        return this.dataWatcher.getWatchableObjectInt(17) != 0;
    }

    public EntityLivingBase getTargetedEntity() {
        if (!this.func_175474_cn()) {
            return null;
        }
        if (this.worldObj.isRemote) {
            if (this.field_175478_bn != null) {
                return this.field_175478_bn;
            }
            Entity entity = this.worldObj.getEntityByID(this.dataWatcher.getWatchableObjectInt(17));
            if (entity instanceof EntityLivingBase) {
                this.field_175478_bn = (EntityLivingBase)entity;
                return this.field_175478_bn;
            }
            return null;
        }
        return this.getAttackTarget();
    }

    public void func_145781_i(int p_145781_1_) {
        super.func_145781_i(p_145781_1_);
        if (p_145781_1_ == 16) {
            if (this.func_175461_cl() && this.width < 1.0f) {
                this.setSize(1.9975f, 1.9975f);
            }
        } else if (p_145781_1_ == 17) {
            this.field_175479_bo = 0;
            this.field_175478_bn = null;
        }
    }

    public int getTalkInterval() {
        return 160;
    }

    protected String getLivingSound() {
        return !this.isInWater() ? "mob.guardian.land.idle" : (this.func_175461_cl() ? "mob.guardian.elder.idle" : "mob.guardian.idle");
    }

    protected String getHurtSound() {
        return !this.isInWater() ? "mob.guardian.land.hit" : (this.func_175461_cl() ? "mob.guardian.elder.hit" : "mob.guardian.hit");
    }

    protected String getDeathSound() {
        return !this.isInWater() ? "mob.guardian.land.death" : (this.func_175461_cl() ? "mob.guardian.elder.death" : "mob.guardian.death");
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    public float getEyeHeight() {
        return this.height * 0.5f;
    }

    public float getBlockPathWeight(int x, int y, int z) {
        return this.worldObj.isAirBlock(x, y, z) ? 10.0f : super.getBlockPathWeight(x, y, z);
    }

    public void onLivingUpdate() {
        if (this.worldObj.isRemote) {
            this.field_175484_c = this.field_175482_b;
            this.field_175483_bk = this.isGazing() ? (this.field_175483_bk < 0.5f ? 4.0f : (this.field_175483_bk += (0.5f - this.field_175483_bk) * 0.1f)) : (this.field_175483_bk += (0.125f - this.field_175483_bk) * 0.2f);
            this.field_175482_b += this.field_175483_bk;
            this.field_175486_bm = this.field_175485_bl;
            this.field_175485_bl = this.isGazing() ? (this.field_175485_bl += (0.0f - this.field_175485_bl) * 0.25f) : (this.field_175485_bl += (1.0f - this.field_175485_bl) * 0.06f);
            if (this.isGazing()) {
                Vec3 vec3 = this.getLook(0.0f);
                for (int i = 0; i < 2; ++i) {
                    this.worldObj.spawnParticle("bubble", this.posX + (this.rand.nextDouble() - 0.5) * (double)this.width - vec3.xCoord * 1.5, this.posY + this.rand.nextDouble() * (double)this.height - vec3.yCoord * 1.5, this.posZ + (this.rand.nextDouble() - 0.5) * (double)this.width - vec3.zCoord * 1.5, 0.0, 0.0, 0.0);
                }
            }
            if (this.func_175474_cn()) {
                EntityLivingBase entitylivingbase;
                if (this.field_175479_bo < this.func_175464_ck()) {
                    ++this.field_175479_bo;
                }
                if ((entitylivingbase = this.getTargetedEntity()) != null) {
                    this.getLookHelper().setLookPositionWithEntity((Entity)entitylivingbase, 90.0f, 90.0f);
                    this.getLookHelper().onUpdateLook();
                    double d5 = this.func_175477_p(0.0f);
                    double d0 = entitylivingbase.posX - this.posX;
                    double d1 = entitylivingbase.posY + (double)(entitylivingbase.height * 0.5f) - (this.posY + (double)this.getEyeHeight());
                    double d2 = entitylivingbase.posZ - this.posZ;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.rand.nextDouble();
                    while (d4 < d3) {
                        this.worldObj.spawnParticle("bubble", this.posX + d0 * (d4 += 1.8 - d5 + this.rand.nextDouble() * (1.7 - d5)), this.posY + d1 * d4 + (double)this.getEyeHeight(), this.posZ + d2 * d4, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (this.func_175474_cn()) {
            this.rotationYaw = this.rotationYawHead;
        }
        super.onLivingUpdate();
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175471_a(float p_175471_1_) {
        return this.field_175484_c + (this.field_175482_b - this.field_175484_c) * p_175471_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_175469_o(float p_175469_1_) {
        return this.field_175486_bm + (this.field_175485_bl - this.field_175486_bm) * p_175469_1_;
    }

    public float func_175477_p(float p_175477_1_) {
        return ((float)this.field_175479_bo + p_175477_1_) / (float)this.func_175464_ck();
    }

    protected void updateAITasks() {
        super.updateAITasks();
        if (this.func_175461_cl() && !this.hasHome()) {
            this.setHomeArea((int)this.posX, (int)this.posY, (int)this.posZ, 16);
        }
    }

    protected boolean isValidLightLevel() {
        return true;
    }

    public boolean attackEntityFrom(DamageSource source, float amount) {
        if (!this.isGazing() && !source.isMagicDamage() && source.getSourceOfDamage() instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)source.getSourceOfDamage();
            if (!source.isExplosion()) {
                entitylivingbase.attackEntityFrom(DamageSource.causeThornsDamage((Entity)this), 2.0f);
                entitylivingbase.playSound("damage.thorns", 0.5f, 1.0f);
            }
        }
        this.wander.setWander();
        return super.attackEntityFrom(source, amount);
    }

    public int getVerticalFaceSpeed() {
        return 180;
    }

    public void moveEntityWithHeading(float p_70612_1_, float p_70612_2_) {
        this.moveFlying(p_70612_1_, p_70612_2_, 0.1f);
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.9f;
        this.motionY *= (double)0.9f;
        this.motionZ *= (double)0.9f;
    }

    class GuardianMoveHelper
    extends EntityMoveHelper {
        private EntityWatcher field_179930_g;

        public GuardianMoveHelper() {
            super((EntityLiving)EntityWatcher.this);
            this.field_179930_g = EntityWatcher.this;
        }

        double getX() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianMoveHelper.class, (Object)((Object)this), (String[])new String[]{"posX", "field_75646_b"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        double getY() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianMoveHelper.class, (Object)((Object)this), (String[])new String[]{"posY", "field_75647_c"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        double getZ() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianMoveHelper.class, (Object)((Object)this), (String[])new String[]{"posZ", "field_75644_d"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        public void onUpdateMoveHelper() {
            if (this.isUpdating() && !this.field_179930_g.getNavigator().noPath()) {
                double d0 = this.getX() - this.field_179930_g.posX;
                double d1 = this.getY() - this.field_179930_g.posY;
                double d2 = this.getZ() - this.field_179930_g.posZ;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.sqrt_double((double)d3);
                d1 /= d3;
                float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                this.field_179930_g.renderYawOffset = this.field_179930_g.rotationYaw = this.limitAngle(this.field_179930_g.rotationYaw, f, 30.0f);
                float f1 = (float)(this.getSpeed() * this.field_179930_g.getEntityAttribute(SharedMonsterAttributes.movementSpeed).getAttributeValue());
                this.field_179930_g.setAIMoveSpeed(this.field_179930_g.getAIMoveSpeed() + (f1 - this.field_179930_g.getAIMoveSpeed()) * 0.125f);
                double d4 = Math.sin((double)(this.field_179930_g.ticksExisted + this.field_179930_g.getEntityId()) * 0.5) * 0.05;
                double d5 = Math.cos(this.field_179930_g.rotationYaw * (float)Math.PI / 180.0f);
                double d6 = Math.sin(this.field_179930_g.rotationYaw * (float)Math.PI / 180.0f);
                this.field_179930_g.motionX += d4 * d5;
                this.field_179930_g.motionZ += d4 * d6;
                d4 = Math.sin((double)(this.field_179930_g.ticksExisted + this.field_179930_g.getEntityId()) * 0.75) * 0.05;
                this.field_179930_g.motionY += d4 * (d6 + d5) * 0.25;
                this.field_179930_g.motionY += (double)this.field_179930_g.getAIMoveSpeed() * d1 * 0.1;
                GuardianLookHelper entitylookhelper = this.field_179930_g.getLookHelper();
                double d7 = this.field_179930_g.posX + d0 / d3 * 2.0;
                double d8 = (double)this.field_179930_g.getEyeHeight() + this.field_179930_g.posY + d1 / d3 * 1.0;
                double d9 = this.field_179930_g.posZ + d2 / d3 * 2.0;
                double d10 = entitylookhelper.getX();
                double d11 = entitylookhelper.getY();
                double d12 = entitylookhelper.getZ();
                if (!entitylookhelper.getLooking()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.field_179930_g.getLookHelper().setLookPosition(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
                this.field_179930_g.setGazing(true);
            } else {
                this.field_179930_g.setAIMoveSpeed(0.0f);
                this.field_179930_g.setGazing(false);
            }
        }

        private float limitAngle(float p_75639_1_, float p_75639_2_, float p_75639_3_) {
            float f3 = MathHelper.wrapAngleTo180_float((float)(p_75639_2_ - p_75639_1_));
            if (f3 > p_75639_3_) {
                f3 = p_75639_3_;
            }
            if (f3 < -p_75639_3_) {
                f3 = -p_75639_3_;
            }
            return p_75639_1_ + f3;
        }
    }

    class GuardianLookHelper
    extends EntityLookHelper {
        public GuardianLookHelper(EntityLiving p_i1613_1_) {
            super(p_i1613_1_);
        }

        double getX() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianLookHelper.class, (Object)((Object)this), (String[])new String[]{"posX", "field_75656_e"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        double getY() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianLookHelper.class, (Object)((Object)this), (String[])new String[]{"posY", "field_75653_f"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        double getZ() {
            try {
                return (Double)ReflectionHelper.getPrivateValue(GuardianLookHelper.class, (Object)((Object)this), (String[])new String[]{"posZ", "field_75654_g"});
            }
            catch (Exception e) {
                return 0.0;
            }
        }

        boolean getLooking() {
            try {
                return (Boolean)ReflectionHelper.getPrivateValue(GuardianLookHelper.class, (Object)((Object)this), (String[])new String[]{"isLooking", "field_75655_d"});
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    class AIGuardianAttack
    extends EntityAIBase {
        private EntityWatcher field_179456_a;
        private int field_179455_b;
        private static final String __OBFID = "CL_00002211";

        public AIGuardianAttack() {
            this.field_179456_a = EntityWatcher.this;
            this.setMutexBits(3);
        }

        public boolean shouldExecute() {
            EntityLivingBase entitylivingbase = this.field_179456_a.getAttackTarget();
            return entitylivingbase != null && entitylivingbase.isEntityAlive();
        }

        public boolean continueExecuting() {
            return super.continueExecuting() && (this.field_179456_a.func_175461_cl() || this.field_179456_a.getDistanceSqToEntity((Entity)this.field_179456_a.getAttackTarget()) > 9.0);
        }

        public void startExecuting() {
            this.field_179455_b = -10;
            this.field_179456_a.getNavigator().clearPathEntity();
            this.field_179456_a.getLookHelper().setLookPositionWithEntity((Entity)this.field_179456_a.getAttackTarget(), 90.0f, 90.0f);
            this.field_179456_a.isAirBorne = true;
        }

        public void resetTask() {
            this.field_179456_a.func_175463_b(0);
            this.field_179456_a.setAttackTarget(null);
            this.field_179456_a.wander.setWander();
        }

        public void updateTask() {
            EntityLivingBase entitylivingbase = this.field_179456_a.getAttackTarget();
            this.field_179456_a.getNavigator().clearPathEntity();
            this.field_179456_a.getLookHelper().setLookPositionWithEntity((Entity)entitylivingbase, 90.0f, 90.0f);
            if (!this.field_179456_a.canEntityBeSeen((Entity)entitylivingbase)) {
                this.field_179456_a.setAttackTarget(null);
            } else {
                ++this.field_179455_b;
                if (this.field_179455_b == 0) {
                    this.field_179456_a.func_175463_b(this.field_179456_a.getAttackTarget().getEntityId());
                    this.field_179456_a.worldObj.setEntityState((Entity)this.field_179456_a, (byte)21);
                } else if (this.field_179455_b >= this.field_179456_a.func_175464_ck()) {
                    float f = 1.0f;
                    if (this.field_179456_a.worldObj.difficultySetting == EnumDifficulty.HARD) {
                        f += 2.0f;
                    }
                    if (this.field_179456_a.func_175461_cl()) {
                        f += 2.0f;
                    }
                    entitylivingbase.attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this.field_179456_a, (Entity)this.field_179456_a), f);
                    entitylivingbase.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.field_179456_a), (float)this.field_179456_a.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue());
                    this.field_179456_a.setAttackTarget(null);
                } else if (this.field_179455_b < 60 || this.field_179455_b % 20 == 0) {
                    // empty if block
                }
                super.updateTask();
            }
        }
    }
}

