/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AICultistHurtByTarget;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.monster.EntityCultistCleric;
import thaumcraft.common.entities.monster.EntityCultistKnight;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityGolemOrb;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityCultistLeader
extends EntityThaumcraftBoss
implements IRangedAttackMob {
    String[] titles = new String[]{"Alberic", "Anselm", "Bastian", "Beturian", "Chabier", "Chorache", "Chuse", "Dodorol", "Ebardo", "Ferrando", "Fertus", "Guillen", "Larpe", "Obano", "Zelipe"};

    public EntityCultistLeader(World p_i1745_1_) {
        super(p_i1745_1_);
        this.setSize(0.75f, 2.25f);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new AILongRangeAttack(this, 16.0, 1.0, 30, 40, 24.0f));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.1, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new AICultistHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.experienceValue = 40;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.32);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(125.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(5.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(16, (Object)0);
    }

    @Override
    public void generateName() {
        int t = (int)this.getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue();
        if (t >= 0) {
            this.setCustomNameTag(String.format(StatCollector.translateToLocal((String)"entity.Thaumcraft.CultistLeader.name"), this.getTitle(), ChampionModifier.mods[t].getModNameLocalized()));
        }
    }

    private String getTitle() {
        return this.titles[this.getDataWatcher().getWatchableObjectByte(16)];
    }

    private void setTitle(int title) {
        this.dataWatcher.updateObject(16, (Object)((byte)title));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setByte("title", this.getDataWatcher().getWatchableObjectByte(16));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.setTitle(nbt.getByte("title"));
    }

    @Override
    protected void addRandomArmor() {
        this.setCurrentItemOrArmor(4, new ItemStack(ConfigItems.itemHelmetCultistLeaderPlate));
        this.setCurrentItemOrArmor(3, new ItemStack(ConfigItems.itemChestCultistLeaderPlate));
        this.setCurrentItemOrArmor(2, new ItemStack(ConfigItems.itemLegsCultistLeaderPlate));
        this.setCurrentItemOrArmor(1, new ItemStack(ConfigItems.itemBootsCultist));
        if (this.worldObj.difficultySetting == EnumDifficulty.EASY) {
            this.setCurrentItemOrArmor(0, new ItemStack(ConfigItems.itemSwordVoid));
        } else {
            this.setCurrentItemOrArmor(0, new ItemStack(ConfigItems.itemSwordCrimson));
        }
    }

    @Override
    protected void enchantEquipment() {
        float f = this.worldObj.func_147462_b(this.posX, this.posY, this.posZ);
        if (this.getHeldItem() != null && this.rand.nextFloat() < 0.5f * f) {
            EnchantmentHelper.addRandomEnchantment((Random)this.rand, (ItemStack)this.getHeldItem(), (int)((int)(7.0f + f * (float)this.rand.nextInt(22))));
        }
    }

    @Override
    public boolean isOnSameTeam(EntityLivingBase el) {
        return el instanceof EntityCultist || el instanceof EntityCultistLeader;
    }

    public boolean canAttackClass(Class clazz) {
        if (clazz == EntityCultistCleric.class || clazz == EntityCultistLeader.class || clazz == EntityCultistKnight.class) {
            return false;
        }
        return super.canAttackClass(clazz);
    }

    protected Item getDropItem() {
        return Item.getItemById((int)0);
    }

    @Override
    protected void dropFewItems(boolean flag, int i) {
        this.entityDropItem(new ItemStack(ConfigItems.itemLootbag, 1, 2), 1.5f);
    }

    @Override
    protected void dropRareDrop(int p_70600_1_) {
    }

    @Override
    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        this.addRandomArmor();
        this.enchantEquipment();
        this.setTitle(this.rand.nextInt(this.titles.length));
        return super.onSpawnWithEgg(p_110161_1_);
    }

    @Override
    protected void updateAITasks() {
        super.updateAITasks();
        ArrayList<Entity> list = EntityUtils.getEntitiesInRange(this.worldObj, this.posX, this.posY, this.posZ, (Entity)this, EntityCultist.class, 8.0);
        for (Entity e : list) {
            try {
                if (!(e instanceof EntityCultist) || ((EntityCultist)e).isPotionActive(Potion.regeneration.id)) continue;
                ((EntityCultist)e).addPotionEffect(new PotionEffect(Potion.regeneration.id, 60, 1));
            }
            catch (Exception e1) {}
        }
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float f) {
        if (this.canEntityBeSeen((Entity)entitylivingbase)) {
            this.swingItem();
            this.getLookHelper().setLookPosition(entitylivingbase.posX, entitylivingbase.boundingBox.minY + (double)(entitylivingbase.height / 2.0f), entitylivingbase.posZ, 30.0f, 30.0f);
            EntityGolemOrb blast = new EntityGolemOrb(this.worldObj, (EntityLivingBase)this, entitylivingbase, true);
            blast.posX += blast.motionX / 2.0;
            blast.posZ += blast.motionZ / 2.0;
            blast.setPosition(blast.posX, blast.posY, blast.posZ);
            double d0 = entitylivingbase.posX - this.posX;
            double d1 = entitylivingbase.boundingBox.minY + (double)(entitylivingbase.height / 2.0f) - (this.posY + (double)(this.height / 2.0f));
            double d2 = entitylivingbase.posZ - this.posZ;
            blast.setThrowableHeading(d0, d1 + 2.0, d2, 0.66f, 3.0f);
            this.playSound("thaumcraft:egattack", 1.0f, 1.0f + this.rand.nextFloat() * 0.1f);
            this.worldObj.spawnEntityInWorld((Entity)blast);
        }
    }
}

