/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockLoot;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityGolemOrb;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityEldritchGolem
extends EntityThaumcraftBoss
implements IEldritchMob,
IRangedAttackMob {
    int beamCharge = 0;
    boolean chargingBeam = false;
    int arcing = 0;
    int ax = 0;
    int ay = 0;
    int az = 0;
    private int attackTimer;

    public EntityEldritchGolem(World p_i1745_1_) {
        super(p_i1745_1_);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.1, false));
        this.tasks.addTask(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.setSize(1.75f, 3.5f);
        this.isImmuneToFire = true;
    }

    @Override
    public void generateName() {
        int t = (int)this.getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue();
        if (t >= 0) {
            this.setCustomNameTag(String.format(StatCollector.translateToLocal((String)"entity.Thaumcraft.EldritchGolem.name"), ChampionModifier.mods[t].getModNameLocalized()));
        }
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(12, (Object)0);
    }

    public boolean isHeadless() {
        return this.getDataWatcher().getWatchableObjectByte(12) == 1;
    }

    public void setHeadless(boolean par1) {
        this.dataWatcher.updateObject(12, (Object)(par1 ? (byte)1 : 0));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setBoolean("headless", this.isHeadless());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.setHeadless(nbt.getBoolean("headless"));
        if (this.isHeadless()) {
            this.makeHeadless();
        }
    }

    public float getEyeHeight() {
        return this.isHeadless() ? 3.33f : 3.0f;
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + 6;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.3);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(10.0);
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(250.0);
    }

    protected String getHurtSound() {
        return "mob.irongolem.hit";
    }

    protected String getDeathSound() {
        return "mob.irongolem.death";
    }

    protected void func_145780_a(int p_145780_1_, int p_145780_2_, int p_145780_3_, Block p_145780_4_) {
        this.playSound("mob.irongolem.walk", 1.0f, 1.0f);
    }

    @Override
    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        this.spawnTimer = 100;
        return super.onSpawnWithEgg(p_110161_1_);
    }

    public void onLivingUpdate() {
        float h;
        Block block;
        int k;
        int j;
        int i;
        super.onLivingUpdate();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.motionX * this.motionX + this.motionZ * this.motionZ > 2.500000277905201E-7 && this.rand.nextInt(5) == 0) {
            i = MathHelper.floor_double((double)this.posX);
            block = this.worldObj.getBlock(i, j = MathHelper.floor_double((double)(this.posY - (double)0.2f - (double)this.yOffset)), k = MathHelper.floor_double((double)this.posZ));
            if (block.getMaterial() != Material.air) {
                this.worldObj.spawnParticle("blockcrack_" + Block.getIdFromBlock((Block)block) + "_" + this.worldObj.getBlockMetadata(i, j, k), this.posX + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, this.boundingBox.minY + 0.1, this.posZ + ((double)this.rand.nextFloat() - 0.5) * (double)this.width, 4.0 * ((double)this.rand.nextFloat() - 0.5), 0.5, ((double)this.rand.nextFloat() - 0.5) * 4.0);
            }
            if (!this.worldObj.isRemote && block instanceof BlockLoot) {
                this.worldObj.func_147480_a(i, j, k, true);
            }
        }
        if (!this.worldObj.isRemote && (h = (block = this.worldObj.getBlock(i = MathHelper.floor_double((double)(this.posX + this.motionX)), j = MathHelper.floor_double((double)this.boundingBox.minY), k = MathHelper.floor_double((double)(this.posZ + this.motionZ)))).getBlockHardness(this.worldObj, i, j, k)) >= 0.0f && h <= 0.15f) {
            this.worldObj.func_147480_a(i, j, k, true);
        }
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (!this.worldObj.isRemote && damage > this.getHealth() && !this.isHeadless()) {
            this.setHeadless(true);
            this.spawnTimer = 100;
            double xx = MathHelper.cos((float)(this.rotationYaw % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
            double zz = MathHelper.sin((float)(this.rotationYaw % 360.0f / 180.0f * (float)Math.PI)) * 0.75f;
            this.worldObj.createExplosion((Entity)this, this.posX + xx, this.posY + (double)this.getEyeHeight(), this.posZ + zz, 2.0f, false);
            this.makeHeadless();
            return false;
        }
        return super.attackEntityFrom(source, damage);
    }

    void makeHeadless() {
        this.tasks.addTask(2, (EntityAIBase)new AILongRangeAttack(this, 3.0, 1.0, 5, 5, 24.0f));
    }

    public boolean attackEntityAsMob(Entity target) {
        if (this.attackTimer > 0) {
            return false;
        }
        this.attackTimer = 10;
        this.worldObj.setEntityState((Entity)this, (byte)4);
        boolean flag = target.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this), (float)this.getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue() * 0.75f);
        if (flag) {
            target.motionY += 0.2000000059604645;
            if (this.isHeadless()) {
                target.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * 1.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * 1.5f));
            }
        }
        return flag;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float f) {
        if (this.canEntityBeSeen((Entity)entitylivingbase) && !this.chargingBeam && this.beamCharge > 0) {
            this.beamCharge -= 15 + this.rand.nextInt(5);
            this.getLookHelper().setLookPosition(entitylivingbase.posX, entitylivingbase.boundingBox.minY + (double)(entitylivingbase.height / 2.0f), entitylivingbase.posZ, 30.0f, 30.0f);
            Vec3 v = this.getLook(1.0f);
            EntityGolemOrb blast = new EntityGolemOrb(this.worldObj, (EntityLivingBase)this, entitylivingbase, false);
            blast.posX += v.xCoord;
            blast.posZ += v.zCoord;
            blast.setPosition(blast.posX, blast.posY, blast.posZ);
            double d0 = entitylivingbase.posX + entitylivingbase.motionX - this.posX;
            double d1 = entitylivingbase.posY - this.posY - (double)(entitylivingbase.height / 2.0f);
            double d2 = entitylivingbase.posZ + entitylivingbase.motionZ - this.posZ;
            blast.setThrowableHeading(d0, d1, d2, 0.66f, 5.0f);
            this.playSound("thaumcraft:egattack", 1.0f, 1.0f + this.rand.nextFloat() * 0.1f);
            this.worldObj.spawnEntityInWorld((Entity)blast);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackTimer = 10;
            this.playSound("mob.irongolem.throw", 1.0f, 1.0f);
        } else if (p_70103_1_ == 18) {
            this.spawnTimer = 150;
        } else if (p_70103_1_ == 19) {
            if (this.arcing == 0) {
                float radius = 2.0f + this.rand.nextFloat() * 2.0f;
                double radians = Math.toRadians(this.rand.nextInt(360));
                double deltaX = (double)radius * Math.cos(radians);
                double deltaZ = (double)radius * Math.sin(radians);
                int bx = MathHelper.floor_double((double)(this.posX + deltaX));
                int by = MathHelper.floor_double((double)this.posY);
                int bz = MathHelper.floor_double((double)(this.posZ + deltaZ));
                int c = 0;
                while (c < 5 && this.worldObj.isAirBlock(bx, by, bz)) {
                    ++c;
                    --by;
                }
                if (this.worldObj.isAirBlock(bx, by + 1, bz) && !this.worldObj.isAirBlock(bx, by, bz)) {
                    this.ax = bx;
                    this.ay = by;
                    this.az = bz;
                    this.arcing = 8 + this.rand.nextInt(5);
                    this.worldObj.playSound(this.posX, this.posY, this.posZ, "thaumcraft:jacobs", 0.8f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.05f, false);
                }
            }
        } else {
            super.handleHealthUpdate(p_70103_1_);
        }
    }

    @Override
    public void onUpdate() {
        if (this.getSpawnTimer() == 150) {
            this.worldObj.setEntityState((Entity)this, (byte)18);
        }
        if (this.getSpawnTimer() > 0) {
            this.heal(2.0f);
        }
        super.onUpdate();
        if (this.worldObj.isRemote) {
            if (this.isHeadless()) {
                this.rotationPitch = 0.0f;
                float f1 = MathHelper.cos((float)(-this.renderYawOffset * ((float)Math.PI / 180) - (float)Math.PI));
                float f2 = MathHelper.sin((float)(-this.renderYawOffset * ((float)Math.PI / 180) - (float)Math.PI));
                float f3 = -MathHelper.cos((float)(-this.rotationPitch * ((float)Math.PI / 180)));
                float f4 = MathHelper.sin((float)(-this.rotationPitch * ((float)Math.PI / 180)));
                Vec3 v = Vec3.createVectorHelper((double)(f2 * f3), (double)f4, (double)(f1 * f3));
                if (this.rand.nextInt(20) == 0) {
                    float a = (this.rand.nextFloat() - this.rand.nextFloat()) / 2.0f;
                    float b = (this.rand.nextFloat() - this.rand.nextFloat()) / 2.0f;
                    Thaumcraft.proxy.spark((float)(this.posX + v.xCoord + (double)a), (float)this.posY + this.getEyeHeight() - 0.25f, (float)(this.posZ + v.zCoord + (double)b), 0.3f, 0.65f + this.rand.nextFloat() * 0.1f, 1.0f, 1.0f, 0.8f);
                }
                Thaumcraft.proxy.drawVentParticles(this.worldObj, (double)((float)this.posX) + v.xCoord * 0.66, (float)this.posY + this.getEyeHeight() - 0.75f, (double)((float)this.posZ) + v.zCoord * 0.66, 0.0, 0.001, 0.0, 0x555555, 4.0f);
                if (this.arcing > 0) {
                    Thaumcraft.proxy.arcLightning(this.worldObj, this.posX, this.posY + (double)(this.height / 2.0f), this.posZ, (double)this.ax + 0.5, this.ay + 1, (double)this.az + 0.5, 0.65f + this.rand.nextFloat() * 0.1f, 1.0f, 1.0f, 1.0f - (float)this.arcing / 10.0f);
                    --this.arcing;
                }
            }
        } else {
            if (this.isHeadless() && this.beamCharge <= 0) {
                this.chargingBeam = true;
            }
            if (this.isHeadless() && this.chargingBeam) {
                ++this.beamCharge;
                this.worldObj.setEntityState((Entity)this, (byte)19);
                if (this.beamCharge == 150) {
                    this.chargingBeam = false;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @Override
    protected void dropRareDrop(int fortune) {
        super.dropRareDrop(fortune);
    }
}

