/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.ai.combat.AIAttackOnCollide;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityEldritchOrb;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockArc;
import thaumcraft.common.lib.network.fx.PacketFXBlockSparkle;
import thaumcraft.common.lib.network.fx.PacketFXSonic;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityEldritchWarden
extends EntityThaumcraftBoss
implements IRangedAttackMob,
IEldritchMob {
    String[] titles = new String[]{"Aphoom-Zhah", "Basatan", "Chaugnar Faugn", "Mnomquah", "Nyogtha", "Oorn", "Shaikorth", "Rhan-Tegoth", "Rhogog", "Shudde M'ell", "Vulthoom", "Yag-Kosha", "Yibb-Tstll", "Zathog", "Zushakon"};
    boolean fieldFrenzy = false;
    int fieldFrenzyCounter = 0;
    boolean lastBlast = false;
    public float armLiftL = 0.0f;
    public float armLiftR = 0.0f;

    public EntityEldritchWarden(World p_i1745_1_) {
        super(p_i1745_1_);
        this.getNavigator().setBreakDoors(true);
        this.tasks.addTask(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.tasks.addTask(2, (EntityAIBase)new AILongRangeAttack(this, 3.0, 1.0, 20, 40, 24.0f));
        this.tasks.addTask(3, (EntityAIBase)new AIAttackOnCollide((EntityCreature)this, EntityLivingBase.class, 1.1, false));
        this.tasks.addTask(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.tasks.addTask(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.tasks.addTask(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.tasks.addTask(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.targetTasks.addTask(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.targetTasks.addTask(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        this.targetTasks.addTask(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCultist.class, 0, true));
        this.setSize(1.5f, 3.5f);
    }

    @Override
    public void generateName() {
        int t = (int)this.getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue();
        if (t >= 0) {
            this.setCustomNameTag(String.format(StatCollector.translateToLocal((String)"entity.Thaumcraft.EldritchWarden.name"), this.getTitle(), ChampionModifier.mods[t].getModNameLocalized()));
        }
    }

    private String getTitle() {
        return this.titles[this.getDataWatcher().getWatchableObjectByte(16)];
    }

    private void setTitle(int title) {
        this.dataWatcher.updateObject(16, (Object)((byte)title));
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(200.0);
        this.getEntityAttribute(SharedMonsterAttributes.movementSpeed).setBaseValue(0.33);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(10.0);
    }

    @Override
    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(16, (Object)0);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbt) {
        super.writeEntityToNBT(nbt);
        nbt.setByte("title", this.getDataWatcher().getWatchableObjectByte(16));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbt) {
        super.readEntityFromNBT(nbt);
        this.setTitle(nbt.getByte("title"));
    }

    public int getTotalArmorValue() {
        return super.getTotalArmorValue() + 4;
    }

    @Override
    protected void updateAITasks() {
        if (this.fieldFrenzyCounter == 0) {
            super.updateAITasks();
        }
        if (this.hurtResistantTime <= 0 && this.ticksExisted % 25 == 0) {
            int bh = (int)(this.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue() * 0.66);
            if (this.getAbsorptionAmount() < (float)bh) {
                this.setAbsorptionAmount(this.getAbsorptionAmount() + 1.0f);
            }
        }
    }

    @Override
    public void onUpdate() {
        if (this.getSpawnTimer() == 150) {
            this.worldObj.setEntityState((Entity)this, (byte)18);
        }
        super.onUpdate();
        if (this.worldObj.isRemote) {
            if (this.armLiftL > 0.0f) {
                this.armLiftL -= 0.05f;
            }
            if (this.armLiftR > 0.0f) {
                this.armLiftR -= 0.05f;
            }
            float x = (float)(this.posX + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f));
            float z = (float)(this.posZ + (double)((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f));
            Thaumcraft.proxy.wispFXEG(this.worldObj, x, (float)(this.posY + 0.25 * (double)this.height), z, (Entity)this);
            if (this.spawnTimer > 0) {
                float he = Math.max(1.0f, this.height * ((float)(150 - this.spawnTimer) / 150.0f));
                for (int a = 0; a < 33; ++a) {
                    Thaumcraft.proxy.smokeSpiral(this.worldObj, this.posX, this.boundingBox.minY + (double)(he / 2.0f), this.posZ, he, this.rand.nextInt(360), MathHelper.floor_double((double)this.boundingBox.minY) - 1, 0x22112F);
                }
            }
        }
    }

    public void onLivingUpdate() {
        super.onLivingUpdate();
        int i = MathHelper.floor_double((double)this.posX);
        int j = MathHelper.floor_double((double)this.posY);
        int k = MathHelper.floor_double((double)this.posZ);
        for (int l = 0; l < 4; ++l) {
            i = MathHelper.floor_double((double)(this.posX + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            if (!this.worldObj.isAirBlock(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)(this.posZ + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))))) continue;
            this.worldObj.setBlock(i, j, k, ConfigBlocks.blockAiry, 11, 3);
        }
        if (!this.worldObj.isRemote && this.fieldFrenzyCounter > 0) {
            if (this.fieldFrenzyCounter == 150) {
                this.teleportHome();
            }
            this.performFieldFrenzy();
        }
    }

    private void performFieldFrenzy() {
        if (this.fieldFrenzyCounter < 121 && this.fieldFrenzyCounter % 10 == 0) {
            this.worldObj.setEntityState((Entity)this, (byte)17);
            double radius = (double)(150 - this.fieldFrenzyCounter) / 8.0;
            int d = 1 + this.fieldFrenzyCounter / 8;
            int i = MathHelper.floor_double((double)this.posX);
            int j = MathHelper.floor_double((double)this.posY);
            int k = MathHelper.floor_double((double)this.posZ);
            for (int q = 0; q < 180 / d; ++q) {
                int deltaZ;
                double radians = Math.toRadians(q * 2 * d);
                int deltaX = (int)(radius * Math.cos(radians));
                if (!this.worldObj.isAirBlock(i + deltaX, j, k + (deltaZ = (int)(radius * Math.sin(radians)))) || !this.worldObj.isBlockNormalCubeDefault(i + deltaX, j - 1, k + deltaZ, false)) continue;
                this.worldObj.setBlock(i + deltaX, j, k + deltaZ, ConfigBlocks.blockAiry, 11, 3);
                this.worldObj.scheduleBlockUpdate(i + deltaX, j, k + deltaZ, ConfigBlocks.blockAiry, 250 + this.rand.nextInt(150));
                if (this.rand.nextFloat() < 0.3f) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockArc(i + deltaX, j, k + deltaZ, this.getEntityId()), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)(i + deltaX), (double)j, (double)(k + deltaZ), 32.0));
                    continue;
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockSparkle(i + deltaX, j, k + deltaZ, 0x800080), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)(i + deltaX), (double)j, (double)(k + deltaZ), 32.0));
            }
            this.worldObj.playSoundEffect(this.posX, this.posY, this.posZ, "thaumcraft:zap", 1.0f, 0.9f + this.rand.nextFloat() * 0.1f);
        }
        --this.fieldFrenzyCounter;
    }

    protected void teleportHome() {
        int k;
        int j;
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, (double)this.getHomePosition().posX, (double)this.getHomePosition().posY, (double)this.getHomePosition().posZ, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        double d3 = this.posX;
        double d4 = this.posY;
        double d5 = this.posZ;
        this.posX = event.targetX;
        this.posY = event.targetY;
        this.posZ = event.targetZ;
        boolean flag = false;
        int i = MathHelper.floor_double((double)this.posX);
        if (this.worldObj.blockExists(i, j = MathHelper.floor_double((double)this.posY), k = MathHelper.floor_double((double)this.posZ))) {
            boolean flag1 = false;
            int tries = 20;
            while (!flag1 && tries > 0) {
                Block block = this.worldObj.getBlock(i, j - 1, k);
                Block block2 = this.worldObj.getBlock(i, j, k);
                if (block.getMaterial().blocksMovement() && !block2.getMaterial().blocksMovement()) {
                    flag1 = true;
                    continue;
                }
                i = MathHelper.floor_double((double)this.posX) + this.rand.nextInt(8) - this.rand.nextInt(8);
                k = MathHelper.floor_double((double)this.posZ) + this.rand.nextInt(8) - this.rand.nextInt(8);
                --tries;
            }
            if (flag1) {
                this.setPosition((double)i + 0.5, (double)j + 0.1, (double)k + 0.5);
                if (this.worldObj.getCollidingBoundingBoxes((Entity)this, this.boundingBox).isEmpty()) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.setPosition(d3, d4, d5);
            return;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.rand.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.posX - d3) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            double d8 = d4 + (this.posY - d4) * d6 + this.rand.nextDouble() * (double)this.height;
            double d9 = d5 + (this.posZ - d5) * d6 + (this.rand.nextDouble() - 0.5) * (double)this.width * 2.0;
            this.worldObj.spawnParticle("portal", d7, d8, d9, (double)f, (double)f1, (double)f2);
        }
        this.worldObj.playSoundEffect(d3, d4, d5, "mob.endermen.portal", 1.0f, 1.0f);
        this.playSound("mob.endermen.portal", 1.0f, 1.0f);
    }

    @Override
    public boolean isEntityInvulnerable() {
        return this.fieldFrenzyCounter > 0 || super.isEntityInvulnerable();
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (this.isEntityInvulnerable() || source == DamageSource.drown || source == DamageSource.wither) {
            return false;
        }
        boolean aef = super.attackEntityFrom(source, damage);
        if (!this.worldObj.isRemote && aef && !this.fieldFrenzy && this.getAbsorptionAmount() <= 0.0f) {
            this.fieldFrenzy = true;
            this.fieldFrenzyCounter = 150;
        }
        return aef;
    }

    @Override
    public IEntityLivingData onSpawnWithEgg(IEntityLivingData p_110161_1_) {
        this.spawnTimer = 150;
        this.setTitle(this.rand.nextInt(this.titles.length));
        this.setAbsorptionAmount((float)((double)this.getAbsorptionAmount() + this.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue() * 0.66));
        return super.onSpawnWithEgg(p_110161_1_);
    }

    public float getEyeHeight() {
        return 3.1f;
    }

    public void attackEntityWithRangedAttack(EntityLivingBase entitylivingbase, float f) {
        if (this.rand.nextFloat() > 0.2f) {
            EntityEldritchOrb blast = new EntityEldritchOrb(this.worldObj, (EntityLivingBase)this);
            this.lastBlast = !this.lastBlast;
            this.worldObj.setEntityState((Entity)this, this.lastBlast ? (byte)16 : 15);
            int rr = this.lastBlast ? 90 : 180;
            double xx = MathHelper.cos((float)((this.rotationYaw + (float)rr) % 360.0f / 180.0f * (float)Math.PI)) * 0.5f;
            double yy = 0.13;
            double zz = MathHelper.sin((float)((this.rotationYaw + (float)rr) % 360.0f / 180.0f * (float)Math.PI)) * 0.5f;
            blast.setPosition(blast.posX - xx, blast.posY - yy, blast.posZ - zz);
            double d0 = entitylivingbase.posX + entitylivingbase.motionX - this.posX;
            double d1 = entitylivingbase.posY - this.posY - (double)(entitylivingbase.height / 2.0f);
            double d2 = entitylivingbase.posZ + entitylivingbase.motionZ - this.posZ;
            blast.setThrowableHeading(d0, d1, d2, 1.0f, 2.0f);
            this.playSound("thaumcraft:egattack", 2.0f, 1.0f + this.rand.nextFloat() * 0.1f);
            this.worldObj.spawnEntityInWorld((Entity)blast);
        } else if (this.canEntityBeSeen((Entity)entitylivingbase)) {
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXSonic(this.getEntityId()), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, this.posX, this.posY, this.posZ, 32.0));
            entitylivingbase.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * 1.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * 1.5f));
            try {
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.wither.id, 400, 0));
                entitylivingbase.addPotionEffect(new PotionEffect(Potion.weakness.id, 400, 0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (entitylivingbase instanceof EntityPlayer) {
                Thaumcraft.addWarpToPlayer((EntityPlayer)entitylivingbase, 3 + this.worldObj.rand.nextInt(3), true);
            }
            this.playSound("thaumcraft:egscreech", 4.0f, 1.0f + this.rand.nextFloat() * 0.1f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleHealthUpdate(byte p_70103_1_) {
        if (p_70103_1_ == 15) {
            this.armLiftL = 0.5f;
        } else if (p_70103_1_ == 16) {
            this.armLiftR = 0.5f;
        } else if (p_70103_1_ == 17) {
            this.armLiftL = 0.9f;
            this.armLiftR = 0.9f;
        } else if (p_70103_1_ == 18) {
            this.spawnTimer = 150;
        } else {
            super.handleHealthUpdate(p_70103_1_);
        }
    }

    @Override
    protected void dropRareDrop(int fortune) {
        super.dropRareDrop(fortune);
    }

    public boolean canAttackClass(Class clazz) {
        if (clazz == EntityEldritchGuardian.class) {
            return false;
        }
        return super.canAttackClass(clazz);
    }

    protected String getLivingSound() {
        return "thaumcraft:egidle";
    }

    protected String getDeathSound() {
        return "thaumcraft:egdeath";
    }

    public int getTalkInterval() {
        return 500;
    }
}

