/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityTaintacle;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityTaintacleGiant
extends EntityTaintacle
implements ITaintedMob,
IBossDisplayData {
    public EntityTaintacleGiant(World par1World) {
        super(par1World);
        this.setSize(1.1f, 6.0f);
        this.experienceValue = 20;
    }

    @Override
    protected void applyEntityAttributes() {
        super.applyEntityAttributes();
        this.getEntityAttribute(SharedMonsterAttributes.maxHealth).setBaseValue(125.0);
        this.getEntityAttribute(SharedMonsterAttributes.attackDamage).setBaseValue(9.0);
    }

    public IEntityLivingData onSpawnWithEgg(IEntityLivingData data) {
        EntityUtils.makeChampion(this, true);
        return data;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.getAnger() > 0) {
            this.setAnger(this.getAnger() - 1);
        }
        if (this.worldObj.isRemote && this.rand.nextInt(15) == 0 && this.getAnger() > 0) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            this.worldObj.spawnParticle("angryVillager", this.posX + (double)(this.rand.nextFloat() * this.width) - (double)this.width / 2.0, this.boundingBox.minY + (double)this.height + (double)this.rand.nextFloat() * 0.5, this.posZ + (double)(this.rand.nextFloat() * this.width) - (double)this.width / 2.0, d0, d1, d2);
        }
        if (!this.worldObj.isRemote && this.ticksExisted % 30 == 0) {
            this.heal(1.0f);
        }
    }

    protected void entityInit() {
        super.entityInit();
        this.getDataWatcher().addObject(14, (Object)new Short(0));
    }

    public int getAnger() {
        return this.dataWatcher.getWatchableObjectShort(14);
    }

    public void setAnger(int par1) {
        this.dataWatcher.updateObject(14, (Object)((short)par1));
    }

    @Override
    public boolean getCanSpawnHere() {
        return false;
    }

    @Override
    protected void dropFewItems(boolean flag, int i) {
        ArrayList<Entity> ents = EntityUtils.getEntitiesInRange(this.worldObj, this.posX, this.posY, this.posZ, (Entity)this, EntityTaintacleGiant.class, 48.0);
        if (ents == null || ents.size() <= 0) {
            EntityUtils.entityDropSpecialItem((Entity)this, new ItemStack(ConfigItems.itemEldritchObject, 1, 3), this.height / 2.0f);
        }
    }

    protected boolean canDespawn() {
        return false;
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    protected int decreaseAirSupply(int air) {
        return air;
    }

    @Override
    public boolean attackEntityFrom(DamageSource source, float damage) {
        if (!this.worldObj.isRemote && damage > 35.0f) {
            if (this.getAnger() == 0) {
                try {
                    this.addPotionEffect(new PotionEffect(Potion.regeneration.id, 200, (int)(damage / 15.0f)));
                    this.addPotionEffect(new PotionEffect(Potion.damageBoost.id, 200, (int)(damage / 40.0f)));
                    this.addPotionEffect(new PotionEffect(Potion.moveSpeed.id, 200, (int)(damage / 40.0f)));
                    this.setAnger(200);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (source.getEntity() != null && source.getEntity() instanceof EntityPlayer) {
                    ((EntityPlayer)source.getEntity()).addChatMessage((IChatComponent)new ChatComponentText(this.getCommandSenderName() + " " + StatCollector.translateToLocal((String)"tc.boss.enrage")));
                }
            }
            damage = 35.0f;
        }
        return super.attackEntityFrom(source, damage);
    }
}

