/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.mods;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.monster.mods.IChampionModifierEffect;

public class ChampionModSpined
implements IChampionModifierEffect {
    @Override
    public float performEffect(EntityLivingBase boss, EntityLivingBase target, DamageSource source, float amount) {
        if (target == null || source.damageType.equalsIgnoreCase("thorns")) {
            return amount;
        }
        target.attackEntityFrom(DamageSource.causeThornsDamage((Entity)boss), (float)(1 + boss.worldObj.rand.nextInt(3)));
        target.playSound("damage.thorns", 0.5f, 1.0f);
        return amount;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void showFX(EntityLivingBase boss) {
        if (boss.worldObj.rand.nextBoolean()) {
            return;
        }
        float w = boss.worldObj.rand.nextFloat() * boss.width;
        float d = boss.worldObj.rand.nextFloat() * boss.width;
        float h = boss.worldObj.rand.nextFloat() * boss.height;
        int p = 176 + boss.worldObj.rand.nextInt(4) * 3;
        Thaumcraft.proxy.drawGenericParticles(boss.worldObj, boss.boundingBox.minX + (double)w, boss.boundingBox.minY + (double)h, boss.boundingBox.minZ + (double)d, 0.0, 0.0, 0.0, 0.5f + boss.worldObj.rand.nextFloat() * 0.2f, 0.1f + boss.worldObj.rand.nextFloat() * 0.2f, 0.1f + boss.worldObj.rand.nextFloat() * 0.2f, 0.7f, false, p, 3, 1, 3, 0, 1.2f + boss.worldObj.rand.nextFloat() * 0.3f);
    }
}

