/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.projectile;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;

public class EntityEldritchOrb
extends EntityThrowable {
    public EntityEldritchOrb(World par1World) {
        super(par1World);
    }

    public EntityEldritchOrb(World par1World, EntityLivingBase par2EntityLiving) {
        super(par1World, par2EntityLiving);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.ticksExisted > 100) {
            this.setDead();
        }
    }

    public void handleHealthUpdate(byte b) {
        if (b == 16) {
            if (this.worldObj.isRemote) {
                for (int a = 0; a < 30; ++a) {
                    float fx = (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.3f;
                    float fy = (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.3f;
                    float fz = (this.worldObj.rand.nextFloat() - this.worldObj.rand.nextFloat()) * 0.3f;
                    Thaumcraft.proxy.wispFX3(this.worldObj, this.posX + (double)fx, this.posY + (double)fy, this.posZ + (double)fz, this.posX + (double)(fx * 8.0f), this.posY + (double)(fy * 8.0f), this.posZ + (double)(fz * 8.0f), 0.3f, 5, true, 0.02f);
                }
            }
        } else {
            super.handleHealthUpdate(b);
        }
    }

    protected void onImpact(MovingObjectPosition mop) {
        if (!this.worldObj.isRemote && this.getThrower() != null) {
            List list = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this.getThrower(), this.boundingBox.expand(2.0, 2.0, 2.0));
            for (int i = 0; i < list.size(); ++i) {
                Entity entity1 = (Entity)list.get(i);
                if (!(entity1 instanceof EntityLivingBase) || ((EntityLivingBase)entity1).isEntityUndead()) continue;
                ((EntityLivingBase)entity1).attackEntityFrom(DamageSource.causeIndirectMagicDamage((Entity)this, (Entity)this.getThrower()), (float)this.getThrower().getEntityAttribute(SharedMonsterAttributes.attackDamage).getAttributeValue() * 0.666f);
                try {
                    ((EntityLivingBase)entity1).addPotionEffect(new PotionEffect(Potion.weakness.id, 160, 0));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.worldObj.playSoundAtEntity((Entity)this, "random.fizz", 0.5f, 2.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.8f);
            this.ticksExisted = 100;
            this.worldObj.setEntityState((Entity)this, (byte)16);
        }
    }

    public float getShadowSize() {
        return 0.1f;
    }
}

