/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockArcaneDoor;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.tiles.TileOwned;

public class ItemKey
extends Item {
    public IIcon iconIron;
    public IIcon iconGold;

    public ItemKey() {
        this.setMaxStackSize(64);
        this.setHasSubtypes(true);
        this.setMaxDamage(0);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.iconIron = ir.registerIcon("thaumcraft:keyiron");
        this.iconGold = ir.registerIcon("thaumcraft:keygold");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return par1 == 0 ? this.iconIron : this.iconGold;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack((Item)this, 1, 0));
        par3List.add(new ItemStack((Item)this, 1, 1));
    }

    public String getUnlocalizedName(ItemStack par1ItemStack) {
        return super.getUnlocalizedName() + "." + par1ItemStack.getItemDamage();
    }

    public boolean hasEffect(ItemStack par1ItemStack) {
        return par1ItemStack.hasTagCompound();
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        Block bi = world.getBlock(x, y, z);
        int md = world.getBlockMetadata(x, y, z);
        if (bi == ConfigBlocks.blockArcaneDoor || bi == ConfigBlocks.blockWoodenDevice && (md == 2 || md == 3)) {
            int mod = 0;
            int mod2 = 1;
            byte type = 0;
            if (bi == ConfigBlocks.blockArcaneDoor) {
                int var10 = ((BlockArcaneDoor)bi).getFullMetadata((IBlockAccess)world, x, y, z);
                if ((var10 & 8) != 0) {
                    mod = -1;
                    mod2 = 0;
                }
            } else {
                type = 1;
            }
            String loc = x + "," + (y + mod) + "," + z;
            TileEntity tile = world.getTileEntity(x, y + mod, z);
            if (tile != null && tile instanceof TileOwned) {
                if (!itemstack.hasTagCompound()) {
                    if (player.getCommandSenderName().equals(((TileOwned)tile).owner) || ((TileOwned)tile).accessList.contains("1" + player.getCommandSenderName()) && itemstack.getItemDamage() == 0) {
                        ItemStack st = new ItemStack(ConfigItems.itemKey, 1, itemstack.getItemDamage());
                        st.setTagInfo("location", (NBTBase)new NBTTagString(loc));
                        st.setTagInfo("type", (NBTBase)new NBTTagByte(type));
                        if (!player.inventory.addItemStackToInventory(st) && !world.isRemote) {
                            world.spawnEntityInWorld((Entity)new EntityItem(world, player.posX, player.posY, player.posZ, st));
                        }
                        if (!player.capabilities.isCreativeMode) {
                            --itemstack.stackSize;
                        }
                        if (!world.isRemote) {
                            switch (type) {
                                case 0: {
                                    player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key1")));
                                    break;
                                }
                                case 1: {
                                    player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key2")));
                                }
                            }
                            world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:key", 1.0f, 0.9f);
                        }
                        player.swingItem();
                    }
                } else if (!player.getCommandSenderName().equals(((TileOwned)tile).owner) && !((TileOwned)tile).accessList.contains(itemstack.getItemDamage() + player.getCommandSenderName()) && !((TileOwned)tile).accessList.contains("1" + player.getCommandSenderName()) && loc.equals(itemstack.stackTagCompound.getString("location"))) {
                    ((TileOwned)tile).accessList.add(itemstack.getItemDamage() + player.getCommandSenderName());
                    if (type == 0) {
                        TileEntity tile2 = world.getTileEntity(x, y + mod2, z);
                        if (tile2 != null && tile2 instanceof TileOwned) {
                            ((TileOwned)tile2).accessList.add(itemstack.getItemDamage() + player.getCommandSenderName());
                        }
                        world.markBlockForUpdate(x, y + mod2, z);
                    }
                    world.markBlockForUpdate(x, y + mod, z);
                    if (!world.isRemote) {
                        switch (type) {
                            case 0: {
                                player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key3") + (itemstack.getItemDamage() == 0 ? "" : StatCollector.translateToLocal((String)"tc.key4"))));
                                break;
                            }
                            case 1: {
                                player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key5") + (itemstack.getItemDamage() == 0 ? "" : StatCollector.translateToLocal((String)"tc.key6"))));
                            }
                        }
                        world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:key", 1.0f, 1.1f);
                    }
                    if (!player.capabilities.isCreativeMode) {
                        --itemstack.stackSize;
                    }
                    player.swingItem();
                } else if (!world.isRemote) {
                    if (!loc.equals(itemstack.stackTagCompound.getString("location"))) {
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key7")));
                    } else {
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key8")));
                    }
                }
            }
            return !world.isRemote;
        }
        return true;
    }

    public void addInformation(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        if (stack.hasTagCompound() && stack.stackTagCompound.hasKey("location")) {
            String location = stack.stackTagCompound.getString("location");
            try {
                String[] ss = location.split(",");
                location = "x " + ss[0] + ", z " + ss[2] + ", y " + ss[1];
            }
            catch (Exception e) {
                // empty catch block
            }
            byte type = stack.stackTagCompound.getByte("type");
            list.add("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"tc.key9"));
            list.add("\u00a75\u00a7o" + (type == 0 ? StatCollector.translateToLocal((String)"tc.key10") : StatCollector.translateToLocal((String)"tc.key11")));
            list.add("\u00a75\u00a7o" + location);
        }
    }
}

