/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;

public class ItemSanitySoap
extends Item {
    @SideOnly(value=Side.CLIENT)
    public IIcon icon;

    public ItemSanitySoap() {
        this.setCreativeTab(Thaumcraft.tabTC);
        this.setHasSubtypes(false);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:soap");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 200;
    }

    public EnumAction getItemUseAction(ItemStack p_77661_1_) {
        return EnumAction.block;
    }

    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        return p_77659_1_;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int ticks = this.getMaxItemUseDuration(stack) - count;
        if (ticks > 195) {
            player.stopUsingItem();
        }
        if (player.worldObj.isRemote) {
            if (player.worldObj.rand.nextFloat() < 0.2f) {
                player.worldObj.playSound(player.posX, player.posY, player.posZ, "thaumcraft:roots", 0.1f, 1.5f + player.worldObj.rand.nextFloat() * 0.2f, false);
            }
            for (int a = 0; a < Thaumcraft.proxy.particleCount(5); ++a) {
                Thaumcraft.proxy.crucibleBubble(Thaumcraft.proxy.getClientWorld(), (float)player.posX - 0.5f + player.worldObj.rand.nextFloat(), (float)player.boundingBox.minY + player.worldObj.rand.nextFloat() * player.height, (float)player.posZ - 0.5f + player.worldObj.rand.nextFloat(), 1.0f, 0.8f, 0.9f);
            }
        }
    }

    public void onPlayerStoppedUsing(ItemStack stack, World world, EntityPlayer player, int par4) {
        int qq = this.getMaxItemUseDuration(stack) - par4;
        if (qq > 195) {
            --stack.stackSize;
            if (!world.isRemote) {
                int k;
                int j;
                int i;
                float chance = 0.33f;
                if (player.isPotionActive(Config.potionWarpWardID)) {
                    chance += 0.25f;
                }
                if (world.getBlock(i = MathHelper.floor_double((double)player.posX), j = MathHelper.floor_double((double)player.posY), k = MathHelper.floor_double((double)player.posZ)) == ConfigBlocks.blockFluidPure) {
                    chance += 0.25f;
                }
                if (world.rand.nextFloat() < chance && Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.getCommandSenderName()) > 0) {
                    Thaumcraft.addStickyWarpToPlayer(player, -1);
                }
                if (Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.getCommandSenderName()) > 0) {
                    Thaumcraft.addWarpToPlayer(player, -Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.getCommandSenderName()), true);
                }
            } else {
                player.worldObj.playSound(player.posX, player.posY, player.posZ, "thaumcraft:craftstart", 0.25f, 1.0f, false);
                for (int a = 0; a < Thaumcraft.proxy.particleCount(20); ++a) {
                    Thaumcraft.proxy.crucibleBubble(Thaumcraft.proxy.getClientWorld(), (float)player.posX - 0.5f + player.worldObj.rand.nextFloat() * 1.5f, (float)player.boundingBox.minY + player.worldObj.rand.nextFloat() * player.height, (float)player.posZ - 0.5f + player.worldObj.rand.nextFloat() * 1.5f, 1.0f, 0.7f, 0.9f);
                }
            }
        }
    }
}

