/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.armor;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.Config;
import thaumcraft.common.items.baubles.ItemGirdleHover;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketFlyToServer;
import thaumcraft.common.lib.utils.Utils;

public class Hover {
    public static final int EFFICIENCY = 360;
    static HashMap<Integer, Boolean> hovering = new HashMap();
    static HashMap<Integer, Long> timing = new HashMap();

    public static boolean toggleHover(EntityPlayer player, int playerId, ItemStack armor) {
        AspectList aspects;
        ItemStack jar;
        boolean hover = hovering.get(playerId) == null ? false : hovering.get(playerId);
        int fuel = 0;
        if (armor.hasTagCompound() && armor.stackTagCompound.hasKey("jar") && (jar = ItemStack.loadItemStackFromNBT((NBTTagCompound)armor.stackTagCompound.getCompoundTag("jar"))) != null && jar.getItem() instanceof ItemJarFilled && jar.hasTagCompound() && (aspects = ((ItemJarFilled)jar.getItem()).getAspects(jar)) != null && aspects.size() > 0 && aspects.getAmount(Aspect.ENERGY) > 0) {
            fuel = (short)aspects.getAmount(Aspect.ENERGY);
        }
        if (!hover && fuel <= 0) {
            return false;
        }
        hovering.put(playerId, !hover);
        if (player.worldObj.isRemote) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFlyToServer(player, !hover));
            player.worldObj.playSound(player.posX, player.posY, player.posZ, !hover ? "thaumcraft:hhon" : "thaumcraft:hhoff", 0.33f, 1.0f, false);
        }
        return !hover;
    }

    public static void setHover(int playerId, boolean hover) {
        hovering.put(playerId, hover);
    }

    public static boolean getHover(int playerId) {
        return hovering.containsKey(playerId) ? hovering.get(playerId) : false;
    }

    public static void handleHoverArmor(EntityPlayer player, ItemStack armor) {
        if (hovering.get(player.getEntityId()) == null && armor.hasTagCompound() && armor.stackTagCompound.hasKey("hover")) {
            hovering.put(player.getEntityId(), armor.stackTagCompound.getByte("hover") == 1);
            if (player.worldObj.isRemote) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFlyToServer(player, armor.stackTagCompound.getByte("hover") == 1));
            }
        }
        boolean hover = hovering.get(player.getEntityId()) == null ? false : hovering.get(player.getEntityId());
        World world = player.worldObj;
        player.capabilities.isFlying = hover;
        if (world.isRemote && player instanceof EntityPlayerSP) {
            if (hover && Hover.expendCharge(player, armor)) {
                long currenttime = System.currentTimeMillis();
                long time = 0L;
                if (timing.get(player.getEntityId()) != null) {
                    time = timing.get(player.getEntityId());
                }
                if (time < currenttime) {
                    time = currenttime + 1200L;
                    timing.put(player.getEntityId(), time);
                    player.worldObj.playSound(player.posX, player.posY, player.posZ, "thaumcraft:jacobs", 0.05f, 1.0f + player.worldObj.rand.nextFloat() * 0.05f, false);
                }
                int haste = EnchantmentHelper.getEnchantmentLevel((int)Config.enchHaste.effectId, (ItemStack)armor);
                float mod = 0.7f + 0.075f * (float)haste;
                if (BaublesApi.getBaubles((EntityPlayer)player).getStackInSlot(3) != null && BaublesApi.getBaubles((EntityPlayer)player).getStackInSlot(3).getItem() instanceof ItemGirdleHover) {
                    mod += 0.21f;
                }
                if (mod > 1.0f) {
                    mod = 1.0f;
                }
                player.motionX *= (double)mod;
                player.motionZ *= (double)mod;
            } else if (hover) {
                Hover.toggleHover(player, player.getEntityId(), armor);
            }
        } else {
            if (armor.hasTagCompound() && !armor.stackTagCompound.hasKey("hover")) {
                armor.setTagInfo("hover", (NBTBase)new NBTTagByte((byte)(hover ? 1 : 0)));
            }
            if (hover && Hover.expendCharge(player, armor)) {
                if (player instanceof EntityPlayerMP) {
                    Utils.resetFloatCounter((EntityPlayerMP)player);
                }
                player.fallDistance = 0.0f;
                if (armor.hasTagCompound() && armor.stackTagCompound.hasKey("hover") && armor.stackTagCompound.getByte("hover") != 1) {
                    armor.setTagInfo("hover", (NBTBase)new NBTTagByte((byte)(hover ? 1 : 0)));
                }
            } else {
                if (hover) {
                    Hover.toggleHover(player, player.getEntityId(), armor);
                }
                player.fallDistance *= 0.75f;
                if (armor.hasTagCompound() && armor.stackTagCompound.hasKey("hover") && armor.stackTagCompound.getByte("hover") == 1) {
                    armor.setTagInfo("hover", (NBTBase)new NBTTagByte((byte)(hover ? 1 : 0)));
                }
            }
        }
    }

    public static boolean expendCharge(EntityPlayer player, ItemStack is) {
        if (is.hasTagCompound() && is.stackTagCompound.hasKey("jar")) {
            AspectList aspects;
            ItemStack jar = ItemStack.loadItemStackFromNBT((NBTTagCompound)is.stackTagCompound.getCompoundTag("jar"));
            int fuel = 0;
            if (jar != null && jar.getItem() instanceof ItemJarFilled && jar.hasTagCompound() && (aspects = ((ItemJarFilled)jar.getItem()).getAspects(jar)) != null && aspects.size() > 0 && aspects.getAmount(Aspect.ENERGY) > 0) {
                fuel = (short)aspects.getAmount(Aspect.ENERGY);
            }
            float mod = 1.0f;
            if (BaublesApi.getBaubles((EntityPlayer)player).getStackInSlot(3) != null && BaublesApi.getBaubles((EntityPlayer)player).getStackInSlot(3).getItem() instanceof ItemGirdleHover) {
                mod = 0.8f;
            }
            if (!is.stackTagCompound.hasKey("charge")) {
                is.setTagInfo("charge", (NBTBase)new NBTTagShort(0));
            }
            if (fuel > 0 && is.stackTagCompound.hasKey("charge")) {
                short charge = is.stackTagCompound.getShort("charge");
                if ((float)charge < 360.0f * mod) {
                    is.setTagInfo("charge", (NBTBase)new NBTTagShort((short)(charge + 1)));
                    return true;
                }
                is.setTagInfo("charge", (NBTBase)new NBTTagShort(0));
                fuel = (short)(fuel - 1);
                if (fuel > 0) {
                    ((ItemJarFilled)jar.getItem()).setAspects(jar, new AspectList().add(Aspect.ENERGY, fuel));
                } else {
                    ((ItemJarFilled)jar.getItem()).setAspects(jar, new AspectList().remove(Aspect.ENERGY));
                }
                NBTTagCompound var4 = new NBTTagCompound();
                jar.writeToNBT(var4);
                is.setTagInfo("jar", (NBTBase)var4);
                return fuel > 0;
            }
        }
        return false;
    }
}

