/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.equipment;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.IRepairable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntityFollowingItem;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockBubble;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;

public class ItemElementalAxe
extends ItemAxe
implements IRepairable {
    public IIcon icon;
    boolean alternateServer = false;
    boolean alternateClient = false;
    public static ArrayList<List> oreDictLogs = new ArrayList();

    public ItemElementalAxe(Item.ToolMaterial enumtoolmaterial) {
        super(enumtoolmaterial);
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:elementalaxe");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.isItemEqual(new ItemStack(ConfigItems.itemResource, 1, 2)) ? true : super.getIsRepairable(par1ItemStack, par2ItemStack);
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.bow;
    }

    public int getMaxItemUseDuration(ItemStack p_77626_1_) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack p_77659_1_, World p_77659_2_, EntityPlayer p_77659_3_) {
        p_77659_3_.setItemInUse(p_77659_1_, this.getMaxItemUseDuration(p_77659_1_));
        return p_77659_1_;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        ArrayList<Entity> stuff = EntityUtils.getEntitiesInRange(player.worldObj, player.posX, player.posY, player.posZ, (Entity)player, EntityItem.class, 10.0);
        if (stuff != null && stuff.size() > 0) {
            for (Entity e : stuff) {
                if (e instanceof EntityFollowingItem && ((EntityFollowingItem)e).target != null || e.isDead || !(e instanceof EntityItem)) continue;
                double d6 = e.posX - player.posX;
                double d8 = e.posY - player.posY + (double)(player.height / 2.0f);
                double d10 = e.posZ - player.posZ;
                double d11 = MathHelper.sqrt_double((double)(d6 * d6 + d8 * d8 + d10 * d10));
                double d13 = 0.3;
                e.motionX -= (d6 /= d11) * d13;
                e.motionY -= (d8 /= d11) * d13;
                e.motionZ -= (d10 /= d11) * d13;
                if (e.motionX > 0.35) {
                    e.motionX = 0.35;
                }
                if (e.motionX < -0.35) {
                    e.motionX = -0.35;
                }
                if (e.motionY > 0.35) {
                    e.motionY = 0.35;
                }
                if (e.motionY < -0.35) {
                    e.motionY = -0.35;
                }
                if (e.motionZ > 0.35) {
                    e.motionZ = 0.35;
                }
                if (e.motionZ < -0.35) {
                    e.motionZ = -0.35;
                }
                Thaumcraft.proxy.crucibleBubble(player.worldObj, (float)e.posX + (player.worldObj.rand.nextFloat() - player.worldObj.rand.nextFloat()) * 0.125f, (float)e.posY + (player.worldObj.rand.nextFloat() - player.worldObj.rand.nextFloat()) * 0.125f, (float)e.posZ + (player.worldObj.rand.nextFloat() - player.worldObj.rand.nextFloat()) * 0.125f, 0.33f, 0.33f, 1.0f);
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int x, int y, int z, EntityPlayer player) {
        World world = player.worldObj;
        Block bi = world.getBlock(x, y, z);
        if (!player.isSneaking() && Utils.isWoodLog((IBlockAccess)world, x, y, z)) {
            if (!world.isRemote) {
                BlockUtils.breakFurthestBlock(world, x, y, z, bi, player, true, 10);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockBubble(x, y, z, new Color(0.33f, 0.33f, 1.0f).getRGB()), new NetworkRegistry.TargetPoint(world.provider.dimensionId, (double)x, (double)y, (double)z, 32.0));
                world.playSoundEffect((double)x, (double)y, (double)z, "thaumcraft:bubble", 0.15f, 1.0f);
            }
            itemstack.damageItem(1, (EntityLivingBase)player);
            return true;
        }
        return super.onBlockStartBreak(itemstack, x, y, z, player);
    }
}

