/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.relics;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.research.IScanEventHandler;
import thaumcraft.api.research.ScanResult;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketScannedToServer;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemThaumometer
extends Item {
    public IIcon icon;
    ScanResult startScan = null;

    public ItemThaumometer() {
        this.setMaxStackSize(1);
        this.setNoRepair();
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    public EnumRarity getRarity(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:blank");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        return this.icon;
    }

    public int getMaxItemUseDuration(ItemStack itemstack) {
        return 25;
    }

    public EnumAction getItemUseAction(ItemStack itemstack) {
        return EnumAction.none;
    }

    private ScanResult doScan(ItemStack stack, World world, EntityPlayer p, int count) {
        Entity pointedEntity = EntityUtils.getPointedEntity(p.worldObj, (Entity)p, 0.5, 10.0, 0.0f, true);
        if (pointedEntity != null) {
            ScanResult sr = new ScanResult(2, 0, 0, pointedEntity, "");
            if (ScanManager.isValidScanTarget(p, sr, "@")) {
                Thaumcraft.proxy.blockRunes(world, pointedEntity.posX - 0.5, pointedEntity.posY + (double)(pointedEntity.getEyeHeight() / 2.0f), pointedEntity.posZ - 0.5, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, (int)(pointedEntity.height * 15.0f), 0.03f);
                return sr;
            }
            return null;
        }
        MovingObjectPosition mop = this.getMovingObjectPositionFromPlayer(p.worldObj, p, true);
        if (mop != null && mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            TileEntity tile = world.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
            if (tile instanceof INode) {
                ScanResult sr = new ScanResult(3, 0, 0, null, "NODE" + ((INode)tile).getId());
                if (ScanManager.isValidScanTarget(p, sr, "@")) {
                    Thaumcraft.proxy.blockRunes(world, mop.blockX, (double)mop.blockY + 0.25, mop.blockZ, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, 15, 0.03f);
                    return sr;
                }
                return null;
            }
            Block bi = world.getBlock(mop.blockX, mop.blockY, mop.blockZ);
            if (bi != Blocks.air) {
                int md = bi.getDamageValue(world, mop.blockX, mop.blockY, mop.blockZ);
                ItemStack is = bi.getPickBlock(mop, p.worldObj, mop.blockX, mop.blockY, mop.blockZ);
                ScanResult sr = null;
                try {
                    if (is == null) {
                        is = BlockUtils.createStackedBlock(bi, md);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    sr = is == null ? new ScanResult(1, Block.getIdFromBlock((Block)bi), md, null, "") : new ScanResult(1, Item.getIdFromItem((Item)is.getItem()), is.getItemDamage(), null, "");
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (ScanManager.isValidScanTarget(p, sr, "@")) {
                    Thaumcraft.proxy.blockRunes(world, mop.blockX, (double)mop.blockY + 0.25, mop.blockZ, 0.3f + world.rand.nextFloat() * 0.7f, 0.0f, 0.3f + world.rand.nextFloat() * 0.7f, 15, 0.03f);
                    return sr;
                }
                return null;
            }
        }
        for (IScanEventHandler seh : ThaumcraftApi.scanEventhandlers) {
            ScanResult scan = seh.scanPhenomena(stack, world, p);
            if (scan == null) continue;
            return scan;
        }
        return null;
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer p) {
        ScanResult scan;
        if (world.isRemote && (scan = this.doScan(stack, world, p, 0)) != null) {
            this.startScan = scan;
        }
        p.setItemInUse(stack, this.getMaxItemUseDuration(stack));
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer p, int count) {
        if (p.worldObj.isRemote && p.getCommandSenderName() == Minecraft.getMinecraft().thePlayer.getCommandSenderName()) {
            ScanResult scan = this.doScan(stack, p.worldObj, p, count);
            if (scan != null && scan.equals(this.startScan)) {
                if (count <= 5) {
                    this.startScan = null;
                    p.stopUsingItem();
                    if (ScanManager.completeScan(p, scan, "@")) {
                        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketScannedToServer(scan, p, "@"));
                    }
                }
                if (count % 2 == 0) {
                    p.worldObj.playSound(p.posX, p.posY, p.posZ, "thaumcraft:cameraticks", 0.2f, 0.45f + p.worldObj.rand.nextFloat() * 0.1f, false);
                }
            } else {
                this.startScan = null;
            }
        }
    }

    public void onPlayerStoppedUsing(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, int par4) {
        super.onPlayerStoppedUsing(par1ItemStack, par2World, par3EntityPlayer, par4);
        this.startScan = null;
    }
}

