/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.monster.EntityFireBat;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemFocusHellbat
extends ItemFocusBasic {
    public IIcon iconOrnament;
    private static final AspectList costBase = new AspectList().add(Aspect.FIRE, 200).add(Aspect.ENTROPY, 100).add(Aspect.AIR, 100);
    private static final AspectList costBomb = new AspectList().add(Aspect.FIRE, 100).add(Aspect.ENTROPY, 200).add(Aspect.AIR, 100);
    private static final AspectList costDevil = new AspectList().add(Aspect.FIRE, 100).add(Aspect.ENTROPY, 100).add(Aspect.AIR, 100).add(Aspect.EARTH, 100);
    public static FocusUpgradeType batbombs = new FocusUpgradeType(13, new ResourceLocation("thaumcraft", "textures/foci/batbombs.png"), "focus.upgrade.batbombs.name", "focus.upgrade.batbombs.text", new AspectList().add(Aspect.ENERGY, 1).add(Aspect.TRAP, 1));
    public static FocusUpgradeType devilbats = new FocusUpgradeType(14, new ResourceLocation("thaumcraft", "textures/foci/devilbats.png"), "focus.upgrade.devilbats.name", "focus.upgrade.devilbats.text", new AspectList().add(Aspect.ARMOR, 1));
    public static FocusUpgradeType vampirebats = new FocusUpgradeType(19, new ResourceLocation("thaumcraft", "textures/foci/vampirebats.png"), "focus.upgrade.vampirebats.name", "focus.upgrade.vampirebats.text", new AspectList().add(Aspect.HUNGER, 1).add(Aspect.LIFE, 1));

    public ItemFocusHellbat() {
        this.setCreativeTab(Thaumcraft.tabTC);
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "HH" + super.getSortingHelper(itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister ir) {
        this.icon = ir.registerIcon("thaumcraft:focus_hellbat");
        this.iconOrnament = ir.registerIcon("thaumcraft:focus_hellbat_orn");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int par1, int renderPass) {
        return renderPass == 1 ? this.icon : this.iconOrnament;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    @Override
    public IIcon getOrnament(ItemStack itemstack) {
        return this.iconOrnament;
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.getItem();
        Entity pointedEntity = EntityUtils.getPointedEntity(player.worldObj, player, 32.0, EntityFireBat.class);
        double px = player.posX;
        double py = player.posY;
        double pz = player.posZ;
        py = player.boundingBox.minY + (double)(player.height / 2.0f) + 0.25;
        px -= (double)(MathHelper.cos((float)(player.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        py -= 0.05000000014901161;
        pz -= (double)(MathHelper.sin((float)(player.rotationYaw / 180.0f * 3.141593f)) * 0.16f);
        Vec3 vec3d = player.getLook(1.0f);
        px += vec3d.xCoord * 0.5;
        py += vec3d.yCoord * 0.5;
        pz += vec3d.zCoord * 0.5;
        if (pointedEntity != null && pointedEntity instanceof EntityLivingBase) {
            if (!world.isRemote) {
                if (pointedEntity instanceof EntityPlayer && !MinecraftServer.getServer().isPVPEnabled()) {
                    return itemstack;
                }
                EntityFireBat firebat = new EntityFireBat(world);
                firebat.setLocationAndAngles(px, py + (double)firebat.height, pz, player.rotationYaw, 0.0f);
                firebat.setTarget(pointedEntity);
                firebat.damBonus = wand.getFocusPotency(itemstack);
                firebat.setIsSummoned(true);
                firebat.setIsBatHanging(false);
                if (this.isUpgradedWith(wand.getFocusItem(itemstack), devilbats)) {
                    firebat.setIsDevil(true);
                }
                if (this.isUpgradedWith(wand.getFocusItem(itemstack), batbombs)) {
                    firebat.setIsExplosive(true);
                }
                if (this.isUpgradedWith(wand.getFocusItem(itemstack), vampirebats)) {
                    firebat.owner = player;
                    firebat.setIsVampire(true);
                }
                if (wand.consumeAllVis(itemstack, player, this.getVisCost(itemstack), true, false) && world.spawnEntityInWorld((Entity)firebat)) {
                    world.playAuxSFX(2004, (int)px, (int)py, (int)pz, 0);
                    world.playSoundAtEntity((Entity)firebat, "thaumcraft:ice", 0.2f, 0.95f + world.rand.nextFloat() * 0.1f);
                } else {
                    world.playSoundAtEntity((Entity)player, "thaumcraft:wandfail", 0.1f, 0.8f + world.rand.nextFloat() * 0.1f);
                }
            }
            player.swingItem();
        }
        return itemstack;
    }

    @Override
    public int getFocusColor(ItemStack itemstack) {
        return 14431746;
    }

    @Override
    public AspectList getVisCost(ItemStack itemstack) {
        return this.isUpgradedWith(itemstack, batbombs) ? costBomb : (this.isUpgradedWith(itemstack, devilbats) ? costDevil : costBase);
    }

    @Override
    public int getActivationCooldown(ItemStack focusstack) {
        return 1000;
    }

    @Override
    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack itemstack, int rank) {
        switch (rank) {
            case 1: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 2: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 3: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, batbombs, devilbats};
            }
            case 4: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
            }
            case 5: {
                return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency, vampirebats};
            }
        }
        return null;
    }

    @Override
    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return !type.equals(vampirebats) || ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "VAMPBAT");
    }
}

