/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.entities.monster.EntityMindSpider;
import thaumcraft.common.items.armor.ItemFortressArmor;
import thaumcraft.common.lib.events.EventHandlerRunic;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.misc.PacketMiscEvent;
import thaumcraft.common.lib.network.playerdata.PacketAspectPool;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.network.playerdata.PacketSyncWarp;
import thaumcraft.common.lib.network.playerdata.PacketWarpMessage;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.EntityUtils;

public class WarpEvents {
    public static void checkWarpEvent(EntityPlayer player) {
        int warp = Thaumcraft.proxy.getPlayerKnowledge().getWarpTotal(player.getCommandSenderName());
        int actualwarp = Thaumcraft.proxy.getPlayerKnowledge().getWarpPerm(player.getCommandSenderName()) + Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.getCommandSenderName());
        int warpCounter = Thaumcraft.proxy.getPlayerKnowledge().getWarpCounter(player.getCommandSenderName());
        int r = player.worldObj.rand.nextInt(100);
        if (warpCounter > 0 && (warp += WarpEvents.getWarpFromGear(player)) > 0 && (double)r <= Math.sqrt(warpCounter)) {
            warp = Math.min(100, (warp + warp + warpCounter) / 3);
            warpCounter = (int)((double)warpCounter - Math.max(5.0, Math.sqrt(warpCounter) * 2.0));
            Thaumcraft.proxy.getPlayerKnowledge().setWarpCounter(player.getCommandSenderName(), warpCounter);
            int eff = player.worldObj.rand.nextInt(warp);
            ItemStack helm = player.inventory.armorInventory[3];
            if (helm != null && helm.getItem() instanceof ItemFortressArmor && helm.hasTagCompound() && helm.stackTagCompound.hasKey("mask") && helm.stackTagCompound.getInteger("mask") == 0) {
                eff -= 2 + player.worldObj.rand.nextInt(4);
            }
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketMiscEvent(0), (EntityPlayerMP)player);
            if (eff > 0) {
                if (eff <= 4) {
                    WarpEvents.grantResearch(player, 1);
                    player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.3")));
                } else if (eff > 8) {
                    if (eff <= 12) {
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.11")));
                    } else if (eff <= 16) {
                        PotionEffect pe = new PotionEffect(Config.potionVisExhaustID, 5000, Math.min(3, warp / 15), true);
                        pe.getCurativeItems().clear();
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.1")));
                    } else if (eff <= 20) {
                        PotionEffect pe = new PotionEffect(Config.potionThaumarhiaID, Math.min(32000, 10 * warp), 0, true);
                        pe.getCurativeItems().clear();
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.15")));
                    } else if (eff <= 24) {
                        PotionEffect pe = new PotionEffect(Config.potionUnHungerID, 5000, Math.min(3, warp / 15), true);
                        pe.getCurativeItems().clear();
                        pe.addCurativeItem(new ItemStack(Items.rotten_flesh));
                        pe.addCurativeItem(new ItemStack(ConfigItems.itemZombieBrain));
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.2")));
                    } else if (eff <= 28) {
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.12")));
                    } else if (eff <= 32) {
                        WarpEvents.spawnMist(player, warp, 1);
                    } else if (eff <= 36) {
                        try {
                            player.addPotionEffect(new PotionEffect(Config.potionBlurredID, Math.min(32000, 10 * warp), 0, true));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (eff <= 40) {
                        PotionEffect pe = new PotionEffect(Config.potionSunScornedID, 5000, Math.min(3, warp / 15), true);
                        pe.getCurativeItems().clear();
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.5")));
                    } else if (eff <= 44) {
                        try {
                            player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, 1200, Math.min(3, warp / 15), true));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.9")));
                    } else if (eff <= 48) {
                        PotionEffect pe = new PotionEffect(Config.potionInfVisExhaustID, 6000, Math.min(3, warp / 15), false);
                        pe.getCurativeItems().clear();
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.1")));
                    } else if (eff <= 52) {
                        player.addPotionEffect(new PotionEffect(Potion.nightVision.id, Math.min(40 * warp, 6000), 0, true));
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.10")));
                    } else if (eff <= 56) {
                        PotionEffect pe = new PotionEffect(Config.potionDeathGazeID, 6000, Math.min(3, warp / 15), true);
                        pe.getCurativeItems().clear();
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.4")));
                    } else if (eff <= 60) {
                        WarpEvents.suddenlySpiders(player, warp, false);
                    } else if (eff <= 64) {
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.13")));
                    } else if (eff <= 68) {
                        WarpEvents.spawnMist(player, warp, warp / 30);
                    } else if (eff <= 72) {
                        try {
                            player.addPotionEffect(new PotionEffect(Potion.blindness.id, Math.min(32000, 5 * warp), 0, true));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (eff == 76) {
                        if (Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.getCommandSenderName()) > 0) {
                            Thaumcraft.proxy.getPlayerKnowledge().addWarpSticky(player.getCommandSenderName(), -1);
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 1), (EntityPlayerMP)player);
                            PacketHandler.INSTANCE.sendTo((IMessage)new PacketWarpMessage(player, 1, -1), (EntityPlayerMP)player);
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.14")));
                    } else if (eff <= 80) {
                        PotionEffect pe = new PotionEffect(Config.potionUnHungerID, 6000, Math.min(3, warp / 15), true);
                        pe.getCurativeItems().clear();
                        pe.addCurativeItem(new ItemStack(Items.rotten_flesh));
                        pe.addCurativeItem(new ItemStack(ConfigItems.itemZombieBrain));
                        try {
                            player.addPotionEffect(pe);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.2")));
                    } else if (eff <= 84) {
                        WarpEvents.grantResearch(player, warp / 10);
                        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.3")));
                    } else if (eff > 88) {
                        if (eff <= 92) {
                            WarpEvents.suddenlySpiders(player, warp, true);
                        } else {
                            WarpEvents.spawnMist(player, warp, warp / 15);
                        }
                    }
                }
            }
            if (actualwarp > 10 && !ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "BATHSALTS") && !ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "@BATHSALTS")) {
                player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.8")));
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("@BATHSALTS"), (EntityPlayerMP)player);
                Thaumcraft.proxy.getResearchManager().completeResearch(player, "@BATHSALTS");
            }
            if (actualwarp > 25 && !ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "ELDRITCHMINOR")) {
                WarpEvents.grantResearch(player, 10);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("ELDRITCHMINOR"), (EntityPlayerMP)player);
                Thaumcraft.proxy.getResearchManager().completeResearch(player, "ELDRITCHMINOR");
            }
            if (actualwarp > 50 && !ThaumcraftApiHelper.isResearchComplete(player.getCommandSenderName(), "ELDRITCHMAJOR")) {
                WarpEvents.grantResearch(player, 20);
                PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("ELDRITCHMAJOR"), (EntityPlayerMP)player);
                Thaumcraft.proxy.getResearchManager().completeResearch(player, "ELDRITCHMAJOR");
            }
        }
        Thaumcraft.proxy.getPlayerKnowledge().addWarpTemp(player.getCommandSenderName(), -1);
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSyncWarp(player, 2), (EntityPlayerMP)player);
    }

    private static void spawnMist(EntityPlayer player, int warp, int guardian) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketMiscEvent(1), (EntityPlayerMP)player);
        if (guardian > 0) {
            guardian = Math.min(8, guardian);
            for (int a = 0; a < guardian; ++a) {
                WarpEvents.spawnGuardian(player);
            }
        }
        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.6")));
    }

    private static void grantResearch(EntityPlayer player, int times) {
        int amt = 1 + player.worldObj.rand.nextInt(times);
        for (int a = 0; a < amt; ++a) {
            Aspect aspect = Aspect.getPrimalAspects().get(player.worldObj.rand.nextInt(6));
            Thaumcraft.proxy.playerKnowledge.addAspectPool(player.getCommandSenderName(), aspect, (short)1);
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketAspectPool(aspect.getTag(), (short)1, Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(player.getCommandSenderName(), aspect)), (EntityPlayerMP)player);
        }
        ResearchManager.scheduleSave(player);
    }

    private static void spawnGuardian(EntityPlayer player) {
        EntityEldritchGuardian eg = new EntityEldritchGuardian(player.worldObj);
        int i = MathHelper.floor_double((double)player.posX);
        int j = MathHelper.floor_double((double)player.posY);
        int k = MathHelper.floor_double((double)player.posZ);
        for (int l = 0; l < 50; ++l) {
            int k1;
            int j1;
            int i1 = i + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1);
            if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)player.worldObj, (int)i1, (int)((j1 = j + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1)) - 1), (int)(k1 = k + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1)))) continue;
            eg.setPosition(i1, j1, k1);
            if (!player.worldObj.checkNoEntityCollision(eg.boundingBox) || !player.worldObj.getCollidingBoundingBoxes((Entity)eg, eg.boundingBox).isEmpty() || player.worldObj.isAnyLiquid(eg.boundingBox)) continue;
            eg.setTarget((Entity)player);
            eg.setAttackTarget((EntityLivingBase)player);
            player.worldObj.spawnEntityInWorld((Entity)eg);
            break;
        }
    }

    private static void suddenlySpiders(EntityPlayer player, int warp, boolean real) {
        int spawns = Math.min(50, warp);
        for (int a = 0; a < spawns; ++a) {
            EntityMindSpider spider = new EntityMindSpider(player.worldObj);
            int i = MathHelper.floor_double((double)player.posX);
            int j = MathHelper.floor_double((double)player.posY);
            int k = MathHelper.floor_double((double)player.posZ);
            boolean success = false;
            for (int l = 0; l < 50; ++l) {
                int k1;
                int j1;
                int i1 = i + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1);
                if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)player.worldObj, (int)i1, (int)((j1 = j + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1)) - 1), (int)(k1 = k + MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)7, (int)24) * MathHelper.getRandomIntegerInRange((Random)player.worldObj.rand, (int)-1, (int)1)))) continue;
                spider.setPosition(i1, j1, k1);
                if (!player.worldObj.checkNoEntityCollision(spider.boundingBox) || !player.worldObj.getCollidingBoundingBoxes((Entity)spider, spider.boundingBox).isEmpty() || player.worldObj.isAnyLiquid(spider.boundingBox)) continue;
                success = true;
                break;
            }
            if (!success) continue;
            spider.setTarget((Entity)player);
            spider.setAttackTarget((EntityLivingBase)player);
            if (!real) {
                spider.setViewer(player.getCommandSenderName());
                spider.setHarmless(true);
            }
            player.worldObj.spawnEntityInWorld((Entity)spider);
        }
        player.addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7o" + StatCollector.translateToLocal((String)"warp.text.7")));
    }

    public static void checkDeathGaze(EntityPlayer player) {
        PotionEffect pe = player.getActivePotionEffect(Potion.potionTypes[Config.potionDeathGazeID]);
        if (pe == null) {
            return;
        }
        int level = pe.getAmplifier();
        int range = Math.min(8 + level * 3, 24);
        List list = player.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)player, player.boundingBox.expand((double)range, (double)range, (double)range));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!entity.canBeCollidedWith() || !(entity instanceof EntityLivingBase) || !((EntityLivingBase)entity).isEntityAlive() || !EntityUtils.isVisibleTo(0.75f, (Entity)player, entity, range) || entity == null || !player.canEntityBeSeen(entity) || entity instanceof EntityPlayer && !MinecraftServer.getServer().isPVPEnabled() || ((EntityLivingBase)entity).isPotionActive(Potion.wither.getId())) continue;
            ((EntityLivingBase)entity).setRevengeTarget((EntityLivingBase)player);
            ((EntityLivingBase)entity).setLastAttacker((Entity)player);
            if (entity instanceof EntityCreature) {
                ((EntityCreature)entity).setTarget((Entity)player);
            }
            ((EntityLivingBase)entity).addPotionEffect(new PotionEffect(Potion.wither.getId(), 80));
        }
    }

    private static int getWarpFromGear(EntityPlayer player) {
        int w = EventHandlerRunic.getFinalWarp(player.getCurrentEquippedItem(), player);
        for (int a = 0; a < 4; ++a) {
            w += EventHandlerRunic.getFinalWarp(player.inventory.armorItemInSlot(a), player);
        }
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        for (int a = 0; a < 4; ++a) {
            w += EventHandlerRunic.getFinalWarp(baubles.getStackInSlot(a), player);
        }
        return w;
    }
}

