/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import com.google.common.io.Files;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import thaumcraft.api.IRepairable;
import thaumcraft.api.IRepairableExtended;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.damagesource.DamageSourceThaumcraft;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.monster.EntityBrainyZombie;
import thaumcraft.common.entities.monster.EntityTaintChicken;
import thaumcraft.common.entities.monster.EntityTaintCow;
import thaumcraft.common.entities.monster.EntityTaintCreeper;
import thaumcraft.common.entities.monster.EntityTaintPig;
import thaumcraft.common.entities.monster.EntityTaintSheep;
import thaumcraft.common.entities.monster.EntityTaintVillager;
import thaumcraft.common.entities.monster.EntityThaumicSlime;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityPrimalArrow;
import thaumcraft.common.items.ItemBathSalts;
import thaumcraft.common.items.ItemCrystalEssence;
import thaumcraft.common.items.armor.Hover;
import thaumcraft.common.items.armor.ItemHoverHarness;
import thaumcraft.common.items.equipment.ItemBowBone;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.WarpEvents;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.lib.world.dim.Cell;
import thaumcraft.common.lib.world.dim.CellLoc;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.TileOwned;

public class EventHandlerEntity {
    public HashMap<Integer, Float> prevStep = new HashMap();
    public static HashMap<String, ArrayList<WeakReference<Entity>>> linkedEntities = new HashMap();

    @SubscribeEvent
    public void droppedItem(ItemTossEvent event) {
        NBTTagCompound itemData = event.entityItem.getEntityData();
        itemData.setString("thrower", event.player.getCommandSenderName());
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        EntityPlayer p = event.entityPlayer;
        Thaumcraft.proxy.getPlayerKnowledge().wipePlayerKnowledge(p.getCommandSenderName());
        File file1 = this.getPlayerFile("thaum", event.playerDirectory, p.getCommandSenderName());
        boolean legacy = false;
        if (!file1.exists()) {
            File filep = event.getPlayerFile("thaum");
            if (filep.exists()) {
                try {
                    Files.copy((File)filep, (File)file1);
                    Thaumcraft.log.info("Using and converting UUID Thaumcraft savefile for " + p.getCommandSenderName());
                    legacy = true;
                    filep.delete();
                    File fb = event.getPlayerFile("thaumback");
                    if (fb.exists()) {
                        fb.delete();
                    }
                }
                catch (IOException e) {}
            } else {
                File filet = this.getLegacyPlayerFile(p);
                if (filet.exists()) {
                    try {
                        Files.copy((File)filet, (File)file1);
                        Thaumcraft.log.info("Using pre MC 1.7.10 Thaumcraft savefile for " + p.getCommandSenderName());
                        legacy = true;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        ResearchManager.loadPlayerData(p, file1, this.getPlayerFile("thaumback", event.playerDirectory, p.getCommandSenderName()), legacy);
        Collection<ResearchCategoryList> rc = ResearchCategories.researchCategories.values();
        for (ResearchCategoryList cat : rc) {
            Collection<ResearchItem> res = cat.research.values();
            for (ResearchItem ri : res) {
                if (!ri.isAutoUnlock()) continue;
                Thaumcraft.proxy.getResearchManager().completeResearch(p, ri.key);
            }
        }
    }

    public File getLegacyPlayerFile(EntityPlayer player) {
        try {
            File playersDirectory = new File(player.worldObj.getSaveHandler().getWorldDirectory(), "players");
            return new File(playersDirectory, player.getCommandSenderName() + ".thaum");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public File getPlayerFile(String suffix, File playerDirectory, String playername) {
        if ("dat".equals(suffix)) {
            throw new IllegalArgumentException("The suffix 'dat' is reserved");
        }
        return new File(playerDirectory, playername + "." + suffix);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        EntityPlayer p = event.entityPlayer;
        ResearchManager.savePlayerData(p, this.getPlayerFile("thaum", event.playerDirectory, p.getCommandSenderName()), this.getPlayerFile("thaumback", event.playerDirectory, p.getCommandSenderName()));
    }

    public static void doRepair(ItemStack is, EntityPlayer player) {
        AspectList cost;
        int level = EnchantmentHelper.getEnchantmentLevel((int)Config.enchRepair.effectId, (ItemStack)is);
        if (level <= 0) {
            return;
        }
        if (level > 2) {
            level = 2;
        }
        if ((cost = ThaumcraftCraftingManager.getObjectTags(is)) == null || cost.size() == 0) {
            return;
        }
        cost = ResearchManager.reduceToPrimals(cost);
        AspectList finalCost = new AspectList();
        for (Aspect a : cost.getAspects()) {
            if (a == null) continue;
            finalCost.merge(a, (int)Math.sqrt(cost.getAmount(a) * 2) * level);
        }
        if (is.getItem() instanceof IRepairableExtended) {
            if (((IRepairableExtended)is.getItem()).doRepair(is, player, level) && WandManager.consumeVisFromInventory(player, finalCost)) {
                is.damageItem(-level, (EntityLivingBase)player);
            }
        } else if (WandManager.consumeVisFromInventory(player, finalCost)) {
            is.damageItem(-level, (EntityLivingBase)player);
        }
    }

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        EntityMob mob;
        int t;
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (event.entity.worldObj.provider.dimensionId == Config.dimensionOuterId && !player.capabilities.isCreativeMode && player.ticksExisted % 20 == 0 && (player.capabilities.isFlying || Hover.getHover(player.getEntityId()))) {
                player.capabilities.isFlying = false;
                Hover.setHover(player.getEntityId(), false);
                player.addChatMessage((IChatComponent)new ChatComponentText(EnumChatFormatting.ITALIC + "" + EnumChatFormatting.GRAY + StatCollector.translateToLocal((String)"tc.break.fly")));
            }
            if (Hover.getHover(player.getEntityId()) && (player.inventory.armorItemInSlot(2) == null || !(player.inventory.armorItemInSlot(2).getItem() instanceof ItemHoverHarness))) {
                Hover.setHover(player.getEntityId(), false);
                player.capabilities.isFlying = false;
            }
            if (!event.entity.worldObj.isRemote) {
                if (!Config.wuss && player.ticksExisted > 0 && player.ticksExisted % 2000 == 0 && !player.isPotionActive(Config.potionWarpWardID)) {
                    WarpEvents.checkWarpEvent(player);
                }
                if (player.ticksExisted % 10 == 0 && player.isPotionActive(Config.potionDeathGazeID)) {
                    WarpEvents.checkDeathGaze(player);
                }
                if (player.ticksExisted % 40 == 0) {
                    ItemStack is;
                    int a = 0;
                    while (true) {
                        EntityPlayer entityPlayer = player;
                        if (a >= entityPlayer.inventory.getHotbarSize()) break;
                        if (player.inventory.mainInventory[a] != null && (is = player.inventory.mainInventory[a]).getItemDamage() > 0 && is.getItem() instanceof IRepairable && !player.capabilities.isCreativeMode && !(is.getItem() instanceof ItemHoverHarness)) {
                            EventHandlerEntity.doRepair(is, player);
                        }
                        ++a;
                    }
                    for (a = 0; a < 4; ++a) {
                        if (player.inventory.armorItemInSlot(a) == null || (is = player.inventory.armorItemInSlot(a)).getItemDamage() <= 0 || !(is.getItem() instanceof IRepairable) || player.capabilities.isCreativeMode) continue;
                        EventHandlerEntity.doRepair(is, player);
                    }
                }
            }
            this.updateSpeed(player);
            if (player.worldObj.isRemote && (player.isSneaking() || player.inventory.armorItemInSlot(0) == null || player.inventory.armorItemInSlot(0).getItem() != ConfigItems.itemBootsTraveller) && this.prevStep.containsKey(player.getEntityId())) {
                player.stepHeight = this.prevStep.get(player.getEntityId()).floatValue();
                this.prevStep.remove(player.getEntityId());
            }
        }
        if (event.entity instanceof EntityMob && !event.entity.isDead && (t = (int)(mob = (EntityMob)event.entity).getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue()) >= 0 && ChampionModifier.mods[t].type == 0) {
            ChampionModifier.mods[t].effect.performEffect((EntityLivingBase)mob, null, null, 0.0f);
        }
    }

    private void updateSpeed(EntityPlayer player) {
        try {
            int haste;
            if (!player.capabilities.isFlying && player.inventory.armorItemInSlot(0) != null && player.moveForward > 0.0f && (haste = EnchantmentHelper.getEnchantmentLevel((int)Config.enchHaste.effectId, (ItemStack)player.inventory.armorItemInSlot(0))) > 0) {
                float bonus = (float)haste * 0.015f;
                if (player.isAirBorne) {
                    bonus /= 2.0f;
                }
                if (player.isInWater()) {
                    bonus /= 2.0f;
                }
                player.moveFlying(0.0f, 1.0f, bonus);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void playerJumps(LivingEvent.LivingJumpEvent event) {
        if (event.entity instanceof EntityPlayer && ((EntityPlayer)event.entity).inventory.armorItemInSlot(0) != null && ((EntityPlayer)event.entity).inventory.armorItemInSlot(0).getItem() == ConfigItems.itemBootsTraveller) {
            event.entityLiving.motionY += (double)0.275f;
        }
    }

    @SubscribeEvent
    public void playerInteract(EntityInteractEvent event) {
        if (event.target instanceof EntityGolemBase && ((EntityGolemBase)event.target).getOwnerName().length() > 0 && !((EntityGolemBase)event.target).getOwnerName().equals(event.entityPlayer.getCommandSenderName())) {
            if (!event.entityPlayer.worldObj.isRemote) {
                event.entityPlayer.addChatMessage((IChatComponent)new ChatComponentTranslation("You are not my Master!", new Object[0]));
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void entitySpawns(EntityJoinWorldEvent event) {
        if (!event.world.isRemote) {
            EntityMob mob;
            if (event.entity instanceof EntityEnderPearl) {
                int x = MathHelper.floor_double((double)event.entity.posX);
                int y = MathHelper.floor_double((double)event.entity.posY);
                int z = MathHelper.floor_double((double)event.entity.posZ);
                block0: for (int xx = -5; xx <= 5; ++xx) {
                    for (int yy = -5; yy <= 5; ++yy) {
                        for (int zz = -5; zz <= 5; ++zz) {
                            TileEntity tile = event.world.getTileEntity(x + xx, y + yy, z + zz);
                            if (tile == null || !(tile instanceof TileOwned)) continue;
                            if (((EntityEnderPearl)event.entity).getThrower() instanceof EntityPlayer) {
                                ((EntityPlayer)((EntityEnderPearl)event.entity).getThrower()).addChatMessage((IChatComponent)new ChatComponentText("\u00a75\u00a7oThe magic of a nearby warded object destroys the ender pearl."));
                            }
                            event.entity.setDead();
                            break block0;
                        }
                    }
                }
            }
            if (event.entity instanceof EntityPlayer) {
                ArrayList<WeakReference<Entity>> dudes = linkedEntities.get(event.entity.getCommandSenderName());
                if (dudes != null) {
                    for (WeakReference<Entity> dude : dudes) {
                        if (dude.get() == null || ((Entity)dude.get()).timeUntilPortal != 0) continue;
                        ((Entity)dude.get()).timeUntilPortal = ((Entity)dude.get()).getPortalCooldown();
                        ((Entity)dude.get()).travelToDimension(event.world.provider.dimensionId);
                    }
                }
            } else if (event.entity instanceof EntityMob && (mob = (EntityMob)event.entity).getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue() < -1.0) {
                BiomeGenBase bg;
                int c = event.world.rand.nextInt(100);
                if (event.world.difficultySetting == EnumDifficulty.EASY || !Config.championMobs) {
                    c += 2;
                }
                if (event.world.difficultySetting == EnumDifficulty.HARD) {
                    c -= Config.championMobs ? 2 : 0;
                }
                if (event.world.provider.dimensionId == Config.dimensionOuterId) {
                    c -= 3;
                }
                if (BiomeDictionary.isBiomeOfType((BiomeGenBase)(bg = mob.worldObj.getBiomeGenForCoords(MathHelper.ceiling_double_int((double)mob.posX), MathHelper.ceiling_double_int((double)mob.posZ))), (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bg, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)bg, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                    c -= Config.championMobs ? 2 : 1;
                }
                if (this.isDangerousLocation(mob.worldObj, MathHelper.ceiling_double_int((double)mob.posX), MathHelper.ceiling_double_int((double)mob.posY), MathHelper.ceiling_double_int((double)mob.posZ))) {
                    c -= Config.championMobs ? 10 : 3;
                }
                int cc = 0;
                boolean whitelisted = false;
                for (Class clazz : ConfigEntities.championModWhitelist.keySet()) {
                    if (!clazz.isAssignableFrom(event.entity.getClass())) continue;
                    whitelisted = true;
                    if (!Config.championMobs && !(event.entity instanceof EntityThaumcraftBoss)) continue;
                    cc = Math.max(cc, ConfigEntities.championModWhitelist.get(clazz) - 1);
                }
                if (whitelisted && (c -= cc) <= 0 && mob.getEntityAttribute(SharedMonsterAttributes.maxHealth).getBaseValue() >= 10.0) {
                    EntityUtils.makeChampion(mob, false);
                } else {
                    IAttributeInstance modai = mob.getEntityAttribute(EntityUtils.CHAMPION_MOD);
                    modai.removeModifier(ChampionModifier.ATTRIBUTE_MOD_NONE);
                    modai.applyModifier(ChampionModifier.ATTRIBUTE_MOD_NONE);
                }
            }
        }
    }

    private boolean isDangerousLocation(World world, int x, int y, int z) {
        int zz;
        int xx;
        Cell c;
        return world.provider.dimensionId == Config.dimensionOuterId && (c = MazeHandler.getFromHashMap(new CellLoc(xx = x >> 4, zz = z >> 4))) != null && (c.feature == 6 || c.feature == 8);
    }

    @SubscribeEvent
    public void entityConstuct(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityMob) {
            EntityMob mob = (EntityMob)event.entity;
            mob.getAttributeMap().registerAttribute(EntityUtils.CHAMPION_MOD).setBaseValue(-2.0);
        }
    }

    @SubscribeEvent
    public void itemPickup(EntityItemPickupEvent event) {
        if (event.entityPlayer.getCommandSenderName().startsWith("FakeThaumcraft")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        AspectList aspects;
        boolean fakeplayer;
        boolean bl = fakeplayer = event.source.getEntity() != null && event.source.getEntity() instanceof FakePlayer;
        if (!event.entity.worldObj.isRemote && event.recentlyHit && !fakeplayer && event.entity instanceof EntityMob && !(event.entity instanceof EntityThaumcraftBoss) && ((EntityMob)event.entity).getEntityAttribute(EntityUtils.CHAMPION_MOD).getAttributeValue() >= 0.0) {
            int j;
            for (int i = 5 + event.entity.worldObj.rand.nextInt(3); i > 0; i -= j) {
                j = EntityXPOrb.getXPSplit((int)i);
                event.entity.worldObj.spawnEntityInWorld((Entity)new EntityXPOrb(event.entity.worldObj, event.entity.posX, event.entity.posY, event.entity.posZ, j));
            }
            int lb = Math.min(2, MathHelper.floor_float((float)((float)(event.entity.worldObj.rand.nextInt(9) + event.lootingLevel) / 5.0f)));
            event.drops.add(new EntityItem(event.entity.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)event.entityLiving.getEyeHeight(), event.entityLiving.posZ, new ItemStack(ConfigItems.itemLootbag, 1, lb)));
        }
        if (event.entityLiving instanceof EntityZombie && !(event.entityLiving instanceof EntityBrainyZombie) && event.recentlyHit && event.entity.worldObj.rand.nextInt(10) - event.lootingLevel < 1) {
            event.drops.add(new EntityItem(event.entity.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)event.entityLiving.getEyeHeight(), event.entityLiving.posZ, new ItemStack(ConfigItems.itemZombieBrain)));
        }
        if (event.entityLiving instanceof EntityVillager && event.entity.worldObj.rand.nextInt(10) - event.lootingLevel < 1) {
            event.drops.add(new EntityItem(event.entity.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)event.entityLiving.getEyeHeight(), event.entityLiving.posZ, new ItemStack(ConfigItems.itemResource, 1, 18)));
        }
        if (event.source == DamageSourceThaumcraft.dissolve && (aspects = ScanManager.generateEntityAspects((Entity)event.entityLiving)) != null && aspects.size() > 0) {
            for (Aspect aspect : aspects.getAspects()) {
                if (event.entity.worldObj.rand.nextBoolean()) continue;
                int size = 1 + event.entity.worldObj.rand.nextInt(aspects.getAmount(aspect));
                size = Math.max(1, size / 2);
                ItemStack stack = new ItemStack(ConfigItems.itemCrystalEssence, size, 0);
                ((ItemCrystalEssence)stack.getItem()).setAspects(stack, new AspectList().add(aspect, 1));
                event.drops.add(new EntityItem(event.entity.worldObj, event.entityLiving.posX, event.entityLiving.posY + (double)event.entityLiving.getEyeHeight(), event.entityLiving.posZ, stack));
            }
        }
    }

    @SubscribeEvent
    public void livingTick(LivingDeathEvent event) {
        AspectList aspectsCompound;
        if (!event.entityLiving.worldObj.isRemote && !(event.entityLiving instanceof ITaintedMob) && event.entityLiving.isPotionActive(Config.potionTaintPoisonID)) {
            EntityMob entity = null;
            if (event.entityLiving instanceof EntityCreeper) {
                entity = new EntityTaintCreeper(event.entityLiving.worldObj);
            } else if (event.entityLiving instanceof EntitySheep) {
                entity = new EntityTaintSheep(event.entityLiving.worldObj);
            } else if (event.entityLiving instanceof EntityCow) {
                entity = new EntityTaintCow(event.entityLiving.worldObj);
            } else if (event.entityLiving instanceof EntityPig) {
                entity = new EntityTaintPig(event.entityLiving.worldObj);
            } else if (event.entityLiving instanceof EntityChicken) {
                entity = new EntityTaintChicken(event.entityLiving.worldObj);
            } else if (event.entityLiving instanceof EntityVillager) {
                entity = new EntityTaintVillager(event.entityLiving.worldObj);
            } else {
                entity = new EntityThaumicSlime(event.entityLiving.worldObj);
                if (entity != null) {
                    ((EntityThaumicSlime)entity).setSlimeSize((int)(1.0f + Math.min(event.entityLiving.getMaxHealth() / 10.0f, 6.0f)));
                }
            }
            if (entity != null) {
                entity.setLocationAndAngles(event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, event.entityLiving.rotationYaw, 0.0f);
                event.entityLiving.worldObj.spawnEntityInWorld((Entity)entity);
                event.entityLiving.setDead();
            }
        } else if (!event.entityLiving.worldObj.isRemote && EntityUtils.getRecentlyHit(event.entityLiving) > 0 && (aspectsCompound = ScanManager.generateEntityAspects((Entity)event.entityLiving)) != null && aspectsCompound.size() > 0) {
            AspectList aspects = ResearchManager.reduceToPrimals(aspectsCompound);
            for (Aspect aspect : aspects.getAspects()) {
                if (!event.entityLiving.worldObj.rand.nextBoolean()) continue;
                EntityAspectOrb orb = new EntityAspectOrb(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, aspect, 1 + event.entityLiving.worldObj.rand.nextInt(aspects.getAmount(aspect)));
                event.entityLiving.worldObj.spawnEntityInWorld((Entity)orb);
            }
        }
    }

    @SubscribeEvent
    public void bowNocked(ArrowNockEvent event) {
        if (event.entityPlayer.inventory.hasItem(ConfigItems.itemPrimalArrow)) {
            event.entityPlayer.setItemInUse(event.result, event.result.getItem().getMaxItemUseDuration(event.result));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bowShot(ArrowLooseEvent event) {
        if (event.entityPlayer.inventory.hasItem(ConfigItems.itemPrimalArrow)) {
            float f = 0.0f;
            float dam = 2.0f;
            if (event.bow.getItem() instanceof ItemBowBone) {
                f = (float)event.charge / 10.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
                dam = 2.5f;
            } else {
                f = (float)event.charge / 20.0f;
                if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                    return;
                }
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            int type = 0;
            for (int j = 0; j < event.entityPlayer.inventory.mainInventory.length; ++j) {
                if (event.entityPlayer.inventory.mainInventory[j] == null || event.entityPlayer.inventory.mainInventory[j].getItem() != ConfigItems.itemPrimalArrow) continue;
                type = event.entityPlayer.inventory.mainInventory[j].getItemDamage();
                break;
            }
            EntityPrimalArrow entityarrow = new EntityPrimalArrow(event.entityPlayer.worldObj, (EntityLivingBase)event.entityPlayer, f * dam, type);
            if (event.bow.getItem() instanceof ItemBowBone) {
                entityarrow.setDamage(entityarrow.getDamage() + 0.5);
            } else if (f == 1.0f) {
                entityarrow.setIsCritical(true);
            }
            int k = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.power.effectId, (ItemStack)event.bow);
            if (k > 0) {
                entityarrow.setDamage(entityarrow.getDamage() + (double)k * 0.5 + 0.5);
            }
            int l = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.punch.effectId, (ItemStack)event.bow);
            if (type == 3) {
                ++l;
            }
            if (l > 0) {
                entityarrow.setKnockbackStrength(l);
            }
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.flame.effectId, (ItemStack)event.bow) > 0) {
                entityarrow.setFire(100);
            }
            event.bow.damageItem(1, (EntityLivingBase)event.entityPlayer);
            event.entityPlayer.worldObj.playSoundAtEntity((Entity)event.entityPlayer, "random.bow", 1.0f, 1.0f / (event.entityPlayer.worldObj.rand.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            boolean flag = false;
            if (EnchantmentHelper.getEnchantmentLevel((int)Enchantment.infinity.effectId, (ItemStack)event.bow) > 0 && event.entityPlayer.worldObj.rand.nextFloat() < 0.33f) {
                flag = true;
            }
            if (!event.entityPlayer.capabilities.isCreativeMode || !flag) {
                InventoryUtils.consumeInventoryItem(event.entityPlayer, ConfigItems.itemPrimalArrow, type);
            }
            if (!event.entityPlayer.worldObj.isRemote) {
                event.entityPlayer.worldObj.spawnEntityInWorld((Entity)entityarrow);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void finishedUsingItem(PlayerUseItemEvent.Finish event) {
        if (!event.entity.worldObj.isRemote && event.entityPlayer.isPotionActive(Config.potionUnHungerID)) {
            if (event.item.isItemEqual(new ItemStack(Items.rotten_flesh)) || event.item.isItemEqual(new ItemStack(ConfigItems.itemZombieBrain))) {
                PotionEffect pe = event.entityPlayer.getActivePotionEffect(Potion.potionTypes[Config.potionUnHungerID]);
                int amp = pe.getAmplifier() - 1;
                int duration = pe.getDuration() - 600;
                event.entityPlayer.removePotionEffect(Config.potionUnHungerID);
                if (duration > 0 && amp >= 0) {
                    pe = new PotionEffect(Config.potionUnHungerID, duration, amp, true);
                    pe.getCurativeItems().clear();
                    pe.addCurativeItem(new ItemStack(Items.rotten_flesh));
                    event.entityPlayer.addPotionEffect(pe);
                }
                event.entityPlayer.addChatMessage((IChatComponent)new ChatComponentText("\u00a72\u00a7o" + StatCollector.translateToLocal((String)"warp.text.hunger.2")));
            } else if (event.item.getItem() instanceof ItemFood) {
                event.entityPlayer.addChatMessage((IChatComponent)new ChatComponentText("\u00a74\u00a7o" + StatCollector.translateToLocal((String)"warp.text.hunger.1")));
            }
        }
    }

    @SubscribeEvent
    public void itemExpire(ItemExpireEvent event) {
        int z;
        int y;
        int x;
        if (event.entityItem.getEntityItem() != null && event.entityItem.getEntityItem().getItem() != null && event.entityItem.getEntityItem().getItem() instanceof ItemBathSalts && event.entityItem.worldObj.getBlock(x = MathHelper.floor_double((double)event.entityItem.posX), y = MathHelper.floor_double((double)event.entityItem.posY), z = MathHelper.floor_double((double)event.entityItem.posZ)) == Blocks.water && event.entityItem.worldObj.getBlockMetadata(x, y, z) == 0) {
            event.entityItem.worldObj.setBlock(x, y, z, ConfigBlocks.blockFluidPure);
        }
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (!event.entityPlayer.onGround && Hover.getHover(event.entityPlayer.getEntityId())) {
            event.newSpeed = event.originalSpeed * 5.0f;
        }
    }
}

