/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.tiles.TileBanner;
import thaumcraft.common.tiles.TileEldritchAltar;

public class WorldGenEldritchRing
extends WorldGenerator {
    public int chunkX;
    public int chunkZ;
    public int width;
    public int height = 0;

    protected Block[] GetValidSpawnBlocks() {
        return new Block[]{Blocks.stone, Blocks.sand, Blocks.packed_ice, Blocks.grass, Blocks.gravel, Blocks.dirt};
    }

    public boolean LocationIsValidSpawn(World world, int i, int j, int k) {
        int distanceToAir = 0;
        Block checkID = world.getBlock(i, j, k);
        while (checkID != Blocks.air) {
            checkID = world.getBlock(i, j + ++distanceToAir, k);
        }
        if (distanceToAir > 2) {
            return false;
        }
        Block blockID = world.getBlock(i, j += distanceToAir - 1, k);
        Block blockIDAbove = world.getBlock(i, j + 1, k);
        Block blockIDBelow = world.getBlock(i, j - 1, k);
        for (Block x : this.GetValidSpawnBlocks()) {
            if (blockIDAbove != Blocks.air) {
                return false;
            }
            if (blockID == x) {
                return true;
            }
            if (blockID != Blocks.snow_layer && blockID != Blocks.tallgrass || blockIDBelow != x) continue;
            return true;
        }
        return false;
    }

    public boolean generate(World world, Random rand, int i, int j, int k) {
        if (!(this.LocationIsValidSpawn(world, i - 3, j, k - 3) && this.LocationIsValidSpawn(world, i, j, k) && this.LocationIsValidSpawn(world, i + 3, j, k) && this.LocationIsValidSpawn(world, i + 3, j, k + 3) && this.LocationIsValidSpawn(world, i, j, k + 3) && !MazeHandler.mazesInRange(this.chunkX, this.chunkZ, this.width, this.height))) {
            return false;
        }
        Block replaceBlock = world.getBiomeGenForCoords((int)i, (int)k).topBlock;
        for (int x = i - 3; x <= i + 3; ++x) {
            for (int z = k - 3; z <= k + 3; ++z) {
                if (!(x != i - 3 && x != i + 3 || z != k - 3 && z != k + 3)) continue;
                for (int q = -4; q < 5; ++q) {
                    Block bb = world.getBlock(x, j + q, z);
                    if (q <= 0 || bb.isReplaceable((IBlockAccess)world, x, j + q, z) || !bb.getMaterial().blocksMovement() || bb.isFoliage((IBlockAccess)world, x, j + q, z)) {
                        if (rand.nextInt(4) == 0) {
                            world.setBlock(x, j + q, z, Blocks.obsidian);
                        } else {
                            world.setBlock(x, j + q, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                        }
                    }
                    if (q <= 0) continue;
                    world.setBlockToAir(x, j + q, z);
                }
                if (x == i && z == k) {
                    world.setBlock(x, j + 1, z, ConfigBlocks.blockEldritch, 0, 3);
                    world.setBlock(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                    int r = rand.nextInt(10);
                    TileEntity te = world.getTileEntity(x, j + 1, z);
                    if (te != null && te instanceof TileEldritchAltar) {
                        switch (r) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                ((TileEldritchAltar)te).setSpawner(true);
                                ((TileEldritchAltar)te).setSpawnType((byte)0);
                                for (int a = 2; a < 6; ++a) {
                                    ForgeDirection dir = ForgeDirection.getOrientation((int)a);
                                    world.setBlock(x - dir.offsetX * 3, j + 1, z + dir.offsetZ * 3, ConfigBlocks.blockWoodenDevice, 8, 3);
                                    te = world.getTileEntity(x - dir.offsetX * 3, j + 1, z + dir.offsetZ * 3);
                                    if (te == null || !(te instanceof TileBanner)) continue;
                                    int face = 0;
                                    switch (a) {
                                        case 2: {
                                            face = 8;
                                            break;
                                        }
                                        case 3: {
                                            face = 0;
                                            break;
                                        }
                                        case 4: {
                                            face = 12;
                                            break;
                                        }
                                        case 5: {
                                            face = 4;
                                            break;
                                        }
                                    }
                                    ((TileBanner)te).setFacing((byte)face);
                                }
                                break;
                            }
                            case 6: 
                            case 7: {
                                ((TileEldritchAltar)te).setSpawner(true);
                                ((TileEldritchAltar)te).setSpawnType((byte)1);
                            }
                        }
                    }
                    world.setBlock(x, j + 3, z, ConfigBlocks.blockEldritch, 1, 3);
                    world.setBlock(x, j + 4, z, ConfigBlocks.blockEldritch, 2, 3);
                    world.setBlock(x, j + 5, z, ConfigBlocks.blockEldritch, 2, 3);
                    world.setBlock(x, j + 6, z, ConfigBlocks.blockEldritch, 2, 3);
                    world.setBlock(x, j + 7, z, ConfigBlocks.blockEldritch, 2, 3);
                    continue;
                }
                if ((x != i - 3 && x != i + 3 || Math.abs((z - k) % 2) != 1) && (z != k - 3 && z != k + 3 || Math.abs((x - i) % 2) != 1) || Math.abs(x - i) == Math.abs(z - k)) continue;
                world.setBlock(x, j, z, ConfigBlocks.blockCosmeticSolid, 1, 3);
                world.setBlock(x, j + 1, z, ConfigBlocks.blockEldritch, 3, 3);
            }
        }
        return true;
    }
}

