/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.biomes;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.entities.monster.EntityWisp;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.WorldGenBigMagicTree;
import thaumcraft.common.lib.world.WorldGenGreatwoodTrees;
import thaumcraft.common.lib.world.WorldGenManaPods;
import thaumcraft.common.lib.world.WorldGenSilverwoodTrees;

public class BiomeGenMagicalForest
extends BiomeGenBase {
    protected WorldGenBigMagicTree bigTree = new WorldGenBigMagicTree(false);
    private static final WorldGenBlockBlob blobs = new WorldGenBlockBlob(Blocks.mossy_cobblestone, 0);

    public BiomeGenMagicalForest(int par1) {
        super(par1);
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityWolf.class, 2, 1, 3));
        this.spawnableCreatureList.add(new BiomeGenBase.SpawnListEntry(EntityHorse.class, 2, 1, 3));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 3, 1, 1));
        this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityEnderman.class, 3, 1, 1));
        if (Config.spawnPech) {
            this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityPech.class, 10, 1, 2));
        }
        if (Config.spawnWisp) {
            this.spawnableMonsterList.add(new BiomeGenBase.SpawnListEntry(EntityWisp.class, 10, 1, 2));
        }
        this.theBiomeDecorator.treesPerChunk = 2;
        this.theBiomeDecorator.flowersPerChunk = 10;
        this.theBiomeDecorator.grassPerChunk = 12;
        this.theBiomeDecorator.waterlilyPerChunk = 6;
        this.theBiomeDecorator.mushroomsPerChunk = 6;
        this.setTemperatureRainfall(0.7f, 0.6f);
        this.setHeight(new BiomeGenBase.Height(0.2f, 0.2f));
        this.setBiomeName("Magical Forest");
        this.setColor(Config.blueBiome ? 0x66AACC : 6747307);
        this.flowers.clear();
        for (int x = 0; x < BlockFlower.field_149859_a.length; ++x) {
            this.addFlower((Block)Blocks.red_flower, x, 10);
        }
    }

    public WorldGenAbstractTree func_150567_a(Random par1Random) {
        return par1Random.nextInt(14) == 0 ? new WorldGenSilverwoodTrees(false, 8, 5) : (par1Random.nextInt(10) == 0 ? new WorldGenGreatwoodTrees(false) : this.bigTree);
    }

    public WorldGenerator getRandomWorldGenForGrass(Random par1Random) {
        return par1Random.nextInt(4) == 0 ? new WorldGenTallGrass((Block)Blocks.tallgrass, 2) : new WorldGenTallGrass((Block)Blocks.tallgrass, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBiomeGrassColor(int x, int y, int z) {
        return Config.blueBiome ? 0x66AACC : 5635969;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBiomeFoliageColor(int x, int y, int z) {
        return Config.blueBiome ? 0x77CCEE : 6750149;
    }

    public int getWaterColorMultiplier() {
        return 30702;
    }

    public void decorate(World world, Random random, int x, int z) {
        int k1;
        int j1;
        int i1;
        int l;
        int k = random.nextInt(3);
        for (l = 0; l < k; ++l) {
            i1 = x + random.nextInt(16) + 8;
            j1 = z + random.nextInt(16) + 8;
            k1 = world.getHeightValue(i1, j1);
            blobs.generate(world, random, i1, k1, j1);
        }
        for (k = 0; k < 4; ++k) {
            for (l = 0; l < 4; ++l) {
                i1 = x + k * 4 + 1 + 8 + random.nextInt(3);
                j1 = z + l * 4 + 1 + 8 + random.nextInt(3);
                k1 = world.getHeightValue(i1, j1);
                if (random.nextInt(40) != 0) continue;
                WorldGenBigMushroom worldgenbigmushroom = new WorldGenBigMushroom();
                worldgenbigmushroom.generate(world, random, i1, k1, j1);
            }
        }
        super.decorate(world, random, x, z);
        WorldGenManaPods worldgenpods = new WorldGenManaPods();
        for (k = 0; k < 10; ++k) {
            l = x + random.nextInt(16) + 8;
            int b0 = 64;
            i1 = z + random.nextInt(16) + 8;
            worldgenpods.generate(world, random, l, b0, i1);
        }
        for (int a = 0; a < 8; ++a) {
            int yy;
            int xx = x + random.nextInt(16);
            int zz = z + random.nextInt(16);
            for (yy = world.getHeightValue(xx, zz); yy > 50 && world.getBlock(xx, yy, zz) != Blocks.grass; --yy) {
            }
            Block l1 = world.getBlock(xx, yy, zz);
            if (l1 != Blocks.grass || !world.getBlock(xx, yy + 1, zz).isReplaceable((IBlockAccess)world, xx, yy + 1, zz) || !this.isBlockAdjacentToWood((IBlockAccess)world, xx, yy + 1, zz)) continue;
            world.setBlock(xx, yy + 1, zz, ConfigBlocks.blockCustomPlant, 5, 2);
        }
    }

    private boolean isBlockAdjacentToWood(IBlockAccess world, int x, int y, int z) {
        boolean count = false;
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                for (int zz = -1; zz <= 1; ++zz) {
                    if (xx == 0 && yy == 0 && zz == 0 || !Utils.isWoodLog(world, xx + x, yy + y, zz + z)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public BiomeGenBase createMutation() {
        return null;
    }
}

