/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.world.dim;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import thaumcraft.common.config.ConfigBlocks;

public class TeleporterThaumcraft
extends Teleporter {
    private final WorldServer worldServerInstance;
    private final Random random;
    private static final LongHashMap destinationCoordinateCache = new LongHashMap();
    private static final List destinationCoordinateKeys = new ArrayList();

    public TeleporterThaumcraft(WorldServer par1WorldServer) {
        super(par1WorldServer);
        this.worldServerInstance = par1WorldServer;
        this.random = new Random(par1WorldServer.getSeed());
    }

    public void placeInPortal(Entity par1Entity, double par2, double par4, double par6, float par8) {
        if (this.worldServerInstance.provider.dimensionId != 1) {
            if (!this.placeInExistingPortal(par1Entity, par2, par4, par6, par8)) {
                this.makePortal(par1Entity);
                this.placeInExistingPortal(par1Entity, par2, par4, par6, par8);
            }
        } else if (!this.placeInExistingPortal(par1Entity, par2, par4, par6, par8)) {
            int i = MathHelper.floor_double((double)par1Entity.posX);
            int k = MathHelper.floor_double((double)par1Entity.posZ);
            int j = this.worldServerInstance.getHeightValue(i, k);
            boolean b0 = true;
            boolean b1 = false;
            par1Entity.setLocationAndAngles((double)i, (double)j + 4.0, (double)k, par1Entity.rotationYaw, 0.0f);
            par1Entity.motionZ = 0.0;
            par1Entity.motionY = 0.0;
            par1Entity.motionX = 0.0;
        }
    }

    public boolean placeInExistingPortal(Entity par1Entity, double par2, double par4, double par6, float par8) {
        double d4;
        int short1 = 128;
        double d3 = -1.0;
        int i = 0;
        int j = 0;
        int k = 0;
        int l = MathHelper.floor_double((double)par1Entity.posX);
        int i1 = MathHelper.floor_double((double)par1Entity.posZ);
        int chunkX = l >> 4;
        int chunkZ = i1 >> 4;
        String hs = chunkX + ":" + chunkZ + ":" + this.worldServerInstance.provider.dimensionId;
        long j1 = hs.hashCode();
        boolean flag = true;
        if (destinationCoordinateCache.containsItem(j1)) {
            Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)destinationCoordinateCache.getValueByKey(j1);
            d3 = 0.0;
            i = portalposition.posX;
            j = portalposition.posY;
            k = portalposition.posZ;
            portalposition.lastUpdateTime = this.worldServerInstance.getTotalWorldTime();
            flag = false;
        } else {
            for (int k1 = l - short1; k1 <= l + short1; ++k1) {
                double d5 = (double)k1 + 0.5 - par1Entity.posX;
                for (int l1 = i1 - short1; l1 <= i1 + short1; ++l1) {
                    double d6 = (double)l1 + 0.5 - par1Entity.posZ;
                    for (int i2 = this.worldServerInstance.getActualHeight() - 1; i2 >= 0; --i2) {
                        if (this.worldServerInstance.getBlock(k1, i2, l1) != ConfigBlocks.blockEldritchPortal) continue;
                        d4 = (double)i2 + 0.5 - par1Entity.posY;
                        double d7 = d5 * d5 + d4 * d4 + d6 * d6;
                        if (!(d3 < 0.0) && !(d7 < d3)) continue;
                        d3 = d7;
                        i = k1;
                        j = i2;
                        k = l1;
                    }
                }
            }
        }
        if (d3 >= 0.0) {
            if (flag) {
                destinationCoordinateCache.add(j1, (Object)new Teleporter.PortalPosition((Teleporter)this, i, j, k, this.worldServerInstance.getTotalWorldTime()));
                destinationCoordinateKeys.add(j1);
            }
            double d8 = (double)i + 0.5 + (double)(this.worldServerInstance.rand.nextBoolean() ? 1 : -1);
            double d9 = j;
            d4 = (double)k + 0.5 + (double)(this.worldServerInstance.rand.nextBoolean() ? 1 : -1);
            par1Entity.motionZ = 0.0;
            par1Entity.motionY = 0.0;
            par1Entity.motionX = 0.0;
            par1Entity.setLocationAndAngles(d8, d9, d4, par1Entity.rotationYaw, par1Entity.rotationPitch);
            return true;
        }
        return false;
    }

    public boolean makePortal(Entity par1Entity) {
        return true;
    }

    public void removeStalePortalLocations(long par1) {
        if (par1 % 100L == 0L) {
            Iterator iterator = destinationCoordinateKeys.iterator();
            long j = par1 - 600L;
            while (iterator.hasNext()) {
                Long olong = (Long)iterator.next();
                Teleporter.PortalPosition portalposition = (Teleporter.PortalPosition)destinationCoordinateCache.getValueByKey(olong.longValue());
                if (portalposition != null && portalposition.lastUpdateTime >= j) continue;
                iterator.remove();
                destinationCoordinateCache.remove(olong.longValue());
            }
        }
    }
}

