/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;

public class TileBanner
extends TileThaumcraft {
    private byte facing = 0;
    private byte color = (byte)-1;
    private Aspect aspect = null;
    private boolean onWall = false;

    public boolean canUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 2), (double)(this.zCoord + 1));
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte face) {
        this.facing = face;
        this.markDirty();
    }

    public boolean getWall() {
        return this.onWall;
    }

    public void setWall(boolean b) {
        this.onWall = b;
        this.markDirty();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.facing = nbttagcompound.getByte("facing");
        this.setColor(nbttagcompound.getByte("color"));
        String as = nbttagcompound.getString("aspect");
        if (as != null && as.length() > 0) {
            this.setAspect(Aspect.getAspect(as));
        } else {
            this.aspect = null;
        }
        this.onWall = nbttagcompound.getBoolean("wall");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("facing", this.facing);
        nbttagcompound.setByte("color", this.getColor());
        nbttagcompound.setString("aspect", this.getAspect() == null ? "" : this.getAspect().getTag());
        nbttagcompound.setBoolean("wall", this.onWall);
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public void setAspect(Aspect aspect) {
        this.aspect = aspect;
    }

    public byte getColor() {
        return this.color;
    }

    public void setColor(byte color) {
        this.color = color;
    }
}

