/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.common.entities.monster.EntityCultist;
import thaumcraft.common.entities.monster.EntityCultistCleric;
import thaumcraft.common.entities.monster.EntityCultistKnight;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;
import thaumcraft.common.lib.world.dim.MazeHandler;
import thaumcraft.common.lib.world.dim.MazeThread;

public class TileEldritchAltar
extends TileThaumcraft {
    private boolean spawner = false;
    private boolean open = false;
    private boolean spawnedClerics = false;
    private byte spawnType = 0;
    private byte eyes = 0;
    private int counter = 0;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.setEyes(nbttagcompound.getByte("eyes"));
        this.setOpen(nbttagcompound.getBoolean("open"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("eyes", this.getEyes());
        nbttagcompound.setBoolean("open", this.isOpen());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.spawnedClerics = nbttagcompound.getBoolean("spawnedClerics");
        this.spawner = nbttagcompound.getBoolean("spawner");
        this.spawnType = nbttagcompound.getByte("spawntype");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setBoolean("spawnedClerics", this.spawnedClerics);
        nbttagcompound.setBoolean("spawner", this.spawner);
        nbttagcompound.setByte("spawntype", this.spawnType);
    }

    public double getMaxRenderDistanceSquared() {
        return 9216.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1));
    }

    public boolean isSpawner() {
        return this.spawner;
    }

    public void setSpawner(boolean spawner) {
        this.spawner = spawner;
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.isSpawner() && this.counter++ >= 80 && this.counter % 40 == 0) {
            switch (this.spawnType) {
                case 0: {
                    if (!this.spawnedClerics) {
                        this.spawnClerics();
                        break;
                    }
                    this.spawnGuards();
                    break;
                }
                case 1: {
                    this.spawnGuardian();
                }
            }
        }
    }

    private void spawnGuards() {
        List ents = this.worldObj.getEntitiesWithinAABB(EntityCultistCleric.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(24.0, 16.0, 24.0));
        if (ents.size() < 1) {
            this.setSpawner(false);
            return;
        }
        ents = this.worldObj.getEntitiesWithinAABB(EntityCultist.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(24.0, 16.0, 24.0));
        if (ents.size() < 8) {
            int k1;
            int j1;
            EntityCultistKnight eg = new EntityCultistKnight(this.worldObj);
            int i1 = this.xCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)4, (int)10) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1);
            if (World.doesBlockHaveSolidTopSurface((IBlockAccess)this.worldObj, (int)i1, (int)((j1 = this.yCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)0, (int)3) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1)) - 1), (int)(k1 = this.zCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)4, (int)10) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1)))) {
                eg.setPosition(i1, j1, k1);
                if (this.worldObj.checkNoEntityCollision(eg.boundingBox) && this.worldObj.getCollidingBoundingBoxes((Entity)eg, eg.boundingBox).isEmpty() && !this.worldObj.isAnyLiquid(eg.boundingBox)) {
                    eg.onSpawnWithEgg(null);
                    eg.spawnExplosionParticle();
                    eg.setHomeArea(this.xCoord, this.yCoord, this.zCoord, 16);
                    this.worldObj.spawnEntityInWorld((Entity)eg);
                }
            }
        }
    }

    private void spawnGuardian() {
        int k1;
        int j1;
        EntityEldritchGuardian eg = new EntityEldritchGuardian(this.worldObj);
        int i1 = this.xCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)4, (int)10) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1);
        if (World.doesBlockHaveSolidTopSurface((IBlockAccess)this.worldObj, (int)i1, (int)((j1 = this.yCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)0, (int)3) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1)) - 1), (int)(k1 = this.zCoord + MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)4, (int)10) * MathHelper.getRandomIntegerInRange((Random)this.worldObj.rand, (int)-1, (int)1)))) {
            eg.setPosition(i1, j1, k1);
            if (eg.getCanSpawnHere()) {
                eg.onSpawnWithEgg(null);
                eg.spawnExplosionParticle();
                eg.setHomeArea(this.xCoord, this.yCoord, this.zCoord, 16);
                this.worldObj.spawnEntityInWorld((Entity)eg);
            }
        }
    }

    private void spawnClerics() {
        int success = 0;
        for (int a = 0; a < 4; ++a) {
            int xx = 0;
            int zz = 0;
            switch (a) {
                case 0: {
                    xx = -2;
                    zz = -2;
                    break;
                }
                case 1: {
                    xx = -2;
                    zz = 2;
                    break;
                }
                case 2: {
                    xx = 2;
                    zz = -2;
                    break;
                }
                case 3: {
                    xx = 2;
                    zz = 2;
                }
            }
            EntityCultistCleric cleric = new EntityCultistCleric(this.worldObj);
            if (!World.doesBlockHaveSolidTopSurface((IBlockAccess)this.worldObj, (int)(this.xCoord + xx), (int)(this.yCoord - 1), (int)(this.zCoord + zz))) continue;
            cleric.setPosition((double)this.xCoord + 0.5 + (double)xx, this.yCoord, (double)this.zCoord + 0.5 + (double)zz);
            if (!this.worldObj.checkNoEntityCollision(cleric.boundingBox) || !this.worldObj.getCollidingBoundingBoxes((Entity)cleric, cleric.boundingBox).isEmpty() || this.worldObj.isAnyLiquid(cleric.boundingBox)) continue;
            cleric.setHomeArea(this.xCoord, this.yCoord, this.zCoord, 8);
            cleric.onSpawnWithEgg(null);
            cleric.spawnExplosionParticle();
            if (!this.worldObj.spawnEntityInWorld((Entity)cleric)) continue;
            ++success;
            cleric.setIsRitualist(true);
        }
        if (success > 2) {
            this.spawnedClerics = true;
            this.markDirty();
        }
    }

    public byte getSpawnType() {
        return this.spawnType;
    }

    public void setSpawnType(byte spawnType) {
        this.spawnType = spawnType;
    }

    public byte getEyes() {
        return this.eyes;
    }

    public void setEyes(byte eyes) {
        this.eyes = eyes;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public boolean checkForMaze() {
        int h;
        int w = 15 + this.worldObj.rand.nextInt(8) * 2;
        if (!MazeHandler.mazesInRange(this.xCoord >> 4, this.zCoord >> 4, w, h = 15 + this.worldObj.rand.nextInt(8) * 2)) {
            Thread t = new Thread(new MazeThread(this.xCoord >> 4, this.zCoord >> 4, w, h, this.worldObj.rand.nextLong()));
            t.start();
            return false;
        }
        return true;
    }
}

