/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.monster.EntityEldritchCrab;

public class TileEldritchCrabSpawner
extends TileThaumcraft {
    public int count = 150;
    public int ticks = 0;
    int venting = 0;
    byte facing = 0;

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.ticks == 0) {
            this.ticks = this.worldObj.rand.nextInt(500);
        }
        ++this.ticks;
        if (!this.worldObj.isRemote) {
            --this.count;
            if (this.count < 0) {
                this.count = 50 + this.worldObj.rand.nextInt(50);
            } else {
                if (this.count == 15 && this.isActivated() && !this.maxEntitiesReached()) {
                    this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, 0);
                    this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.fizz", 0.5f, 1.0f);
                }
                if (this.count <= 0 && this.isActivated() && !this.maxEntitiesReached()) {
                    this.count = 150 + this.worldObj.rand.nextInt(100);
                    this.spawnCrab();
                    this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:gore", 0.5f, 1.0f);
                }
            }
        } else if (this.venting > 0) {
            --this.venting;
            for (int a = 0; a < 3; ++a) {
                this.drawVent();
            }
        } else if (this.worldObj.rand.nextInt(20) == 0) {
            this.drawVent();
        }
    }

    void drawVent() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.facing);
        float fx = 0.15f - this.worldObj.rand.nextFloat() * 0.3f;
        float fz = 0.15f - this.worldObj.rand.nextFloat() * 0.3f;
        float fy = 0.15f - this.worldObj.rand.nextFloat() * 0.3f;
        float fx2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
        float fz2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
        float fy2 = 0.1f - this.worldObj.rand.nextFloat() * 0.2f;
        Thaumcraft.proxy.drawVentParticles(this.worldObj, (float)this.xCoord + 0.5f + fx + (float)dir.offsetX / 2.1f, (float)this.yCoord + 0.5f + fy + (float)dir.offsetY / 2.1f, (float)this.zCoord + 0.5f + fz + (float)dir.offsetZ / 2.1f, (float)dir.offsetX / 3.0f + fx2, (float)dir.offsetY / 3.0f + fy2, (float)dir.offsetZ / 3.0f + fz2, 0x9988AA, 2.0f);
    }

    public boolean receiveClientEvent(int i, int j) {
        if (i == 1) {
            this.venting = 20;
            return true;
        }
        return super.receiveClientEvent(i, j);
    }

    private boolean maxEntitiesReached() {
        List ents = this.worldObj.getEntitiesWithinAABB(EntityEldritchCrab.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)((double)this.xCoord + 1.0), (double)((double)this.yCoord + 1.0), (double)((double)this.zCoord + 1.0)).expand(32.0, 32.0, 32.0));
        return ents.size() > 5;
    }

    public boolean isActivated() {
        return this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 16.0) != null;
    }

    private void spawnCrab() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)this.facing);
        EntityEldritchCrab crab = new EntityEldritchCrab(this.worldObj);
        double x = this.xCoord + dir.offsetX;
        double y = this.yCoord + dir.offsetY;
        double z = this.zCoord + dir.offsetZ;
        crab.setLocationAndAngles(x + 0.5, y + 0.5, z + 0.5, 0.0f, 0.0f);
        crab.onSpawnWithEgg(null);
        crab.setHelm(false);
        crab.motionX = (float)dir.offsetX * 0.2f;
        crab.motionY = (float)dir.offsetY * 0.2f;
        crab.motionZ = (float)dir.offsetZ * 0.2f;
        this.worldObj.spawnEntityInWorld((Entity)crab);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)(this.yCoord - 1), (double)(this.zCoord - 1), (double)(this.xCoord + 2), (double)(this.yCoord + 2), (double)(this.zCoord + 2));
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte face) {
        this.facing = face;
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        this.markDirty();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.facing = nbttagcompound.getByte("facing");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setByte("facing", this.facing);
    }
}

