/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;

public class TileLifter
extends TileEntity {
    private int counter = 0;
    public int rangeAbove = 0;
    public boolean requiresUpdate = true;
    public boolean lastPowerState = false;

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        List targets;
        super.updateEntity();
        ++this.counter;
        if (this.requiresUpdate || this.counter % 100 == 0) {
            this.lastPowerState = this.gettingPower();
            this.requiresUpdate = false;
            int max = 10;
            int count = 1;
            while (this.worldObj.getBlock(this.xCoord, this.yCoord - count, this.zCoord) == ConfigBlocks.blockLifter && !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord - count, this.zCoord)) {
                ++count;
                max += 10;
            }
            this.rangeAbove = 0;
            while (this.rangeAbove < max && !this.worldObj.getBlock(this.xCoord, this.yCoord + 1 + this.rangeAbove, this.zCoord).isOpaqueCube()) {
                ++this.rangeAbove;
            }
        }
        if (this.rangeAbove > 0 && !this.gettingPower() && (targets = this.worldObj.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)(this.yCoord + 1), (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1 + this.rangeAbove), (double)(this.zCoord + 1)))).size() > 0) {
            for (Entity e : targets) {
                if (!(e instanceof EntityItem) && !e.canBePushed() && !(e instanceof EntityHorse)) continue;
                if (Thaumcraft.proxy.isShiftKeyDown()) {
                    if (e.motionY < 0.0) {
                        e.motionY *= (double)0.9f;
                    }
                } else if (e.motionY < (double)0.35f) {
                    e.motionY += (double)0.1f;
                }
                e.fallDistance = 0.0f;
            }
        }
    }

    public boolean gettingPower() {
        return this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) || this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord + 1, this.zCoord);
    }
}

