/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.utils.Utils;

public class TileMirrorEssentia
extends TileThaumcraft
implements IAspectSource {
    public boolean linked = false;
    public int linkX;
    public int linkY;
    public int linkZ;
    public int linkDim;
    public ForgeDirection linkedFacing = ForgeDirection.UNKNOWN;
    int count = 0;
    int inc = 40;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.linked = nbttagcompound.getBoolean("linked");
        this.linkX = nbttagcompound.getInteger("linkX");
        this.linkY = nbttagcompound.getInteger("linkY");
        this.linkZ = nbttagcompound.getInteger("linkZ");
        this.linkDim = nbttagcompound.getInteger("linkDim");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setBoolean("linked", this.linked);
        nbttagcompound.setInteger("linkX", this.linkX);
        nbttagcompound.setInteger("linkY", this.linkY);
        nbttagcompound.setInteger("linkZ", this.linkZ);
        nbttagcompound.setInteger("linkDim", this.linkDim);
    }

    public void restoreLink() {
        if (this.isDestinationValid()) {
            WorldServer targetWorld = MinecraftServer.getServer().worldServerForDimension(this.linkDim);
            if (targetWorld == null) {
                return;
            }
            TileEntity te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ);
            if (te != null && te instanceof TileMirrorEssentia) {
                TileMirrorEssentia tm = (TileMirrorEssentia)te;
                tm.linked = true;
                tm.linkX = this.xCoord;
                tm.linkY = this.yCoord;
                tm.linkZ = this.zCoord;
                tm.linkDim = this.worldObj.provider.dimensionId;
                targetWorld.markBlockForUpdate(tm.xCoord, tm.yCoord, tm.zCoord);
                this.linkedFacing = ForgeDirection.getOrientation((int)targetWorld.getBlockMetadata(this.linkX, this.linkY, this.linkZ));
                this.linked = true;
                this.markDirty();
                tm.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        }
    }

    public void invalidateLink() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return;
        }
        if (!Utils.isChunkLoaded((World)targetWorld, this.linkX, this.linkZ)) {
            return;
        }
        TileEntity te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ);
        if (te != null && te instanceof TileMirrorEssentia) {
            TileMirrorEssentia tm = (TileMirrorEssentia)te;
            tm.linked = false;
            tm.linkedFacing = ForgeDirection.UNKNOWN;
            this.markDirty();
            tm.markDirty();
            targetWorld.markBlockForUpdate(this.linkX, this.linkY, this.linkZ);
        }
    }

    public boolean isLinkValid() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            this.linked = false;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        if (!tm.linked) {
            this.linked = false;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return false;
        }
        if (tm.linkX != this.xCoord || tm.linkY != this.yCoord || tm.linkZ != this.zCoord || tm.linkDim != this.worldObj.provider.dimensionId) {
            this.linked = false;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return false;
        }
        return true;
    }

    public boolean isLinkValidSimple() {
        if (!this.linked) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        if (!tm.linked) {
            return false;
        }
        return tm.linkX == this.xCoord && tm.linkY == this.yCoord && tm.linkZ == this.zCoord && tm.linkDim == this.worldObj.provider.dimensionId;
    }

    public boolean isDestinationValid() {
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (targetWorld == null) {
            return false;
        }
        TileEntity te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ);
        if (te == null || !(te instanceof TileMirrorEssentia)) {
            this.linked = false;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            return false;
        }
        TileMirrorEssentia tm = (TileMirrorEssentia)te;
        return !tm.isLinkValid();
    }

    @Override
    public AspectList getAspects() {
        return null;
    }

    @Override
    public void setAspects(AspectList aspects) {
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return false;
    }

    @Override
    public int addToContainer(Aspect tag, int amount) {
        return 0;
    }

    @Override
    public boolean takeFromContainer(Aspect tag, int amount) {
        TileEntity te;
        if (!this.isLinkValid() || amount > 1) {
            return false;
        }
        WorldServer targetWorld = DimensionManager.getWorld((int)this.linkDim);
        if (this.linkedFacing == ForgeDirection.UNKNOWN && targetWorld != null) {
            this.linkedFacing = ForgeDirection.getOrientation((int)(targetWorld.getBlockMetadata(this.linkX, this.linkY, this.linkZ) % 6));
        }
        if ((te = targetWorld.getTileEntity(this.linkX, this.linkY, this.linkZ)) != null && te instanceof TileMirrorEssentia) {
            return EssentiaHandler.drainEssentia(te, tag, this.linkedFacing, 8, true);
        }
        return false;
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote && this.count++ % this.inc == 0) {
            if (!this.isLinkValidSimple()) {
                if (this.inc < 600) {
                    this.inc += 20;
                }
                this.restoreLink();
            } else {
                this.inc = 40;
            }
        }
    }
}

