/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.api.research.ScanResult;
import thaumcraft.api.wands.IWandable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockTaintFibres;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityAspectOrb;
import thaumcraft.common.entities.monster.EntityGiantBrainyZombie;
import thaumcraft.common.items.ItemCompassStone;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.fx.PacketFXBlockZap;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.Utils;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;

public class TileNode
extends TileThaumcraft
implements INode,
IWandable {
    long lastActive = 0L;
    AspectList aspects = new AspectList();
    AspectList aspectsBase = new AspectList();
    public static HashMap<String, ArrayList<Integer>> locations = new HashMap();
    private NodeType nodeType = NodeType.NORMAL;
    private NodeModifier nodeModifier = null;
    int count = 0;
    int regeneration = -1;
    int wait = 0;
    String id = null;
    byte nodeLock = 0;
    boolean catchUp = false;
    public Entity drainEntity = null;
    public MovingObjectPosition drainCollision = null;
    public int drainColor = 0xFFFFFF;
    public Color targetColor = new Color(0xFFFFFF);
    public Color color = new Color(0xFFFFFF);

    @Override
    public String getId() {
        if (this.id == null) {
            this.id = this.generateId();
        }
        return this.id;
    }

    public String generateId() {
        this.id = this.worldObj.provider.dimensionId + ":" + this.xCoord + ":" + this.yCoord + ":" + this.zCoord;
        if (this.worldObj != null && locations != null) {
            ArrayList<Integer> t = new ArrayList<Integer>();
            t.add(this.worldObj.provider.dimensionId);
            t.add(this.xCoord);
            t.add(this.yCoord);
            t.add(this.zCoord);
            locations.put(this.id, t);
        }
        return this.id;
    }

    public void onChunkUnload() {
        if (locations != null) {
            locations.remove(this.id);
        }
        super.onChunkUnload();
    }

    public void validate() {
        super.validate();
    }

    public void updateEntity() {
        super.updateEntity();
        if (this.id == null) {
            this.generateId();
        }
        boolean change = false;
        change = this.handleHungryNodeFirst(change);
        ++this.count;
        this.checkLock();
        if (!this.worldObj.isRemote) {
            change = this.handleDischarge(change);
            change = this.handleRecharge(change);
            change = this.handleTaintNode(change);
            change = this.handleNodeStability(change);
            change = this.handleDarkNode(change);
            change = this.handlePureNode(change);
            if (change = this.handleHungryNodeSecond(change)) {
                this.markDirty();
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            }
        } else if (this.getNodeType() == NodeType.DARK && this.count % 50 == 0) {
            ItemCompassStone.sinisterNodes.put(new WorldCoordinates(this), System.currentTimeMillis());
        }
    }

    public void nodeChange() {
        this.regeneration = -1;
        this.markDirty();
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    public boolean canUpdate() {
        return true;
    }

    public double getDistanceTo(double par1, double par3, double par5) {
        double var7 = (double)this.xCoord + 0.5 - par1;
        double var9 = (double)this.yCoord + 0.5 - par3;
        double var11 = (double)this.zCoord + 0.5 - par5;
        return var7 * var7 + var9 * var9 + var11 * var11;
    }

    @Override
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        return -1;
    }

    @Override
    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        player.setItemInUse(wandstack, Integer.MAX_VALUE);
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        wand.setObjectInUse(wandstack, this.xCoord, this.yCoord, this.zCoord);
        return wandstack;
    }

    @Override
    public AspectList getAspects() {
        return this.aspects;
    }

    @Override
    public AspectList getAspectsBase() {
        return this.aspectsBase;
    }

    @Override
    public void setAspects(AspectList aspects) {
        this.aspects = aspects;
        this.aspectsBase = aspects.copy();
    }

    @Override
    public int addToContainer(Aspect aspect, int amount) {
        int left = amount + this.aspects.getAmount(aspect) - this.aspectsBase.getAmount(aspect);
        left = left > 0 ? left : 0;
        this.aspects.add(aspect, amount - left);
        return left;
    }

    @Override
    public boolean takeFromContainer(Aspect aspect, int amount) {
        return this.aspects.reduce(aspect, amount);
    }

    public Aspect takeRandomPrimalFromSource() {
        Aspect[] primals = this.aspects.getPrimalAspects();
        Aspect asp = primals[this.worldObj.rand.nextInt(primals.length)];
        if (asp != null && this.aspects.reduce(asp, 1)) {
            return asp;
        }
        return null;
    }

    public Aspect chooseRandomFilteredFromSource(AspectList filter, boolean preserve) {
        int min = preserve ? 1 : 0;
        ArrayList<Aspect> validaspects = new ArrayList<Aspect>();
        for (Aspect prim : this.aspects.getAspects()) {
            if (filter.getAmount(prim) <= 0 || this.aspects.getAmount(prim) <= min) continue;
            validaspects.add(prim);
        }
        if (validaspects.size() == 0) {
            return null;
        }
        Aspect asp = (Aspect)validaspects.get(this.worldObj.rand.nextInt(validaspects.size()));
        if (asp != null && this.aspects.getAmount(asp) > min) {
            return asp;
        }
        return null;
    }

    @Override
    public NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Override
    public void setNodeModifier(NodeModifier nodeModifier) {
        this.nodeModifier = nodeModifier;
    }

    @Override
    public NodeModifier getNodeModifier() {
        return this.nodeModifier;
    }

    @Override
    public int getNodeVisBase(Aspect aspect) {
        return this.aspectsBase.getAmount(aspect);
    }

    @Override
    public void setNodeVisBase(Aspect aspect, short nodeVisBase) {
        if (this.aspectsBase.getAmount(aspect) < nodeVisBase) {
            this.aspectsBase.merge(aspect, nodeVisBase);
        } else {
            this.aspectsBase.reduce(aspect, this.aspectsBase.getAmount(aspect) - nodeVisBase);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.lastActive = nbttagcompound.getLong("lastActive");
        AspectList al = new AspectList();
        NBTTagList tlist = nbttagcompound.getTagList("AspectsBase", 10);
        for (int j = 0; j < tlist.tagCount(); ++j) {
            NBTTagCompound rs = tlist.getCompoundTagAt(j);
            if (!rs.hasKey("key")) continue;
            al.add(Aspect.getAspect(rs.getString("key")), rs.getInteger("amount"));
        }
        Short oldBase = nbttagcompound.getShort("nodeVisBase");
        this.aspectsBase = new AspectList();
        if (oldBase > 0 && al.size() == 0) {
            for (Aspect a : this.aspects.getAspects()) {
                this.aspectsBase.merge(a, oldBase.shortValue());
            }
        } else {
            this.aspectsBase = al.copy();
        }
        int regen = 600;
        if (this.getNodeModifier() != null) {
            switch (this.getNodeModifier()) {
                case BRIGHT: {
                    regen = 400;
                    break;
                }
                case PALE: {
                    regen = 900;
                    break;
                }
                case FADING: {
                    regen = 0;
                }
            }
        }
        long ct = System.currentTimeMillis();
        int inc = regen * 75;
        if (regen > 0 && this.lastActive > 0L && ct > this.lastActive + (long)inc) {
            this.catchUp = true;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setLong("lastActive", this.lastActive);
        NBTTagList tlist = new NBTTagList();
        nbttagcompound.setTag("AspectsBase", (NBTBase)tlist);
        for (Aspect aspect : this.aspectsBase.getAspects()) {
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.setString("key", aspect.getTag());
            f.setInteger("amount", this.aspectsBase.getAmount(aspect));
            tlist.appendTag((NBTBase)f);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.id = nbttagcompound.getString("nodeId");
        if (this.worldObj != null && locations != null) {
            ArrayList<Integer> t = new ArrayList<Integer>();
            t.add(this.worldObj.provider.dimensionId);
            t.add(this.xCoord);
            t.add(this.yCoord);
            t.add(this.zCoord);
            locations.put(this.id, t);
        }
        this.setNodeType(NodeType.values()[nbttagcompound.getByte("type")]);
        byte mod = nbttagcompound.getByte("modifier");
        if (mod >= 0) {
            this.setNodeModifier(NodeModifier.values()[mod]);
        } else {
            this.setNodeModifier(null);
        }
        this.aspects.readFromNBT(nbttagcompound);
        String de = nbttagcompound.getString("drainer");
        if (de != null && de.length() > 0 && this.getWorldObj() != null) {
            this.drainEntity = this.getWorldObj().getPlayerEntityByName(de);
            if (this.drainEntity != null) {
                this.drainCollision = new MovingObjectPosition(this.xCoord, this.yCoord, this.zCoord, 0, Vec3.createVectorHelper((double)this.drainEntity.posX, (double)this.drainEntity.posY, (double)this.drainEntity.posZ));
            }
        }
        this.drainColor = nbttagcompound.getInteger("draincolor");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        if (this.id == null) {
            this.id = this.generateId();
        }
        if (this.worldObj != null && locations != null) {
            ArrayList<Integer> t = new ArrayList<Integer>();
            t.add(this.worldObj.provider.dimensionId);
            t.add(this.xCoord);
            t.add(this.yCoord);
            t.add(this.zCoord);
            locations.put(this.id, t);
        }
        nbttagcompound.setString("nodeId", this.id);
        nbttagcompound.setByte("type", (byte)this.getNodeType().ordinal());
        nbttagcompound.setByte("modifier", this.getNodeModifier() == null ? (byte)-1 : (byte)this.getNodeModifier().ordinal());
        this.aspects.writeToNBT(nbttagcompound);
        if (this.drainEntity != null && this.drainEntity instanceof EntityPlayer) {
            nbttagcompound.setString("drainer", this.drainEntity.getCommandSenderName());
        }
        nbttagcompound.setInteger("draincolor", this.drainColor);
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
        boolean mfu = false;
        ItemWandCasting wand = (ItemWandCasting)wandstack.getItem();
        MovingObjectPosition movingobjectposition = EntityUtils.getMovingObjectPositionFromPlayer(this.worldObj, player, true);
        if (movingobjectposition == null || movingobjectposition.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK) {
            player.stopUsingItem();
        } else {
            int i = movingobjectposition.blockX;
            int j = movingobjectposition.blockY;
            int k = movingobjectposition.blockZ;
            if (i != this.xCoord || j != this.yCoord || k != this.zCoord) {
                player.stopUsingItem();
            }
        }
        if (count % 5 == 0) {
            int tap = 1;
            if (ResearchManager.isResearchComplete(player.getCommandSenderName(), "NODETAPPER1")) {
                ++tap;
            }
            if (ResearchManager.isResearchComplete(player.getCommandSenderName(), "NODETAPPER2")) {
                ++tap;
            }
            boolean preserve = !player.isSneaking() && ResearchManager.isResearchComplete(player.getCommandSenderName(), "NODEPRESERVE") && !wand.getRod(wandstack).getTag().equals("wood") && !wand.getCap(wandstack).getTag().equals("iron");
            boolean success = false;
            Aspect aspect = null;
            aspect = this.chooseRandomFilteredFromSource(wand.getAspectsWithRoom(wandstack), preserve);
            if (aspect != null) {
                int rem;
                int amt = this.getAspects().getAmount(aspect);
                if (tap > amt) {
                    tap = amt;
                }
                if (preserve && tap == amt) {
                    --tap;
                }
                if (tap > 0 && (rem = wand.addVis(wandstack, aspect, tap, !this.worldObj.isRemote)) < tap) {
                    this.drainColor = aspect.getColor();
                    if (!this.worldObj.isRemote) {
                        this.takeFromContainer(aspect, tap - rem);
                        mfu = true;
                    }
                    success = true;
                }
            }
            if (success) {
                this.drainEntity = player;
                this.drainCollision = movingobjectposition;
                this.targetColor = new Color(this.drainColor);
            } else {
                this.drainEntity = null;
                this.drainCollision = null;
            }
            if (mfu) {
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
        }
        if (player.worldObj.isRemote) {
            int r = this.targetColor.getRed();
            int g = this.targetColor.getGreen();
            int b = this.targetColor.getBlue();
            int r2 = this.color.getRed() * 4;
            int g2 = this.color.getGreen() * 4;
            int b2 = this.color.getBlue() * 4;
            this.color = new Color((r + r2) / 5, (g + g2) / 5, (b + b2) / 5);
        }
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
        this.drainEntity = null;
        this.drainCollision = null;
    }

    public boolean receiveClientEvent(int i, int j) {
        return super.receiveClientEvent(i, j);
    }

    @Override
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    @Override
    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return false;
    }

    @Override
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Override
    public int containerContains(Aspect tag) {
        return 0;
    }

    @Override
    public boolean doesContainerAccept(Aspect tag) {
        return true;
    }

    private boolean handleHungryNodeFirst(boolean change) {
        if (this.getNodeType() == NodeType.HUNGRY) {
            List ents;
            if (this.worldObj.isRemote) {
                for (int a = 0; a < Thaumcraft.proxy.particleCount(1); ++a) {
                    Vec3 v2;
                    Vec3 v1;
                    MovingObjectPosition mop;
                    int tz;
                    int tx = this.xCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
                    int ty = this.yCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
                    if (ty > this.worldObj.getHeightValue(tx, tz = this.zCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16))) {
                        ty = this.worldObj.getHeightValue(tx, tz);
                    }
                    if ((mop = ThaumcraftApiHelper.rayTraceIgnoringSource(this.worldObj, v1 = Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.5), (double)((double)this.zCoord + 0.5)), v2 = Vec3.createVectorHelper((double)((double)tx + 0.5), (double)((double)ty + 0.5), (double)((double)tz + 0.5)), true, false, false)) == null || !(this.getDistanceFrom(mop.blockX, mop.blockY, mop.blockZ) < 256.0)) continue;
                    tx = mop.blockX;
                    ty = mop.blockY;
                    tz = mop.blockZ;
                    Block bi = this.worldObj.getBlock(tx, ty, tz);
                    int md = this.worldObj.getBlockMetadata(tx, ty, tz);
                    if (bi.isAir((IBlockAccess)this.worldObj, tx, ty, tz)) continue;
                    Thaumcraft.proxy.hungryNodeFX(this.worldObj, tx, ty, tz, this.xCoord, this.yCoord, this.zCoord, bi, md);
                }
            }
            if (Config.hardNode && (ents = this.worldObj.getEntitiesWithinAABB(Entity.class, AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(15.0, 15.0, 15.0))) != null && ents.size() > 0) {
                for (Object ent : ents) {
                    double var7;
                    double var5;
                    double var3;
                    double var9;
                    double var11;
                    double d;
                    Entity eo = (Entity)ent;
                    if (eo instanceof EntityPlayer && ((EntityPlayer)eo).capabilities.disableDamage) continue;
                    if (eo.isEntityAlive() && !eo.isEntityInvulnerable() && (d = this.getDistanceTo(eo.posX, eo.posY, eo.posZ)) < 2.0) {
                        ScanResult scan;
                        AspectList al;
                        eo.attackEntityFrom(DamageSource.outOfWorld, 1.0f);
                        if (!eo.isEntityAlive() && !this.worldObj.isRemote && (al = ScanManager.getScanAspects(scan = new ScanResult(2, 0, 0, eo, ""), this.worldObj)) != null && al.size() > 0 && (al = ResearchManager.reduceToPrimals(al.copy())) != null && al.size() > 0) {
                            Aspect a = al.getAspects()[this.worldObj.rand.nextInt(al.size())];
                            if (this.getAspects().getAmount(a) < this.getNodeVisBase(a)) {
                                this.addToContainer(a, 1);
                                change = true;
                            } else if (this.worldObj.rand.nextInt(1 + this.getNodeVisBase(a) * 2) < al.getAmount(a)) {
                                this.aspectsBase.add(a, 1);
                                change = true;
                            }
                        }
                    }
                    if (!((var11 = 1.0 - (var9 = Math.sqrt((var3 = ((double)this.xCoord + 0.5 - eo.posX) / 15.0) * var3 + (var5 = ((double)this.yCoord + 0.5 - eo.posY) / 15.0) * var5 + (var7 = ((double)this.zCoord + 0.5 - eo.posZ) / 15.0) * var7))) > 0.0)) continue;
                    var11 *= var11;
                    eo.motionX += var3 / var9 * var11 * 0.15;
                    eo.motionY += var5 / var9 * var11 * 0.25;
                    eo.motionZ += var7 / var9 * var11 * 0.15;
                }
            }
        }
        return change;
    }

    private boolean handleDischarge(boolean change) {
        TileEntity te;
        int inc;
        boolean shiny;
        if (this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) != ConfigBlocks.blockAiry || this.getLock() == 1) {
            return change;
        }
        if (this.getNodeModifier() == NodeModifier.FADING) {
            return change;
        }
        boolean bl = shiny = this.getNodeType() == NodeType.HUNGRY || this.getNodeModifier() == NodeModifier.BRIGHT;
        int n = this.getNodeModifier() == null ? 2 : (shiny ? 1 : (inc = this.getNodeModifier() == NodeModifier.PALE ? 3 : 2));
        if (this.count % inc != 0) {
            return change;
        }
        int x = this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
        int y = this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
        int z = this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
        if (this.getNodeModifier() == NodeModifier.PALE && this.worldObj.rand.nextBoolean()) {
            return change;
        }
        if ((x != 0 || y != 0 || z != 0) && (te = this.worldObj.getTileEntity(this.xCoord + x, this.yCoord + y, this.zCoord + z)) != null && te instanceof INode && this.worldObj.getBlock(this.xCoord + x, this.yCoord + y, this.zCoord + z) == ConfigBlocks.blockAiry) {
            int thisavg;
            if (te instanceof TileNode && ((TileNode)te).getLock() > 0) {
                return change;
            }
            INode nd = (INode)te;
            int ndavg = (nd.getAspects().visSize() + nd.getAspectsBase().visSize()) / 2;
            if (ndavg < (thisavg = (this.getAspects().visSize() + this.getAspectsBase().visSize()) / 2) && nd.getAspects().size() > 0) {
                Aspect a = nd.getAspects().getAspects()[this.worldObj.rand.nextInt(nd.getAspects().size())];
                boolean u = false;
                if (this.getAspects().getAmount(a) < this.getNodeVisBase(a) && nd.takeFromContainer(a, 1)) {
                    this.addToContainer(a, 1);
                    u = true;
                } else if (nd.takeFromContainer(a, 1)) {
                    if (this.worldObj.rand.nextInt(1 + (int)((double)this.getNodeVisBase(a) / (shiny ? 1.5 : 1.0))) == 0) {
                        this.aspectsBase.add(a, 1);
                        if (this.getNodeModifier() == NodeModifier.PALE && this.worldObj.rand.nextInt(100) == 0) {
                            this.setNodeModifier(null);
                            this.regeneration = -1;
                        }
                        if (this.worldObj.rand.nextInt(3) == 0) {
                            nd.setNodeVisBase(a, (short)(nd.getNodeVisBase(a) - 1));
                        }
                    }
                    u = true;
                }
                if (u) {
                    ((TileNode)te).wait = ((TileNode)te).regeneration / 2;
                    this.worldObj.markBlockForUpdate(this.xCoord + x, this.yCoord + y, this.zCoord + z);
                    te.markDirty();
                    change = true;
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXBlockZap((float)(this.xCoord + x) + 0.5f, (float)(this.yCoord + y) + 0.5f, (float)(this.zCoord + z) + 0.5f, (float)this.xCoord + 0.5f, (float)this.yCoord + 0.5f, (float)this.zCoord + 0.5f), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 32.0));
                }
            }
        }
        return change;
    }

    private boolean handleRecharge(boolean change) {
        if (this.regeneration < 0) {
            this.regeneration = 600;
            if (this.getNodeModifier() != null) {
                switch (this.getNodeModifier()) {
                    case BRIGHT: {
                        this.regeneration = 400;
                        break;
                    }
                    case PALE: {
                        this.regeneration = 900;
                        break;
                    }
                    case FADING: {
                        this.regeneration = 0;
                    }
                }
            }
            if (this.getLock() == 1) {
                this.regeneration *= 2;
            }
            if (this.getLock() == 2) {
                this.regeneration *= 20;
            }
        }
        if (this.catchUp) {
            int amt;
            this.catchUp = false;
            long ct = System.currentTimeMillis();
            int inc = this.regeneration * 75;
            int n = amt = inc > 0 ? (int)((ct - this.lastActive) / (long)inc) : 0;
            if (amt > 0) {
                for (int a = 0; a < Math.min(amt, this.aspectsBase.visSize()); ++a) {
                    AspectList al = new AspectList();
                    for (Aspect aspect : this.getAspects().getAspects()) {
                        if (this.getAspects().getAmount(aspect) >= this.getNodeVisBase(aspect)) continue;
                        al.add(aspect, 1);
                    }
                    if (al.size() <= 0) continue;
                    this.addToContainer(al.getAspects()[this.worldObj.rand.nextInt(al.size())], 1);
                }
            }
        }
        if (this.count % 1200 == 0) {
            for (Aspect aspect : this.getAspects().getAspects()) {
                if (this.getAspects().getAmount(aspect) > 0) continue;
                this.setNodeVisBase(aspect, (short)(this.getNodeVisBase(aspect) - 1));
                if (this.worldObj.rand.nextInt(20) == 0 || this.getNodeVisBase(aspect) <= 0) {
                    this.getAspects().remove(aspect);
                    if (this.worldObj.rand.nextInt(5) == 0) {
                        if (this.getNodeModifier() == NodeModifier.BRIGHT) {
                            this.setNodeModifier(null);
                        } else if (this.getNodeModifier() == null) {
                            this.setNodeModifier(NodeModifier.PALE);
                        }
                        if (this.getNodeModifier() == NodeModifier.PALE && this.worldObj.rand.nextInt(5) == 0) {
                            this.setNodeModifier(NodeModifier.FADING);
                        }
                    }
                    this.nodeChange();
                    break;
                }
                this.nodeChange();
            }
            if (this.getAspects().size() <= 0) {
                this.invalidate();
                if (this.getBlockType() == ConfigBlocks.blockAiry) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                } else if (this.getBlockType() == ConfigBlocks.blockMagicalLog) {
                    this.worldObj.setBlockMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord) - 1, 3);
                }
            }
        }
        if (this.wait > 0) {
            --this.wait;
        }
        if (this.regeneration > 0 && this.wait == 0 && this.count % this.regeneration == 0) {
            this.lastActive = System.currentTimeMillis();
            AspectList al = new AspectList();
            for (Aspect aspect : this.getAspects().getAspects()) {
                if (this.getAspects().getAmount(aspect) >= this.getNodeVisBase(aspect)) continue;
                al.add(aspect, 1);
            }
            if (al.size() > 0) {
                this.addToContainer(al.getAspects()[this.worldObj.rand.nextInt(al.size())], 1);
                change = true;
            }
        }
        return change;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean handleTaintNode(boolean change) {
        if (this.getNodeType() == NodeType.TAINTED && this.count % 50 == 0) {
            int x = 0;
            int z = 0;
            int y = 0;
            x = this.xCoord + this.worldObj.rand.nextInt(8) - this.worldObj.rand.nextInt(8);
            z = this.zCoord + this.worldObj.rand.nextInt(8) - this.worldObj.rand.nextInt(8);
            BiomeGenBase bg = this.worldObj.getBiomeGenForCoords(x, z);
            if (bg.biomeID != ThaumcraftWorldGenerator.biomeTaint.biomeID) {
                Utils.setBiomeAt(this.worldObj, x, z, ThaumcraftWorldGenerator.biomeTaint);
            }
            if (!Config.hardNode || !this.worldObj.rand.nextBoolean()) return change;
            x = this.xCoord + this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
            z = this.zCoord + this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
            y = this.yCoord + this.worldObj.rand.nextInt(5) - this.worldObj.rand.nextInt(5);
            if (!BlockTaintFibres.spreadFibres(this.worldObj, x, y, z)) return change;
        }
        if (this.getNodeType() == NodeType.PURE || this.getNodeType() == NodeType.TAINTED || this.count % 100 != 0) return change;
        BiomeGenBase bg = this.worldObj.getBiomeGenForCoords(this.xCoord, this.zCoord);
        if (bg.biomeID != ThaumcraftWorldGenerator.biomeTaint.biomeID || this.worldObj.rand.nextInt(500) != 0) return change;
        this.setNodeType(NodeType.TAINTED);
        this.nodeChange();
        return change;
    }

    private boolean handleNodeStability(boolean change) {
        if (this.count % 100 == 0) {
            if (this.getNodeType() == NodeType.UNSTABLE && this.worldObj.rand.nextBoolean()) {
                if (this.getLock() == 0) {
                    Aspect aspect = null;
                    aspect = this.takeRandomPrimalFromSource();
                    if (aspect != null) {
                        EntityAspectOrb orb = new EntityAspectOrb(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, aspect, 1);
                        this.worldObj.spawnEntityInWorld((Entity)orb);
                        change = true;
                    }
                } else if (this.worldObj.rand.nextInt(10000 / this.getLock()) == 42) {
                    this.setNodeType(NodeType.NORMAL);
                    change = true;
                }
            }
            if (this.getNodeModifier() == NodeModifier.FADING && this.getLock() > 0 && this.worldObj.rand.nextInt(12500 / this.getLock()) == 69) {
                this.setNodeModifier(NodeModifier.PALE);
                change = true;
            }
        }
        return change;
    }

    private boolean handlePureNode(boolean change) {
        int dimbl = ThaumcraftWorldGenerator.getDimBlacklist(this.worldObj.provider.dimensionId);
        if (this.worldObj.provider.dimensionId != -1 && this.worldObj.provider.dimensionId != 1 && dimbl != 0 && dimbl != 2 && this.getNodeType() == NodeType.PURE && this.count % 50 == 0) {
            int x = this.xCoord + this.worldObj.rand.nextInt(8) - this.worldObj.rand.nextInt(8);
            int z = this.zCoord + this.worldObj.rand.nextInt(8) - this.worldObj.rand.nextInt(8);
            BiomeGenBase bg = this.worldObj.getBiomeGenForCoords(x, z);
            int biobl = ThaumcraftWorldGenerator.getBiomeBlacklist(bg.biomeID);
            if (biobl != 0 && biobl != 2 && bg.biomeID != ThaumcraftWorldGenerator.biomeMagicalForest.biomeID) {
                if (bg.biomeID == ThaumcraftWorldGenerator.biomeTaint.biomeID) {
                    Utils.setBiomeAt(this.worldObj, x, z, ThaumcraftWorldGenerator.biomeMagicalForest);
                } else if (this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord) == ConfigBlocks.blockMagicalLog) {
                    Utils.setBiomeAt(this.worldObj, x, z, ThaumcraftWorldGenerator.biomeMagicalForest);
                }
            }
        }
        return change;
    }

    private boolean handleDarkNode(boolean change) {
        int dimbl = ThaumcraftWorldGenerator.getDimBlacklist(this.worldObj.provider.dimensionId);
        int biobl = ThaumcraftWorldGenerator.getBiomeBlacklist(this.worldObj.getBiomeGenForCoords((int)this.xCoord, (int)this.zCoord).biomeID);
        if (biobl != 0 && biobl != 2 && this.worldObj.provider.dimensionId != -1 && this.worldObj.provider.dimensionId != 1 && dimbl != 0 && dimbl != 2 && this.getNodeType() == NodeType.DARK && this.count % 50 == 0) {
            int j;
            EntityGiantBrainyZombie entity;
            int x = this.xCoord + this.worldObj.rand.nextInt(12) - this.worldObj.rand.nextInt(12);
            int z = this.zCoord + this.worldObj.rand.nextInt(12) - this.worldObj.rand.nextInt(12);
            BiomeGenBase bg = this.worldObj.getBiomeGenForCoords(x, z);
            if (bg.biomeID != ThaumcraftWorldGenerator.biomeEerie.biomeID) {
                Utils.setBiomeAt(this.worldObj, x, z, ThaumcraftWorldGenerator.biomeEerie);
            }
            if (Config.hardNode && this.worldObj.rand.nextBoolean() && this.worldObj.getClosestPlayer((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, 24.0) != null && (entity = new EntityGiantBrainyZombie(this.worldObj)) != null && (j = this.worldObj.getEntitiesWithinAABB(((Object)((Object)entity)).getClass(), AxisAlignedBB.getBoundingBox((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, (double)(this.xCoord + 1), (double)(this.yCoord + 1), (double)(this.zCoord + 1)).expand(10.0, 6.0, 10.0)).size()) <= 3) {
                double d0 = (double)this.xCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 5.0;
                double d3 = this.yCoord + this.worldObj.rand.nextInt(3) - 1;
                double d4 = (double)this.zCoord + (this.worldObj.rand.nextDouble() - this.worldObj.rand.nextDouble()) * 5.0;
                EntityGiantBrainyZombie entityliving = entity instanceof EntityLiving ? entity : null;
                entity.setLocationAndAngles(d0, d3, d4, this.worldObj.rand.nextFloat() * 360.0f, 0.0f);
                if (entityliving == null || entityliving.getCanSpawnHere()) {
                    this.worldObj.spawnEntityInWorld((Entity)entityliving);
                    this.worldObj.playAuxSFX(2004, this.xCoord, this.yCoord, this.zCoord, 0);
                    if (entityliving != null) {
                        entityliving.spawnExplosionParticle();
                    }
                }
            }
        }
        return change;
    }

    private boolean handleHungryNodeSecond(boolean change) {
        if (this.getNodeType() == NodeType.HUNGRY && this.count % 50 == 0) {
            Vec3 v2;
            Vec3 v1;
            MovingObjectPosition mop;
            int tz;
            int tx = this.xCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
            int ty = this.yCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16);
            if (ty > this.worldObj.getHeightValue(tx, tz = this.zCoord + this.worldObj.rand.nextInt(16) - this.worldObj.rand.nextInt(16))) {
                ty = this.worldObj.getHeightValue(tx, tz);
            }
            if ((mop = ThaumcraftApiHelper.rayTraceIgnoringSource(this.worldObj, v1 = Vec3.createVectorHelper((double)((double)this.xCoord + 0.5), (double)((double)this.yCoord + 0.5), (double)((double)this.zCoord + 0.5)), v2 = Vec3.createVectorHelper((double)((double)tx + 0.5), (double)((double)ty + 0.5), (double)((double)tz + 0.5)), true, false, false)) != null && this.getDistanceFrom(mop.blockX, mop.blockY, mop.blockZ) < 256.0) {
                float h;
                tx = mop.blockX;
                ty = mop.blockY;
                tz = mop.blockZ;
                Block bi = this.worldObj.getBlock(tx, ty, tz);
                int md = this.worldObj.getBlockMetadata(tx, ty, tz);
                if (!bi.isAir((IBlockAccess)this.worldObj, tx, ty, tz) && (h = bi.getBlockHardness(this.worldObj, tx, ty, tz)) >= 0.0f && h < 5.0f) {
                    this.worldObj.func_147480_a(tx, ty, tz, true);
                }
            }
        }
        return change;
    }

    public byte getLock() {
        return this.nodeLock;
    }

    public void checkLock() {
        if ((this.count <= 1 || this.count % 50 == 0) && this.yCoord > 0 && this.getBlockType() == ConfigBlocks.blockAiry) {
            byte oldLock = this.nodeLock;
            this.nodeLock = 0;
            if (!this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord - 1, this.zCoord) && this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord) == ConfigBlocks.blockStoneDevice) {
                if (this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 1, this.zCoord) == 9) {
                    this.nodeLock = 1;
                } else if (this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 1, this.zCoord) == 10) {
                    this.nodeLock = (byte)2;
                }
            }
            if (oldLock != this.nodeLock) {
                this.regeneration = -1;
            }
        }
    }
}

