/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockAiry;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileNode;
import thaumcraft.common.tiles.TileNodeEnergized;
import thaumcraft.common.tiles.TileNodeStabilizer;

public class TileNodeConverter
extends TileThaumcraft {
    public int count = -1;
    public int status = 0;

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        TileEntity tilenew;
        NodeModifier mod;
        NodeType type;
        AspectList base;
        TileEntity tile;
        super.updateEntity();
        if (this.count == -1) {
            this.checkStatus();
        }
        if (this.status == 1 && !this.worldObj.isRemote && this.count >= 1000 && (tile = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord)) != null && tile instanceof TileNode) {
            base = ((TileNode)tile).getAspectsBase();
            type = ((TileNode)tile).getNodeType();
            mod = ((TileNode)tile).getNodeModifier();
            this.worldObj.setBlock(this.xCoord, this.yCoord - 1, this.zCoord, ConfigBlocks.blockAiry, 5, 3);
            tilenew = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (tilenew != null && tilenew instanceof TileNodeEnergized) {
                ((TileNodeEnergized)tilenew).setNodeModifier(mod);
                ((TileNodeEnergized)tilenew).setNodeType(type);
                ((TileNodeEnergized)tilenew).setAspects(base.copy());
                ((TileNodeEnergized)tilenew).setupNode();
            }
            this.checkStatus();
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 10, 10);
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
        }
        if (this.status == 2 && !this.worldObj.isRemote && this.count <= 50 && (tile = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord)) != null && tile instanceof TileNodeEnergized) {
            base = ((TileNodeEnergized)tile).getAuraBase();
            type = ((TileNodeEnergized)tile).getNodeType();
            mod = ((TileNodeEnergized)tile).getNodeModifier();
            this.worldObj.setBlock(this.xCoord, this.yCoord - 1, this.zCoord, ConfigBlocks.blockAiry, 0, 3);
            tilenew = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord);
            if (tilenew != null && tilenew instanceof TileNode) {
                ((TileNode)tilenew).setNodeModifier(mod);
                ((TileNode)tilenew).setNodeType(type);
                ((TileNode)tilenew).setAspects(base.copy());
                for (Aspect a : ((TileNode)tilenew).getAspects().getAspects()) {
                    ((TileNode)tilenew).takeFromContainer(a, ((TileNode)tilenew).getAspects().getAmount(a));
                }
            }
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 10, 10);
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
            this.markDirty();
            this.status = 0;
        }
        if (this.status == 0 || !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord)) {
            if (this.count > 0) {
                --this.count;
                if (this.count > 50 && this.worldObj.isRemote) {
                    if (this.worldObj.rand.nextBoolean()) {
                        Thaumcraft.proxy.nodeBolt(this.worldObj, (float)this.xCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.yCoord + 0.5f, (float)this.zCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.xCoord + 0.5f, (float)this.yCoord - 0.5f, (float)this.zCoord + 0.5f);
                    }
                    if (this.worldObj.rand.nextBoolean() && this.hasStabilizer()) {
                        Thaumcraft.proxy.nodeBolt(this.worldObj, (float)this.xCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.yCoord - 1.5f, (float)this.zCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.xCoord + 0.5f, (float)this.yCoord - 0.5f, (float)this.zCoord + 0.5f);
                    }
                }
            }
        } else if (this.count < 1000) {
            TileNode nd;
            AspectList al;
            TileEntity tilenew2;
            ++this.count;
            if (!this.worldObj.isRemote && (tilenew2 = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 1, this.zCoord)) != null && tilenew2 instanceof TileNode && (al = (nd = (TileNode)tilenew2).getAspects()).getAspects().length > 0) {
                nd.takeFromContainer(al.getAspects()[this.worldObj.rand.nextInt(al.getAspects().length)], 1);
                if (this.count % 5 == 0 || nd.getAspects().visSize() == 0) {
                    this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord - 1, this.zCoord);
                }
            }
            if (this.count > 50 && this.worldObj.isRemote) {
                if (this.worldObj.rand.nextBoolean()) {
                    Thaumcraft.proxy.nodeBolt(this.worldObj, (float)this.xCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.yCoord + 0.5f, (float)this.zCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.xCoord + 0.5f, (float)this.yCoord - 0.5f, (float)this.zCoord + 0.5f);
                }
                if (this.worldObj.rand.nextBoolean() && this.hasStabilizer()) {
                    Thaumcraft.proxy.nodeBolt(this.worldObj, (float)this.xCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.yCoord - 1.5f, (float)this.zCoord + 0.25f + this.worldObj.rand.nextFloat() * 0.5f, (float)this.xCoord + 0.5f, (float)this.yCoord - 0.5f, (float)this.zCoord + 0.5f);
                }
            }
        }
        if (this.count > 1000) {
            this.count = 1000;
        }
    }

    private boolean hasStabilizer() {
        TileEntity te = this.worldObj.getTileEntity(this.xCoord, this.yCoord - 2, this.zCoord);
        return !this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord - 2, this.zCoord) && te != null && te instanceof TileNodeStabilizer;
    }

    public void checkStatus() {
        if (this.count == -1) {
            this.count = 0;
        }
        if (!(this.status != 2 || this.count <= 50 || this.hasStabilizer() && this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord) == ConfigBlocks.blockAiry && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 1, this.zCoord) == 5)) {
            BlockAiry.explodify(this.getWorldObj(), this.xCoord, this.yCoord - 1, this.zCoord);
            this.status = 0;
            this.count = 50;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        } else if (this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord) && this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord) == ConfigBlocks.blockAiry && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 1, this.zCoord) == 0 && this.hasStabilizer()) {
            this.status = 1;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        } else if (this.worldObj.getBlock(this.xCoord, this.yCoord - 1, this.zCoord) == ConfigBlocks.blockAiry && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord - 1, this.zCoord) == 5) {
            this.status = 2;
            this.count = 1000;
            this.markDirty();
            this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
        } else {
            this.status = 0;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.status = nbttagcompound.getInteger("status");
        this.count = nbttagcompound.getInteger("count");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setInteger("status", this.status);
        nbttagcompound.setInteger("count", this.count);
    }

    public boolean receiveClientEvent(int i, int j) {
        if (i == 10 && j == 10) {
            if (this.worldObj.isRemote) {
                Thaumcraft.proxy.burst(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord - 0.5, (double)this.zCoord + 0.5, 1.0f);
                this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord - 0.5, (double)this.zCoord + 0.5, "thaumcraft:craftfail", 0.5f, 1.0f, false);
            }
            return true;
        }
        return super.receiveClientEvent(i, j);
    }
}

