/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.TileThaumcraft;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.wands.IWandable;
import thaumcraft.codechicken.lib.raytracer.IndexedCuboid6;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.codechicken.lib.vec.Cuboid6;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;

public class TileTube
extends TileThaumcraft
implements IEssentiaTransport,
IWandable {
    public ForgeDirection facing = ForgeDirection.NORTH;
    public boolean[] openSides = new boolean[]{true, true, true, true, true, true};
    Aspect essentiaType = null;
    int essentiaAmount = 0;
    Aspect suctionType = null;
    int suction = 0;
    int venting = 0;
    int count = 0;
    static final int freq = 5;
    int ventColor = 0;

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        this.essentiaType = Aspect.getAspect(nbttagcompound.getString("type"));
        this.essentiaAmount = nbttagcompound.getInteger("amount");
        this.facing = ForgeDirection.getOrientation((int)nbttagcompound.getInteger("side"));
        byte[] sides = nbttagcompound.getByteArray("open");
        if (sides != null && sides.length == 6) {
            for (int a = 0; a < 6; ++a) {
                this.openSides[a] = sides[a] == 1;
            }
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        if (this.essentiaType != null) {
            nbttagcompound.setString("type", this.essentiaType.getTag());
        }
        nbttagcompound.setInteger("amount", this.essentiaAmount);
        byte[] sides = new byte[6];
        for (int a = 0; a < 6; ++a) {
            sides[a] = this.openSides[a] ? (byte)1 : 0;
        }
        nbttagcompound.setInteger("side", this.facing.ordinal());
        nbttagcompound.setByteArray("open", sides);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.suctionType = Aspect.getAspect(nbttagcompound.getString("stype"));
        this.suction = nbttagcompound.getInteger("samount");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        if (this.suctionType != null) {
            nbttagcompound.setString("stype", this.suctionType.getTag());
        }
        nbttagcompound.setInteger("samount", this.suction);
    }

    public boolean canUpdate() {
        return true;
    }

    public void updateEntity() {
        if (this.venting > 0) {
            --this.venting;
        }
        if (this.count == 0) {
            this.count = this.worldObj.rand.nextInt(10);
        }
        if (!this.worldObj.isRemote) {
            if (this.venting <= 0) {
                if (++this.count % 2 == 0) {
                    this.calculateSuction(null, false, false);
                    this.checkVenting();
                    if (this.essentiaType != null && this.essentiaAmount == 0) {
                        this.essentiaType = null;
                    }
                }
                if (this.count % 5 == 0 && this.suction > 0) {
                    this.equalizeWithNeighbours(false);
                }
            }
        } else if (this.venting > 0) {
            Random r = new Random(this.hashCode() * 4);
            float rp = r.nextFloat() * 360.0f;
            float ry = r.nextFloat() * 360.0f;
            double fx = -MathHelper.sin((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rp / 180.0f * (float)Math.PI));
            double fz = MathHelper.cos((float)(ry / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rp / 180.0f * (float)Math.PI));
            double fy = -MathHelper.sin((float)(rp / 180.0f * (float)Math.PI));
            Thaumcraft.proxy.drawVentParticles(this.worldObj, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, fx / 5.0, fy / 5.0, fx / 5.0, this.ventColor);
        }
    }

    void calculateSuction(Aspect filter, boolean restrict, boolean directional) {
        this.suction = 0;
        this.suctionType = null;
        ForgeDirection loc = null;
        for (int dir = 0; dir < 6; ++dir) {
            try {
                int suck;
                TileEntity te;
                loc = ForgeDirection.getOrientation((int)dir);
                if (directional && this.facing != loc.getOpposite() || !this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.worldObj, this.xCoord, this.yCoord, this.zCoord, loc)) == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                if (filter != null && ic.getSuctionType(loc.getOpposite()) != null && ic.getSuctionType(loc.getOpposite()) != filter || filter == null && this.getEssentiaAmount(loc) > 0 && ic.getSuctionType(loc.getOpposite()) != null && this.getEssentiaType(loc) != ic.getSuctionType(loc.getOpposite()) || filter != null && this.getEssentiaAmount(loc) > 0 && this.getEssentiaType(loc) != null && ic.getSuctionType(loc.getOpposite()) != null && this.getEssentiaType(loc) != ic.getSuctionType(loc.getOpposite()) || (suck = ic.getSuctionAmount(loc.getOpposite())) <= 0 || suck <= this.suction + 1) continue;
                Aspect st = ic.getSuctionType(loc.getOpposite());
                if (st == null) {
                    st = filter;
                }
                this.setSuction(st, restrict ? suck / 2 : suck - 1);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    void checkVenting() {
        ForgeDirection loc = null;
        for (int dir = 0; dir < 6; ++dir) {
            try {
                TileEntity te;
                loc = ForgeDirection.getOrientation((int)dir);
                if (!this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.worldObj, this.xCoord, this.yCoord, this.zCoord, loc)) == null) continue;
                IEssentiaTransport ic = (IEssentiaTransport)te;
                int suck = ic.getSuctionAmount(loc.getOpposite());
                if (this.suction <= 0 || suck != this.suction && suck != this.suction - 1 || this.suctionType == ic.getSuctionType(loc.getOpposite())) continue;
                int c = -1;
                if (this.suctionType != null) {
                    c = Config.aspectOrder.indexOf(this.suctionType);
                }
                this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, ConfigBlocks.blockTube, 1, c);
                this.venting = 40;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void equalizeWithNeighbours(boolean directional) {
        ForgeDirection loc = null;
        if (this.essentiaAmount > 0) {
            return;
        }
        for (int dir = 0; dir < 6; ++dir) {
            try {
                int am;
                IEssentiaTransport ic;
                TileEntity te;
                loc = ForgeDirection.getOrientation((int)dir);
                if (directional && this.facing == loc.getOpposite() || !this.isConnectable(loc) || (te = ThaumcraftApiHelper.getConnectableTile(this.worldObj, this.xCoord, this.yCoord, this.zCoord, loc)) == null || !(ic = (IEssentiaTransport)te).canOutputTo(loc.getOpposite()) || this.getSuctionType(null) != null && this.getSuctionType(null) != ic.getEssentiaType(loc.getOpposite()) && ic.getEssentiaType(loc.getOpposite()) != null || this.getSuctionAmount(null) <= ic.getSuctionAmount(loc.getOpposite()) || this.getSuctionAmount(null) < ic.getMinimumSuction()) continue;
                Aspect a = this.getSuctionType(null);
                if (a == null && (a = ic.getEssentiaType(loc.getOpposite())) == null) {
                    a = ic.getEssentiaType(ForgeDirection.UNKNOWN);
                }
                if ((am = this.addEssentia(a, ic.takeEssentia(a, 1, loc.getOpposite()), loc)) <= 0) continue;
                if (this.worldObj.rand.nextInt(100) == 0) {
                    this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, ConfigBlocks.blockTube, 0, 0);
                }
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isConnectable(ForgeDirection face) {
        if (face == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public boolean canInputFrom(ForgeDirection face) {
        if (face == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public boolean canOutputTo(ForgeDirection face) {
        if (face == ForgeDirection.UNKNOWN) {
            return false;
        }
        return this.openSides[face.ordinal()];
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        this.suctionType = aspect;
        this.suction = amount;
    }

    @Override
    public Aspect getSuctionType(ForgeDirection loc) {
        return this.suctionType;
    }

    @Override
    public int getSuctionAmount(ForgeDirection loc) {
        return this.suction;
    }

    @Override
    public Aspect getEssentiaType(ForgeDirection loc) {
        return this.essentiaType;
    }

    @Override
    public int getEssentiaAmount(ForgeDirection loc) {
        return this.essentiaAmount;
    }

    @Override
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.canOutputTo(face) && this.essentiaType == aspect && this.essentiaAmount > 0 && amount > 0) {
            --this.essentiaAmount;
            if (this.essentiaAmount <= 0) {
                this.essentiaType = null;
            }
            this.markDirty();
            return 1;
        }
        return 0;
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        if (this.canInputFrom(face) && this.essentiaAmount == 0 && amount > 0) {
            this.essentiaType = aspect;
            ++this.essentiaAmount;
            this.markDirty();
            return 1;
        }
        return 0;
    }

    @Override
    public int getMinimumSuction() {
        return 0;
    }

    @Override
    public boolean renderExtendedTube() {
        return false;
    }

    public boolean receiveClientEvent(int i, int j) {
        if (i == 0) {
            if (this.worldObj.isRemote) {
                this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:creak", 1.0f, 1.3f + this.worldObj.rand.nextFloat() * 0.2f, false);
            }
            return true;
        }
        if (i == 1) {
            if (this.worldObj.isRemote) {
                if (this.venting <= 0) {
                    this.worldObj.playSound((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "random.fizz", 0.1f, 1.0f + this.worldObj.rand.nextFloat() * 0.1f, false);
                }
                this.venting = 50;
                this.ventColor = j == -1 || j >= Config.aspectOrder.size() ? 0xAAAAAA : Config.aspectOrder.get(j).getColor();
            }
            return true;
        }
        return super.receiveClientEvent(i, j);
    }

    @Override
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        MovingObjectPosition hit = RayTracer.retraceBlock(world, player, x, y, z);
        if (hit == null) {
            return 0;
        }
        if (hit.subHit >= 0 && hit.subHit < 6) {
            player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
            player.swingItem();
            this.markDirty();
            world.markBlockForUpdate(x, y, z);
            this.openSides[hit.subHit] = !this.openSides[hit.subHit];
            ForgeDirection dir = ForgeDirection.getOrientation((int)hit.subHit);
            TileEntity tile = this.worldObj.getTileEntity(this.xCoord + dir.offsetX, this.yCoord + dir.offsetY, this.zCoord + dir.offsetZ);
            if (tile != null && tile instanceof TileTube) {
                ((TileTube)tile).openSides[dir.getOpposite().ordinal()] = this.openSides[hit.subHit];
                world.markBlockForUpdate(this.xCoord + dir.offsetX, this.yCoord + dir.offsetY, this.zCoord + dir.offsetZ);
                tile.markDirty();
            }
        }
        if (hit.subHit == 6) {
            player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
            player.swingItem();
            int a = this.facing.ordinal();
            this.markDirty();
            while (++a < 20) {
                if (!this.canConnectSide(ForgeDirection.getOrientation((int)(a % 6)).getOpposite().ordinal()) || !this.isConnectable(ForgeDirection.getOrientation((int)(a % 6)).getOpposite())) continue;
                this.facing = ForgeDirection.getOrientation((int)(a %= 6));
                world.markBlockForUpdate(x, y, z);
                break;
            }
        }
        return 0;
    }

    @Override
    public ItemStack onWandRightClick(World world, ItemStack wandstack, EntityPlayer player) {
        return null;
    }

    @Override
    public void onUsingWandTick(ItemStack wandstack, EntityPlayer player, int count) {
    }

    @Override
    public void onWandStoppedUsing(ItemStack wandstack, World world, EntityPlayer player, int count) {
    }

    public MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, MovingObjectPosition fullblock) {
        return fullblock;
    }

    protected boolean canConnectSide(int side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        TileEntity tile = this.worldObj.getTileEntity(this.xCoord + dir.offsetX, this.yCoord + dir.offsetY, this.zCoord + dir.offsetZ);
        return tile != null && tile instanceof IEssentiaTransport;
    }

    public void addTraceableCuboids(List<IndexedCuboid6> cuboids) {
        float min = 0.42f;
        float max = 0.58f;
        if (this.canConnectSide(0)) {
            cuboids.add(new IndexedCuboid6(0, new Cuboid6((float)this.xCoord + min, this.yCoord, (float)this.zCoord + min, (float)this.xCoord + max, (double)this.yCoord + 0.5, (float)this.zCoord + max)));
        }
        if (this.canConnectSide(1)) {
            cuboids.add(new IndexedCuboid6(1, new Cuboid6((float)this.xCoord + min, (double)this.yCoord + 0.5, (float)this.zCoord + min, (float)this.xCoord + max, this.yCoord + 1, (float)this.zCoord + max)));
        }
        if (this.canConnectSide(2)) {
            cuboids.add(new IndexedCuboid6(2, new Cuboid6((float)this.xCoord + min, (float)this.yCoord + min, this.zCoord, (float)this.xCoord + max, (float)this.yCoord + max, (double)this.zCoord + 0.5)));
        }
        if (this.canConnectSide(3)) {
            cuboids.add(new IndexedCuboid6(3, new Cuboid6((float)this.xCoord + min, (float)this.yCoord + min, (double)this.zCoord + 0.5, (float)this.xCoord + max, (float)this.yCoord + max, this.zCoord + 1)));
        }
        if (this.canConnectSide(4)) {
            cuboids.add(new IndexedCuboid6(4, new Cuboid6(this.xCoord, (float)this.yCoord + min, (float)this.zCoord + min, (double)this.xCoord + 0.5, (float)this.yCoord + max, (float)this.zCoord + max)));
        }
        if (this.canConnectSide(5)) {
            cuboids.add(new IndexedCuboid6(5, new Cuboid6((double)this.xCoord + 0.5, (float)this.yCoord + min, (float)this.zCoord + min, this.xCoord + 1, (float)this.yCoord + max, (float)this.zCoord + max)));
        }
        cuboids.add(new IndexedCuboid6(6, new Cuboid6((double)this.xCoord + 0.34375, (double)this.yCoord + 0.34375, (double)this.zCoord + 0.34375, (double)this.xCoord + 0.65625, (double)this.yCoord + 0.65625, (double)this.zCoord + 0.65625)));
    }
}

