/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.codechicken.lib.raytracer.RayTracer;
import thaumcraft.common.tiles.TileTube;

public class TileTubeValve
extends TileTube {
    public boolean allowFlow = true;
    boolean wasPoweredLastTick = false;
    public float rotation = 0.0f;

    @Override
    public void updateEntity() {
        if (!this.worldObj.isRemote && this.count % 5 == 0) {
            boolean gettingPower = this.gettingPower();
            if (this.wasPoweredLastTick && !gettingPower && !this.allowFlow) {
                this.allowFlow = true;
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:squeek", 0.7f, 0.9f + this.worldObj.rand.nextFloat() * 0.2f);
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
            if (!this.wasPoweredLastTick && gettingPower && this.allowFlow) {
                this.allowFlow = false;
                this.worldObj.playSoundEffect((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5, "thaumcraft:squeek", 0.7f, 0.9f + this.worldObj.rand.nextFloat() * 0.2f);
                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                this.markDirty();
            }
            this.wasPoweredLastTick = gettingPower;
        }
        if (this.worldObj.isRemote) {
            if (!this.allowFlow && this.rotation < 360.0f) {
                this.rotation += 20.0f;
            } else if (this.allowFlow && this.rotation > 0.0f) {
                this.rotation -= 20.0f;
            }
        }
        super.updateEntity();
    }

    @Override
    public int onWandRightClick(World world, ItemStack wandstack, EntityPlayer player, int x, int y, int z, int side, int md) {
        MovingObjectPosition hit = RayTracer.retraceBlock(world, player, x, y, z);
        if (hit == null) {
            return 0;
        }
        if (hit.subHit >= 0 && hit.subHit < 6) {
            player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
            player.swingItem();
            this.markDirty();
            world.markBlockForUpdate(x, y, z);
            this.openSides[hit.subHit] = !this.openSides[hit.subHit];
            ForgeDirection dir = ForgeDirection.getOrientation((int)hit.subHit);
            TileEntity tile = this.worldObj.getTileEntity(this.xCoord + dir.offsetX, this.yCoord + dir.offsetY, this.zCoord + dir.offsetZ);
            if (tile != null && tile instanceof TileTube) {
                ((TileTube)tile).openSides[dir.getOpposite().ordinal()] = this.openSides[hit.subHit];
                world.markBlockForUpdate(this.xCoord + dir.offsetX, this.yCoord + dir.offsetY, this.zCoord + dir.offsetZ);
                tile.markDirty();
            }
        }
        if (hit.subHit == 6) {
            player.worldObj.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:tool", 0.5f, 0.9f + player.worldObj.rand.nextFloat() * 0.2f, false);
            player.swingItem();
            int a = this.facing.ordinal();
            this.markDirty();
            while (++a < 20) {
                if (this.canConnectSide(ForgeDirection.getOrientation((int)(a % 6)).ordinal())) continue;
                this.facing = ForgeDirection.getOrientation((int)(a %= 6));
                world.markBlockForUpdate(x, y, z);
                break;
            }
        }
        return 0;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        super.readCustomNBT(nbttagcompound);
        this.allowFlow = nbttagcompound.getBoolean("flow");
        this.wasPoweredLastTick = nbttagcompound.getBoolean("hadpower");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        super.writeCustomNBT(nbttagcompound);
        nbttagcompound.setBoolean("flow", this.allowFlow);
        nbttagcompound.setBoolean("hadpower", this.wasPoweredLastTick);
    }

    @Override
    public boolean isConnectable(ForgeDirection face) {
        return face != this.facing && super.isConnectable(face);
    }

    @Override
    public void setSuction(Aspect aspect, int amount) {
        if (this.allowFlow) {
            super.setSuction(aspect, amount);
        }
    }

    public boolean gettingPower() {
        return this.worldObj.isBlockIndirectlyGettingPowered(this.xCoord, this.yCoord, this.zCoord);
    }
}

