/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.client.gui;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IParts;
import appeng.api.storage.ITerminalHost;
import appeng.core.localization.GuiText;
import java.io.IOException;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiCraftingCPU;
import net.p455w0rd.wirelesscraftingterminal.client.gui.widgets.GuiTabButton;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftingStatus;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketSwitchGuis;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.items.ItemEnum;
import net.p455w0rd.wirelesscraftingterminal.items.ItemWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;
import org.lwjgl.input.Mouse;

public class GuiCraftingStatus
extends GuiCraftingCPU {
    private final ContainerCraftingStatus status = (ContainerCraftingStatus)this.inventorySlots;
    private GuiButton selectCPU;
    private GuiTabButton originalGuiBtn;
    private int originalGui;
    private ItemStack myIcon = null;

    public GuiCraftingStatus(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerCraftingStatus(inventoryPlayer, te));
        Object target = this.status.getTarget();
        IDefinitions definitions = AEApi.instance().definitions();
        IParts parts = definitions.parts();
        if (target instanceof WirelessTerminalGuiObject) {
            Iterator i$ = definitions.items().wirelessTerminal().maybeStack(1).asSet().iterator();
            while (i$.hasNext()) {
                ItemStack wirelessTerminalStack;
                this.myIcon = wirelessTerminalStack = (ItemStack)i$.next();
            }
            ItemStack is = new ItemStack(ItemEnum.WIRELESS_CRAFTING_TERMINAL.getItem());
            ((ItemWirelessCraftingTerminal)is.getItem()).injectAEPower(is, 6400001.0);
            this.myIcon = is;
            this.originalGui = Reference.GUI_WCT;
        }
    }

    @Override
    protected void actionPerformed(GuiButton btn) {
        super.actionPerformed(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.selectCPU) {
            try {
                NetworkHandler.instance.sendToServer(new PacketValueConfig("Terminal.Cpu", backwards ? "Prev" : "Next"));
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
        if (btn == this.originalGuiBtn) {
            NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.originalGui));
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        this.selectCPU = new GuiButton(0, this.guiLeft + 8, this.guiTop + this.ySize - 25, 150, 20, GuiText.CraftingCPU.getLocal() + ": " + GuiText.NoCraftingCPUs);
        this.buttonList.add(this.selectCPU);
        if (this.myIcon != null) {
            this.originalGuiBtn = new GuiTabButton(this.guiLeft + 213, this.guiTop - 4, this.myIcon, this.myIcon.getDisplayName(), itemRender);
            this.buttonList.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float btn) {
        this.updateCPUButtonText();
        super.drawScreen(mouseX, mouseY, btn);
    }

    private void updateCPUButtonText() {
        String btnTextText = GuiText.NoCraftingJobs.getLocal();
        if (this.status.selectedCpu >= 0) {
            if (this.status.myName.length() > 0) {
                String name = this.status.myName.substring(0, Math.min(20, this.status.myName.length()));
                btnTextText = GuiText.CPUs.getLocal() + ": " + name;
            } else {
                btnTextText = GuiText.CPUs.getLocal() + ": #" + this.status.selectedCpu;
            }
        }
        if (this.status.noCPU) {
            btnTextText = GuiText.NoCraftingJobs.getLocal();
        }
        this.selectCPU.displayString = btnTextText;
    }

    @Override
    protected String getGuiDisplayName(String in) {
        return in;
    }
}

