/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.p455w0rd.wirelesscraftingterminal.client.gui.widgets.WCTGuiButton;
import net.p455w0rd.wirelesscraftingterminal.client.gui.widgets.WCTGuiCheckBox;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerMagnet;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import org.lwjgl.opengl.GL11;

public class GuiMagnet
extends GuiContainer {
    private WCTGuiButton modeBtn;
    public boolean mode = true;
    public boolean ignoreNBT = false;
    public boolean ignoreMeta = false;
    public boolean useOreDict = false;
    private ItemStack magnetItem;
    private WCTGuiCheckBox ignoreNBTBox;
    private WCTGuiCheckBox ignoreMetaBox;
    private WCTGuiCheckBox useOreDictBox;

    public GuiMagnet(ContainerMagnet c) {
        super((Container)c);
        this.width = this.xSize = 176;
        this.height = this.ySize = 208;
        this.magnetItem = c.magnetItem;
        this.loadSettings();
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        this.bindTexture("magnetfilter.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, 176, 208);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.mc.fontRenderer.drawString(LocaleHandler.MagnetFilterTitle.getLocal(), 7, 5, 0x404040);
        this.mc.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 7, 114, 0x404040);
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.modeBtn = new WCTGuiButton(0, this.guiLeft + 104, this.guiTop + 4, 64, 14, this.getLabel(this.mode));
        this.buttonList.add(this.modeBtn);
        this.ignoreNBTBox = new WCTGuiCheckBox(1, this.guiLeft + 61, this.guiTop + 20, "Ignore NBT Data", this.ignoreNBT, 107);
        this.buttonList.add(this.ignoreNBTBox);
        this.ignoreMetaBox = new WCTGuiCheckBox(2, this.guiLeft + 61, this.guiTop + 32, "Ignore Meta Data", this.ignoreMeta, 107);
        this.buttonList.add(this.ignoreMetaBox);
        this.useOreDictBox = new WCTGuiCheckBox(3, this.guiLeft + 61, this.guiTop + 44, "Use Ore Dictionary", this.useOreDict, 107);
        this.buttonList.add(this.useOreDictBox);
    }

    String getLabel(boolean filterMode) {
        return filterMode ? "Whitelisting" : "Blacklisting";
    }

    private void loadSettings() {
        if (this.magnetItem == null) {
            return;
        }
        if (!this.magnetItem.hasTagCompound()) {
            NetworkHandler.instance.sendToServer(new PacketMagnetFilter(0, false));
        }
        this.mode = this.getMode(1);
        this.ignoreNBT = this.getMode(2);
        this.ignoreMeta = this.getMode(3);
        this.useOreDict = this.getMode(4);
    }

    protected void actionPerformed(GuiButton btn) {
        if (btn == this.modeBtn) {
            btn.displayString = this.getLabel(!this.mode);
            this.mode = !this.mode;
            this.updateMode(1, this.mode);
        } else if (btn == this.ignoreNBTBox) {
            this.ignoreNBT = !this.ignoreNBT;
            this.updateMode(2, this.ignoreNBT);
        } else if (btn == this.ignoreMetaBox) {
            this.ignoreMeta = !this.ignoreMeta;
            this.updateMode(3, this.ignoreMeta);
        } else if (btn == this.useOreDictBox) {
            this.useOreDict = !this.useOreDict;
            this.updateMode(4, this.useOreDict);
        } else {
            return;
        }
    }

    private void updateMode(int type, boolean mode) {
        NetworkHandler.instance.sendToServer(new PacketMagnetFilter(type, mode));
    }

    private boolean getMode(int type) {
        NBTTagCompound nbtTC = this.magnetItem.getTagCompound();
        if (type == 1) {
            if (nbtTC.hasKey("Whitelisting")) {
                return nbtTC.getBoolean("Whitelisting");
            }
            return true;
        }
        if (type == 2) {
            if (nbtTC.hasKey("IgnoreNBT")) {
                return nbtTC.getBoolean("IgnoreNBT");
            }
            return false;
        }
        if (type == 3) {
            if (nbtTC.hasKey("IgnoreMeta")) {
                return nbtTC.getBoolean("IgnoreMeta");
            }
            return false;
        }
        if (type == 4) {
            if (nbtTC.hasKey("UseOreDict")) {
                return nbtTC.getBoolean("UseOreDict");
            }
            return false;
        }
        return true;
    }

    public void bindTexture(String file) {
        ResourceLocation loc = new ResourceLocation("ae2wct", "textures/gui/" + file);
        this.mc.getTextureManager().bindTexture(loc);
    }
}

