/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryMagnetFilter;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;

public class ContainerMagnet
extends Container {
    public final InventoryPlayer inventoryPlayer;
    public ItemStack magnetItem;
    public WCTInventoryMagnetFilter magnetInventory;
    private int distributeState = 0;
    private int pressedKeyInRange = -1;
    private final Set distributeSlotSet = new HashSet();
    private final int PLAYER_INV_START = 0;
    private final int PLAYER_INV_END = 26;
    private final int HOTBAR_START = 27;
    private final int HOTBAR_END = 35;
    private final int FILTERS_START = 36;
    private final int FILTERS_END = 62;

    public ContainerMagnet(EntityPlayer player, InventoryPlayer inventoryPlayer) {
        int j;
        int i;
        this.inventoryPlayer = inventoryPlayer;
        this.magnetItem = RandomUtils.getMagnet(inventoryPlayer);
        this.magnetInventory = new WCTInventoryMagnetFilter(this.magnetItem);
        this.magnetInventory.setContainer(this);
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)this.inventoryPlayer, j + i * 9 + 9, j * 18 + 8, 126 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)this.inventoryPlayer, i, i * 18 + 8, 184));
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotMagnetFilter(this.magnetInventory, j + i * 9, j * 18 + 8, 58 + i * 18));
            }
        }
    }

    private boolean isInHotbar(int slotNum) {
        return slotNum >= 27 && slotNum <= 35;
    }

    private boolean isInPlayerInventory(int slotNum) {
        return slotNum >= 0 && slotNum <= 26;
    }

    private boolean isInFilters(int slotNum) {
        return slotNum >= 36 && slotNum <= 62;
    }

    public boolean canInteractWith(EntityPlayer p) {
        return true;
    }

    private boolean alreadyFiltered(ItemStack item) {
        for (int i = 0; i < this.magnetInventory.getSizeInventory(); ++i) {
            if (!this.isIdenticalItem(item, this.magnetInventory.getStackInSlot(i))) continue;
            return true;
        }
        return false;
    }

    public ItemStack slotClick(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        if (slotNum >= this.inventorySlots.size()) {
            return null;
        }
        InventoryPlayer inventoryplayer = player.inventory;
        ItemStack stack = null;
        if (slotNum == -999) {
            if (inventoryplayer.getItemStack() != null && slotNum == -999) {
                if (mouseButton == 0) {
                    player.dropPlayerItemWithRandomChoice(inventoryplayer.getItemStack(), true);
                    inventoryplayer.setItemStack((ItemStack)null);
                }
                if (mouseButton == 1) {
                    player.dropPlayerItemWithRandomChoice(inventoryplayer.getItemStack().splitStack(1), true);
                    if (inventoryplayer.getItemStack().stackSize == 0) {
                        inventoryplayer.setItemStack((ItemStack)null);
                    }
                }
            }
            return null;
        }
        if (modifier == 5) {
            int currentDistributeState = this.distributeState;
            this.distributeState = ContainerMagnet.checkForPressedButton(mouseButton);
            if ((currentDistributeState != 1 || this.distributeState != 2) && currentDistributeState != this.distributeState) {
                this.resetDistributionVariables();
            } else if (inventoryplayer.getItemStack() == null) {
                this.resetDistributionVariables();
            } else if (this.distributeState == 0) {
                this.pressedKeyInRange = ContainerMagnet.checkForPressedButton2(mouseButton);
                if (ContainerMagnet.checkValue(this.pressedKeyInRange)) {
                    this.distributeState = 1;
                    this.distributeSlotSet.clear();
                } else {
                    this.resetDistributionVariables();
                }
            } else if (this.distributeState == 1) {
                Slot slot = (Slot)this.inventorySlots.get(slotNum);
                if (slot != null && ContainerMagnet.stackFitsInSlot(slot, inventoryplayer.getItemStack(), true) && slot.isItemValid(inventoryplayer.getItemStack()) && inventoryplayer.getItemStack().stackSize > this.distributeSlotSet.size() && this.canDragIntoSlot(slot)) {
                    this.distributeSlotSet.add(slot);
                }
            } else if (this.distributeState == 2) {
                if (!this.distributeSlotSet.isEmpty()) {
                    ItemStack itemstack3 = inventoryplayer.getItemStack().copy();
                    int sizeOrID = inventoryplayer.getItemStack().stackSize;
                    for (Slot slot1 : this.distributeSlotSet) {
                        if (slot1 == null || !ContainerMagnet.stackFitsInSlot(slot1, inventoryplayer.getItemStack(), true) || !slot1.isItemValid(inventoryplayer.getItemStack()) || inventoryplayer.getItemStack().stackSize < this.distributeSlotSet.size() || !this.canDragIntoSlot(slot1)) continue;
                        ItemStack itemstack1 = itemstack3.copy();
                        int j1 = slot1.getHasStack() ? slot1.getStack().stackSize : 0;
                        ContainerMagnet.setSlotStack(this.distributeSlotSet, this.pressedKeyInRange, itemstack1, j1);
                        if (itemstack1.stackSize > itemstack1.getMaxStackSize()) {
                            itemstack1.stackSize = itemstack1.getMaxStackSize();
                        }
                        if (itemstack1.stackSize > slot1.getSlotStackLimit()) {
                            itemstack1.stackSize = slot1.getSlotStackLimit();
                        }
                        sizeOrID -= itemstack1.stackSize - j1;
                        slot1.putStack(itemstack1);
                    }
                    itemstack3.stackSize = sizeOrID;
                    if (itemstack3.stackSize <= 0) {
                        itemstack3 = null;
                    }
                    inventoryplayer.setItemStack(itemstack3);
                }
                this.resetDistributionVariables();
            } else {
                this.resetDistributionVariables();
            }
        } else if (this.distributeState != 0) {
            this.resetDistributionVariables();
        } else {
            if (this.getSlot(slotNum) != null && this.getSlot(slotNum) instanceof SlotMagnetFilter) {
                SlotMagnetFilter slot = (SlotMagnetFilter)this.getSlot(slotNum);
                ItemStack stackSlot = slot.getStack();
                if (this.alreadyFiltered(player.inventory.getItemStack()) && player.inventory.getItemStack() != null) {
                    return null;
                }
                if (stackSlot != null) {
                    stack = stackSlot.copy();
                }
                if (mouseButton == 2) {
                    this.fillPhantomSlot(slot, null, mouseButton);
                } else if (mouseButton == 0 || mouseButton == 1) {
                    InventoryPlayer playerInv = player.inventory;
                    ItemStack stackHeld = playerInv.getItemStack();
                    if (stackSlot == null) {
                        if (stackHeld != null && slot.isItemValid(stackHeld)) {
                            this.fillPhantomSlot(slot, stackHeld, mouseButton);
                        }
                    } else if (stackHeld == null) {
                        this.adjustPhantomSlot(slot, mouseButton, modifier);
                    } else if (slot.isItemValid(stackHeld)) {
                        if (this.isIdenticalItem(stackSlot, stackHeld)) {
                            this.adjustPhantomSlot(slot, mouseButton, modifier);
                        } else {
                            this.fillPhantomSlot(slot, stackHeld, mouseButton);
                        }
                    }
                }
                return stack;
            }
            return super.slotClick(slotNum, mouseButton, modifier, player);
        }
        return stack;
    }

    public boolean alwaysTrue(Slot slot) {
        return true;
    }

    public static void setSlotStack(Set slotSet, int stackSizeSelector, ItemStack stackToResize, int currentSlotStackSize) {
        switch (stackSizeSelector) {
            case 0: {
                stackToResize.stackSize = MathHelper.floor_float((float)((float)stackToResize.stackSize / (float)slotSet.size()));
                break;
            }
            case 1: {
                stackToResize.stackSize = 1;
            }
        }
        stackToResize.stackSize += currentSlotStackSize;
    }

    public static boolean stackFitsInSlot(Slot slot, ItemStack itemStack, boolean sizeMatters) {
        boolean flag1;
        boolean bl = flag1 = slot == null || !slot.getHasStack();
        if (slot != null && slot.getHasStack() && itemStack != null && itemStack.isItemEqual(slot.getStack()) && ItemStack.areItemStackTagsEqual((ItemStack)slot.getStack(), (ItemStack)itemStack)) {
            int i = sizeMatters ? 0 : itemStack.stackSize;
            flag1 |= slot.getStack().stackSize + i <= itemStack.getMaxStackSize();
        }
        return flag1;
    }

    public static int checkForPressedButton(int btn) {
        return btn & 3;
    }

    public static int checkForPressedButton2(int mouseButtonPressed) {
        return mouseButtonPressed >> 2 & 3;
    }

    public static boolean checkValue(int value) {
        return value == 0 || value == 1;
    }

    protected void resetDistributionVariables() {
        this.distributeState = 0;
        this.distributeSlotSet.clear();
    }

    private void arrangeSlots() {
        int invSize = this.magnetInventory.getSizeInventory();
        if (invSize <= 0) {
            return;
        }
        block0: for (int i = 0; i < invSize; ++i) {
            if (this.magnetInventory.getStackInSlot(i) != null) continue;
            for (int j = 0; j < invSize; ++j) {
                if (j <= i || this.magnetInventory.getStackInSlot(j) == null) continue;
                this.magnetInventory.setInventorySlotContents(i, this.magnetInventory.getStackInSlot(j));
                this.magnetInventory.decrStackSize(j, 1);
                continue block0;
            }
        }
    }

    private void fillPhantomSlot(SlotMagnetFilter slot, ItemStack stackHeld, int mouseButton) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        if (stackHeld == null) {
            slot.putStack(null);
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.stackSize : 1;
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        ItemStack phantomStack = stackHeld.copy();
        RandomUtils.removeTimerTags(phantomStack);
        phantomStack.stackSize = stackSize;
        slot.putStack(phantomStack);
        this.arrangeSlots();
    }

    private void adjustPhantomSlot(SlotMagnetFilter slot, int mouseButton, int modifier) {
        int stackSize;
        if (!slot.canAdjustPhantom()) {
            return;
        }
        ItemStack stackSlot = slot.getStack();
        if (modifier == 1) {
            stackSize = mouseButton == 0 ? (stackSlot.stackSize + 1) / 2 : stackSlot.stackSize * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.stackSize - 1 : stackSlot.stackSize + 1;
        }
        if (stackSize > slot.getSlotStackLimit()) {
            stackSize = slot.getSlotStackLimit();
        }
        stackSlot.stackSize = stackSize;
        if (stackSlot.stackSize <= 0) {
            stackSlot = null;
        }
        slot.putStack(stackSlot);
        this.arrangeSlots();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemStack transferStackInSlot(EntityPlayer p, int slotIndex) {
        Slot slot = (Slot)this.inventorySlots.get(slotIndex);
        if (slot == null || slot.getStack() == null) {
            return null;
        }
        ItemStack stack = slot.getStack();
        if (this.isInHotbar(slotIndex)) {
            if (this.mergePhantomStack(stack)) return null;
            if (!this.mergeItemStack(stack, 0, 27, false)) {
                return null;
            }
        } else {
            if (!this.isInPlayerInventory(slotIndex)) return null;
            if (this.mergePhantomStack(stack)) return null;
            if (!this.mergeItemStack(stack, 27, 36, false)) {
                return null;
            }
        }
        if (stack.stackSize == 0) {
            slot.putStack((ItemStack)null);
        } else {
            slot.onSlotChanged();
        }
        slot.onPickupFromSlot(p, stack);
        return stack;
    }

    protected boolean mergePhantomStack(ItemStack stack) {
        if (!this.alreadyFiltered(stack)) {
            for (int i = 36; i <= 62; ++i) {
                if (this.getSlot(i).getStack() != null) continue;
                this.fillPhantomSlot((SlotMagnetFilter)this.getSlot(i), stack, 0);
                return true;
            }
        }
        return false;
    }

    public boolean isIdenticalItem(ItemStack lhs, ItemStack rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.getItem() != rhs.getItem()) {
            return false;
        }
        if (lhs.getItemDamage() != Short.MAX_VALUE && lhs.getItemDamage() != rhs.getItemDamage()) {
            return false;
        }
        return ItemStack.areItemStackTagsEqual((ItemStack)lhs, (ItemStack)rhs);
    }

    protected boolean mergeItemStack(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (!backwards && k < end || backwards && k >= start)) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getItemDamage() == itemstack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.stackSize + stack.stackSize;
                    if (l <= stack.getMaxStackSize() && l <= slot.getSlotStackLimit()) {
                        stack.stackSize = 0;
                        itemstack1.stackSize = l;
                        this.magnetInventory.markDirty();
                        flag1 = true;
                    } else if (itemstack1.stackSize < stack.getMaxStackSize() && l < slot.getSlotStackLimit()) {
                        stack.stackSize -= stack.getMaxStackSize() - itemstack1.stackSize;
                        itemstack1.stackSize = stack.getMaxStackSize();
                        this.magnetInventory.markDirty();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.stackSize > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.stackSize;
                    if (l <= slot.getSlotStackLimit()) {
                        slot.putStack(stack.copy());
                        stack.stackSize = 0;
                        this.magnetInventory.markDirty();
                        flag1 = true;
                        break;
                    }
                    this.putStackInSlot(k, new ItemStack(stack.getItem(), slot.getSlotStackLimit(), stack.getItemDamage()));
                    stack.stackSize -= slot.getSlotStackLimit();
                    this.magnetInventory.markDirty();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }
}

