/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.container.ContainerNull;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTIActionHost;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTPlayerSource;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerOpenContext;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.GuiSync;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.SyncData;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngCraftingSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.NullSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotArmor;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotBooster;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingMatrix;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingTerm;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotDisabled;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotFake;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotInaccessible;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerHotBar;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerInv;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotTrash;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryBooster;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryCrafting;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryMagnet;
import net.p455w0rd.wirelesscraftingterminal.common.inventory.WCTInventoryTrash;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketInventoryAction;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMEInventoryUpdate;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketPartialItem;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.handlers.LocaleHandler;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;
import net.p455w0rd.wirelesscraftingterminal.items.ItemMagnet;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class ContainerWirelessCraftingTerminal
extends Container
implements IConfigManagerHost,
IConfigurableObject,
IMEMonitorHandlerReceiver<IAEItemStack>,
IAEAppEngInventory,
IContainerCraftingPacket {
    private final ItemStack containerstack;
    public WCTInventoryCrafting craftingGrid;
    public final WCTInventoryBooster boosterInventory;
    public final WCTInventoryMagnet magnetInventory;
    public final WCTInventoryTrash trashInventory;
    public final InventoryPlayer inventoryPlayer;
    public ItemStack[] craftMatrixInventory;
    public ItemStack craftItem;
    private World worldObj;
    private EntityPlayer player;
    private static final int HOTBAR_START = 1;
    private static final int HOTBAR_END = 9;
    private static final int INV_START = 10;
    private static final int INV_END = 36;
    private static final int ARMOR_START = 37;
    private static final int ARMOR_END = 40;
    private static final int CRAFT_GRID_START = 41;
    private static final int CRAFT_GRID_END = 49;
    private static final int CRAFT_RESULT = 50;
    private static final int BOOSTER_INDEX = 0;
    private static final int MAGNET_INDEX = 51;
    public static int CRAFTING_SLOT_X_POS = 80;
    public static int CRAFTING_SLOT_Y_POS = 83;
    private SlotBooster boosterSlot;
    private SlotMagnet magnetSlot;
    private NullSlot nullSlot;
    private Slot[] hotbarSlot;
    private Slot[] inventorySlot;
    private SlotArmor[] armorSlot;
    private SlotCraftingMatrix[] craftMatrixSlot;
    private SlotCraftingTerm craftingSlot;
    public SlotTrash trashSlot;
    private int firstCraftingSlotNumber = -1;
    private int lastCraftingSlotNumber = -1;
    private final WirelessTerminalGuiObject obj;
    private boolean isContainerValid = true;
    private double powerMultiplier = 0.5;
    private final IPortableCell civ;
    private int ticks = 0;
    private final IMEMonitor<IAEItemStack> monitor;
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final IConfigManager clientCM;
    private IConfigManager serverCM;
    private IEnergySource powerSrc;
    @GuiSync(value=98)
    public static boolean hasPower = false;
    private IConfigManagerHost gui;
    private final BaseActionSource mySrc;
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private final List<PacketPartialItem> dataChunks = new LinkedList<PacketPartialItem>();
    private IAEItemStack clientRequestedTargetItem = null;
    private int ticksSinceCheck = 900;
    private String customName;
    private boolean sentCustomName;
    private ContainerOpenContext openContext;
    private final AppEngInternalInventory output = new AppEngInternalInventory((IAEAppEngInventory)this, 1);
    private final HashSet<Integer> locked = new HashSet();
    private IWirelessCraftingTerminalItem thisItem;
    private IGridNode networkNode;
    private IMEInventoryHandler<IAEItemStack> cellInv;

    public ContainerWirelessCraftingTerminal(EntityPlayer player, InventoryPlayer inventoryPlayer) {
        int j;
        int i;
        IGridNode node;
        this.clientCM = new ConfigManager((IConfigManagerHost)this);
        this.clientCM.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        this.clientCM.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        this.clientCM.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        this.mySrc = new WCTPlayerSource(inventoryPlayer.player, this.getActionHost());
        this.customName = "WCTContainer";
        this.boosterInventory = new WCTInventoryBooster(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.magnetInventory = new WCTInventoryMagnet(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.trashInventory = new WCTInventoryTrash(RandomUtils.getWirelessTerm(inventoryPlayer));
        this.containerstack = RandomUtils.getWirelessTerm(inventoryPlayer);
        this.thisItem = (IWirelessCraftingTerminalItem)this.containerstack.getItem();
        this.worldObj = player.worldObj;
        this.craftingGrid = new WCTInventoryCrafting(this, 3, 3, this.containerstack);
        this.inventoryPlayer = inventoryPlayer;
        this.player = player;
        this.craftMatrixInventory = new ItemStack[9];
        this.hotbarSlot = new Slot[9];
        this.inventorySlot = new Slot[27];
        this.armorSlot = new SlotArmor[4];
        this.craftMatrixSlot = new SlotCraftingMatrix[9];
        this.obj = this.getGuiObject(this.containerstack, player, this.worldObj, (int)player.posX, (int)player.posY, (int)player.posZ);
        this.civ = this.obj;
        this.networkNode = node = this.obj.getGridNode(ForgeDirection.UNKNOWN);
        this.prepareSync();
        if (Platform.isServer()) {
            this.serverCM = this.civ.getConfigManager();
            this.monitor = this.civ.getItemInventory();
            if (this.monitor != null) {
                this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
                this.setCellInventory((IMEInventoryHandler<IAEItemStack>)this.monitor);
                if (this.civ instanceof IPortableCell) {
                    this.setPowerSource((IEnergySource)this.civ);
                }
            } else {
                this.setValidContainer(false);
            }
        } else {
            this.monitor = null;
        }
        if (Reference.WCT_BOOSTER_ENABLED) {
            this.boosterSlot = new SlotBooster(this.boosterInventory, 0, 134, -20);
            this.addSlotToContainer(this.boosterSlot);
        } else {
            this.nullSlot = new NullSlot();
            this.addSlotToContainer(this.nullSlot);
        }
        for (int i2 = 0; i2 < 9; ++i2) {
            this.hotbarSlot[i2] = new SlotPlayerHotBar((IInventory)this.inventoryPlayer, i2, i2 * 18 + 8, 58);
            this.addSlotToContainer(this.hotbarSlot[i2]);
        }
        int k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.inventorySlot[k] = new SlotPlayerInv((IInventory)this.inventoryPlayer, j + i * 9 + 9, j * 18 + 8, 0 + i * 18);
                this.addSlotToContainer(this.inventorySlot[k]);
                ++k;
            }
        }
        for (i = 0; i < 4; ++i) {
            this.armorSlot[i] = new SlotArmor(this.player, (IInventory)this.inventoryPlayer, 39 - i, 8, i * 18 - 76, i);
            this.addSlotToContainer(this.armorSlot[i]);
        }
        k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.craftMatrixSlot[k] = new SlotCraftingMatrix(this, (IInventory)this.craftingGrid, j + i * 3, 80 + j * 18, i * 18 - 76);
                this.addSlotToContainer(this.craftMatrixSlot[k]);
                if (k == 0) {
                    this.firstCraftingSlotNumber = this.craftMatrixSlot[k].slotNumber;
                }
                ++k;
            }
        }
        this.lastCraftingSlotNumber = this.craftMatrixSlot[8].slotNumber;
        this.craftingSlot = new SlotCraftingTerm(this.getPlayerInv().player, this.mySrc, this.getPowerSource(), (IStorageMonitorable)this.obj, (IInventory)this.craftingGrid, (IInventory)this.craftingGrid, (IInventory)this.output, 174, -58, this);
        this.addSlotToContainer(this.craftingSlot);
        this.magnetSlot = new SlotMagnet(this.magnetInventory, 152, -20);
        this.addSlotToContainer(this.magnetSlot);
        this.trashSlot = new SlotTrash((IInventory)this.trashInventory, 80, -20, player);
        this.trashSlot.setContainer(this);
        this.addSlotToContainer(this.trashSlot);
        this.updateCraftingMatrix();
        this.onCraftMatrixChanged((IInventory)this.craftingGrid);
        this.thisItem.checkForBooster(this.containerstack);
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public void onSlotChange(Slot s) {
    }

    protected Slot addSlotToContainer(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
            return super.addSlotToContainer(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "] for WCT Container instead of AppEngSlot.");
    }

    public boolean canDragIntoSlot(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    public void onCraftMatrixChanged(IInventory iinv) {
        ContainerNull cn = new ContainerNull();
        InventoryCrafting ic = new InventoryCrafting((Container)cn, 3, 3);
        for (int x = 0; x < 9; ++x) {
            ic.setInventorySlotContents(x, this.craftMatrixSlot[x].getStack());
        }
        this.craftingSlot.putStack(CraftingManager.getInstance().findMatchingRecipe(ic, this.worldObj));
        this.writeToNBT("crafting");
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.inventorySlots.size()) {
            Slot s = this.getSlot(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.inventory.getItemStack();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand == null) {
                            s.putStack(null);
                            break;
                        }
                        s.putStack(hand.copy());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand == null) break;
                        ItemStack is = hand.copy();
                        is.stackSize = 1;
                        s.putStack(is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        ItemStack is = s.getStack();
                        if (is != null) {
                            if (hand == null) {
                                --is.stackSize;
                            } else if (hand.isItemEqual(is)) {
                                is.stackSize = Math.min(is.getMaxStackSize(), is.stackSize + 1);
                            } else {
                                is = hand.copy();
                                is.stackSize = 1;
                            }
                            s.putStack(is);
                            break;
                        }
                        if (hand == null) break;
                        is = hand.copy();
                        is.stackSize = 1;
                        s.putStack(is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                LinkedList<Slot> from = new LinkedList<Slot>();
                for (Object j : this.inventorySlots) {
                    if (!(j instanceof Slot) || j.getClass() != s.getClass()) continue;
                    from.add((Slot)j);
                }
                for (Slot fr : from) {
                    this.transferStackInSlot((EntityPlayer)player, fr.slotNumber);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.getItemStack();
                ais.setStackSize((long)myItem.getMaxStackSize());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                myItem.stackSize = (int)ais.getStackSize();
                myItem = adp.simulateAdd(myItem);
                if (myItem != null) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.stackSize);
                }
                if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) break;
                adp.addItems(ais.getItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.inventory.getItemStack();
                if (isg == null) break;
                IAEItemStack ais = AEApi.instance().storage().createItemStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.removeItems(1, extracted.getItemStack(), null);
                if (fail == null) {
                    this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.inventory.getItemStack();
                if (item != null) {
                    if (item.stackSize >= item.getMaxStackSize()) {
                        liftQty = 0;
                    }
                    if (!Platform.isSameItemPrecise((ItemStack)slotItem.getItemStack(), (ItemStack)item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais == null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.addItems(ais.getItemStack());
                if (fail != null) {
                    this.getCellInventory().injectItems((IAEStack)ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.inventory.getItemStack() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize((long)ais.getItemStack().getMaxStackSize());
                    ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    if (ais != null) {
                        player.inventory.setItemStack(ais.getItemStack());
                    } else {
                        player.inventory.setItemStack(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.inventory.getItemStack());
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) {
                    player.inventory.setItemStack(ais.getItemStack());
                } else {
                    player.inventory.setItemStack(null);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.inventory.getItemStack() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getItemStack().getMaxStackSize();
                    ais.setStackSize(maxSize);
                    ais = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    }
                    if (ais != null) {
                        player.inventory.setItemStack(ais.getItemStack());
                    } else {
                        player.inventory.setItemStack(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.inventory.getItemStack());
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                ItemStack is = player.inventory.getItemStack();
                --is.stackSize;
                if (is.stackSize <= 0) {
                    player.inventory.setItemStack(null);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.capabilities.isCreativeMode || slotItem == null) break;
                ItemStack is = slotItem.getItemStack();
                is.stackSize = is.getMaxStackSize();
                player.inventory.setItemStack(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.getItemStack();
                    ais.setStackSize((long)myItem.getMaxStackSize());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    myItem.stackSize = (int)ais.getStackSize();
                    myItem = adp.simulateAdd(myItem);
                    if (myItem != null) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.stackSize);
                    }
                    if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.getItemStack());
                }
                break;
            }
        }
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance.sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.create((ItemStack)p.inventory.getItemStack())), p);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    private void updateCraftingMatrix() {
        if (!this.containerstack.hasTagCompound()) {
            this.containerstack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound stack = this.containerstack.getTagCompound();
        this.readMatrixNBT(stack);
        for (int i = 0; i < 9; ++i) {
            this.craftingGrid.setInventorySlotContents(i, this.craftMatrixInventory[i]);
        }
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public boolean useRealItems() {
        return true;
    }

    public IInventory getInventoryByName(String name) {
        if (name.equals("player") || name.equals("container.inventory")) {
            return this.getInventoryPlayer();
        }
        if (name.equals("crafting")) {
            return this.craftingGrid;
        }
        return null;
    }

    public ItemStack[] getViewCells() {
        return null;
    }

    private WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public void detectAndSendChanges() {
        this.sendCustomName();
        ++this.ticks;
        if (this.ticks > 10) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            } else {
                this.civ.extractAEPower((double)((int)(0.5 * (double)this.ticks)), Actionable.MODULATE, PowerMultiplier.CONFIG);
            }
            this.ticks = 0;
        }
        if (Platform.isServer()) {
            if (this.monitor != this.civ.getItemInventory()) {
                this.setValidContainer(false);
            }
            for (Settings set : this.serverCM.getSettings()) {
                Enum sideRemote;
                Enum sideLocal = this.serverCM.getSetting(set);
                if (sideLocal == (sideRemote = this.clientCM.getSetting(set))) continue;
                this.clientCM.putSetting(set, sideLocal);
                for (Object crafter : this.crafters) {
                    try {
                        NetworkHandler.instance.sendTo(new PacketValueConfig(set.name(), sideLocal.name()), (EntityPlayerMP)crafter);
                    }
                    catch (IOException e) {
                        WCTLog.debug(e.getMessage(), new Object[0]);
                    }
                }
            }
            if (!this.items.isEmpty()) {
                try {
                    IItemList monitorCache = this.monitor.getStorageList();
                    PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                    for (IAEItemStack is : this.items) {
                        IAEItemStack send = (IAEItemStack)monitorCache.findPrecise((IAEStack)is);
                        if (send == null) {
                            is.setStackSize(0L);
                            piu.appendItem(is);
                            continue;
                        }
                        piu.appendItem(send);
                    }
                    if (!piu.isEmpty()) {
                        this.items.resetStatus();
                        for (Object c : this.crafters) {
                            if (!(c instanceof EntityPlayer)) continue;
                            NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        }
                    }
                }
                catch (IOException e) {
                    WCTLog.debug(e.getMessage(), new Object[0]);
                }
            }
            this.sendCustomName();
            if (Platform.isServer()) {
                for (Object crafter : this.crafters) {
                    ICrafting icrafting = (ICrafting)crafter;
                    for (SyncData sd : this.syncData.values()) {
                        sd.tick(icrafting);
                    }
                }
            }
        }
        if (!this.isInRange()) {
            if (!this.isBoosterInstalled() || !Reference.WCT_BOOSTER_ENABLED) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().player.addChatMessage(PlayerMessages.OutOfRange.get());
                }
                this.setValidContainer(false);
            }
            if (!this.networkIsPowered()) {
                if (this.isValidContainer()) {
                    this.getPlayerInv().player.addChatMessage((IChatComponent)new ChatComponentText(LocaleHandler.NoNetworkPower.getLocal()));
                }
                this.setValidContainer(false);
            }
        } else if (!(this.hasAccess(SecurityPermissions.CRAFT, true) && this.hasAccess(SecurityPermissions.EXTRACT, true) && this.hasAccess(SecurityPermissions.INJECT, true))) {
            if (this.isValidContainer()) {
                this.getPlayerInv().player.addChatMessage(PlayerMessages.CommunicationError.get());
            }
            this.setValidContainer(false);
        } else {
            this.setPowerMultiplier(AEConfig.instance.wireless_getDrainRate(this.obj.getRange()));
        }
        super.detectAndSendChanges();
    }

    public boolean isBoosterInstalled() {
        Item boosterSlotContents;
        Slot slot = this.getSlotFromInventory(this.boosterInventory, 0);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.getSlotFromInventory(this.boosterInventory, 0).getHasStack();
        return hasStack && (boosterSlotContents = this.getSlotFromInventory(this.boosterInventory, 0).getStack().getItem()) instanceof ItemInfinityBooster;
    }

    public boolean isMagnetInstalled() {
        Item magnetSlotContents;
        Slot slot = this.getSlotFromInventory(this.magnetInventory, 51);
        if (slot == null) {
            return false;
        }
        boolean hasStack = this.getSlotFromInventory(this.magnetInventory, 51).getHasStack();
        return hasStack && (magnetSlotContents = this.getSlotFromInventory(this.magnetInventory, 51).getStack().getItem()) instanceof ItemMagnet;
    }

    public BaseActionSource getActionSource() {
        return this.mySrc;
    }

    public boolean canInteractWith(EntityPlayer entityplayer) {
        return this.isValidContainer();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.obj;
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this;
                }
                if (name != null) {
                    if (name.hasCustomName()) {
                        this.setCustomName(name.getCustomName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance.sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().player);
                        }
                        catch (IOException e) {
                            WCTLog.debug(e.getMessage(), new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean isInRange() {
        return this.obj.rangeCheck(Reference.WCT_BOOSTER_ENABLED && this.isBoosterInstalled());
    }

    protected boolean networkIsPowered() {
        IEnergyGrid eg;
        IGrid grid;
        WCTIActionHost host = this.getActionHost();
        return host != null && (grid = this.obj.getTargetGrid()) != null && (eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class)).isNetworkPowered();
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IEnergyGrid eg;
        IGrid grid = this.obj.getTargetGrid();
        if (grid != null && !(eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class)).isNetworkPowered()) {
            return false;
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        return sg.hasPermission(this.getInventoryPlayer().player, perm);
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public void postPartial(PacketPartialItem packetPartialItem) {
        this.dataChunks.add(packetPartialItem);
        if (packetPartialItem.getPageCount() == this.dataChunks.size()) {
            this.parsePartials();
        }
    }

    private void parsePartials() {
        int total = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            total += ppi.getSize();
        }
        byte[] buffer = new byte[total];
        int cursor = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            cursor = ppi.write(buffer, cursor);
        }
        try {
            NBTTagCompound data = CompressedStreamTools.readCompressed((InputStream)new ByteArrayInputStream(buffer));
            if (data != null) {
                this.setTargetStack(AEApi.instance().storage().createItemStack(ItemStack.loadItemStackFromNBT((NBTTagCompound)data)));
            }
        }
        catch (IOException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        this.dataChunks.clear();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            ItemStack b;
            ItemStack a = stack == null ? null : stack.getItemStack();
            ItemStack itemStack = b = this.clientRequestedTargetItem == null ? null : this.clientRequestedTargetItem.getItemStack();
            if (Platform.isSameItemPrecise((ItemStack)a, (ItemStack)b)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            NBTTagCompound item = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(item);
            }
            try {
                CompressedStreamTools.writeCompressed((NBTTagCompound)item, (OutputStream)stream);
                int maxChunkSize = 30000;
                LinkedList<byte[]> miniPackets = new LinkedList<byte[]>();
                byte[] data = stream.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(data, 0, stream.size());
                while (bis.available() > 0) {
                    int nextBLock = bis.available() > 30000 ? 30000 : bis.available();
                    byte[] nextSegment = new byte[nextBLock];
                    bis.read(nextSegment);
                    miniPackets.add(nextSegment);
                }
                bis.close();
                stream.close();
                int page = 0;
                for (byte[] packet : miniPackets) {
                    PacketPartialItem ppi = new PacketPartialItem(page, miniPackets.size(), packet);
                    ++page;
                    NetworkHandler.instance.sendToServer(ppi);
                }
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
                return;
            }
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                WCTLog.warning("Channel already in use: " + annotation.value() + " for " + f.getName(), new Object[0]);
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    protected WCTIActionHost getActionHost() {
        if (this.obj instanceof WCTIActionHost) {
            return this.obj;
        }
        return null;
    }

    public IConfigManager getConfigManager() {
        if (Platform.isServer()) {
            return this.serverCM;
        }
        return this.clientCM;
    }

    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        if (this.getGui() != null) {
            this.getGui().updateSetting(manager, settingName, newValue);
        }
    }

    private IConfigManagerHost getGui() {
        return this.gui;
    }

    public void setGui(@Nonnull IConfigManagerHost gui) {
        this.gui = gui;
    }

    public void onListUpdate() {
        for (Object c : this.crafters) {
            if (!(c instanceof ICrafting)) continue;
            ICrafting cr = (ICrafting)c;
            this.queueInventory(cr);
        }
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource source) {
        for (IAEItemStack is : change) {
            this.items.add((IAEStack)is);
        }
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void onContainerClosed(EntityPlayer player) {
        super.onContainerClosed(player);
        if (this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void addCraftingToCrafters(ICrafting c) {
        super.addCraftingToCrafters(c);
        this.queueInventory(c);
    }

    public void removeCraftingFromCrafters(ICrafting c) {
        super.removeCraftingFromCrafters(c);
        if (this.crafters.isEmpty() && this.monitor != null) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    private void queueInventory(ICrafting c) {
        if (Platform.isServer() && c instanceof EntityPlayer && this.monitor != null) {
            try {
                PacketMEInventoryUpdate piu = new PacketMEInventoryUpdate();
                IItemList monitorCache = this.monitor.getStorageList();
                for (IAEItemStack send : monitorCache) {
                    try {
                        piu.appendItem(send);
                    }
                    catch (BufferOverflowException boe) {
                        NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
                        piu = new PacketMEInventoryUpdate();
                        piu.appendItem(send);
                    }
                }
                NetworkHandler.instance.sendTo(piu, (EntityPlayerMP)c);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public boolean isPowered() {
        double pwr = this.thisItem.getAECurrentPower(this.containerstack);
        return pwr > 0.0;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.inventoryPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public Object getTarget() {
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    private void readMatrixNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.getTagList("CraftingMatrix", 10);
        this.craftMatrixInventory = new ItemStack[9];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slot = tagCompound.getByte("Slot");
            if (slot < 0 || slot >= this.craftMatrixInventory.length) continue;
            this.craftMatrixInventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    public void writeToNBT(String which) {
        if (!this.containerstack.hasTagCompound()) {
            this.containerstack.setTagCompound(new NBTTagCompound());
        }
        switch (which) {
            case "booster": {
                this.boosterInventory.writeNBT(this.containerstack.getTagCompound());
                break;
            }
            case "crafting": {
                this.craftingGrid.writeNBT(this.containerstack.getTagCompound());
                break;
            }
            case "magnet": {
                this.magnetInventory.writeNBT(this.containerstack.getTagCompound());
                break;
            }
            case "trash": {
                this.trashInventory.writeNBT(this.containerstack.getTagCompound());
                break;
            }
            default: {
                this.boosterInventory.writeNBT(this.containerstack.getTagCompound());
                this.craftingGrid.writeNBT(this.containerstack.getTagCompound());
                this.magnetInventory.writeNBT(this.containerstack.getTagCompound());
                this.trashInventory.writeNBT(this.containerstack.getTagCompound());
            }
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer p, int idx) {
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.inventorySlots.get(idx));
        ItemStack tis = clickSlot.getStack();
        if (tis == null) {
            return null;
        }
        if (this.isInInventory(idx) || this.isInHotbar(idx)) {
            if (tis.getItem() instanceof ItemArmor) {
                int type = ((ItemArmor)tis.getItem()).armorType;
                if (this.mergeItemStack(tis, 37 + type, 37 + type + 1, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.getItem() instanceof ItemInfinityBooster) {
                if (this.mergeItemStack(tis, 0, 1, false)) {
                    clickSlot.clearStack();
                    return null;
                }
            } else if (tis.getItem() instanceof ItemMagnet && this.mergeItemStack(tis, 51, 52, false)) {
                clickSlot.clearStack();
                return null;
            }
        }
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.inventorySlots) {
            if (!(is instanceof InternalSlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return null;
        }
        if (clickSlot != null && clickSlot.getHasStack()) {
            AppEngSlot cs;
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                tis = this.shiftStoreItem(tis);
                for (Object e : this.inventorySlots) {
                    cs = (AppEngSlot)((Object)e);
                    if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.isItemValid(tis)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (Object e : this.inventorySlots) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof AppEngCraftingSlot || !cs.isItemValid(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && tis != null) {
                for (Object e : this.inventorySlots) {
                    cs = (AppEngSlot)((Object)e);
                    ItemStack destination = cs.getStack();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.isSameItemPrecise((ItemStack)destination, (ItemStack)tis)) {
                        return null;
                    }
                    if (destination != null) continue;
                    cs.putStack(tis.copy());
                    cs.onSlotChanged();
                    this.updateSlot(cs);
                    return null;
                }
            }
            if (tis != null) {
                int placeAble;
                for (Slot slot : selectedSlots) {
                    ItemStack t;
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.isItemValid(tis) || !slot.getHasStack() || !Platform.isSameItemPrecise((ItemStack)tis, (ItemStack)(t = slot.getStack()))) continue;
                    int maxSize = t.getMaxStackSize();
                    if (maxSize > slot.getSlotStackLimit()) {
                        maxSize = slot.getSlotStackLimit();
                    }
                    if (tis.stackSize < (placeAble = maxSize - t.stackSize)) {
                        placeAble = tis.stackSize;
                    }
                    t.stackSize += placeAble;
                    tis.stackSize -= placeAble;
                    if (tis.stackSize <= 0) {
                        clickSlot.putStack(null);
                        slot.onSlotChanged();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.isItemValid(tis)) continue;
                    if (slot.getHasStack()) {
                        ItemStack t = slot.getStack();
                        if (!Platform.isSameItemPrecise((ItemStack)t, (ItemStack)tis)) continue;
                        int maxSize = t.getMaxStackSize();
                        if (slot.getSlotStackLimit() < maxSize) {
                            maxSize = slot.getSlotStackLimit();
                        }
                        if (tis.stackSize < (placeAble = maxSize - t.stackSize)) {
                            placeAble = tis.stackSize;
                        }
                        t.stackSize += placeAble;
                        tis.stackSize -= placeAble;
                        if (tis.stackSize <= 0) {
                            clickSlot.putStack(null);
                            slot.onSlotChanged();
                            this.updateSlot(clickSlot);
                            this.updateSlot(slot);
                            return null;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize = tis.getMaxStackSize();
                    if (maxSize > slot.getSlotStackLimit()) {
                        maxSize = slot.getSlotStackLimit();
                    }
                    ItemStack tmp = tis.copy();
                    if (tmp.stackSize > maxSize) {
                        tmp.stackSize = maxSize;
                    }
                    tis.stackSize -= tmp.stackSize;
                    slot.putStack(tmp);
                    if (tis.stackSize <= 0) {
                        clickSlot.putStack(null);
                        slot.onSlotChanged();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.putStack(tis != null ? tis.copy() : null);
        }
        this.updateSlot(clickSlot);
        return null;
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.getSlot(slotA);
        Slot b = this.getSlot(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.getStack();
        ItemStack isB = b.getStack();
        if (isA == null && isB == null) {
            return;
        }
        if (isA != null && !a.canTakeStack(this.getInventoryPlayer().player)) {
            return;
        }
        if (isB != null && !b.canTakeStack(this.getInventoryPlayer().player)) {
            return;
        }
        if (isB != null && !a.isItemValid(isB)) {
            return;
        }
        if (isA != null && !b.isItemValid(isA)) {
            return;
        }
        ItemStack testA = isB == null ? null : isB.copy();
        ItemStack itemStack = testB = isA == null ? null : isA.copy();
        if (testA != null && testA.stackSize > a.getSlotStackLimit()) {
            if (testB != null) {
                return;
            }
            int totalA = testA.stackSize;
            testA.stackSize = a.getSlotStackLimit();
            testB = testA.copy();
            testB.stackSize = totalA - testA.stackSize;
        }
        if (testB != null && testB.stackSize > b.getSlotStackLimit()) {
            if (testA != null) {
                return;
            }
            int totalB = testB.stackSize;
            testB.stackSize = b.getSlotStackLimit();
            testA = testB.copy();
            testA.stackSize = totalB - testA.stackSize;
        }
        a.putStack(testA);
        b.putStack(testB);
    }

    private boolean isCraftMatrixSlot(AppEngSlot cs) {
        return cs.getSlotIndex() >= this.firstCraftingSlotNumber && cs.getSlotIndex() > this.lastCraftingSlotNumber;
    }

    private void updateSlot(Slot clickSlot) {
        this.detectAndSendChanges();
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.civ == null) {
            return input;
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), (IMEInventory)this.civ, (IAEStack)AEApi.instance().storage().createItemStack(input), (BaseActionSource)this.getActionSource());
        if (ais == null) {
            return null;
        }
        return ais.getItemStack();
    }

    private boolean isInHotbar(@Nonnull int index) {
        return index >= 1 && index <= 9;
    }

    private boolean isInInventory(@Nonnull int index) {
        return index >= 10 && index <= 36;
    }

    private boolean isInArmorSlot(@Nonnull int index) {
        return index >= 37 && index <= 40;
    }

    private boolean isInBoosterSlot(@Nonnull int index) {
        return index == 0;
    }

    private boolean isCraftResult(@Nonnull int index) {
        return index == 50;
    }

    private boolean isInCraftMatrix(@Nonnull int index) {
        return index >= 41 && index <= 49;
    }

    private boolean notArmorOrBooster(ItemStack is) {
        return !(is.getItem() instanceof ItemInfinityBooster) && !(is.getItem() instanceof ItemArmor);
    }

    public ItemStack slotClick(int slot, int button, int flag, EntityPlayer player) {
        try {
            if (slot >= 0 && this.getSlot(slot) != null && this.getSlot(slot).getStack() == RandomUtils.getWirelessTerm(player.inventory)) {
                return null;
            }
            return super.slotClick(slot, button, flag, player);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.updateProgressBar(idx, (int)value);
    }

    protected boolean mergeItemStack(ItemStack stack, int start, int end, boolean backwards) {
        int l;
        ItemStack itemstack1;
        Slot slot;
        int k;
        boolean flag1 = false;
        int n = k = backwards ? end - 1 : start;
        if (stack.isStackable()) {
            while (stack.stackSize > 0 && (!backwards && k < end || backwards && k >= start)) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 != null && itemstack1.getItem() == stack.getItem() && (!stack.getHasSubtypes() || stack.getItemDamage() == itemstack1.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)stack, (ItemStack)itemstack1)) {
                    l = itemstack1.stackSize + stack.stackSize;
                    if (l <= stack.getMaxStackSize() && l <= slot.getSlotStackLimit()) {
                        stack.stackSize = 0;
                        itemstack1.stackSize = l;
                        this.boosterInventory.markDirty();
                        flag1 = true;
                    } else if (itemstack1.stackSize < stack.getMaxStackSize() && l < slot.getSlotStackLimit()) {
                        stack.stackSize -= stack.getMaxStackSize() - itemstack1.stackSize;
                        itemstack1.stackSize = stack.getMaxStackSize();
                        this.boosterInventory.markDirty();
                        flag1 = true;
                    }
                }
                k += backwards ? -1 : 1;
            }
        }
        if (stack.stackSize > 0) {
            int n2 = k = backwards ? end - 1 : start;
            while (!backwards && k < end || backwards && k >= start) {
                slot = (Slot)this.inventorySlots.get(k);
                itemstack1 = slot.getStack();
                if (!slot.isItemValid(stack)) {
                    k += backwards ? -1 : 1;
                    continue;
                }
                if (itemstack1 == null) {
                    l = stack.stackSize;
                    if (l <= slot.getSlotStackLimit()) {
                        slot.putStack(stack.copy());
                        stack.stackSize = 0;
                        this.boosterInventory.markDirty();
                        flag1 = true;
                        break;
                    }
                    this.putStackInSlot(k, new ItemStack(stack.getItem(), slot.getSlotStackLimit(), stack.getItemDamage()));
                    stack.stackSize -= slot.getSlotStackLimit();
                    this.boosterInventory.markDirty();
                    flag1 = true;
                }
                k += backwards ? -1 : 1;
            }
        }
        return flag1;
    }
}

