/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container.slot;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngSlot;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;

public class SlotTrash
extends AppEngSlot {
    private final EntityPlayer entityPlayer;
    private ItemStack itemStack;
    private boolean shouldDeleteMouseStack;
    private String name = "TrashSlot";

    public SlotTrash(IInventory inv, int x, int y, EntityPlayer player) {
        super(null, 0, x, y);
        this.entityPlayer = player;
        this.readNBT();
    }

    @Override
    public ItemStack getStack() {
        return this.itemStack;
    }

    public boolean getHasStack() {
        return this.itemStack != null;
    }

    @Override
    public void putStack(ItemStack itemStack) {
        this.shouldDeleteMouseStack = this.itemStack != null;
        this.itemStack = itemStack;
        this.writeNBT();
    }

    public int getSlotStackLimit() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onSlotChanged() {
        if (this.itemStack != null && this.shouldDeleteMouseStack) {
            this.entityPlayer.inventory.setItemStack(null);
        }
    }

    @Override
    public boolean isItemValid(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canTakeStack(EntityPlayer player) {
        return true;
    }

    public ItemStack decrStackSize(int amount) {
        if (this.itemStack != null) {
            if (this.itemStack.stackSize <= amount) {
                ItemStack returnStack = this.itemStack;
                this.itemStack = null;
                this.shouldDeleteMouseStack = true;
                this.writeNBT();
                return returnStack;
            }
            ItemStack returnStack = this.itemStack.splitStack(amount);
            this.shouldDeleteMouseStack = false;
            if (this.itemStack.stackSize == 0) {
                this.itemStack = null;
                this.shouldDeleteMouseStack = true;
            }
            this.writeNBT();
            return returnStack;
        }
        return null;
    }

    public void readNBT() {
        NBTTagCompound nbtTagCompound = RandomUtils.getWirelessTerm(this.entityPlayer.inventory).getTagCompound();
        NBTTagList tagList = nbtTagCompound.getTagList(this.name, 10);
        NBTTagCompound tagCompound = tagList.getCompoundTagAt(0);
        if (tagCompound != null) {
            this.itemStack = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    public void writeNBT() {
        NBTTagCompound nbtTagCompound = RandomUtils.getWirelessTerm(this.entityPlayer.inventory).getTagCompound();
        NBTTagList tagList = new NBTTagList();
        if (this.itemStack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.itemStack.writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag(this.name, (NBTBase)tagList);
    }

    @Override
    public void clearStack() {
        if (this.itemStack != null) {
            this.itemStack = null;
        }
    }
}

