/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.p455w0rd.wirelesscraftingterminal.items.ItemInfinityBooster;

public class WCTInventoryBooster
implements IInventory {
    private String name = "BoosterSlot";
    private final ItemStack invItem;
    private ItemStack[] inventory = new ItemStack[1];

    public WCTInventoryBooster(ItemStack stack) {
        this.invItem = stack;
        if (stack != null) {
            if (!stack.hasTagCompound()) {
                stack.setTagCompound(new NBTTagCompound());
            }
            this.readFromNBT(stack.getTagCompound());
        }
    }

    public int getSizeInventory() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.inventory[slot];
    }

    public String getInventoryName() {
        return this.name;
    }

    public boolean hasCustomInventoryName() {
        return this.name.length() > 0;
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public ItemStack decrStackSize(int slot, int amount) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            if (stack.stackSize > amount) {
                stack = stack.splitStack(amount);
                this.markDirty();
            } else {
                this.setInventorySlotContents(slot, null);
            }
        }
        return stack;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemStack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemStack;
        }
        return null;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void markDirty() {
        this.writeNBT(this.invItem.getTagCompound());
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        return itemstack.getItem() instanceof ItemInfinityBooster;
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = nbtTagCompound.getTagList(this.name, 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            int slot = tagCompound.getInteger("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setInteger("Slot", currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag(this.name, (NBTBase)tagList);
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }
}

