/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.inventory;

import appeng.api.storage.IMEInventory;
import appeng.me.storage.MEIInventoryWrapper;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.inventory.IAEAppEngInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTerminalItem;

public class WCTInventoryCrafting
extends AppEngInternalInventory {
    private ItemStack[] stackList;
    private int inventoryWidth;
    private Container eventHandler;
    private final ItemStack invItem;
    private IAEAppEngInventory te;
    private final int size;
    private boolean enableClientEvents = false;

    public WCTInventoryCrafting(Container container, int rows, int cols, ItemStack is) {
        super((IAEAppEngInventory)container, rows * cols);
        this.size = rows * cols;
        this.stackList = new ItemStack[this.size];
        this.eventHandler = container;
        this.inventoryWidth = rows;
        this.invItem = is;
        this.setTileEntity((IAEAppEngInventory)container);
    }

    public int getSizeInventory() {
        return this.stackList.length;
    }

    public ItemStack getStackInSlot(int slot) {
        return slot >= this.getSizeInventory() ? null : this.stackList[slot];
    }

    public ItemStack getStackInRowAndColumn(int row, int col) {
        if (row >= 0 && row < this.inventoryWidth) {
            int k = row + col * this.inventoryWidth;
            return this.getStackInSlot(k);
        }
        return null;
    }

    public String getInventoryName() {
        return "crafting";
    }

    public boolean hasCustomInventoryName() {
        return true;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.stackList[slot] != null) {
            ItemStack itemstack = this.stackList[slot];
            this.stackList[slot] = null;
            return itemstack;
        }
        return null;
    }

    public ItemStack decrStackSize(int slot, int qty) {
        if (this.stackList[slot] != null) {
            ItemStack split = this.getStackInSlot(slot);
            ItemStack ns = null;
            if (qty >= split.stackSize) {
                ns = this.stackList[slot];
                this.stackList[slot] = null;
            } else {
                ns = split.splitStack(qty);
            }
            if (this.getTileEntity() != null && this.eventsEnabled()) {
                this.getTileEntity().onChangeInventory((IInventory)this, slot, InvOperation.decreaseStackSize, ns, null);
            }
            this.markDirty();
            return ns;
        }
        return null;
    }

    protected boolean eventsEnabled() {
        return Platform.isServer() || this.isEnableClientEvents();
    }

    private boolean isEnableClientEvents() {
        return this.enableClientEvents;
    }

    public void setEnableClientEvents(boolean enableClientEvents) {
        this.enableClientEvents = enableClientEvents;
    }

    public boolean isEmpty() {
        for (int x = 0; x < this.size; ++x) {
            if (this.getStackInSlot(x) == null) continue;
            return false;
        }
        return true;
    }

    public IMEInventory getMEInventory() {
        return new MEIInventoryWrapper((IInventory)this, null);
    }

    private IAEAppEngInventory getTileEntity() {
        return this.te;
    }

    public void setTileEntity(IAEAppEngInventory te) {
        this.te = te;
    }

    public void setInventorySlotContents(int slot, ItemStack stack) {
        this.stackList[slot] = stack;
        this.eventHandler.onCraftMatrixChanged((IInventory)this);
        if (stack != null && stack.stackSize > this.getInventoryStackLimit()) {
            stack.stackSize = this.getInventoryStackLimit();
        }
        this.markDirty();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public void markDirty(int slotIndex) {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory((IInventory)this, slotIndex, InvOperation.markDirty, null, null);
        }
    }

    public void markDirty() {
        if (this.getTileEntity() != null && this.eventsEnabled()) {
            this.getTileEntity().onChangeInventory((IInventory)this, -1, InvOperation.markDirty, null, null);
        }
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null || this.getStackInSlot((int)i).stackSize != 0) continue;
            this.stackList[i] = null;
        }
        this.writeNBT(this.invItem.getTagCompound());
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        return !(stack.getItem() instanceof IWirelessCraftingTerminalItem);
    }

    public void writeNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.stackList.length; ++currentIndex) {
            if (this.stackList[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.stackList[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("CraftingMatrix", (NBTBase)tagList);
    }
}

