/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.core.sync.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.crafting.ICraftingGrid;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.p455w0rd.wirelesscraftingterminal.common.WCTGuiHandler;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftAmount;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerCraftConfirm;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.INetworkInfo;
import net.p455w0rd.wirelesscraftingterminal.reference.Reference;

public class PacketCraftRequest
extends WCTPacket {
    private final long amount;
    private final boolean heldShift;

    public PacketCraftRequest(ByteBuf stream) {
        this.heldShift = stream.readBoolean();
        this.amount = stream.readLong();
    }

    public PacketCraftRequest(int craftAmt, boolean shift) {
        this.amount = craftAmt;
        this.heldShift = shift;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        data.writeBoolean(shift);
        data.writeLong(this.amount);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WCTPacket packet, EntityPlayer player) {
        block5: {
            ContainerCraftAmount cca;
            Object target;
            if (player.openContainer instanceof ContainerCraftAmount && (target = (cca = (ContainerCraftAmount)player.openContainer).getTarget()) instanceof IGridHost) {
                IGrid g = cca.obj2.getTargetGrid();
                if (g == null || cca.getItemToCraft() == null) {
                    return;
                }
                cca.getItemToCraft().setStackSize(this.amount);
                Future futureJob = null;
                try {
                    ICraftingGrid cg = (ICraftingGrid)g.getCache(ICraftingGrid.class);
                    futureJob = cg.beginCraftingJob(cca.getWorld(), cca.getGrid(), cca.getActionSrc(), cca.getItemToCraft(), null);
                    int x = (int)player.posX;
                    int y = (int)player.posY;
                    int z = (int)player.posZ;
                    WCTGuiHandler.launchGui(Reference.GUI_CRAFT_CONFIRM, player, player.worldObj, x, y, z);
                    if (player.openContainer instanceof ContainerCraftConfirm) {
                        ContainerCraftConfirm ccc = (ContainerCraftConfirm)player.openContainer;
                        ccc.setAutoStart(this.heldShift);
                        ccc.setJob(futureJob);
                        cca.detectAndSendChanges();
                    }
                }
                catch (Throwable e) {
                    if (futureJob == null) break block5;
                    futureJob.cancel(true);
                }
            }
        }
    }
}

